/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.jcal;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.Trigger;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.convert.jcal.JsonParameters;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.calendar.XcalUtil;

public class JsonProperty
implements Serializable {
    private static final Set<String> types = new TreeSet<String>();
    private static final Map<String, PropertyValueEmitter> valMap;
    private static final PropertyValueEmitter defValEmitter;

    public static void addFields(JsonGenerator jgen, Property prop) throws CalFacadeException {
        try {
            jgen.writeStartArray();
            jgen.writeString(prop.getName().toLowerCase());
            JsonParameters.addFields(jgen, prop);
            PropertyIndex.DataType type = JsonProperty.getType(prop);
            jgen.writeString(type.getJsonType());
            JsonProperty.outValue(jgen, prop, type);
            jgen.writeEndArray();
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static PropertyIndex.DataType getType(Property prop) {
        PropertyIndex.PropertyInfoIndex pii = PropertyIndex.PropertyInfoIndex.fromName((String)prop.getName());
        if (pii == null) {
            return PropertyIndex.DataType.TEXT;
        }
        PropertyIndex.DataType dtype = pii.getPtype();
        if (dtype == null) {
            return PropertyIndex.DataType.TEXT;
        }
        String nm = prop.getName().toLowerCase();
        if (dtype != PropertyIndex.DataType.SPECIAL && !types.contains(nm)) {
            return dtype;
        }
        if ("attach".equals(nm)) {
            Attach att = (Attach)prop;
            if (att.getUri() != null) {
                return PropertyIndex.DataType.URI;
            }
            return PropertyIndex.DataType.BINARY;
        }
        if ("trigger".equals(nm)) {
            Trigger tr = (Trigger)prop;
            if (tr.getDuration() != null) {
                return PropertyIndex.DataType.DURATION;
            }
            return PropertyIndex.DataType.DATE_TIME;
        }
        if (prop instanceof DateProperty) {
            DateProperty dp = (DateProperty)prop;
            if (Value.DATE.equals((Object)dp.getParameter("VALUE"))) {
                return PropertyIndex.DataType.DATE;
            }
            return PropertyIndex.DataType.DATE_TIME;
        }
        if (prop instanceof DateListProperty) {
            DateListProperty dlp = (DateListProperty)prop;
            if (Value.DATE.equals((Object)dlp.getDates().getType())) {
                return PropertyIndex.DataType.DATE;
            }
            return PropertyIndex.DataType.DATE_TIME;
        }
        return PropertyIndex.DataType.TEXT;
    }

    private static void outValue(JsonGenerator jgen, Property prop, PropertyIndex.DataType type) throws Throwable {
        String nm = prop.getName().toLowerCase();
        PropertyValueEmitter pve = valMap.get(nm);
        if (pve == null) {
            defValEmitter.emitValue(jgen, prop, type);
            return;
        }
        pve.emitValue(jgen, prop);
    }

    static {
        types.add("attach");
        types.add("dtend");
        types.add("dtstart");
        types.add("due");
        types.add("exdate");
        types.add("rdate");
        types.add("recurrence-id");
        types.add("trigger");
        valMap = new HashMap<String, PropertyValueEmitter>();
        valMap.put("categories", new CategoriesValueEmitter());
        valMap.put("exdate", new ExdateValueEmitter());
        valMap.put("exrule", new RecurValueEmitter());
        valMap.put("freebusy", new PeriodListValueEmitter());
        valMap.put("geo", new GeoValueEmitter());
        valMap.put("rdate", new RdateValueEmitter());
        valMap.put("request-status", new ReqStatValueEmitter());
        valMap.put("rrule", new RecurValueEmitter());
        defValEmitter = new SingleValueEmitter();
    }

    private static abstract class PropertyValueEmitter {
        private PropertyValueEmitter() {
        }

        abstract void emitValue(JsonGenerator var1, Property var2) throws Throwable;

        protected void emitValue(JsonGenerator jgen, Property prop, PropertyIndex.DataType type) throws Throwable {
            throw new RuntimeException("Unimplemented");
        }

        protected void outField(JsonGenerator jgen, String name, String val) throws Throwable {
            if (val == null) {
                return;
            }
            jgen.writeFieldName(name);
            jgen.writeString(val);
        }

        protected void outField(JsonGenerator jgen, String name, int val) throws Throwable {
            jgen.writeFieldName(name);
            jgen.writeNumber(val);
        }

        protected void outField(JsonGenerator jgen, String name, NumberList val) throws Throwable {
            if (val == null || val.size() == 0) {
                return;
            }
            jgen.writeFieldName(name);
            if (val.size() == 1) {
                jgen.writeNumber(((Integer)val.iterator().next()).intValue());
                return;
            }
            jgen.writeStartArray();
            for (Integer i : val) {
                jgen.writeNumber(i.intValue());
            }
            jgen.writeEndArray();
        }

        protected void outField(JsonGenerator jgen, String name, WeekDayList val) throws Throwable {
            if (val == null || val.size() == 0) {
                return;
            }
            jgen.writeFieldName(name);
            if (val.size() == 1) {
                jgen.writeNumber(((WeekDay)val.get(0)).getOffset());
                return;
            }
            jgen.writeStartArray();
            for (WeekDay wd : val) {
                jgen.writeString(wd.getDay().name().toLowerCase());
            }
            jgen.writeEndArray();
        }
    }

    private static class CategoriesValueEmitter
    extends PropertyValueEmitter {
        private CategoriesValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            Categories p = (Categories)prop;
            jgen.writeStartArray();
            TextList cl = p.getCategories();
            for (String s : cl) {
                jgen.writeString(s);
            }
            jgen.writeEndArray();
        }
    }

    private static class ExdateValueEmitter
    extends PropertyValueEmitter {
        private ExdateValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            ExDate p = (ExDate)prop;
            jgen.writeStartArray();
            DateList dl = p.getDates();
            for (Object o : dl) {
                jgen.writeString(XcalUtil.getXmlFormatDateTime((String)o.toString()));
            }
            jgen.writeEndArray();
        }
    }

    private static class RecurValueEmitter
    extends PropertyValueEmitter {
        private RecurValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            Recur r = null;
            if (prop instanceof RRule) {
                r = ((RRule)prop).getRecur();
            } else if (prop instanceof ExRule) {
                r = ((ExRule)prop).getRecur();
            }
            jgen.writeStartObject();
            this.outField(jgen, "freq", r.getFrequency().name());
            this.outField(jgen, "wkst", r.getWeekStartDay().name());
            if (r.getUntil() != null) {
                this.outField(jgen, "until", r.getUntil().toString());
            }
            this.outField(jgen, "count", r.getCount());
            if (r.getInterval() > 1) {
                this.outField(jgen, "interval", r.getInterval());
            }
            this.outField(jgen, "bymonth", r.getMonthList());
            this.outField(jgen, "byweekno", r.getWeekNoList());
            this.outField(jgen, "byyearday", r.getYearDayList());
            this.outField(jgen, "bymonthday", r.getMonthDayList());
            this.outField(jgen, "byday", r.getDayList());
            this.outField(jgen, "byhour", r.getHourList());
            this.outField(jgen, "byminute", r.getMinuteList());
            this.outField(jgen, "bysecond", r.getSecondList());
            this.outField(jgen, "bysetpos", r.getSetPosList());
            jgen.writeEndObject();
        }
    }

    private static class PeriodListValueEmitter
    extends PropertyValueEmitter {
        private PeriodListValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            PeriodList pl;
            if (prop instanceof RDate) {
                p = (RDate)prop;
                pl = p.getPeriods();
            } else if (prop instanceof FreeBusy) {
                p = (FreeBusy)prop;
                pl = p.getPeriods();
            } else {
                throw new RuntimeException("Unknown property " + prop);
            }
            jgen.writeStartArray();
            for (Period per : pl) {
                StringBuilder sb = new StringBuilder(XcalUtil.getXmlFormatDateTime((String)per.getStart().toString()));
                sb.append("/");
                if (per.getDuration() != null) {
                    sb.append(per.getDuration());
                } else {
                    sb.append(XcalUtil.getXmlFormatDateTime((String)per.getEnd().toString()));
                }
                jgen.writeString(sb.toString());
            }
            jgen.writeEndArray();
        }
    }

    private static class GeoValueEmitter
    extends PropertyValueEmitter {
        private GeoValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            Geo p = (Geo)prop;
            jgen.writeStartArray();
            jgen.writeNumber(p.getLatitude());
            jgen.writeNumber(p.getLongitude());
            jgen.writeEndArray();
        }
    }

    private static class RdateValueEmitter
    extends PeriodListValueEmitter {
        private RdateValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            RDate p = (RDate)prop;
            DateList dl = p.getDates();
            if (dl != null) {
                jgen.writeStartArray();
                for (Object o : dl) {
                    jgen.writeString(XcalUtil.getXmlFormatDateTime((String)o.toString()));
                }
                jgen.writeEndArray();
            } else {
                super.emitValue(jgen, prop);
            }
        }
    }

    private static class ReqStatValueEmitter
    extends PropertyValueEmitter {
        private ReqStatValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            RequestStatus p = (RequestStatus)prop;
            jgen.writeStartArray();
            jgen.writeString(p.getStatusCode());
            jgen.writeString(p.getDescription());
            if (p.getExData() != null) {
                jgen.writeString(p.getExData());
            }
            jgen.writeEndArray();
        }
    }

    private static class SingleValueEmitter
    extends PropertyValueEmitter {
        private SingleValueEmitter() {
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop) throws Throwable {
            this.emitValue(jgen, prop, PropertyIndex.DataType.TEXT);
            jgen.writeString(prop.getValue());
        }

        @Override
        public void emitValue(JsonGenerator jgen, Property prop, PropertyIndex.DataType type) throws Throwable {
            switch (type) {
                case BOOLEAN: {
                    jgen.writeBoolean(Boolean.parseBoolean(prop.getValue()));
                    break;
                }
                case DATE: 
                case DATE_TIME: {
                    jgen.writeString(XcalUtil.getXmlFormatDateTime((String)prop.getValue()));
                    break;
                }
                case FLOAT: {
                    jgen.writeNumber(Float.parseFloat(prop.getValue()));
                    break;
                }
                case INTEGER: {
                    jgen.writeNumber(Integer.parseInt(prop.getValue()));
                    break;
                }
                case PERIOD: {
                    jgen.writeString(prop.getValue());
                    break;
                }
                case RECUR: {
                    jgen.writeString(prop.getValue());
                    break;
                }
                case BINARY: 
                case CUA: 
                case DURATION: 
                case TEXT: 
                case URI: {
                    jgen.writeString(prop.getValue());
                    break;
                }
                case TIME: {
                    jgen.writeString(XcalUtil.getXmlFormatTime((String)prop.getValue()));
                    break;
                }
                case UTC_OFFSET: {
                    jgen.writeString(XcalUtil.getXmlFormatUtcOffset((String)prop.getValue()));
                    break;
                }
                case SPECIAL: {
                    break;
                }
            }
        }
    }
}

