/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.xcal;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VeventType;
import ietf.params.xml.ns.icalendar_2.VfreebusyType;
import ietf.params.xml.ns.icalendar_2.VjournalType;
import ietf.params.xml.ns.icalendar_2.VtodoType;
import java.util.Collection;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwVersion;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.EventTimeZonesRegistry;
import org.bedework.convert.IcalTranslator;
import org.bedework.convert.ical.BwEvent2Ical;
import org.bedework.convert.ical.VFreeUtil;
import org.bedework.convert.xcal.ToXEvent;
import org.bedework.convert.xcal.Xutil;
import org.bedework.util.calendar.IcalendarUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.XcalTags;

public class XmlTranslator
extends IcalTranslator {
    public XmlTranslator(IcalCallback cb) {
        super(cb);
    }

    public IcalendarType toXMLIcalendar(EventInfo val, int methodType, IcalendarType pattern, boolean wrapXprops) throws CalFacadeException {
        JAXBElement<? extends BaseComponentType> el;
        IcalendarType ical = Xutil.initCalendar(BwVersion.prodId, methodType);
        VcalendarType vcal = (VcalendarType)ical.getVcalendar().get(0);
        ArrayOfComponents aoc = vcal.getComponents();
        if (aoc == null) {
            aoc = new ArrayOfComponents();
            vcal.setComponents(aoc);
        }
        BwEvent ev = val.getEvent();
        VcalendarType vc = null;
        if (pattern != null && !pattern.getVcalendar().isEmpty()) {
            vc = (VcalendarType)pattern.getVcalendar().get(0);
        }
        BaseComponentType bc = this.matches(vc, ev.getEntityType());
        if (vc != null && bc == null) {
            return ical;
        }
        if (!ev.getSuppressed() && (el = ev.getEntityType() == 4 ? ToXEvent.toComponent(ev, false, wrapXprops, bc) : ToXEvent.toComponent(ev, false, wrapXprops, bc)) != null) {
            aoc.getBaseComponent().add(el);
        }
        if (val.getNumOverrides() == 0) {
            return ical;
        }
        for (EventInfo oei : val.getOverrides()) {
            ev = oei.getEvent();
            el = ToXEvent.toComponent(ev, true, wrapXprops, bc);
            if (el == null) continue;
            aoc.getBaseComponent().add(el);
        }
        if (val.getNumContainedItems() > 0) {
            for (EventInfo aei : val.getContainedItems()) {
                ev = aei.getEvent();
                el = ToXEvent.toComponent(ev, true, wrapXprops, bc);
                if (el == null) continue;
                aoc.getBaseComponent().add(el);
            }
        }
        return ical;
    }

    public void writeXmlCalendar(Collection<EventInfo> vals, int methodType, XmlEmit xml) throws CalFacadeException {
        xml.addNs(new XmlEmit.NameSpace("urn:ietf:params:xml:ns:icalendar-2.0", "X"), false);
        xml.openTag(XcalTags.icalendar);
        xml.openTag(XcalTags.vcalendar);
        xml.openTag(XcalTags.properties);
        this.xmlProp(xml, "PRODID", XcalTags.textVal, BwVersion.prodId);
        this.xmlProp(xml, "VERSION", XcalTags.textVal, Version.VERSION_2_0.getValue());
        xml.closeTag(XcalTags.properties);
        boolean componentsOpen = false;
        if (!this.cb.getTimezonesByReference()) {
            Calendar cal = IcalendarUtil.newIcal((int)methodType, (String)BwVersion.prodId);
            this.addIcalTimezones(cal, vals);
            for (Component comp : cal.getComponents()) {
                if (!(comp instanceof VTimeZone)) continue;
                if (!componentsOpen) {
                    xml.openTag(XcalTags.components);
                    componentsOpen = true;
                }
                this.xmlComponent(xml, comp);
            }
        }
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        for (EventInfo ei : vals) {
            BwEvent ev = ei.getEvent();
            EventTimeZonesRegistry tzreg = new EventTimeZonesRegistry(this, ev);
            Object comp = ev.getEntityType() == 4 ? VFreeUtil.toVFreeBusy(ev) : BwEvent2Ical.convert(ei, false, tzreg, currentPrincipal);
            if (!componentsOpen) {
                xml.openTag(XcalTags.components);
                componentsOpen = true;
            }
            this.xmlComponent(xml, (Component)comp);
            if (ei.getNumOverrides() <= 0) continue;
            for (EventInfo oei : ei.getOverrides()) {
                this.xmlComponent(xml, BwEvent2Ical.convert(oei, true, tzreg, currentPrincipal));
            }
        }
        if (componentsOpen) {
            xml.closeTag(XcalTags.components);
        }
        xml.closeTag(XcalTags.vcalendar);
        xml.closeTag(XcalTags.icalendar);
    }

    private BaseComponentType matches(VcalendarType vc, int entityType) throws CalFacadeException {
        String nm;
        if (vc == null || vc.getComponents() == null) {
            return null;
        }
        if (entityType == 0) {
            nm = VeventType.class.getName();
        } else if (entityType == 2) {
            nm = VtodoType.class.getName();
        } else if (entityType == 3) {
            nm = VjournalType.class.getName();
        } else if (entityType == 4) {
            nm = VfreebusyType.class.getName();
        } else {
            throw new CalFacadeException("org.bedework.invalid.entity.type", String.valueOf(entityType));
        }
        for (JAXBElement jbc : vc.getComponents().getBaseComponent()) {
            BaseComponentType bc = (BaseComponentType)jbc.getValue();
            if (!nm.equals(bc.getClass().getName())) continue;
            return bc;
        }
        return null;
    }

    private void xmlComponent(XmlEmit xml, Component val) {
        ComponentList cl;
        QName tag = this.openTag(xml, val.getName());
        PropertyList pl = val.getProperties();
        if (pl.size() > 0) {
            xml.openTag(XcalTags.properties);
            for (Property po : pl) {
                this.xmlProperty(xml, po);
            }
            xml.closeTag(XcalTags.properties);
        }
        if ((cl = val instanceof ComponentContainer ? ((ComponentContainer)val).getComponents() : null) != null && cl.size() > 0) {
            xml.openTag(XcalTags.components);
            for (Component c : cl) {
                this.xmlComponent(xml, c);
            }
            xml.closeTag(XcalTags.components);
        }
        xml.closeTag(tag);
    }

    private void xmlProperty(XmlEmit xml, Property val) {
        PropertyIndex.DataType dtype;
        QName tag = this.openTag(xml, val.getName());
        ParameterList pl = val.getParameters();
        if (pl.size() > 0) {
            xml.openTag(XcalTags.parameters);
            for (Parameter parameter : pl) {
                this.xmlParameter(xml, parameter);
            }
            xml.closeTag(XcalTags.parameters);
        }
        PropertyIndex.PropertyInfoIndex pii = PropertyIndex.PropertyInfoIndex.fromName((String)val.getName());
        QName ptype = XcalTags.textVal;
        if (pii != null && (dtype = pii.getPtype()) != null) {
            ptype = dtype.getXcalType();
        }
        if (ptype == null) {
            this.warn("Unimplemented value type for " + val.getName());
            ptype = XcalTags.textVal;
        }
        if (ptype.equals(XcalTags.recurVal)) {
            xml.openTag(ptype);
            Recur r = val instanceof ExRule ? ((ExRule)val).getRecur() : ((RRule)val).getRecur();
            xml.property(XcalTags.freq, r.getFrequency().name());
            this.xmlProp(xml, XcalTags.wkst, r.getWeekStartDay().name());
            if (r.getUntil() != null) {
                this.xmlProp(xml, XcalTags.until, r.getUntil().toString());
            }
            this.xmlProp(xml, XcalTags.count, String.valueOf(r.getCount()));
            this.xmlProp(xml, XcalTags.interval, String.valueOf(r.getInterval()));
            this.xmlProp(xml, XcalTags.bymonth, (Collection<?>)r.getMonthList());
            this.xmlProp(xml, XcalTags.byweekno, (Collection<?>)r.getWeekNoList());
            this.xmlProp(xml, XcalTags.byyearday, (Collection<?>)r.getYearDayList());
            this.xmlProp(xml, XcalTags.bymonthday, (Collection<?>)r.getMonthDayList());
            this.xmlProp(xml, XcalTags.byday, (Collection<?>)r.getDayList());
            this.xmlProp(xml, XcalTags.byhour, (Collection<?>)r.getHourList());
            this.xmlProp(xml, XcalTags.byminute, (Collection<?>)r.getMinuteList());
            this.xmlProp(xml, XcalTags.bysecond, (Collection<?>)r.getSecondList());
            this.xmlProp(xml, XcalTags.bysetpos, (Collection<?>)r.getSetPosList());
            xml.closeTag(ptype);
        } else {
            xml.property(ptype, val.getValue());
        }
        xml.closeTag(tag);
    }

    private void xmlProp(XmlEmit xml, QName tag, String val) {
        if (val == null) {
            return;
        }
        xml.property(tag, val);
    }

    private void xmlProp(XmlEmit xml, QName tag, Collection<?> val) {
        if (val == null || val.isEmpty()) {
            return;
        }
        xml.property(tag, val.toString());
    }

    private void xmlProp(XmlEmit xml, String pname, QName ptype, String val) {
        QName tag = new QName("urn:ietf:params:xml:ns:icalendar-2.0", pname.toLowerCase());
        xml.openTag(tag);
        xml.property(ptype, val);
        xml.closeTag(tag);
    }

    private void xmlParameter(XmlEmit xml, Parameter val) {
        PropertyIndex.DataType dtype;
        PropertyIndex.ParameterInfoIndex pii = PropertyIndex.ParameterInfoIndex.lookupPname((String)val.getName());
        QName ptype = XcalTags.textVal;
        if (pii != null && (dtype = pii.getPtype()) != null) {
            ptype = dtype.getXcalType();
        }
        if (ptype.equals(XcalTags.textVal)) {
            tag = new QName("urn:ietf:params:xml:ns:icalendar-2.0", val.getName().toLowerCase());
            xml.property(tag, val.getValue());
        } else {
            tag = this.openTag(xml, val.getName());
            xml.property(ptype, val.getValue());
            xml.closeTag(tag);
        }
    }

    private QName openTag(XmlEmit xml, String name) {
        QName tag = new QName("urn:ietf:params:xml:ns:icalendar-2.0", name.toLowerCase());
        xml.openTag(tag);
        return tag;
    }
}

