/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert;

import java.text.ParseException;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.ical.BwEvent2Ical;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;

public class RecurUtil {
    private static final BwLogger logger = new BwLogger().setLoggedClass(RecurUtil.class);

    public static RecurRange getRange(BwEvent ev, int maxYears) {
        Date dt;
        BwDateTime pend;
        PropertyList evprops = new PropertyList();
        BwEvent2Ical.doRecurring(ev, (PropertyList<Property>)evprops);
        RecurRange rr = new RecurRange();
        DtStart start = ev.getDtstart().makeDtStart();
        DtEnd end = IcalUtil.makeDtEnd(ev.getDtend());
        Duration duration = new Duration(null, ev.getDuration());
        rr.rangeStart = start.getDate();
        for (Property p : evprops.getProperties("RDATE")) {
            RDate rd = (RDate)p;
            for (Date d : rd.getDates()) {
                if (!d.before((java.util.Date)rr.rangeStart)) continue;
                rr.rangeStart = d;
            }
        }
        TemporalAmountAdapter dur = new TemporalAmountAdapter((TemporalAmount)java.time.Duration.of(maxYears * 365, ChronoUnit.DAYS));
        Date maxRangeEnd = new Date(dur.getTime((java.util.Date)rr.rangeStart));
        if (ev.getParent() != null && (pend = ev.getParent().getDtend()) != null && (dt = pend.makeDate()).before((java.util.Date)maxRangeEnd)) {
            maxRangeEnd = dt;
        }
        rr.rangeEnd = RecurUtil.getLatestRecurrenceDate((PropertyList<Property>)evprops, start, end, duration, maxRangeEnd);
        if (rr.rangeEnd == null || rr.rangeEnd.after((java.util.Date)maxRangeEnd)) {
            rr.rangeEnd = maxRangeEnd;
        }
        return rr;
    }

    public static RecurPeriods getPeriods(BwEvent ev, int maxYears, int maxInstances) {
        return RecurUtil.getPeriods(ev, maxYears, maxInstances, null, null);
    }

    public static RecurPeriods getPeriods(BwEvent ev, int maxYears, int maxInstances, String startRange, String endRange) {
        Date dt;
        BwDateTime pend;
        PropertyList evprops = new PropertyList();
        BwEvent2Ical.doRecurring(ev, (PropertyList<Property>)evprops);
        RecurPeriods rp = new RecurPeriods();
        DtStart start = ev.getDtstart().makeDtStart();
        if (startRange != null) {
            try {
                rp.rangeStart = new DateTime(startRange);
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        } else {
            rp.rangeStart = start.getDate();
            for (Object o : evprops) {
                if (!(o instanceof RDate)) continue;
                RDate rd = (RDate)o;
                for (Object o1 : rd.getDates()) {
                    Date d = (Date)o1;
                    if (!d.before((java.util.Date)rp.rangeStart)) continue;
                    rp.rangeStart = d;
                }
            }
        }
        TemporalAmountAdapter dur = new TemporalAmountAdapter((TemporalAmount)java.time.Duration.of(maxYears * 365, ChronoUnit.DAYS));
        Date maxRangeEnd = new Date(dur.getTime((java.util.Date)rp.rangeStart));
        if (ev.getParent() != null && (pend = ev.getParent().getDtend()) != null && (dt = pend.makeDate()).before((java.util.Date)maxRangeEnd)) {
            maxRangeEnd = dt;
        }
        DtEnd end = IcalUtil.makeDtEnd(ev.getDtend());
        if (endRange != null) {
            try {
                rp.rangeEnd = new DateTime(endRange);
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        } else {
            Duration duration = new Duration(null, ev.getDuration());
            rp.rangeEnd = RecurUtil.getLatestRecurrenceDate((PropertyList<Property>)evprops, start, end, duration, maxRangeEnd);
            if (rp.rangeEnd == null || rp.rangeEnd.after((java.util.Date)maxRangeEnd)) {
                rp.rangeEnd = maxRangeEnd;
            }
        }
        net.fortuna.ical4j.model.Period rangePeriod = new net.fortuna.ical4j.model.Period(new DateTime((java.util.Date)rp.rangeStart), new DateTime((java.util.Date)rp.rangeEnd));
        VEvent vev = new VEvent();
        PropertyList vevprops = vev.getProperties();
        vevprops.addAll((Collection)evprops);
        if (!ev.getSuppressed()) {
            vevprops.add((Property)start);
            vevprops.add((Property)end);
        } else {
            TemporalAmountAdapter evdur = TemporalAmountAdapter.parse((String)ev.getDuration());
            TemporalAmount setback = RecurUtil.addDays(evdur.getDuration(), 1L);
            boolean dateOnly = ev.getDtstart().getDateType();
            Object adjustedEnd = dateOnly ? new Date((java.util.Date)rp.rangeStart) : new DateTime((java.util.Date)rp.rangeStart);
            adjustedEnd.setTime(java.util.Date.from(Instant.from(setback.subtractFrom(rp.rangeStart.toInstant()))).getTime());
            vevprops.add((Property)new DtEnd(adjustedEnd));
            Object adjustedStart = dateOnly ? new Date((java.util.Date)adjustedEnd) : new DateTime((java.util.Date)adjustedEnd);
            adjustedStart.setTime(java.util.Date.from(Instant.from(evdur.getDuration().subtractFrom(adjustedStart.toInstant()))).getTime());
            vevprops.add((Property)new DtStart(adjustedStart));
        }
        PeriodList pl = vev.calculateRecurrenceSet(rangePeriod);
        if (pl.size() <= maxInstances) {
            rp.instances = pl;
        } else {
            rp.instances = new TreeSet<net.fortuna.ical4j.model.Period>();
            for (net.fortuna.ical4j.model.Period p : pl) {
                rp.instances.add(p);
                if (rp.instances.size() != maxInstances) continue;
                break;
            }
        }
        return rp;
    }

    public static Recurrence fromRecurrencId(BwEvent master, String recurrenceId) throws CalFacadeException {
        String stzid = master.getDtstart().getTzid();
        boolean dateOnly = master.getDtstart().getDateType();
        BwDateTime rstart = BwDateTime.makeBwDateTime((boolean)dateOnly, (String)recurrenceId, (String)stzid);
        BwDateTime rend = rstart.addDuration(BwDuration.makeDuration((String)master.getDuration()));
        return new Recurrence(master, rstart, rend, rstart.getDate(), null);
    }

    public static Collection<Recurrence> getRecurrences(EventInfo ei, int maxYears, int maxInstances, String fromDate, String toDate) {
        BwEvent ev = ei.getEvent();
        RecurPeriods rp = RecurUtil.getPeriods(ev, maxYears, maxInstances);
        ArrayList<Recurrence> recurrences = new ArrayList<Recurrence>();
        if (rp.instances.isEmpty()) {
            return recurrences;
        }
        String stzid = ev.getDtstart().getTzid();
        int instanceCt = maxInstances;
        boolean dateOnly = ev.getDtstart().getDateType();
        HashMap<String, EventInfo> overrides = new HashMap<String, EventInfo>();
        if (!Util.isEmpty((Collection)ei.getOverrides())) {
            for (EventInfo ov : ei.getOverrides()) {
                overrides.put(ov.getRecurrenceId(), ov);
            }
        }
        for (net.fortuna.ical4j.model.Period p : rp.instances) {
            BwDateTime rend;
            BwDateTime rstart;
            String rid;
            EventInfo override;
            String dtval = p.getStart().toString();
            if (dateOnly) {
                dtval = dtval.substring(0, 8);
            }
            if ((override = (EventInfo)overrides.get(rid = (rstart = BwDateTime.makeBwDateTime((boolean)dateOnly, (String)dtval, (String)stzid)).getDate())) != null) {
                BwEvent ove = override.getEvent();
                rstart = ove.getDtstart();
                rend = ove.getDtend();
            } else {
                dtval = p.getEnd().toString();
                if (dateOnly) {
                    dtval = dtval.substring(0, 8);
                }
                rend = BwDateTime.makeBwDateTime((boolean)dateOnly, (String)dtval, (String)stzid);
            }
            if (!RecurUtil.inDateTimeRange(fromDate, toDate, rstart.getDate(), rend.getDate())) continue;
            recurrences.add(new Recurrence(ev, rstart, rend, rid, override));
            if (--instanceCt != 0) continue;
            break;
        }
        return recurrences;
    }

    public static boolean inDateTimeRange(String rangeStart, String rangeEnd, String periodStart, String periodEnd) {
        int evstSt = rangeEnd == null ? -1 : periodStart.compareTo(rangeEnd);
        if (evstSt >= 0) {
            return false;
        }
        int evendSt = rangeStart == null ? 1 : periodEnd.compareTo(rangeStart);
        return evendSt > 0 || periodStart.equals(periodEnd) && evendSt >= 0;
    }

    private static Date getLatestRecurrenceDate(PropertyList<Property> evprops, DtStart vstart, DtEnd enddt, Duration d, Date maxRangeEnd) {
        RRule r;
        TemporalAmount dur;
        Date start = vstart.getDate();
        DateTime until = null;
        if (d != null) {
            dur = d.getDuration();
        } else {
            Date evend = enddt == null ? start : enddt.getDate();
            dur = TemporalAmountAdapter.fromDateRange((java.util.Date)start, (java.util.Date)evend).getDuration();
        }
        if (dur instanceof Period) {
            Period per = (Period)dur;
            dur = per.getMonths() == 0 && per.getYears() == 0 && per.getDays() % 7 == 0 ? per.plusDays(7L) : per.plusDays(1L);
        } else {
            java.time.Duration jdur = (java.time.Duration)dur;
            dur = jdur.plusDays(1L);
        }
        TemporalAmountAdapter taa = new TemporalAmountAdapter(dur);
        PropertyList rrules = evprops.getProperties("RRULE");
        PropertyList rdts = evprops.getProperties("RDATE");
        if (Util.isEmpty((Collection)rrules) && Util.isEmpty((Collection)rdts)) {
            return null;
        }
        for (Property rrule : rrules) {
            r = (RRule)rrule;
            Date nextUntil = RecurUtil.getLastDate(r.getRecur(), start, maxRangeEnd);
            if (nextUntil == null) {
                return null;
            }
            if (logger.debug()) {
                logger.debug("Last date for recur=" + nextUntil);
            }
            if (until != null && !nextUntil.after((java.util.Date)until)) continue;
            until = nextUntil;
        }
        if (until == null) {
            return null;
        }
        for (Property rdt : rdts) {
            r = (RDate)rdt;
            if (Value.PERIOD.equals((Object)r.getParameter("VALUE"))) {
                PeriodList pl = r.getPeriods();
                for (net.fortuna.ical4j.model.Period p : pl) {
                    DateTime nextUntil = p.getEnd();
                    if (nextUntil == null) {
                        nextUntil = p.getStart();
                    }
                    if (!nextUntil.after((java.util.Date)until)) continue;
                    until = nextUntil;
                }
                continue;
            }
            DateList startDates = r.getDates();
            for (Date startDate : startDates) {
                Date endDate = new Date(taa.getTime((java.util.Date)startDate));
                if (!endDate.after((java.util.Date)until)) continue;
                until = endDate;
            }
        }
        if (logger.debug()) {
            logger.debug("Last date before fix=" + until);
        }
        if (until instanceof DateTime) {
            until = new DateTime(taa.getTime(until));
            until.setUtc(true);
        } else {
            until = new Date(taa.getTime(until));
        }
        if (logger.debug()) {
            logger.debug("Last date after fix=" + (Date)until);
        }
        return until;
    }

    private static TemporalAmount addDays(TemporalAmount val, long days) {
        if (val instanceof Period) {
            return ((Period)val).plusDays(days);
        }
        return ((java.time.Duration)val).plusDays(days);
    }

    private static Date getLastDate(Recur r, Date start, Date maxRangeEnd) {
        Date seed = start;
        Date until = r.getUntil();
        if (until != null) {
            return until;
        }
        int count = r.getCount();
        if (count < 1) {
            return null;
        }
        TemporalAmountAdapter days100 = new TemporalAmountAdapter((TemporalAmount)Period.ofDays(100));
        int counted = 0;
        while (counted < count && start.before((java.util.Date)maxRangeEnd)) {
            DateTime end = new DateTime(days100.getTime((java.util.Date)start));
            DateList dl = r.getDates(seed, start, (Date)end, Value.DATE_TIME);
            int sz = dl.size();
            counted += sz;
            if (sz != 0) {
                until = dl.get(sz - 1);
            }
            start = end;
        }
        return until;
    }

    public static class RecurRange {
        public Date rangeStart;
        public Date rangeEnd;
    }

    public static class RecurPeriods {
        public Collection<net.fortuna.ical4j.model.Period> instances;
        public Date rangeStart;
        public Date rangeEnd;
    }

    public static class Recurrence {
        public BwEvent master;
        public BwDateTime start;
        public BwDateTime end;
        public String recurrenceId;
        public EventInfo override;

        private Recurrence(BwEvent master, BwDateTime start, BwDateTime end, String recurrenceId, EventInfo override) {
            this.master = master;
            this.start = start;
            this.end = end;
            this.recurrenceId = recurrenceId;
            this.override = override;
        }
    }
}

