/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.ical;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.ws.Holder;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentContainer;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VLocation;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VResource;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalendarAddress;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Concept;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.PollItemId;
import net.fortuna.ical4j.model.property.PollWinner;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.model.property.immutable.ImmutableRelativeTo;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.convert.CnvUtil;
import org.bedework.convert.EventTimeZonesRegistry;
import org.bedework.convert.Icalendar;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.convert.ical.VAlarmUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntitiesResponse;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.misc.response.Response;
import org.bedework.util.timezones.Timezones;
import org.bedework.util.xml.tagdefs.XcalTags;

public class Ical2BwEvent
extends IcalUtil {
    private static final BwLogger logger = new BwLogger().setLoggedClass(Ical2BwEvent.class);

    public static GetEntityResponse<EventInfo> toEvent(IcalCallback cb, BwCalendar cal, Icalendar ical, Component val, boolean mergeAttendees) {
        GetEntityResponse resp = new GetEntityResponse();
        if (val == null) {
            return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"No component supplied");
        }
        String currentPrincipal = null;
        BwPrincipal principal = cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        Holder hasXparams = new Holder((Object)Boolean.FALSE);
        int methodType = ical.getMethodType();
        String attUri = null;
        if (mergeAttendees) {
            attUri = cb.getCaladdr(cb.getPrincipal().getPrincipalRef());
        }
        String colPath = cal == null ? null : cal.getPath();
        try {
            TreeSet<Integer> pids;
            int entityType;
            PropertyList pl = val.getProperties();
            boolean vpoll = false;
            boolean event = false;
            boolean task = false;
            if (pl == null) {
                return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"Empty component");
            }
            if (val instanceof VEvent) {
                entityType = 0;
                event = true;
            } else if (val instanceof VToDo) {
                entityType = 2;
                task = true;
            } else if (val instanceof VJournal) {
                entityType = 3;
            } else if (val instanceof VFreeBusy) {
                entityType = 4;
            } else if (val instanceof VAvailability) {
                entityType = 5;
            } else if (val instanceof Available) {
                entityType = 6;
            } else if (val instanceof VPoll) {
                entityType = 7;
                vpoll = true;
            } else {
                return (GetEntityResponse)Response.error((Response)resp, (String)("org.bedework.invalid.component.type: " + val.getName()));
            }
            String guid = null;
            Uid uidp = (Uid)pl.getProperty("UID");
            if (uidp != null) {
                Ical2BwEvent.testXparams((Property)uidp, (Holder<Boolean>)hasXparams);
                guid = uidp.getValue();
            }
            if (guid == null) {
                return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"org.bedework.exception.ical.noguid");
            }
            BwDateTime ridObj = null;
            String rid = null;
            Object ridTz = null;
            RecurrenceId ridp = (RecurrenceId)pl.getProperty("RECURRENCE-ID");
            if (ridp != null) {
                Ical2BwEvent.testXparams((Property)ridp, (Holder<Boolean>)hasXparams);
                ridObj = BwDateTime.makeBwDateTime((DateProperty)ridp);
                if (ridObj.getRange() != null) {
                    logger.warn("TRANS-TO_EVENT: Got a recurrence id range");
                }
                rid = ridObj.getDate();
            }
            EventInfo masterEI = null;
            EventInfo evinfo = null;
            DtStart dtStart = (DtStart)pl.getProperty("DTSTART");
            if (rid != null && (masterEI = Ical2BwEvent.findMaster(guid, ical.getComponents())) != null) {
                evinfo = masterEI.findOverride(rid);
                evinfo.recurrenceSeen = true;
            }
            if (evinfo == null && cal != null && cal.getCalType() != 5 && cal.getCalType() != 13 && cal.getCalType() != 6) {
                GetEntitiesResponse eisResp;
                if (logger.debug()) {
                    logger.debug("TRANS-TO_EVENT: try to fetch event with guid=" + guid);
                }
                if ((eisResp = cb.getEvent(colPath, guid)).isError()) {
                    return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)eisResp);
                }
                Collection eis = eisResp.getEntities();
                if (!Util.isEmpty((Collection)eis)) {
                    if (eis.size() > 1) {
                        return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"More than one event returned for guid.");
                    }
                    evinfo = (EventInfo)eis.iterator().next();
                }
                if (logger.debug()) {
                    if (evinfo != null) {
                        logger.debug("TRANS-TO_EVENT: fetched event with guid");
                    } else {
                        logger.debug("TRANS-TO_EVENT: did not find event with guid");
                    }
                }
                if (evinfo != null) {
                    if (rid != null) {
                        masterEI = evinfo;
                        masterEI.setInstanceOnly(true);
                        evinfo = masterEI.findOverride(rid);
                        evinfo.recurrenceSeen = true;
                        ical.addComponent(masterEI);
                    } else if (methodType == 5) {
                        evinfo.setInstanceOnly(evinfo.getEvent().getSuppressed());
                    } else {
                        evinfo.getEvent().setSuppressed(false);
                    }
                } else if (rid != null) {
                    masterEI = CnvUtil.makeNewEvent(cb, entityType, guid, colPath);
                    BwEvent e = masterEI.getEvent();
                    String bogusDate = "19980118";
                    String bogusTime = "T230000";
                    boolean isDateType = ridObj.getDateType();
                    Iterator mdtStart = isDateType ? new DtStart(new Date("19980118")) : (dtStart.isUtc() ? new DtStart("19980118T230000Z") : (ridObj.getTzid() == null ? new DtStart("19980118T230000") : new DtStart("19980118T230000", Timezones.getTz((String)ridObj.getTzid()))));
                    IcalUtil.setDates(cb.getPrincipal().getPrincipalRef(), masterEI, (DtStart)mdtStart, null, null);
                    e.setRecurring(Boolean.valueOf(true));
                    Summary sum = (Summary)pl.getProperty("SUMMARY");
                    e.setSummary(sum.getValue());
                    e.setSuppressed(true);
                    ical.addComponent(masterEI);
                    evinfo = masterEI.findOverride(rid);
                    evinfo.recurrenceSeen = true;
                    masterEI.setInstanceOnly(rid != null);
                }
            }
            if (evinfo == null) {
                evinfo = CnvUtil.makeNewEvent(cb, entityType, guid, colPath);
            } else if (evinfo.getEvent().getEntityType() != entityType) {
                return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)("org.bedework.mismatched.entity.type: " + val));
            }
            ChangeTable chg = evinfo.getChangeset(cb.getPrincipal().getPrincipalRef());
            if (rid != null) {
                String evrid = evinfo.getEvent().getRecurrenceId();
                if (evrid == null || !evrid.equals(rid)) {
                    logger.warn("Mismatched rid ev=" + evrid + " expected " + rid);
                    chg.changed(PropertyIndex.PropertyInfoIndex.RECURRENCE_ID, (Object)evrid, (Object)rid);
                }
                if (masterEI.getEvent().getSuppressed()) {
                    masterEI.getEvent().addRdate(ridObj);
                }
            }
            BwEvent ev = evinfo.getEvent();
            ev.setScheduleMethod(methodType);
            DtEnd dtEnd = null;
            if (entityType == 2) {
                Due due = (Due)pl.getProperty("DUE");
                if (due != null) {
                    dtEnd = new DtEnd(due.getParameters(), due.getValue());
                }
            } else {
                dtEnd = (DtEnd)pl.getProperty("DTEND");
            }
            Duration duration = (Duration)pl.getProperty("DURATION");
            IcalUtil.setDates(cb.getPrincipal().getPrincipalRef(), evinfo, dtStart, dtEnd, duration);
            block46: for (Property prop : pl) {
                PropertyIndex.PropertyInfoIndex pi;
                Ical2BwEvent.testXparams(prop, (Holder<Boolean>)hasXparams);
                String pval = prop.getValue();
                if (pval != null && pval.length() == 0) {
                    pval = null;
                }
                if ((pi = prop instanceof XProperty ? PropertyIndex.PropertyInfoIndex.XPROP : PropertyIndex.PropertyInfoIndex.fromName((String)prop.getName())) == null) {
                    logger.debug("Unknown property with name " + prop.getName() + " class " + prop.getClass() + " and value " + pval);
                    continue;
                }
                chg.present(pi);
                switch (pi) {
                    case ACCEPT_RESPONSE: {
                        String sval = prop.getValue();
                        if (!chg.changed(pi, (Object)ev.getPollAcceptResponse(), (Object)sval)) continue block46;
                        ev.setPollAcceptResponse(sval);
                        break;
                    }
                    case ATTACH: {
                        chg.addValue(pi, (Object)IcalUtil.getAttachment((Attach)prop));
                        break;
                    }
                    case ATTENDEE: {
                        Response attResp = Ical2BwEvent.doAttendee(cb, chg, evinfo, (Attendee)prop, attUri, methodType, mergeAttendees);
                        if (attResp.isOk()) continue block46;
                        return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)attResp);
                    }
                    case BUSYTYPE: {
                        int ibt = BwEvent.fromBusyTypeString((String)pval);
                        if (!chg.changed(pi, (Object)ev.getBusyType(), (Object)ibt)) continue block46;
                        ev.setBusyType(ibt);
                        break;
                    }
                    case CATEGORIES: {
                        Categories cats = (Categories)prop;
                        TextList cl = cats.getCategories();
                        String lang = IcalUtil.getLang((Property)cats);
                        if (cl == null) continue block46;
                        for (String wd : cl) {
                            BwCategory cat;
                            if (wd == null) continue;
                            BwString key = new BwString(lang, wd);
                            GetEntityResponse fcResp = cb.findCategory(key);
                            if (fcResp.isError()) {
                                return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)fcResp);
                            }
                            if (fcResp.isNotFound()) {
                                cat = BwCategory.makeCategory();
                                cat.setWord(key);
                                cb.addCategory(cat);
                            } else {
                                cat = (BwCategory)fcResp.getEntity();
                            }
                            chg.addValue(pi, (Object)cat);
                        }
                        continue block46;
                    }
                    case CLASS: {
                        if (!chg.changed(pi, (Object)ev.getClassification(), (Object)pval)) continue block46;
                        ev.setClassification(pval);
                        break;
                    }
                    case COMMENT: {
                        chg.addValue(pi, (Object)new BwString(null, pval));
                        break;
                    }
                    case COMPLETED: {
                        if (!chg.changed(pi, (Object)ev.getCompleted(), (Object)pval)) continue block46;
                        ev.setCompleted(pval);
                        break;
                    }
                    case CONCEPT: {
                        Concept c = (Concept)prop;
                        String cval = c.getValue();
                        if (cval == null) continue block46;
                        chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)ev.makeConcept(cval));
                        break;
                    }
                    case CONTACT: {
                        GetEntityResponse fcResp;
                        String altrep = Ical2BwEvent.getAltRepPar(prop);
                        String lang = IcalUtil.getLang(prop);
                        String uid = Ical2BwEvent.getUidPar(prop);
                        BwString nm = new BwString(lang, pval);
                        BwContact contact = null;
                        if (uid != null) {
                            fcResp = cb.getContact(uid);
                            if (fcResp.isError()) {
                                return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)fcResp);
                            }
                            if (fcResp.isOk()) {
                                contact = (BwContact)fcResp.getEntity();
                            }
                        }
                        if (contact == null) {
                            fcResp = cb.findContact(nm);
                            if (fcResp.isError()) {
                                return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)fcResp);
                            }
                            if (fcResp.isOk()) {
                                contact = (BwContact)fcResp.getEntity();
                            }
                        }
                        if (contact == null) {
                            contact = BwContact.makeContact();
                            contact.setCn(nm);
                            contact.setLink(altrep);
                            cb.addContact(contact);
                        } else {
                            contact.setCn(nm);
                            contact.setLink(altrep);
                        }
                        chg.addValue(pi, (Object)contact);
                        break;
                    }
                    case CREATED: {
                        if (!chg.changed(pi, (Object)ev.getCreated(), (Object)pval)) continue block46;
                        ev.setCreated(pval);
                        break;
                    }
                    case DESCRIPTION: {
                        if (!chg.changed(pi, (Object)ev.getDescription(), (Object)pval)) continue block46;
                        ev.setDescription(pval);
                        break;
                    }
                    case DTEND: {
                        break;
                    }
                    case DTSTAMP: {
                        ev.setDtstamp(pval);
                        break;
                    }
                    case DTSTART: {
                        break;
                    }
                    case DUE: {
                        break;
                    }
                    case DURATION: {
                        break;
                    }
                    case EXDATE: {
                        chg.addValues(pi, IcalUtil.makeDateTimes((DateListProperty)prop));
                        break;
                    }
                    case EXRULE: {
                        chg.addValue(pi, (Object)pval);
                        break;
                    }
                    case FREEBUSY: {
                        int fbtype;
                        FreeBusy fbusy = (FreeBusy)prop;
                        PeriodList perpl = fbusy.getPeriods();
                        Parameter par = IcalUtil.getParameter((Property)fbusy, "FBTYPE");
                        if (par == null) {
                            fbtype = 0;
                        } else if (par.equals((Object)FbType.BUSY)) {
                            fbtype = 0;
                        } else if (par.equals((Object)FbType.BUSY_TENTATIVE)) {
                            fbtype = 3;
                        } else if (par.equals((Object)FbType.BUSY_UNAVAILABLE)) {
                            fbtype = 2;
                        } else if (par.equals((Object)FbType.FREE)) {
                            fbtype = 1;
                        } else {
                            if (logger.debug()) {
                                logger.debug("Unsupported parameter " + par.getName());
                            }
                            return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)("Unsupported parameter " + par.getName()));
                        }
                        BwFreeBusyComponent fbc = new BwFreeBusyComponent();
                        fbc.setType(fbtype);
                        for (Period per : perpl) {
                            fbc.addPeriod(per);
                        }
                        ev.addFreeBusyPeriod(fbc);
                        break;
                    }
                    case GEO: {
                        Geo g = (Geo)prop;
                        BwGeo geo = new BwGeo(g.getLatitude(), g.getLongitude());
                        if (!chg.changed(pi, (Object)ev.getGeo(), (Object)geo)) continue block46;
                        ev.setGeo(geo);
                        break;
                    }
                    case LAST_MODIFIED: {
                        if (!chg.changed(pi, (Object)ev.getLastmod(), (Object)pval)) continue block46;
                        ev.setLastmod(pval);
                        break;
                    }
                    case LOCATION: {
                        Response plresp = Ical2BwEvent.processLocation(cb, ev, val, prop, pval, chg);
                        if (!plresp.isError()) continue block46;
                        return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)plresp);
                    }
                    case ORGANIZER: {
                        BwOrganizer org = IcalUtil.getOrganizer(cb, (Organizer)prop);
                        BwOrganizer evorg = ev.getOrganizer();
                        BwOrganizer evorgCopy = evorg == null ? null : (BwOrganizer)evorg.clone();
                        if (!chg.changed(pi, (Object)evorgCopy, (Object)org)) continue block46;
                        if (evorg == null) {
                            ev.setOrganizer(org);
                            break;
                        }
                        evorg.update(org);
                        break;
                    }
                    case PERCENT_COMPLETE: {
                        Integer ival = ((PercentComplete)prop).getPercentage();
                        if (!chg.changed(pi, (Object)ev.getPercentComplete(), (Object)ival)) continue block46;
                        ev.setPercentComplete(ival);
                        break;
                    }
                    case POLL_MODE: {
                        String sval = prop.getValue();
                        if (!chg.changed(pi, (Object)ev.getPollMode(), (Object)sval)) continue block46;
                        ev.setPollMode(sval);
                        break;
                    }
                    case POLL_PROPERTIES: {
                        String sval = prop.getValue();
                        if (!chg.changed(pi, (Object)ev.getPollProperties(), (Object)sval)) continue block46;
                        ev.setPollProperties(sval);
                        break;
                    }
                    case POLL_WINNER: {
                        Integer ival = ((PollWinner)prop).getPollwinner();
                        if (!chg.changed(pi, (Object)ev.getPollWinner(), (Object)ival)) continue block46;
                        ev.setPollWinner(ival);
                        break;
                    }
                    case PRIORITY: {
                        Integer ival = ((Priority)prop).getLevel();
                        if (!chg.changed(pi, (Object)ev.getPriority(), (Object)ival)) continue block46;
                        ev.setPriority(ival);
                        break;
                    }
                    case RDATE: {
                        chg.addValues(pi, IcalUtil.makeDateTimes((DateListProperty)prop));
                        break;
                    }
                    case RECURRENCE_ID: {
                        break;
                    }
                    case RELATED_TO: {
                        RelatedTo irelto = (RelatedTo)prop;
                        BwRelatedTo relto = new BwRelatedTo();
                        String parval = IcalUtil.getParameterVal((Property)irelto, "RELTYPE");
                        if (parval != null) {
                            relto.setRelType(parval);
                        }
                        relto.setValue(irelto.getValue());
                        if (!chg.changed(pi, (Object)ev.getRelatedTo(), (Object)relto)) continue block46;
                        ev.setRelatedTo(relto);
                        break;
                    }
                    case REQUEST_STATUS: {
                        BwRequestStatus rs = BwRequestStatus.fromRequestStatus((RequestStatus)((RequestStatus)prop));
                        chg.addValue(pi, (Object)rs);
                        break;
                    }
                    case RESOURCES: {
                        TextList rl = ((Resources)prop).getResources();
                        if (rl == null) continue block46;
                        String lang = IcalUtil.getLang(prop);
                        for (String s : rl) {
                            BwString rsrc = new BwString(lang, s);
                            chg.addValue(pi, (Object)rsrc);
                        }
                        continue block46;
                    }
                    case RRULE: {
                        chg.addValue(pi, (Object)pval);
                        break;
                    }
                    case SEQUENCE: {
                        int seq = ((Sequence)prop).getSequenceNo();
                        if (seq == ev.getSequence()) continue block46;
                        chg.changed(pi, (Object)ev.getSequence(), (Object)seq);
                        ev.setSequence(seq);
                        break;
                    }
                    case STATUS: {
                        if (!chg.changed(pi, (Object)ev.getStatus(), (Object)pval)) continue block46;
                        ev.setStatus(pval);
                        break;
                    }
                    case SUMMARY: {
                        if (!chg.changed(pi, (Object)ev.getSummary(), (Object)pval)) continue block46;
                        ev.setSummary(pval);
                        break;
                    }
                    case TRANSP: {
                        BwXproperty pu;
                        if (!chg.changed(pi, (Object)ev.getPeruserTransparency(cb.getPrincipal().getPrincipalRef()), (Object)pval) || (pu = ev.setPeruserTransparency(cb.getPrincipal().getPrincipalRef(), pval)) == null) continue block46;
                        chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)pu);
                        break;
                    }
                    case UID: {
                        break;
                    }
                    case URL: {
                        if (!chg.changed(pi, (Object)ev.getLink(), (Object)pval)) continue block46;
                        ev.setLink(pval);
                        break;
                    }
                    case XPROP: {
                        String name = prop.getName();
                        if (name.equalsIgnoreCase("X-BEDEWORK-COST")) {
                            if (!chg.changed(PropertyIndex.PropertyInfoIndex.COST, (Object)ev.getCost(), (Object)pval)) continue block46;
                            ev.setCost(pval);
                            break;
                        }
                        if (name.equalsIgnoreCase("X-BEDEWORK-CATEGORIES") && Ical2BwEvent.checkCategory(cb, chg, ev, null, pval) || name.equalsIgnoreCase("X-BEDEWORK-LOCATION") && Ical2BwEvent.checkLocation(cb, chg, ev, prop) || name.equalsIgnoreCase("X-BEDEWORK-CONTACT") && Ical2BwEvent.checkContact(cb, chg, ev, null, pval)) break;
                        XProperty xp = (XProperty)prop;
                        chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty(name, xp.getParameters().toString(), pval));
                        break;
                    }
                    default: {
                        if (!logger.debug()) continue block46;
                        logger.debug("Unsupported property with index " + pi + "; class " + prop.getClass() + " and value " + pval);
                    }
                }
            }
            ComponentList subComps = val instanceof ComponentContainer ? ((ComponentContainer)val).getComponents() : null;
            if (vpoll) {
                pids = new TreeSet<Integer>();
                BwEvent vp = evinfo.getEvent();
                if (!Util.isEmpty((Collection)vp.getPollItems())) {
                    vp.clearPollItems();
                }
            } else {
                pids = null;
            }
            if (!Util.isEmpty((Collection)subComps)) {
                for (Component subComp : subComps) {
                    Response vresp;
                    if (subComp instanceof Available) {
                        if (!(val instanceof VAvailability)) {
                            return (GetEntityResponse)Response.error((Response)resp, (String)"AVAILABLE only valid in VAVAILABLE");
                        }
                        Response avlResp = Ical2BwEvent.processAvailable(cb, cal, ical, (VAvailability)val, (Available)subComp, evinfo);
                        if (avlResp.isOk()) continue;
                        return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)avlResp);
                    }
                    if (subComp instanceof Participant) {
                        if (vpoll) {
                            vresp = Ical2BwEvent.processVoter(cb, (VPoll)val, (Participant)subComp, evinfo, chg, mergeAttendees);
                            if (vresp.isOk()) continue;
                            return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)vresp);
                        }
                        logger.warn("Unimplemented Participant object");
                        continue;
                    }
                    if (subComp instanceof VResource) {
                        logger.warn("Unimplemented VResource object");
                        continue;
                    }
                    if (subComp instanceof VLocation) {
                        logger.warn("Unimplemented VLocation object");
                        continue;
                    }
                    if (subComp instanceof VAlarm) {
                        Response aresp = VAlarmUtil.processAlarm(cb, val, (VAlarm)subComp, ev, currentPrincipal, chg);
                        if (aresp.isOk()) continue;
                        return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)aresp);
                    }
                    if (vpoll && (event || task)) {
                        vresp = Ical2BwEvent.processCandidate((VPoll)val, subComp, evinfo, pids, chg);
                        if (vresp.isOk()) continue;
                        return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)vresp);
                    }
                    logger.warn("Unimplemented Component object: " + subComp);
                }
            }
            if (ev.getCreated() == null) {
                if (ev.getLastmod() != null) {
                    ev.setCreated(ev.getLastmod());
                    chg.changed(PropertyIndex.PropertyInfoIndex.CREATED, null, (Object)ev.getCreated());
                } else {
                    ev.updateDtstamp();
                    chg.changed(PropertyIndex.PropertyInfoIndex.CREATED, null, (Object)ev.getCreated());
                    chg.changed(PropertyIndex.PropertyInfoIndex.LAST_MODIFIED, null, (Object)ev.getLastmod());
                }
            }
            if (ev.getLastmod() == null) {
                ev.setLastmod(ev.getCreated());
                chg.changed(PropertyIndex.PropertyInfoIndex.LAST_MODIFIED, null, (Object)ev.getLastmod());
            }
            Ical2BwEvent.processTimezones(ev, ical, chg);
            if (ev.getRecipients() != null) {
                ev.getRecipients().clear();
            }
            ev.setOriginator(null);
            if (((Boolean)hasXparams.value).booleanValue()) {
                Value v;
                Attach attachp;
                Component valCopy = val.copy();
                Description desp = (Description)valCopy.getProperty("DESCRIPTION");
                if (desp != null) {
                    desp.setValue(null);
                }
                if ((attachp = (Attach)valCopy.getProperty("ATTACH")) != null && (v = (Value)attachp.getParameter("VALUE")) != null) {
                    attachp.setValue(String.valueOf(attachp.getValue().hashCode()));
                }
                chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty("X-BEDEWORK-ICAL", null, valCopy.toString()));
            }
            chg.processChanges(ev, true, false);
            ev.setRecurring(Boolean.valueOf(ev.isRecurringEntity()));
            if (logger.debug()) {
                logger.debug(chg.toString());
                logger.debug(ev.toString());
            }
            if (masterEI != null) {
                return (GetEntityResponse)Response.notFound((Response)resp);
            }
            resp.setEntity((Object)evinfo);
            return resp;
        }
        catch (Throwable t) {
            if (logger.debug()) {
                logger.error(t);
            }
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    private static Response doAttendee(IcalCallback cb, ChangeTable chg, EventInfo evinfo, Attendee attPr, String attUri, int methodType, boolean mergeAttendees) {
        if (methodType == 1 && cb.getStrictness() == 2) {
            return Response.notOk((Response)new Response(), (Response.Status)Response.Status.failed, (String)"org.bedework.exception.ical.attendeesinpublish");
        }
        BwEvent ev = evinfo.getEvent();
        if (evinfo.getNewEvent() || !mergeAttendees) {
            chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)IcalUtil.getAttendee(cb, attPr));
        } else {
            String pUri = cb.getCaladdr(attPr.getValue());
            if (pUri.equals(attUri)) {
                chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)IcalUtil.getAttendee(cb, attPr));
            } else {
                boolean found = false;
                for (BwAttendee att : ev.getAttendees()) {
                    if (!pUri.equals(att.getAttendeeUri())) continue;
                    chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, att.clone());
                    found = true;
                    break;
                }
                if (!found) {
                    BwAttendee att = IcalUtil.getAttendee(cb, attPr);
                    att.setPartstat("NEEDS-ACTION");
                    chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)att);
                }
            }
        }
        return Response.ok();
    }

    private static boolean checkCategory(IcalCallback cb, ChangeTable chg, BwEvent ev, String lang, String val) {
        if (val == null || val.length() == 0) {
            return false;
        }
        BwString sval = new BwString(lang, val);
        GetEntityResponse resp = cb.findCategory(sval);
        if (resp.getStatus() == Response.Status.notFound) {
            return false;
        }
        if (!resp.isOk()) {
            throw new RuntimeException("Failed. Status: " + resp.getStatus() + ", msg: " + resp.getMessage());
        }
        Set cats = ev.getCategories();
        if (cats != null) {
            for (BwCategory c : cats) {
                if (!c.getWord().equals((Object)sval)) continue;
                return true;
            }
        }
        BwCategory cat = (BwCategory)resp.getEntity();
        ev.addCategory(cat);
        chg.addValue(PropertyIndex.PropertyInfoIndex.CATEGORIES, (Object)cat);
        return true;
    }

    private static boolean checkLocation(IcalCallback cb, ChangeTable chg, BwEvent ev, Property prop) {
        Parameter keyName = prop.getParameter(XcalTags.xBedeworkLocationKey.getLocalPart());
        String val = prop.getValue();
        BwLocation evloc = ev.getLocation();
        GetEntityResponse resp = keyName == null ? cb.fetchLocationByCombined(val, true) : cb.fetchLocationByKey(keyName.getValue(), val);
        if (resp.getStatus() != Response.Status.ok) {
            return false;
        }
        BwLocation loc = (BwLocation)resp.getEntity();
        ev.setLocation(loc);
        chg.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)evloc, (Object)loc);
        return true;
    }

    private static boolean checkContact(IcalCallback cb, ChangeTable chg, BwEvent ev, String lang, String val) {
        BwString sval = new BwString(lang, val);
        GetEntityResponse resp = cb.findContact(sval);
        if (resp.getStatus() == Response.Status.notFound) {
            return false;
        }
        if (!resp.isOk()) {
            throw new RuntimeException("Failed. Status: " + resp.getStatus() + ", msg: " + resp.getMessage());
        }
        Set cs = ev.getContacts();
        BwContact c = (BwContact)resp.getEntity();
        if (cs != null) {
            for (BwContact c1 : cs) {
                if (!c1.getCn().equals((Object)sval)) continue;
                return true;
            }
        }
        ev.addContact(c);
        chg.addValue(PropertyIndex.PropertyInfoIndex.CONTACT, (Object)c);
        return true;
    }

    private static void testXparams(Property p, Holder<Boolean> hasXparams) {
        if (((Boolean)hasXparams.value).booleanValue()) {
            return;
        }
        ParameterList params = p.getParameters();
        for (Parameter param : params) {
            XParameter xpar;
            if (!(param instanceof XParameter) || (xpar = (XParameter)param).getName().equalsIgnoreCase("X-BEDEWORK-UID")) continue;
            hasXparams.value = true;
        }
    }

    private static Response processLocation(IcalCallback cb, BwEvent ev, Component val, Property prop, String pval, ChangeTable chg) {
        String inval;
        String evval;
        ComponentList vlocs;
        Response resp = new Response();
        BwLocation loc = null;
        VLocation mainVloc = null;
        ev.removeXproperties("X-BEDEWORK-VLOCATION");
        if (val instanceof ComponentContainer && !Util.isEmpty((Collection)(vlocs = ((ComponentContainer)val).getComponents("VLOCATION")))) {
            for (VLocation vloc : vlocs) {
                Property relto = vloc.getProperty("RELATIVE-TO");
                if (relto != null) {
                    if (relto.equals((Object)ImmutableRelativeTo.START)) {
                        mainVloc = vloc;
                    } else if (relto.equals((Object)ImmutableRelativeTo.END) && mainVloc == null) {
                        mainVloc = vloc;
                    }
                }
                chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty("X-BEDEWORK-VLOCATION", null, vloc.toString()));
            }
            if (mainVloc == null) {
                mainVloc = (VLocation)vlocs.get(0);
            }
        }
        if (mainVloc != null) {
            Uid puid = mainVloc.getUid();
            if (puid != null) {
                GetEntityResponse lresp = cb.getLocation(puid.getValue());
                if (lresp.isError()) {
                    return lresp;
                }
                if (lresp.isNotFound()) {
                    BwString addr = new BwString(null, pval);
                    GetEntityResponse fcResp = cb.findLocation(addr);
                    if (fcResp.isError()) {
                        return fcResp;
                    }
                    if (fcResp.isOk()) {
                        loc = (BwLocation)fcResp.getEntity();
                    }
                    if (loc == null) {
                        loc = BwLocation.makeLocation();
                        loc.setAddress(addr);
                        cb.addLocation(loc);
                    }
                } else {
                    loc = (BwLocation)lresp.getEntity();
                }
            }
        } else {
            String lang = IcalUtil.getLang(prop);
            BwString addr = null;
            if (pval != null) {
                addr = new BwString(lang, pval);
                GetEntityResponse fcResp = cb.findLocation(addr);
                if (fcResp.isError()) {
                    return fcResp;
                }
                if (fcResp.isOk()) {
                    loc = (BwLocation)fcResp.getEntity();
                }
                if (loc == null) {
                    loc = BwLocation.makeLocation();
                    loc.setAddress(addr);
                    cb.addLocation(loc);
                }
            }
        }
        BwLocation evloc = ev.getLocation();
        if (chg.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)evloc, loc)) {
            ev.setLocation(loc);
        } else if (loc != null && evloc != null && !(evval = evloc.getAddress().getValue()).equals(inval = loc.getAddress().getValue())) {
            chg.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)evval, (Object)inval);
            evloc.getAddress().setValue(inval);
        }
        return Response.ok();
    }

    private static void processTimezones(BwEvent ev, Icalendar ical, ChangeTable chg) {
        for (Icalendar.TimeZoneInfo tzi : ical.getTimeZones()) {
            if (tzi.tzSpec == null || EventTimeZonesRegistry.findTzValue(ev, tzi.tzid) != null) continue;
            chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty("X-BEDEWORK-TZ", null, BwXproperty.escapeSemi((String)tzi.tzid) + ";" + tzi.tzSpec));
        }
    }

    private static Response processAvailable(IcalCallback cb, BwCalendar cal, Icalendar ical, VAvailability val, Available avl, EventInfo vavail) {
        Response resp = new Response();
        GetEntityResponse<EventInfo> availi = Ical2BwEvent.toEvent(cb, cal, ical, (Component)avl, false);
        if (!resp.isOk()) {
            return Response.fromResponse((Response)resp, availi);
        }
        EventInfo ei = (EventInfo)availi.getEntity();
        ei.getEvent().setOwnerHref(vavail.getEvent().getOwnerHref());
        vavail.addContainedItem(ei);
        vavail.getEvent().addAvailableUid(ei.getEvent().getUid());
        return resp;
    }

    private static Response processVoter(IcalCallback cb, VPoll val, Participant part, EventInfo vpoll, ChangeTable changes, boolean mergeAttendees) {
        ComponentList voters = val.getVoters();
        if (Util.isEmpty((Collection)voters)) {
            return Response.ok();
        }
        BwEvent event = vpoll.getEvent();
        if (!Util.isEmpty((Collection)event.getVoters())) {
            event.clearVoters();
        }
        String voter = part.toString();
        event.addVoter(voter);
        changes.addValue(PropertyIndex.PropertyInfoIndex.VOTER, (Object)voter);
        Property p = part.getProperty("CALENDAR-ADDRESS");
        if (p == null) {
            return Response.error((Response)new Response(), (String)"Voter - no calendar address");
        }
        Ical2BwEvent.processVoter((CalendarAddress)p, vpoll, cb, changes, mergeAttendees);
        return Response.ok();
    }

    private static void processVoter(CalendarAddress ca, EventInfo vpoll, IcalCallback cb, ChangeTable chg, boolean mergeAttendees) {
        BwEvent ev = vpoll.getEvent();
        if (vpoll.getNewEvent() || !mergeAttendees) {
            chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)IcalUtil.getVoter(cb, ca));
            return;
        }
        String pUri = cb.getCaladdr(ca.getValue());
        if (pUri.equals(cb.getCaladdr(cb.getPrincipal().getPrincipalRef()))) {
            chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)IcalUtil.getVoter(cb, ca));
            return;
        }
        for (BwAttendee att : ev.getAttendees()) {
            if (!pUri.equals(att.getAttendeeUri())) continue;
            chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, att.clone());
            break;
        }
    }

    private static Response processCandidate(VPoll val, Component comp, EventInfo vpoll, Set<Integer> pids, ChangeTable changes) {
        BwEvent event = vpoll.getEvent();
        String pollItem = comp.toString();
        event.addPollItem(pollItem);
        changes.addValue(PropertyIndex.PropertyInfoIndex.POLL_ITEM, (Object)pollItem);
        Property p = comp.getProperty("POLL-ITEM-ID");
        if (p == null) {
            return Response.error((Response)new Response(), (String)"VPoll candidate - no poll item id");
        }
        int pid = ((PollItemId)p).getPollitemid();
        if (pids.contains(pid)) {
            return Response.error((Response)new Response(), (String)("VPoll candidate - duplicate poll item id " + pid));
        }
        pids.add(pid);
        return Response.ok();
    }

    private static EventInfo findMaster(String guid, Collection<EventInfo> evs) {
        if (evs == null) {
            return null;
        }
        for (EventInfo ei : evs) {
            BwEvent ev = ei.getEvent();
            if (ev.getRecurrenceId() != null || !guid.equals(ev.getUid())) continue;
            return ei;
        }
        return null;
    }

    private static String getUidPar(Property p) {
        ParameterList pars = p.getParameters();
        Parameter par = pars.getParameter("X-BEDEWORK-UID");
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    private static String getAltRepPar(Property p) {
        AltRep par = IcalUtil.getAltRep(p);
        if (par == null) {
            return null;
        }
        return par.getValue();
    }
}

