/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert;

import java.util.Collection;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.property.DtStart;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.convert.Icalendar;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;

public class CnvUtil {
    static boolean colCanRetrieve(BwCalendar col) {
        return col != null && col.getCalType() != 5 && col.getCalType() != 13 && col.getCalType() != 6;
    }

    public static GetEntityResponse<RetrievedEvents> retrieveEvent(IcalCallback cb, String uid, String rid, int entityType, BwCalendar col, Icalendar ical, String startDate, String timeZone, BwLogger logger) {
        DtStart mdtStart;
        GetEntitiesResponse eisResp;
        GetEntityResponse resp = new GetEntityResponse();
        if (!CnvUtil.colCanRetrieve(col)) {
            return (GetEntityResponse)Response.notFound((Response)resp);
        }
        RetrievedEvents re = new RetrievedEvents();
        resp.setEntity((Object)re);
        String colPath = col.getPath();
        if (logger.debug()) {
            logger.debug("TRANS-TO_EVENT: try to fetch event with guid=" + uid);
        }
        if ((eisResp = cb.getEvent(colPath, uid)).isError()) {
            return (GetEntityResponse)Response.fromResponse((Response)resp, (Response)eisResp);
        }
        Collection eis = eisResp.getEntities();
        if (!Util.isEmpty((Collection)eis)) {
            if (eis.size() > 1) {
                return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"More than one event returned for uid.");
            }
            re.evinfo = (EventInfo)eis.iterator().next();
        }
        if (logger.debug()) {
            if (re.evinfo != null) {
                logger.debug("TRANS-TO_EVENT: fetched event with uid");
            } else {
                logger.debug("TRANS-TO_EVENT: did not find event with uid");
            }
        }
        if (re.evinfo != null) {
            if (rid != null) {
                re.masterEI = re.evinfo;
                re.masterEI.setInstanceOnly(true);
                re.evinfo = re.masterEI.findOverride(rid);
                re.evinfo.recurrenceSeen = true;
                ical.addComponent(re.masterEI);
            } else if (ical.getMethodType() == 5) {
                re.evinfo.setInstanceOnly(re.evinfo.getEvent().getSuppressed());
            } else {
                re.evinfo.getEvent().setSuppressed(false);
            }
            return resp;
        }
        if (rid == null) {
            re.evinfo = CnvUtil.makeNewEvent(cb, entityType, uid, colPath);
            return resp;
        }
        re.masterEI = CnvUtil.makeNewEvent(cb, entityType, uid, colPath);
        BwEvent e = re.masterEI.getEvent();
        String bogusDate = "19980118";
        String bogusTime = "T230000";
        boolean isDateType = startDate.length() == 8;
        boolean isUTC = startDate.endsWith("Z");
        try {
            mdtStart = isDateType ? new DtStart(new Date("19980118")) : (isUTC ? new DtStart("19980118T230000Z") : (timeZone == null ? new DtStart("19980118T230000") : new DtStart("19980118T230000", ical.getTimeZone(timeZone))));
        }
        catch (Throwable t) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)t);
        }
        IcalUtil.setDates(cb.getPrincipal().getPrincipalRef(), re.masterEI, mdtStart, null, null);
        e.setSummary("Generated master");
        e.setSuppressed(true);
        re.evinfo = re.masterEI.findOverride(rid);
        re.evinfo.recurrenceSeen = true;
        re.masterEI.setInstanceOnly(true);
        ical.addComponent(re.masterEI);
        return resp;
    }

    public static EventInfo makeNewEvent(IcalCallback cb, int entityType, String uid, String colPath) {
        BwEventObj ev = new BwEventObj();
        EventInfo evinfo = new EventInfo((BwEvent)ev);
        ev.setEntityType(entityType);
        ev.setCreatorHref(cb.getPrincipal().getPrincipalRef());
        ev.setOwnerHref(cb.getOwner().getPrincipalRef());
        ev.setUid(uid);
        ev.setColPath(colPath);
        ChangeTable chg = evinfo.getChangeset(cb.getPrincipal().getPrincipalRef());
        chg.changed(PropertyIndex.PropertyInfoIndex.UID, null, (Object)uid);
        evinfo.setNewEvent(true);
        return evinfo;
    }

    public static class RetrievedEvents {
        public EventInfo masterEI;
        public EventInfo evinfo;
    }
}

