/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwEvent;

public class RecurRuleComponents {
    private String rule;
    private Recur.Frequency freq;
    private Date until;
    private int count;
    private int interval;
    private Collection<Integer> bySecond;
    private Collection<Integer> byMinute;
    private Collection<Integer> byHour;
    private Collection<PosDays> byDay;
    private Collection<Integer> byMonthDay;
    private Collection<Integer> byYearDay;
    private Collection<Integer> byWeekNo;
    private Collection<Integer> byMonth;
    private Collection<Integer> bySetPos;
    private String wkst;

    public void setRule(String val) {
        this.rule = val;
    }

    public String getRule() {
        return this.rule;
    }

    public void setFreq(Recur.Frequency val) {
        this.freq = val;
    }

    public Recur.Frequency getFreq() {
        return this.freq;
    }

    public void setUntil(Date val) {
        this.until = val;
    }

    public Date getUntil() {
        return this.until;
    }

    public void setCount(int val) {
        this.count = val;
    }

    public int getCount() {
        return this.count;
    }

    public void setInterval(int val) {
        this.interval = val;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setBySecond(Collection<Integer> val) {
        this.bySecond = val;
    }

    public Collection<Integer> getBySecond() {
        return this.bySecond;
    }

    public void setByMinute(Collection<Integer> val) {
        this.byMinute = val;
    }

    public Collection<Integer> getByMinute() {
        return this.byMinute;
    }

    public void setByHour(Collection<Integer> val) {
        this.byHour = val;
    }

    public Collection<Integer> getByHour() {
        return this.byHour;
    }

    public void setByDay(Collection<PosDays> val) {
        this.byDay = val;
    }

    public Collection<PosDays> getByDay() {
        return this.byDay;
    }

    public void setByMonthDay(Collection<Integer> val) {
        this.byMonthDay = val;
    }

    public Collection<Integer> getByMonthDay() {
        return this.byMonthDay;
    }

    public void setByYearDay(Collection<Integer> val) {
        this.byYearDay = val;
    }

    public Collection<Integer> getByYearDay() {
        return this.byYearDay;
    }

    public void setByWeekNo(Collection<Integer> val) {
        this.byWeekNo = val;
    }

    public Collection<Integer> getByWeekNo() {
        return this.byWeekNo;
    }

    public void setByMonth(Collection<Integer> val) {
        this.byMonth = val;
    }

    public Collection<Integer> getByMonth() {
        return this.byMonth;
    }

    public void setBySetPos(Collection<Integer> val) {
        this.bySetPos = val;
    }

    public Collection<Integer> getBySetPos() {
        return this.bySetPos;
    }

    public void setWkst(String val) {
        this.wkst = val;
    }

    public String getWkst() {
        return this.wkst;
    }

    public static GetEntitiesResponse<RecurRuleComponents> fromEventRrules(BwEvent ev) {
        GetEntitiesResponse resp = new GetEntitiesResponse();
        if (!ev.isRecurringEntity()) {
            return (GetEntitiesResponse)Response.notFound((Response)resp);
        }
        Set rules = ev.getRrules();
        if (rules == null) {
            return (GetEntitiesResponse)Response.notFound((Response)resp);
        }
        for (String rule : rules) {
            Recur recur;
            RecurRuleComponents rrc = new RecurRuleComponents();
            try {
                recur = new Recur(rule);
            }
            catch (ParseException e) {
                return (GetEntitiesResponse)Response.error((Response)resp, (String)("Invalid RRULE: " + rule));
            }
            rrc.setRule(rule);
            rrc.setFreq(recur.getFrequency());
            Date until = recur.getUntil();
            if (until != null) {
                rrc.setUntil(until);
            } else {
                rrc.setCount(recur.getCount());
            }
            rrc.setInterval(recur.getInterval());
            rrc.setBySecond(RecurRuleComponents.checkNumList(recur.getSecondList()));
            rrc.setByMinute(RecurRuleComponents.checkNumList(recur.getMinuteList()));
            rrc.setByHour(RecurRuleComponents.checkNumList(recur.getHourList()));
            WeekDayList wds = recur.getDayList();
            if (wds != null) {
                HashMap<Integer, Collection> hm = new HashMap<Integer, Collection>();
                for (WeekDay wd : wds) {
                    Collection c = hm.computeIfAbsent(wd.getOffset(), k -> new ArrayList());
                    c.add(wd.getDay().name());
                }
                ArrayList<PosDays> pds = new ArrayList<PosDays>();
                Set poss = hm.keySet();
                for (Integer pos : poss) {
                    pds.add(new PosDays(pos, (Collection)hm.get(pos)));
                }
                rrc.setByDay(pds);
            }
            rrc.setByMonthDay(RecurRuleComponents.checkNumList(recur.getMonthDayList()));
            rrc.setByYearDay(RecurRuleComponents.checkNumList(recur.getYearDayList()));
            rrc.setByWeekNo(RecurRuleComponents.checkNumList(recur.getWeekNoList()));
            rrc.setByMonth(RecurRuleComponents.checkNumList(recur.getMonthList()));
            rrc.setBySetPos(RecurRuleComponents.checkNumList(recur.getSetPosList()));
            if (recur.getWeekStartDay() != null) {
                rrc.setWkst(recur.getWeekStartDay().name());
            }
            resp.addEntity((Object)rrc);
        }
        return (GetEntitiesResponse)Response.ok((Response)resp);
    }

    private static Collection<Integer> checkNumList(NumberList val) {
        if (val == null || val.isEmpty()) {
            return null;
        }
        return val;
    }

    public static class PosDays {
        Integer pos;
        Collection<String> days;

        PosDays(Integer pos, Collection<String> days) {
            this.pos = pos;
            this.days = days;
        }

        public Integer getPos() {
            return this.pos;
        }

        public Collection<String> getDays() {
            return this.days;
        }
    }
}

