/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.ical;

import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.DefaultParameterFactorySupplier;
import net.fortuna.ical4j.data.DefaultPropertyFactorySupplier;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterBuilder;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyBuilder;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.Email;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Language;
import net.fortuna.ical4j.model.parameter.Member;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.ScheduleStatus;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PollItemId;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.model.property.immutable.ImmutableVersion;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.convert.Icalendar;
import org.bedework.util.calendar.IcalendarUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.Timezones;

public class IcalUtil {
    private static final BwLogger logger = new BwLogger().setLoggedClass(IcalUtil.class);
    private static final Supplier<List<PropertyFactory<? extends Property>>> propertyFactorySupplier = new DefaultPropertyFactorySupplier();
    private static final Supplier<List<ParameterFactory<?>>> parameterFactorySupplier = new DefaultParameterFactorySupplier();

    public static Component getXcomp(BwEvent ev, String compName) {
        List xcompProps = ev.getXproperties("X-BEDEWORK-ICAL");
        if (Util.isEmpty((Collection)xcompProps)) {
            return null;
        }
        BwXproperty xcompProp = (BwXproperty)xcompProps.get(0);
        String xcompPropVal = xcompProp.getValue();
        if (xcompPropVal == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Icalendar ic = new Icalendar();
        try {
            sb.append("BEGIN:VCALENDAR\n");
            sb.append(ImmutableVersion.VERSION_2_0);
            sb.append("\n");
            sb.append(xcompPropVal);
            if (!xcompPropVal.endsWith("\n")) {
                sb.append("\n");
            }
            sb.append("END:VCALENDAR\n");
            CalendarBuilder bldr = new CalendarBuilder((CalendarParser)new CalendarParserImpl(), (TimeZoneRegistry)ic);
            UnfoldingReader ufrdr = new UnfoldingReader((Reader)new StringReader(sb.toString()), true);
            Calendar cal = bldr.build(ufrdr);
            if (cal != null) {
                return cal.getComponent(compName);
            }
        }
        catch (Throwable t) {
            logger.error(t);
            logger.error("Trying to parse:\n" + xcompPropVal);
        }
        return null;
    }

    public static void xpropertiesToIcal(PropertyList<Property> pl, List<BwXproperty> xprops) {
        for (BwXproperty x : xprops) {
            String xname = x.getName();
            if (xname.equals("X-BEDEWORK-ICAL-PROP")) {
                ArrayList<BwXproperty.Xpar> params = x.getParameters();
                if (params == null || params.isEmpty()) continue;
                String pname = ((BwXproperty.Xpar)params.get(0)).getValue();
                if (params.size() == 1) {
                    params = null;
                } else {
                    params = new ArrayList<BwXproperty.Xpar>(params);
                    params.remove(0);
                }
                PropertyBuilder propertyBuilder = new PropertyBuilder(propertyFactorySupplier.get()).name(pname);
                ParameterList pars = IcalUtil.makeXparlist(params);
                for (Parameter par : pars) {
                    propertyBuilder.parameter(par);
                }
                propertyBuilder.value(x.getValue());
                try {
                    pl.add(propertyBuilder.build());
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (x.getSkip() || xname.startsWith("X-BEDEWORK-TZ-")) continue;
            IcalUtil.addXproperty(pl, xname, x.getParameters(), x.getValue());
        }
    }

    public static ParameterList makeXparlist(List<BwXproperty.Xpar> pars) {
        ParameterList xparl = new ParameterList();
        if (pars == null) {
            return xparl;
        }
        for (BwXproperty.Xpar xpar : pars) {
            Object xval = xpar.getValue();
            if (((String)xval).contains(":") || ((String)xval).contains(";") || ((String)xval).contains(",")) {
                xval = "\"" + (String)xval + "\"";
            }
            try {
                xparl.add(new ParameterBuilder(parameterFactorySupplier.get()).name(xpar.getName().toUpperCase()).value((String)xval).build());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return xparl;
    }

    public static void addXproperty(PropertyList<Property> pl, String name, List<BwXproperty.Xpar> pars, String val) {
        if (val == null) {
            return;
        }
        pl.add((Property)new XProperty(name, IcalUtil.makeXparlist(pars), val));
    }

    public static String getLang(Property p) {
        ParameterList pars = p.getParameters();
        Parameter par = pars.getParameter("LANGUAGE");
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    public static Organizer setOrganizer(BwOrganizer val) {
        ParameterList pars = new ParameterList();
        try {
            String temp = val.getScheduleStatus();
            if (temp != null) {
                pars.add((Parameter)new ScheduleStatus(temp));
            }
            if ((temp = val.getCn()) != null) {
                pars.add((Parameter)new Cn(temp));
            }
            if ((temp = val.getDir()) != null) {
                pars.add((Parameter)new Dir(temp));
            }
            if ((temp = val.getLanguage()) != null) {
                pars.add((Parameter)new Language(temp));
            }
            if ((temp = val.getSentBy()) != null) {
                pars.add((Parameter)new SentBy(temp));
            }
            return new Organizer(pars, val.getOrganizerUri());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static BwOrganizer getOrganizer(IcalCallback cb, Organizer orgProp) {
        BwOrganizer org = new BwOrganizer();
        org.setOrganizerUri(cb.getCaladdr(orgProp.getValue()));
        ParameterList pars = orgProp.getParameters();
        org.setCn(IcalUtil.getOptStr(pars, "CN"));
        org.setDir(IcalUtil.getOptStr(pars, "DIR"));
        org.setLanguage(IcalUtil.getOptStr(pars, "LANGUAGE"));
        org.setScheduleStatus(IcalUtil.getOptStr(pars, "SCHEDULE-STATUS"));
        org.setSentBy(IcalUtil.getOptStr(pars, "SENT-BY"));
        return org;
    }

    public static Attach setAttachment(BwAttachment val) {
        String uri;
        ParameterList pars = new ParameterList();
        String temp = val.getFmtType();
        if (temp != null) {
            pars.add((Parameter)new FmtType(temp));
        }
        if ((temp = val.getEncoding()) == null) {
            uri = val.getUri();
        } else {
            pars.add((Parameter)new Encoding(temp));
            temp = val.getValueType();
            if (temp != null) {
                pars.add((Parameter)new Value(temp));
            }
            uri = val.getValue();
        }
        try {
            return new Attach(pars, uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static BwAttachment getAttachment(Attach attProp) {
        BwAttachment att = new BwAttachment();
        ParameterList pars = attProp.getParameters();
        att.setFmtType(IcalUtil.getOptStr(pars, "FMTTYPE"));
        att.setValueType(IcalUtil.getOptStr(pars, "VALUE"));
        att.setEncoding(IcalUtil.getOptStr(pars, "ENCODING"));
        if (att.getEncoding() == null) {
            att.setUri(attProp.getValue());
        } else {
            att.setValue(attProp.getValue());
        }
        return att;
    }

    public static Attendee setAttendee(BwAttendee val) {
        Attendee prop;
        try {
            prop = new Attendee(val.getAttendeeUri());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ParameterList pars = prop.getParameters();
        IcalUtil.setAttendeeParams(val, pars);
        String temp = val.getPartstat();
        if (temp != null && !temp.equals("NEEDS-ACTION")) {
            pars.add((Parameter)new PartStat(temp));
        }
        return prop;
    }

    public static Map<Integer, Component> parseVpollCandidates(BwEvent poll) {
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCALENDAR\n");
        sb.append("PRODID://Bedework.org//BedeWork V3.9//EN\n");
        sb.append("VERSION:2.0\n");
        if (!Util.isEmpty((Collection)poll.getPollItems())) {
            for (String s : poll.getPollItems()) {
                sb.append(s);
            }
        }
        sb.append("END:VCALENDAR\n");
        Calendar ical = IcalendarUtil.fromBuilder((String)sb.toString());
        HashMap<Integer, Component> comps = new HashMap<Integer, Component>();
        for (Component comp : ical.getComponents()) {
            PollItemId pid = (PollItemId)comp.getProperty("POLL-ITEM-ID");
            if (pid == null) continue;
            comps.put(pid.getPollitemid(), comp);
        }
        return comps;
    }

    private static void setAttendeeParams(BwAttendee val, ParameterList pars) {
        try {
            String temp;
            if (val.getRsvp()) {
                pars.add((Parameter)Rsvp.TRUE);
            }
            if ((temp = val.getCn()) != null) {
                pars.add((Parameter)new Cn(temp));
            }
            if ((temp = val.getScheduleStatus()) != null) {
                pars.add((Parameter)new ScheduleStatus(temp));
            }
            if ((temp = val.getCuType()) != null) {
                pars.add((Parameter)new CuType(temp));
            }
            if ((temp = val.getEmail()) != null) {
                pars.add((Parameter)new Email(temp));
            }
            if ((temp = val.getDelegatedFrom()) != null) {
                pars.add((Parameter)new DelegatedFrom(temp));
            }
            if ((temp = val.getDelegatedTo()) != null) {
                pars.add((Parameter)new DelegatedTo(temp));
            }
            if ((temp = val.getDir()) != null) {
                pars.add((Parameter)new Dir(temp));
            }
            if ((temp = val.getLanguage()) != null) {
                pars.add((Parameter)new Language(temp));
            }
            if ((temp = val.getMember()) != null) {
                pars.add((Parameter)new Member(temp));
            }
            if ((temp = val.getRole()) != null) {
                pars.add((Parameter)new Role(temp));
            }
            if ((temp = val.getSentBy()) != null) {
                pars.add((Parameter)new SentBy(temp));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static BwAttendee getAttendee(IcalCallback cb, Attendee attProp) {
        ParameterList pars = attProp.getParameters();
        BwAttendee att = IcalUtil.initAttendee(cb, attProp.getValue(), pars);
        att.setPartstat(IcalUtil.getOptStr(pars, "PARTSTAT"));
        if (att.getPartstat() == null) {
            att.setPartstat("NEEDS-ACTION");
        }
        att.setRole(IcalUtil.getOptStr(pars, "ROLE"));
        return att;
    }

    public static BwAttendee initAttendee(IcalCallback cb, String val, ParameterList pars) {
        BwAttendee att = new BwAttendee();
        att.setAttendeeUri(cb.getCaladdr(val));
        att.setCn(IcalUtil.getOptStr(pars, "CN"));
        att.setCuType(IcalUtil.getOptStr(pars, "CUTYPE"));
        att.setDelegatedFrom(IcalUtil.getOptStr(pars, "DELEGATED-FROM"));
        att.setDelegatedTo(IcalUtil.getOptStr(pars, "DELEGATED-TO"));
        att.setDir(IcalUtil.getOptStr(pars, "DIR"));
        att.setLanguage(IcalUtil.getOptStr(pars, "LANGUAGE"));
        att.setMember(IcalUtil.getOptStr(pars, "MEMBER"));
        att.setScheduleStatus(IcalUtil.getOptStr(pars, "SCHEDULE-STATUS"));
        att.setSentBy(IcalUtil.getOptStr(pars, "SENT-BY"));
        att.setEmail(IcalUtil.getOptStr(pars, "EMAIL"));
        Parameter par = pars.getParameter("RSVP");
        if (par != null) {
            att.setRsvp(((Rsvp)par).getRsvp().booleanValue());
        }
        return att;
    }

    public static BwAlarm.TriggerVal getTrigger(PropertyList<Property> pl, boolean absentOk) {
        Trigger prop = (Trigger)pl.getProperty("TRIGGER");
        BwAlarm.TriggerVal tr = new BwAlarm.TriggerVal();
        if (prop == null) {
            if (!absentOk) {
                throw new RuntimeException("Invalid alarm - no trigger");
            }
            return tr;
        }
        tr.trigger = prop.getValue();
        if (prop.getDateTime() != null) {
            tr.triggerDateTime = true;
            return tr;
        }
        ParameterList pars = prop.getParameters();
        if (pars == null) {
            tr.triggerStart = true;
            return tr;
        }
        Parameter par = pars.getParameter("RELATED");
        if (par == null) {
            tr.triggerStart = true;
            return tr;
        }
        tr.triggerStart = "START".equals(par.getValue());
        return tr;
    }

    public static DurationRepeat getDurationRepeat(PropertyList<Property> pl) {
        DurationRepeat dr = new DurationRepeat();
        Property prop = (Property)pl.getProperty("DURATION");
        if (prop == null) {
            return dr;
        }
        dr.duration = prop.getValue();
        prop = (Property)pl.getProperty("REPEAT");
        if (prop == null) {
            throw new RuntimeException("Invalid alarm - no repeat");
        }
        dr.repeat = ((Repeat)prop).getCount();
        return dr;
    }

    public static Collection<BwDateTime> makeDateTimes(DateListProperty val) {
        DateList dl = val.getDates();
        TreeSet<BwDateTime> ts = new TreeSet<BwDateTime>();
        Parameter par = IcalUtil.getParameter((Property)val, "VALUE");
        boolean isDateType = par != null && par.equals((Object)Value.DATE);
        String tzidval = null;
        Parameter tzid = IcalUtil.getParameter((Property)val, "TZID");
        if (tzid != null) {
            tzidval = tzid.getValue();
        }
        for (Date dt : dl) {
            ts.add(BwDateTime.makeBwDateTime((boolean)isDateType, (String)dt.toString(), (String)tzidval));
        }
        return ts;
    }

    public static void addProperty(Component comp, Property val) {
        PropertyList props = comp.getProperties();
        props.add(val);
    }

    public static void addParameter(Property prop, Parameter val) {
        ParameterList parl = prop.getParameters();
        parl.add(val);
    }

    public static Parameter getParameter(Property prop, String name) {
        ParameterList parl = prop.getParameters();
        if (parl == null) {
            return null;
        }
        return parl.getParameter(name);
    }

    public static String getParameterVal(Property prop, String name) {
        ParameterList parl = prop.getParameters();
        if (parl == null) {
            return null;
        }
        return IcalUtil.getOptStr(parl, name);
    }

    public static Property getProperty(Component comp, String name) {
        PropertyList props = comp.getProperties();
        return (Property)props.getProperty(name);
    }

    public static PropertyList<Property> getProperties(Component comp, String name) {
        PropertyList props = comp.getProperties();
        if ((props = props.getProperties(name)).isEmpty()) {
            return null;
        }
        return props;
    }

    public static Iterator<?> getReqStrs(PropertyList<Property> pl, String name) {
        PropertyList props = pl.getProperties(name);
        if (props.isEmpty()) {
            throw new RuntimeException("Missing required property " + name);
        }
        return props.iterator();
    }

    public static String getReqStr(PropertyList<Property> pl, String name) {
        Property prop = (Property)pl.getProperty(name);
        if (prop == null) {
            throw new RuntimeException("Missing required property " + name);
        }
        return prop.getValue();
    }

    public static String getOptStr(PropertyList<Property> pl, String name) {
        Property prop = (Property)pl.getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public static String getOptStr(ParameterList pl, String name) {
        Parameter par = pl.getParameter(name);
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    public static AltRep getAltRep(Property prop) {
        return (AltRep)prop.getParameters().getParameter("ALTREP");
    }

    public static DtEnd makeDtEnd(BwDateTime val) {
        return IcalUtil.makeDtEnd(val, Timezones.getTzRegistry());
    }

    public static DtEnd makeDtEnd(BwDateTime val, TimeZoneRegistry tzreg) {
        DtEnd dt = new DtEnd();
        IcalUtil.initDateProp(val, (DateProperty)dt, tzreg);
        return dt;
    }

    public static Due makeDue(BwDateTime val, TimeZoneRegistry tzreg) {
        Due dt = new Due();
        IcalUtil.initDateProp(val, (DateProperty)dt, tzreg);
        return dt;
    }

    public static DateTime makeDateTime(BwDateTime dt) {
        try {
            return new DateTime(dt.getDtval());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setDates(String userHref, EventInfo ei, DtStart dtStart, DtEnd dtEnd, Duration duration) {
        String durVal;
        boolean vpoll;
        BwEvent ev = ei.getEvent();
        ChangeTable chg = ei.getChangeset(userHref);
        boolean scheduleReply = ev.getScheduleMethod() == 3;
        boolean todo = ev.getEntityType() == 2;
        boolean bl = vpoll = ev.getEntityType() == 7;
        if (dtStart == null) {
            if (!(scheduleReply || todo || vpoll)) {
                throw new RuntimeException("org.bedework.error.nostartdate");
            }
            if (dtEnd != null) {
                try {
                    dtStart = new DtStart(dtEnd.getParameters(), dtEnd.getValue());
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            } else {
                Date now = new Date(new java.util.Date().getTime());
                dtStart = new DtStart(now);
                dtStart.getParameters().add((Parameter)Value.DATE);
            }
            ev.setNoStart(Boolean.valueOf(true));
        } else {
            ev.setNoStart(Boolean.valueOf(false));
        }
        BwDateTime bwDtStart = BwDateTime.makeBwDateTime((DateProperty)dtStart);
        if (!CalFacadeUtil.eqObjval((Object)ev.getDtstart(), (Object)bwDtStart)) {
            chg.changed(PropertyIndex.PropertyInfoIndex.DTSTART, (Object)ev.getDtstart(), (Object)bwDtStart);
            ev.setDtstart(bwDtStart);
        }
        char endType = 'N';
        if (dtEnd != null) {
            endType = 'E';
        } else if (scheduleReply || todo || vpoll) {
            Dur years = new Dur(520);
            Date now = new Date(new java.util.Date().getTime());
            dtEnd = new DtEnd(new Date(years.getTime((java.util.Date)now)));
            dtEnd.getParameters().add((Parameter)Value.DATE);
        }
        if (dtEnd != null) {
            BwDateTime bwDtEnd = BwDateTime.makeBwDateTime((DateProperty)dtEnd);
            if (!CalFacadeUtil.eqObjval((Object)ev.getDtend(), (Object)bwDtEnd)) {
                chg.changed(PropertyIndex.PropertyInfoIndex.DTEND, (Object)ev.getDtend(), (Object)bwDtEnd);
                ev.setDtend(bwDtEnd);
            }
        }
        if (duration != null) {
            if (endType != 'N' && ev.getEntityType() != 4) {
                throw new BedeworkException("org.bedework.exception.ical.endandduration");
            }
            endType = 'D';
            String durVal2 = duration.getValue();
            if (!durVal2.equals(ev.getDuration())) {
                chg.changed(PropertyIndex.PropertyInfoIndex.DURATION, (Object)ev.getDuration(), (Object)durVal2);
                ev.setDuration(durVal2);
            }
            ev.setDtend(BwDateTime.makeDateTime((DateProperty)dtStart, (boolean)ev.getDtstart().getDateType(), (String)durVal2));
        } else if (!scheduleReply && endType == 'N' && !todo) {
            boolean dateOnly = ev.getDtstart().getDateType();
            String dur = dateOnly ? BwDateTime.oneDayForward : "P0D";
            BwDateTime bwDtEnd = BwDateTime.makeDateTime((DateProperty)dtStart, (boolean)dateOnly, (String)dur);
            if (!CalFacadeUtil.eqObjval((Object)ev.getDtend(), (Object)bwDtEnd)) {
                chg.changed(PropertyIndex.PropertyInfoIndex.DTEND, (Object)ev.getDtend(), (Object)bwDtEnd);
                ev.setDtend(bwDtEnd);
            }
        }
        if (endType != 'D' && ev.getDtstart() != null && ev.getDtend() != null && !(durVal = BwDateTime.makeDuration((BwDateTime)ev.getDtstart(), (BwDateTime)ev.getDtend()).toString()).equals(ev.getDuration())) {
            chg.changed(PropertyIndex.PropertyInfoIndex.DURATION, (Object)ev.getDuration(), (Object)durVal);
            ev.setDuration(durVal);
        }
        ev.setEndType(endType);
    }

    private static void initDateProp(BwDateTime val, DateProperty dt, TimeZoneRegistry tzreg) {
        String tzid = val.getTzid();
        ParameterList pl = dt.getParameters();
        if (val.getDateType()) {
            pl.add((Parameter)Value.DATE);
        }
        if (tzid != null) {
            dt.setTimeZone(tzreg.getTimeZone(tzid));
        }
        try {
            dt.setValue(val.getDtval());
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static final class DurationRepeat {
        String duration;
        int repeat;
    }
}

