/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.ical;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.util.calendar.PropertyIndex;

public class VAlarmUtil
extends IcalUtil {
    public static Response processAlarm(IcalCallback cb, Component val, VAlarm va, BwEvent ev, String currentPrincipal, ChangeTable chg) {
        BwAlarm al;
        PropertyList pl = va.getProperties();
        if (pl == null) {
            return Response.error((Response)new Response(), (String)"Invalid alarm list");
        }
        Property prop = (Property)pl.getProperty("X-MOZ-LASTACK");
        boolean mozlastAck = prop != null;
        String mozSnoozeTime = null;
        if (mozlastAck) {
            prop = (Property)pl.getProperty("X-MOZ-SNOOZE-TIME");
            if (prop == null) {
                return Response.ok();
            }
            mozSnoozeTime = prop.getValue();
        }
        if ((prop = (Property)pl.getProperty("ACTION")) == null) {
            return Response.error((Response)new Response(), (String)"Invalid alarm");
        }
        String actionStr = prop.getValue();
        BwAlarm.TriggerVal tr = VAlarmUtil.getTrigger((PropertyList<Property>)pl, "NONE".equals(actionStr));
        if (mozSnoozeTime != null) {
            tr.trigger = mozSnoozeTime;
            tr.triggerDateTime = true;
            tr.triggerStart = false;
        }
        IcalUtil.DurationRepeat dr = VAlarmUtil.getDurationRepeat((PropertyList<Property>)pl);
        if ("EMAIL".equals(actionStr)) {
            al = BwAlarm.emailAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr((PropertyList<Property>)pl, "ATTACH"), (String)VAlarmUtil.getReqStr((PropertyList<Property>)pl, "DESCRIPTION"), (String)VAlarmUtil.getReqStr((PropertyList<Property>)pl, "SUMMARY"), null);
            Iterator<?> atts = VAlarmUtil.getReqStrs((PropertyList<Property>)pl, "ATTENDEE");
            while (atts.hasNext()) {
                al.addAttendee(VAlarmUtil.getAttendee(cb, (Attendee)atts.next()));
            }
        } else {
            al = "AUDIO".equals(actionStr) ? BwAlarm.audioAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr((PropertyList<Property>)pl, "ATTACH")) : ("DISPLAY".equals(actionStr) ? BwAlarm.displayAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getReqStr((PropertyList<Property>)pl, "DESCRIPTION")) : ("PROCEDURE".equals(actionStr) ? BwAlarm.procedureAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getReqStr((PropertyList<Property>)pl, "ATTACH"), (String)VAlarmUtil.getOptStr((PropertyList<Property>)pl, "DESCRIPTION")) : ("NONE".equals(actionStr) ? BwAlarm.noneAlarm((String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr((PropertyList<Property>)pl, "DESCRIPTION")) : BwAlarm.otherAlarm((String)ev.getCreatorHref(), (String)actionStr, (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr((PropertyList<Property>)pl, "DESCRIPTION")))));
        }
        for (Property property : pl) {
            prop = property;
            if (prop instanceof XProperty) {
                XProperty xp = (XProperty)prop;
                al.addXproperty(new BwXproperty(xp.getName(), xp.getParameters().toString(), xp.getValue()));
                continue;
            }
            if (!(prop instanceof Uid)) continue;
            Uid p = (Uid)prop;
            al.addXproperty(BwXproperty.makeIcalProperty((String)p.getName(), (String)p.getParameters().toString(), (String)p.getValue()));
        }
        al.setOwnerHref(currentPrincipal);
        chg.addValue(PropertyIndex.PropertyInfoIndex.VALARM, (Object)al);
        return Response.ok();
    }

    public static void processEventAlarm(BwEvent ev, Component comp, String currentPrincipal) {
        ComponentList vals;
        if (currentPrincipal == null) {
            return;
        }
        Set als = ev.getAlarms();
        if (als == null || als.isEmpty()) {
            return;
        }
        if (comp instanceof VEvent) {
            vals = ((VEvent)comp).getComponents();
        } else if (comp instanceof VToDo) {
            vals = ((VToDo)comp).getComponents();
        } else {
            throw new RuntimeException("org.bedework.invalid.component.type " + comp.getName());
        }
        for (BwAlarm alarm : als) {
            if (!currentPrincipal.equals(alarm.getOwnerHref())) continue;
            vals.add((Object)VAlarmUtil.setAlarm(ev, alarm));
        }
    }

    private static VAlarm setAlarm(BwEvent ev, BwAlarm val) {
        try {
            String action;
            VAlarm alarm = new VAlarm();
            int atype = val.getAlarmType();
            if (atype != 5) {
                action = BwAlarm.alarmTypes[atype];
            } else {
                List xps = val.getXicalProperties("ACTION");
                action = ((BwXproperty)xps.get(0)).getValue();
            }
            VAlarmUtil.addProperty((Component)alarm, (Property)new Action(action));
            if (val.getTriggerDateTime()) {
                DateTime dt = new DateTime(val.getTrigger());
                VAlarmUtil.addProperty((Component)alarm, (Property)new Trigger(dt));
            } else {
                Trigger tr = new Trigger(new Dur(val.getTrigger()));
                if (!val.getTriggerStart()) {
                    VAlarmUtil.addParameter((Property)tr, (Parameter)Related.END);
                } else {
                    VAlarmUtil.addParameter((Property)tr, (Parameter)Related.START);
                }
                VAlarmUtil.addProperty((Component)alarm, (Property)tr);
            }
            if (val.getDuration() != null) {
                VAlarmUtil.addProperty((Component)alarm, (Property)new Duration(new Dur(val.getDuration())));
                VAlarmUtil.addProperty((Component)alarm, (Property)new Repeat(val.getRepeat()));
            }
            if (atype == 0) {
                if (val.getAttach() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Attach(new URI(val.getAttach())));
                }
            } else if (atype == 1) {
                if (val.getDescription() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
                } else {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Description(ev.getSummary()));
                }
            } else if (atype == 2) {
                if (val.getAttach() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Attach(new URI(val.getAttach())));
                }
                VAlarmUtil.checkRequiredProperty(val.getDescription(), "alarm-description");
                VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
                VAlarmUtil.checkRequiredProperty(val.getSummary(), "alarm-summary");
                VAlarmUtil.addProperty((Component)alarm, (Property)new Summary(val.getSummary()));
                if (val.getNumAttendees() > 0) {
                    for (BwAttendee att : val.getAttendees()) {
                        VAlarmUtil.addProperty((Component)alarm, (Property)VAlarmUtil.setAttendee(att));
                    }
                }
            } else if (atype == 3) {
                VAlarmUtil.checkRequiredProperty(val.getAttach(), "alarm-attach");
                VAlarmUtil.addProperty((Component)alarm, (Property)new Attach(new URI(val.getAttach())));
                if (val.getDescription() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
                }
            } else if (val.getDescription() != null) {
                VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
            }
            if (val.getNumXproperties() > 0) {
                VAlarmUtil.xpropertiesToIcal((PropertyList<Property>)alarm.getProperties(), val.getXproperties());
            }
            return alarm;
        }
        catch (BedeworkException bfe) {
            throw bfe;
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    private static void checkRequiredProperty(String val, String name) {
        if (val == null) {
            throw new BedeworkException("org.bedework.icalendar.missing.required.property", name);
        }
    }
}

