/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.ical;

import java.util.List;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Uid;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.convert.ical.IcalUtil;

public class VFreeUtil
extends IcalUtil {
    public static VFreeBusy toVFreeBusy(BwEvent val) {
        try {
            BwOrganizer org;
            List times;
            VFreeBusy vfb = new VFreeBusy(VFreeUtil.makeDateTime(val.getDtstart()), VFreeUtil.makeDateTime(val.getDtend()));
            PropertyList pl = vfb.getProperties();
            if (val.getNumAttendees() > 0) {
                for (BwAttendee att : val.getAttendees()) {
                    pl.add((Property)VFreeUtil.setAttendee(att));
                }
            }
            if (val.getNumComments() > 0) {
                for (Object str : val.getComments()) {
                    pl.add((Property)new Comment(str.getValue()));
                }
            }
            if (val.getDtstamp() != null) {
                DtStamp dts = (DtStamp)pl.getProperty("DTSTAMP");
                if (dts == null) {
                    DtStamp prop = new DtStamp(new DateTime(val.getDtstamp()));
                    pl.add((Property)prop);
                } else {
                    dts.setDateTime(new DateTime(val.getDtstamp()));
                }
            }
            if ((times = val.getFreeBusyPeriods()) != null) {
                for (BwFreeBusyComponent fbc : times) {
                    FreeBusy fb = new FreeBusy();
                    int type = fbc.getType();
                    if (type == 0) {
                        VFreeUtil.addParameter((Property)fb, (Parameter)FbType.BUSY);
                    } else if (type == 1) {
                        VFreeUtil.addParameter((Property)fb, (Parameter)FbType.FREE);
                    } else if (type == 2) {
                        VFreeUtil.addParameter((Property)fb, (Parameter)FbType.BUSY_UNAVAILABLE);
                    } else if (type == 3) {
                        VFreeUtil.addParameter((Property)fb, (Parameter)FbType.BUSY_TENTATIVE);
                    } else {
                        throw new BedeworkException("Bad free-busy type " + type);
                    }
                    PeriodList pdl = fb.getPeriods();
                    for (Period p : fbc.getPeriods()) {
                        Period np = new Period(p.getStart(), p.getEnd());
                        pdl.add(np);
                    }
                    pl.add((Property)fb);
                }
            }
            if ((org = val.getOrganizer()) != null) {
                pl.add((Property)VFreeUtil.setOrganizer(org));
            }
            if (val.getUid() != null) {
                pl.add((Property)new Uid(val.getUid()));
            }
            return vfb;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

