/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.ical;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VLocation;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Schema;
import net.fortuna.ical4j.model.property.LocationType;
import net.fortuna.ical4j.model.property.StructuredData;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.immutable.ImmutableRelativeTo;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwXproperty;
import org.bedework.schemaorg.impl.SOMapper;
import org.bedework.schemaorg.model.values.SOGeo;
import org.bedework.schemaorg.model.values.SOGeoCoordinates;
import org.bedework.schemaorg.model.values.SOPlace;
import org.bedework.schemaorg.model.values.SOPostalAddress;
import org.bedework.util.calendar.IcalendarUtil;
import org.bedework.util.misc.Util;

public class VLocationUtil {
    private final SOMapper somapper = new SOMapper();

    public GetEntityResponse<VLocation> toVlocation(BwLocation loc, Relto relTo) {
        GetEntityResponse resp = new GetEntityResponse();
        VLocation vloc = new VLocation();
        try {
            PropertyList plist = vloc.getProperties();
            SOPlace pl = (SOPlace)this.somapper.getJFactory().newValue("Place");
            SOPostalAddress pa = (SOPostalAddress)this.somapper.getJFactory().newValue("PostalAddress");
            plist.add((Property)new Uid(loc.getUid()));
            pa.setIdentifier(loc.getUid());
            if (relTo == Relto.start) {
                plist.add((Property)ImmutableRelativeTo.START);
            } else if (relTo == Relto.end) {
                plist.add((Property)ImmutableRelativeTo.END);
            }
            if (loc.getGeouri() != null) {
                URI geouri = new URI(loc.getGeouri());
                plist.add((Property)new Url(geouri));
                SOGeoCoordinates geo = (SOGeoCoordinates)this.somapper.getJFactory().newValue("GeoCoordinates");
                geo.setURI(geouri);
                pl.setGeo((SOGeo)geo);
            }
            if (loc.getLoctype() != null) {
                plist.add((Property)new LocationType(loc.getLoctype()));
            }
            pa.setName(loc.getAddressField());
            pa.setStreetAddress(loc.getStreet());
            pa.setAddressLocality(loc.getCity());
            pa.setAddressRegion(loc.getState());
            pa.setAddressCountry(loc.getCountry());
            pa.setPostalCode(loc.getZip());
            pl.setAddress(pa);
            StructuredData sdata = new StructuredData(pl.writeValueAsStringFormatted((ObjectMapper)this.somapper));
            sdata.getParameters().add((Parameter)new Schema(this.somapper.getSchema("Place")));
            plist.add((Property)sdata);
        }
        catch (Throwable t) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)t);
        }
        resp.setEntity((Object)vloc);
        return (GetEntityResponse)Response.ok((Response)resp);
    }

    public static GetEntitiesResponse<VLocation> getVlocations(BwEvent ev) {
        GetEntitiesResponse geresp = new GetEntitiesResponse();
        List xlocs = ev.getXproperties("X-BEDEWORK-VLOCATION");
        if (Util.isEmpty((Collection)xlocs)) {
            return (GetEntitiesResponse)Response.notFound((Response)geresp);
        }
        StringBuilder sb = new StringBuilder("BEGIN:VCALENDAR\nPRODID://Bedework.org//BedeWork V3.9//EN\nVERSION:2.0\nBEGIN:VTODO\nUID:0123\n");
        for (BwXproperty xloc : xlocs) {
            sb.append(xloc.getValue());
        }
        sb.append("END:VTODO\nEND:VCALENDAR\n");
        Calendar ical = IcalendarUtil.fromBuilder((String)sb.toString());
        VToDo comp = (VToDo)ical.getComponent("VTODO");
        ComponentList vlocs = comp.getComponents("VLOCATION");
        for (Component o : vlocs) {
            geresp.addEntity((Object)((VLocation)o));
        }
        return geresp;
    }

    public static enum Relto {
        start,
        end,
        none;

    }
}

