/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.jscal;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.RRule;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.BwDiffer;
import org.bedework.convert.DifferResult;
import org.bedework.convert.jscal.BwJSFactory;
import org.bedework.convert.jscal.BwJSRegistration;
import org.bedework.jsforj.JSRegistration;
import org.bedework.jsforj.impl.JSFactory;
import org.bedework.jsforj.impl.values.dataTypes.JSDurationImpl;
import org.bedework.jsforj.impl.values.dataTypes.JSLocalDateTimeImpl;
import org.bedework.jsforj.impl.values.dataTypes.JSSignedDurationImpl;
import org.bedework.jsforj.impl.values.dataTypes.JSStringImpl;
import org.bedework.jsforj.impl.values.dataTypes.JSUTCDateTimeImpl;
import org.bedework.jsforj.impl.values.dataTypes.JSUnsignedIntegerImpl;
import org.bedework.jsforj.model.JSCalendarObject;
import org.bedework.jsforj.model.JSProperty;
import org.bedework.jsforj.model.values.JSAbsoluteTrigger;
import org.bedework.jsforj.model.values.JSAlert;
import org.bedework.jsforj.model.values.JSLink;
import org.bedework.jsforj.model.values.JSLocation;
import org.bedework.jsforj.model.values.JSOffsetTrigger;
import org.bedework.jsforj.model.values.JSOverride;
import org.bedework.jsforj.model.values.JSParticipant;
import org.bedework.jsforj.model.values.JSRecurrenceRule;
import org.bedework.jsforj.model.values.JSRelation;
import org.bedework.jsforj.model.values.JSRoles;
import org.bedework.jsforj.model.values.JSTrigger;
import org.bedework.jsforj.model.values.JSValue;
import org.bedework.jsforj.model.values.collections.JSAlerts;
import org.bedework.jsforj.model.values.collections.JSArray;
import org.bedework.jsforj.model.values.collections.JSLinks;
import org.bedework.jsforj.model.values.collections.JSList;
import org.bedework.jsforj.model.values.collections.JSLocations;
import org.bedework.jsforj.model.values.collections.JSParticipants;
import org.bedework.jsforj.model.values.collections.JSRecurrenceOverrides;
import org.bedework.jsforj.model.values.collections.JSRecurrenceRules;
import org.bedework.jsforj.model.values.collections.JSRelations;
import org.bedework.jsforj.model.values.collections.JSSendTo;
import org.bedework.jsforj.model.values.dataTypes.JSLocalDateTime;
import org.bedework.jsforj.model.values.dataTypes.JSSignedDuration;
import org.bedework.jsforj.model.values.dataTypes.JSURI;
import org.bedework.jsforj.model.values.dataTypes.JSUTCDateTime;
import org.bedework.jsforj.model.values.dataTypes.JSUnsignedInteger;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.vcard.Card;

public class BwEvent2JsCal {
    static final JSFactory factory = BwJSFactory.getFactory();
    private static final BwLogger logger;
    private static final String dataUriPrefix = "data:text/plain;base64,";
    private static final int dataUriPrefixLen;

    public static GetEntityResponse<JSCalendarObject> convert(EventInfo ei, EventInfo master, JSCalendarObject jsCalMaster, int method, TimeZoneRegistry tzreg, String currentPrincipal) {
        GetEntityResponse resp = new GetEntityResponse();
        if (ei == null || ei.getEvent() == null) {
            return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.failed, (String)"No entity supplied");
        }
        BwEvent val = ei.getEvent();
        boolean isInstance = false;
        try {
            URI uri;
            String status;
            BwGeo bwgeo;
            List fbps;
            Object durDiff;
            BwDateTime bdt;
            String lastMod;
            String dtstamp;
            int updCmp;
            String updatedVal;
            JSRecurrenceOverrides ovs;
            String jstype;
            boolean freeBusy = false;
            boolean vavail = false;
            boolean todo = false;
            boolean event = false;
            boolean vpoll = false;
            switch (val.getEntityType()) {
                case 0: {
                    jstype = "Event";
                    event = true;
                    break;
                }
                case 2: {
                    jstype = "Task";
                    todo = true;
                    break;
                }
                case 7: {
                    jstype = "Vpoll";
                    vpoll = true;
                    break;
                }
                default: {
                    return (GetEntityResponse)Response.error((Response)resp, (String)("org.bedework.invalid.entity.type: " + val.getEntityType()));
                }
            }
            JSCalendarObject jsval = null;
            if (master == null) {
                jsval = (JSCalendarObject)factory.newValue(jstype);
                ovs = null;
            } else {
                ovs = jsCalMaster.getOverrides(true);
            }
            String strval = val.getRecurrenceId();
            JSLocalDateTimeImpl rid = null;
            if (strval != null && strval.length() > 0) {
                rid = new JSLocalDateTimeImpl(BwEvent2JsCal.jsonDate(BwEvent2JsCal.timeInZone(strval, BwEvent2JsCal.findZone(val.getDtstart(), val.getDtend()), tzreg)));
                isInstance = true;
                if (master == null) {
                    jsval.setRecurrenceId((JSLocalDateTime)rid);
                    throw new RuntimeException("Need to set recurrenceIdTimeZone");
                }
                JSOverride ov = (JSOverride)ovs.makeEntry((Object)rid).getValue();
                if (ov.getExcluded()) {
                    throw new RuntimeException("Cannot have override for exdate");
                }
                jsval = ov;
            }
            if (jsval == null) {
                return (GetEntityResponse)Response.error((Response)resp, (String)"Badly formatted component");
            }
            BwEvent2JsCal.doAlarms(val, master, jsval, jsCalMaster);
            BwEvent2JsCal.doAttachments(val, master, jsval, jsCalMaster);
            BwEvent2JsCal.doAttendees(val, master, jsval, jsCalMaster);
            BwEvent2JsCal.doCategories(val, master, jsval, jsCalMaster);
            String clazz = val.getClassification();
            DifferResult classDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.CLASS, clazz, master);
            if (classDiff.differs) {
                if (clazz.equalsIgnoreCase("confidential")) {
                    jsval.setProperty("privacy", "secret");
                } else {
                    jsval.setProperty("privacy", clazz.toLowerCase());
                }
            }
            String color = val.getColor();
            DifferResult colorDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.COLOR, color, master);
            if (colorDiff.differs) {
                jsval.setProperty("color", color);
            }
            if (todo || vpoll) {
                String completed = val.getCompleted();
                DifferResult compDiff = BwDiffer.differs(BwString.class, PropertyIndex.PropertyInfoIndex.COMPLETED, completed, master);
                if (compDiff.differs) {
                    jsval.setProperty("progress", "completed");
                    jsval.setProperty("progressUpdated", BwEvent2JsCal.jsonDate(completed));
                }
            }
            BwEvent2JsCal.doConcepts(val, master, jsval, jsCalMaster);
            BwEvent2JsCal.doContacts(val, master, jsval, jsCalMaster);
            if (val.getCost() != null) {
                BwEvent2JsCal.addXproperty(jsval, jsCalMaster, "X-BEDEWORK-COST", val.getCost());
            }
            if (master == null && val.getCreated() != null) {
                jsval.setProperty("created", (JSValue)new JSUTCDateTimeImpl(BwEvent2JsCal.jsonDate(val.getCreated())));
            }
            if (val.getDeleted()) {
                BwEvent2JsCal.addXproperty(jsval, jsCalMaster, "X-BEDEWORK-DELETED", String.valueOf(val.getDeleted()));
            }
            String descVal = val.getDescription();
            DifferResult descDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.DESCRIPTION, descVal, master);
            if (descDiff.differs) {
                jsval.setProperty("description", descVal);
            }
            if (master == null && (updatedVal = (updCmp = Util.cmpObjval((Comparable)((Object)(dtstamp = val.getDtstamp())), (Comparable)((Object)(lastMod = val.getLastmod())))) <= 0 ? dtstamp : lastMod) != null) {
                jsval.setProperty("created", (JSValue)new JSUTCDateTimeImpl(BwEvent2JsCal.jsonDate(updatedVal)));
            }
            String startTimezone = null;
            if (!val.getNoStart().booleanValue()) {
                bdt = val.getDtstart();
                startTimezone = BwEvent2JsCal.jscalTzid(bdt, true, master);
                String jsStart = BwEvent2JsCal.jscalDt(bdt);
                if (rid == null || !jsStart.equals(rid.getStringValue())) {
                    jsval.setProperty("start", (JSValue)new JSLocalDateTimeImpl(jsStart));
                    if (bdt.getDateType() && master == null) {
                        jsval.setProperty("showWithoutTime", true);
                    }
                    if (startTimezone != null) {
                        jsval.setProperty("timeZone", startTimezone);
                    }
                }
            }
            if (val.getEndType() == 'E') {
                bdt = val.getDtend();
                String tzid = BwEvent2JsCal.jscalTzid(bdt, false, master);
                if (val.getNoStart().booleanValue() && tzid != null) {
                    jsval.setProperty("timeZone", tzid);
                }
                if (todo) {
                    BwEvent2JsCal.sameZone(val.getDtstart(), bdt);
                    jsval.setProperty("due", BwEvent2JsCal.jscalDt(bdt));
                } else {
                    if (Util.cmpObjval((Comparable)((Object)tzid), (Comparable)((Object)startTimezone)) != 0) {
                        JSLocations locs = jsval.getLocations(true);
                        JSLocation loc = (JSLocation)locs.makeLocation().getValue();
                        loc.setTimeZone(tzid);
                        loc.setRelativeTo("end");
                    }
                    String durVal = BwDateTime.makeDuration((BwDateTime)val.getDtstart(), (BwDateTime)bdt).toString();
                    durDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.DURATION, durVal, master);
                    if (((DifferResult)durDiff).differs) {
                        jsval.setProperty("duration", durVal);
                    }
                }
            } else if (val.getEndType() == 'D') {
                String durVal = val.getDuration();
                DifferResult durDiff2 = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.DURATION, durVal, master);
                if (durDiff2.differs) {
                    jsval.setProperty("duration", (JSValue)new JSDurationImpl(durVal));
                }
            }
            String estDur = val.getEstimatedDuration();
            DifferResult estdDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.ESTIMATED_DURATION, estDur, master);
            if (estdDiff.differs) {
                jsval.setProperty("estimatedDuration", estDur);
            }
            if (freeBusy && (fbps = val.getFreeBusyPeriods()) != null && (durDiff = fbps.iterator()).hasNext()) {
                BwFreeBusyComponent fbc = (BwFreeBusyComponent)durDiff.next();
                FreeBusy fb = new FreeBusy();
                throw new RuntimeException("Not done");
            }
            if (!vpoll && (bwgeo = val.getGeo()) != null) {
                Geo geo = new Geo(bwgeo.getLatitude(), bwgeo.getLongitude());
                throw new RuntimeException("Not done");
            }
            BwEvent2JsCal.doLocation(val, master, jsval, jsCalMaster);
            BwEvent2JsCal.doOrganizer(val, master, jsval, jsCalMaster);
            BwEvent2JsCal.doPercentComplete(val, master, jsval, jsCalMaster, method);
            Integer prio = val.getPriority();
            DifferResult prioDiff = BwDiffer.differs(Integer.class, PropertyIndex.PropertyInfoIndex.PRIORITY, prio, master);
            if (prioDiff.differs) {
                jsval.setProperty("priority", (JSValue)new JSUnsignedIntegerImpl(prio.intValue()));
            }
            BwEvent2JsCal.doRelatedTo(val, master, jsval, jsCalMaster);
            if (val.getNumResources() > 0) {
                Set resources = val.getResources();
                DifferResult resDiff = BwDiffer.differs(BwString.class, PropertyIndex.PropertyInfoIndex.RESOURCES, resources, master);
                if (resDiff.differs) {
                    for (BwString bs : resources) {
                        JSParticipants parts = jsval.getParticipants(true);
                        JSParticipant jsResource = (JSParticipant)parts.makeParticipant().getValue();
                        jsResource.getRoles(true).add((Object)"required");
                        jsResource.setKind("resource");
                        if (bs.getLang() != null) {
                            jsResource.setLanguage(bs.getLang());
                        }
                        jsResource.setName(bs.getValue());
                    }
                }
            }
            int seq = val.getSequence();
            DifferResult seqDiff = BwDiffer.differs(Integer.class, PropertyIndex.PropertyInfoIndex.SEQUENCE, seq, master);
            if (seqDiff.differs && (master != null || seq != 0)) {
                jsval.setProperty("sequence", (JSValue)new JSUnsignedIntegerImpl(seq));
            }
            if ((status = val.getStatus()) != null && !status.equals("MASTER-SUPPRESSED")) {
                DifferResult statusDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.STATUS, status, master);
                if (statusDiff.differs) {
                    if (event) {
                        jsval.setProperty("status", status.toLowerCase());
                    } else {
                        jsval.setProperty("progress", status.toLowerCase());
                    }
                }
            }
            String summary = val.getSummary();
            DifferResult sumDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.SUMMARY, summary, master);
            if (sumDiff.differs) {
                jsval.setProperty("title", summary);
            }
            if (!todo && !vpoll) {
                strval = val.getPeruserTransparency(currentPrincipal);
                DifferResult transpDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.TRANSP, strval, master);
                if (transpDiff.differs) {
                    if (strval.equalsIgnoreCase("opaque")) {
                        jsval.setProperty("freeBusyStatus", "busy");
                    } else {
                        jsval.setProperty("freeBusyStatus", "free");
                    }
                }
            }
            if (master == null) {
                jsval.setUid(val.getUid());
            }
            if ((strval = val.getLink()) != null) {
                strval = strval.trim();
            }
            DifferResult urlDiff = BwDiffer.differs(String.class, PropertyIndex.PropertyInfoIndex.URL, strval, master);
            if (urlDiff.differs && (uri = Util.validURI((String)strval)) != null) {
                BwEvent2JsCal.addLink(jsval, strval, "describedby");
            }
            if (val.getNumXproperties() > 0) {
                // empty if block
            }
            if (!vpoll && !isInstance && val.isRecurringEntity()) {
                BwEvent2JsCal.doRecurring(val, jsval, tzreg);
            }
            if (vavail) {
                throw new RuntimeException("Not done");
            }
            List xlocs = val.getXproperties("X-BEDEWORK-LOCATION");
            resp.setEntity((Object)jsval);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return resp;
    }

    private static String jscalDt(BwDateTime bdt) {
        if (bdt.isUTC()) {
            return BwEvent2JsCal.jsonDate(bdt.getDtval().substring(0, bdt.getDtval().length() - 1));
        }
        if (bdt.getDateType()) {
            return BwEvent2JsCal.jsonDate(bdt.getDtval() + "T000000");
        }
        return BwEvent2JsCal.jsonDate(bdt.getDtval());
    }

    private static String jscalTzid(BwDateTime bdt, boolean start, EventInfo master) {
        BwDateTime mbdt;
        if (bdt.isUTC()) {
            return "Etc/UTC";
        }
        if (bdt.getDateType()) {
            return null;
        }
        if (master != null && (mbdt = start ? master.getEvent().getDtstart() : master.getEvent().getDtend()) != null && Util.cmpObjval((Comparable)((Object)bdt.getTzid()), (Comparable)((Object)mbdt.getTzid())) == 0) {
            return null;
        }
        return bdt.getTzid();
    }

    private static String findZone(BwDateTime start, BwDateTime end) {
        if (start != null) {
            return start.getTzid();
        }
        return end.getTzid();
    }

    private static void sameZone(BwDateTime start, BwDateTime due) {
        if (start == null) {
            return;
        }
        if (due.isUTC() != start.isUTC() || due.getDateType() != start.getDateType() || Util.cmpObjval((Comparable)((Object)due.getTzid()), (Comparable)((Object)start.getTzid())) != 0) {
            throw new RuntimeException("Start zone and due zone must be equal");
        }
    }

    private static void doRecurring(BwEvent val, JSCalendarObject jsval, TimeZoneRegistry tzreg) {
        if (val.hasRrules()) {
            for (String rl : val.getRrules()) {
                BwEvent2JsCal.makeRule(true, val, jsval, rl, tzreg);
            }
        }
        if (val.hasExrules()) {
            for (String rl : val.getExrules()) {
                JSRecurrenceRule jSRecurrenceRule = BwEvent2JsCal.makeRule(false, val, jsval, rl, tzreg);
            }
        }
        BwEvent2JsCal.makeRexdates(val, false, val.getRdates(), jsval, tzreg);
        BwEvent2JsCal.makeRexdates(val, true, val.getExdates(), jsval, tzreg);
    }

    private static JSRecurrenceRule makeRule(boolean rrules, BwEvent val, JSCalendarObject jsval, String iCalRule, TimeZoneRegistry tzreg) {
        JSArray mdl;
        RRule rule = new RRule();
        try {
            rule.setValue(iCalRule);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        JSRecurrenceRules rules = rrules ? jsval.getRecurrenceRules(true) : jsval.getExcludedRecurrenceRules(true);
        JSRecurrenceRule rrule = rules.makeRecurrenceRule();
        Recur recur = rule.getRecur();
        if (recur.getFrequency() != null) {
            rrule.setFrequency(recur.getFrequency().name().toLowerCase());
        }
        if (recur.getInterval() != -1) {
            rrule.setInterval((JSUnsignedInteger)new JSUnsignedIntegerImpl(recur.getInterval()));
        }
        if (!Util.isEmpty((Collection)recur.getDayList())) {
            for (WeekDay d : recur.getDayList()) {
                rrule.addByDayValue(d.getDay().name().toLowerCase(), Integer.valueOf(d.getOffset()));
            }
        }
        if (!Util.isEmpty((Collection)recur.getMonthDayList())) {
            mdl = rrule.getByMonthDay(true);
            for (Integer md : recur.getMonthDayList()) {
                mdl.add((Object)md);
            }
        }
        if (!Util.isEmpty((Collection)recur.getMonthList())) {
            mdl = rrule.getByMonth(true);
            for (Integer md : recur.getMonthList()) {
                mdl.add((Object)String.valueOf(md));
            }
        }
        if (!Util.isEmpty((Collection)recur.getYearDayList())) {
            JSArray ydl = rrule.getByYearDay(true);
            for (Integer yd : recur.getYearDayList()) {
                ydl.add((Object)yd);
            }
        }
        if (!Util.isEmpty((Collection)recur.getWeekNoList())) {
            JSArray wnl = rrule.getByWeekNo(true);
            for (Integer wn : recur.getWeekNoList()) {
                wnl.add((Object)wn);
            }
        }
        if (!Util.isEmpty((Collection)recur.getHourList())) {
            JSArray hl = rrule.getByHour(true);
            for (Integer h : recur.getHourList()) {
                hl.add((Object)new JSUnsignedIntegerImpl(h.intValue()));
            }
        }
        if (!Util.isEmpty((Collection)recur.getMinuteList())) {
            JSArray ml = rrule.getByMinute(true);
            for (Integer m : recur.getMinuteList()) {
                ml.add((Object)new JSUnsignedIntegerImpl(m.intValue()));
            }
        }
        if (!Util.isEmpty((Collection)recur.getSecondList())) {
            JSArray sl = rrule.getBySecond(true);
            for (Integer s : recur.getSecondList()) {
                sl.add((Object)new JSUnsignedIntegerImpl(s.intValue()));
            }
        }
        if (!Util.isEmpty((Collection)recur.getSetPosList())) {
            JSArray spl = rrule.getBySetPosition(true);
            for (Integer s : recur.getSetPosList()) {
                spl.add((Object)s);
            }
        }
        if (recur.getCount() > 0) {
            rrule.setCount((JSUnsignedInteger)new JSUnsignedIntegerImpl(recur.getCount()));
        }
        if (recur.getUntil() != null) {
            JSLocalDateTimeImpl until = new JSLocalDateTimeImpl(BwEvent2JsCal.jsonDate(BwEvent2JsCal.timeInZone(recur.getUntil().toString(), BwEvent2JsCal.findZone(val.getDtstart(), val.getDtend()), tzreg)));
            rrule.setUntil((JSLocalDateTime)until);
        }
        return rrule;
    }

    private static void makeRexdates(BwEvent val, boolean exdt, Collection<BwDateTime> dts, JSCalendarObject jsval, TimeZoneRegistry tzreg) {
        BwDateTime dtstart;
        if (dts == null || dts.isEmpty()) {
            return;
        }
        String tzid = null;
        if (!val.getForceUTC() && (dtstart = val.getDtstart()) != null && !dtstart.isUTC()) {
            DtStart ds = dtstart.makeDtStart();
            tzid = ds.getTimeZone().getID();
        }
        JSRecurrenceOverrides overrides = jsval.getOverrides(true);
        for (BwDateTime dt : dts) {
            JSLocalDateTimeImpl rid = new JSLocalDateTimeImpl(BwEvent2JsCal.jsonDate(BwEvent2JsCal.timeInZone(dt.getDtval(), tzid, tzreg)));
            JSProperty ov = overrides.makeEntry((Object)rid);
            if (!exdt) continue;
            ((JSOverride)ov.getValue()).markExcluded();
        }
    }

    private static void doAlarms(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        Set alarms = event.getAlarms();
        DifferResult alarmDiff = BwDiffer.differs(BwAlarm.class, PropertyIndex.PropertyInfoIndex.VALARM, alarms, master);
        if (!alarmDiff.differs) {
            return;
        }
        if (master == null || alarmDiff.addAll) {
            JSAlerts alerts = jsval.getAlerts(true);
            for (BwAlarm alarm : alarms) {
                BwEvent2JsCal.makeAlarm(alerts, alarm);
            }
            return;
        }
        JSOverride override = (JSOverride)jsval;
        if (alarmDiff.removeAll) {
            override.setNull(new String[]{"alerts"});
            return;
        }
        if (!Util.isEmpty(alarmDiff.removed)) {
            for (BwAlarm alarm : alarmDiff.removed) {
                JSAlerts masterAlerts = jsCalMaster.getAlerts(false);
                if (masterAlerts == null) {
                    throw new RuntimeException("Bad patch - removing from missing master object");
                }
                for (JSProperty jsalertp : masterAlerts.get()) {
                    if (!BwEvent2JsCal.compareAlarm(alarm, (JSProperty<JSAlert>)jsalertp)) continue;
                    override.setNull(new String[]{"alerts", jsalertp.getName()});
                }
            }
        }
        if (!Util.isEmpty(alarmDiff.added)) {
            JSAlerts alerts = jsval.getAlerts(true);
            for (BwAlarm alarm : alarmDiff.added) {
                BwEvent2JsCal.makeAlarm(alerts, alarm);
            }
        }
    }

    private static void makeAlarm(JSAlerts alerts, BwAlarm alarm) {
        JSAlert jsalarm = (JSAlert)alerts.makeAlert().getValue();
        String action = BwEvent2JsCal.getAction(alarm.getAlarmType());
        jsalarm.setAction(action);
        if (alarm.getSummary() != null) {
            jsalarm.setTitle(alarm.getSummary());
        }
        if (alarm.getDescription() != null) {
            jsalarm.setDescription(alarm.getDescription());
        }
        if (alarm.getTriggerDateTime()) {
            JSAbsoluteTrigger absT = jsalarm.makeAbsoluteTrigger();
            JSUTCDateTimeImpl when = new JSUTCDateTimeImpl(BwEvent2JsCal.jsonDate(alarm.getTrigger()));
            absT.setWhen((JSUTCDateTime)when);
        } else {
            JSOffsetTrigger offT = jsalarm.makeOffsetTrigger();
            JSSignedDurationImpl offset = new JSSignedDurationImpl(alarm.getTrigger());
            offT.setOffset((JSSignedDuration)offset);
            if (!alarm.getTriggerStart()) {
                offT.setRelativeTo("end");
            }
        }
    }

    private static String getAction(int atype) {
        if (atype == 2) {
            return "email";
        }
        return "display";
    }

    public static boolean compareAlarm(BwAlarm alarm, JSProperty<JSAlert> alertp) {
        JSAlert alert = (JSAlert)alertp.getValue();
        if (!alert.getAction().equals(BwEvent2JsCal.getAction(alarm.getAlarmType()))) {
            return false;
        }
        JSTrigger trigger = alert.getTrigger();
        String dt = BwEvent2JsCal.jsonDate(alarm.getTrigger());
        if (trigger instanceof JSOffsetTrigger) {
            JSOffsetTrigger offT = (JSOffsetTrigger)trigger;
            if (!offT.getOffset().getStringValue().equals(dt)) {
                return false;
            }
            String rel = offT.getRelativeTo();
            if (alarm.getTriggerStart() ? "end".equals(rel) : !"end".equals(rel)) {
                return false;
            }
        } else {
            JSAbsoluteTrigger absT = (JSAbsoluteTrigger)trigger;
            if (!absT.getWhen().getStringValue().equals(dt)) {
                return false;
            }
        }
        return true;
    }

    private static void doAttachments(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        Set atts = event.getAttachments();
        DifferResult attDiff = BwDiffer.differs(BwAttachment.class, PropertyIndex.PropertyInfoIndex.ATTACH, atts, master);
        if (!attDiff.differs) {
            return;
        }
        if (master == null || attDiff.addAll) {
            JSLinks links = jsval.getLinks(true);
            for (BwAttachment att : atts) {
                BwEvent2JsCal.makeAttachment(links, att);
            }
            return;
        }
        JSOverride override = (JSOverride)jsval;
        if (attDiff.removeAll) {
            JSLinks masterLinks = jsCalMaster.getLinks(false);
            if (masterLinks == null) {
                throw new RuntimeException("Bad patch - removing from missing master object");
            }
            for (JSProperty linkp : masterLinks.get()) {
                JSLink link = (JSLink)linkp.getValue();
                if (!"enclosure".equals(link.getRel())) continue;
                override.setNull(new String[]{"links", linkp.getName()});
            }
            return;
        }
        if (!Util.isEmpty(attDiff.removed)) {
            for (BwAttachment att : attDiff.removed) {
                JSLinks masterLinks = jsCalMaster.getLinks(false);
                if (masterLinks == null) {
                    throw new RuntimeException("Bad patch - removing from missing master object");
                }
                for (JSProperty linkp : masterLinks.get()) {
                    if (!BwEvent2JsCal.compareAttachment(att, (JSProperty<JSLink>)linkp)) continue;
                    override.setNull(new String[]{"links", linkp.getName()});
                }
            }
        }
        if (!Util.isEmpty(attDiff.added)) {
            for (BwAttachment att : attDiff.added) {
                BwEvent2JsCal.makeAttachmentOverride(override, att);
            }
        }
    }

    private static void makeAttachment(JSLinks links, BwAttachment att) {
        BwEvent2JsCal.setLink((JSLink)links.makeLink().getValue(), att);
    }

    private static void makeAttachmentOverride(JSOverride jsval, BwAttachment att) {
        JSProperty linkp = jsval.newOverrideProperty((TypeReference)new TypeReference<JSLink>(){}, "Link", new String[]{"links", UUID.randomUUID().toString()});
        jsval.setProperty(linkp);
        BwEvent2JsCal.setLink((JSLink)linkp.getValue(), att);
    }

    public static boolean compareAttachment(BwAttachment att, JSProperty<JSLink> linkp) {
        JSLink link = (JSLink)linkp.getValue();
        if (!"enclosure".equals(link.getRel())) {
            return false;
        }
        if (Util.cmpObjval((Comparable)((Object)att.getFmtType()), (Comparable)((Object)link.getContentType())) != 0) {
            return false;
        }
        JSURI jhrefVal = link.getHref(false);
        String jhref = jhrefVal == null ? null : jhrefVal.getStringValue();
        if (att.getEncoding() == null) {
            return Util.cmpObjval((Comparable)((Object)att.getUri()), (Comparable)((Object)jhref)) == 0;
        }
        if (att.getValue() == null) {
            return jhref == null;
        }
        if (jhref == null) {
            return false;
        }
        return att.getValue().regionMatches(0, jhref, dataUriPrefixLen, jhref.length());
    }

    private static void doAttendees(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        Set participants = event.getSchedulingInfo().getParticipants();
        DifferResult partDiff = BwDiffer.differs(Participant.class, PropertyIndex.PropertyInfoIndex.ATTENDEE, participants, master);
        if (!partDiff.differs) {
            return;
        }
        if (master == null || partDiff.addAll) {
            BwEvent2JsCal.makeAttendees(jsval, jsCalMaster, jsval.getParticipants(true), participants);
            return;
        }
        JSOverride override = (JSOverride)jsval;
        if (partDiff.removeAll) {
            JSParticipants masterPart = jsCalMaster.getParticipants(false);
            if (masterPart == null) {
                throw new BedeworkException("Bad patch - removing from missing master object");
            }
            for (JSProperty partp : masterPart.get()) {
                JSParticipant part = (JSParticipant)partp.getValue();
                JSSendTo sendTo = part.getSendTo(false);
                if (sendTo == null || Util.isEmpty((Collection)sendTo.get())) continue;
                override.setNull(new String[]{"participants", partp.getName()});
            }
            return;
        }
        if (!Util.isEmpty(partDiff.removed)) {
            JSParticipants masterPart = jsCalMaster.getParticipants(false);
            if (masterPart == null) {
                throw new RuntimeException("Bad patch - removing from missing master object");
            }
            for (Participant att : (Set)partDiff.removed) {
                JSProperty partp = masterPart.findParticipant(att.getCalendarAddress());
                if (partp == null) continue;
                override.setNull(new String[]{"participants", partp.getName()});
            }
        }
        if (!Util.isEmpty(partDiff.added)) {
            BwEvent2JsCal.makeAttendees(jsval, jsCalMaster, jsval.getParticipants(true), (Set)partDiff.added);
        }
        if (!Util.isEmpty(partDiff.differ)) {
            Participant matt;
            JSParticipants parts = jsval.getParticipants(true);
            SchedulingInfo msi = master.getEvent().getSchedulingInfo();
            for (Participant att : (Set)partDiff.differ) {
                matt = msi.findParticipant(att.getCalendarAddress());
                if (matt == null) {
                    throw new BedeworkException("Unable to locate attendee " + att.getCalendarAddress());
                }
                if ("group".equalsIgnoreCase(att.getKind())) continue;
                BwEvent2JsCal.makeAttendeeOverride(override, jsCalMaster, att, matt);
            }
            for (Participant att : (Set)partDiff.differ) {
                matt = msi.findParticipant(att.getCalendarAddress());
                if (!"group".equalsIgnoreCase(att.getKind())) continue;
                BwEvent2JsCal.makeAttendeeOverride(override, jsCalMaster, att, matt);
            }
        }
    }

    private static void makeAttendees(JSCalendarObject jsval, JSCalendarObject master, JSParticipants participants, Set<Participant> attendees) {
        for (Participant att : attendees) {
            if (!"group".equalsIgnoreCase(att.getKind())) continue;
            BwEvent2JsCal.makeAttendee(jsval, master, participants, att);
        }
        for (Participant att : attendees) {
            if ("group".equalsIgnoreCase(att.getKind())) continue;
            BwEvent2JsCal.makeAttendee(jsval, master, participants, att);
        }
    }

    private static void makeAttendee(JSCalendarObject jsval, JSCalendarObject master, JSParticipants participants, Participant participant) {
        String[] split;
        String temp;
        JSParticipant jsParticipant = (JSParticipant)participants.makeParticipant().getValue();
        jsParticipant.getSendTo(true).makeSendTo("imip", participant.getCalendarAddress());
        String partStat = participant.getParticipationStatus();
        if (partStat != null && !partStat.equals("NEEDS-ACTION")) {
            jsParticipant.setParticipationStatus(partStat.toLowerCase());
        }
        if (participant.getExpectReply()) {
            jsParticipant.setExpectReply(true);
        }
        if ((temp = participant.getName()) != null) {
            jsParticipant.setName(temp);
        }
        if ((temp = BwEvent2JsCal.jsCalCutype(participant.getKind())) != null) {
            jsParticipant.setKind(temp);
        }
        if ((temp = participant.getDelegatedFrom()) != null) {
            for (String s : split = temp.split(",")) {
                jsParticipant.getDelegatedFrom(true).add((Object)s);
            }
        }
        if ((temp = participant.getDelegatedTo()) != null) {
            for (String s : split = temp.split(",")) {
                jsParticipant.getDelegatedTo(true).add((Object)s);
            }
        }
        if ((temp = participant.getLanguage()) != null) {
            jsParticipant.setLanguage(temp);
        }
        if ((temp = participant.getMemberOf()) != null) {
            JSParticipants mparts;
            JSProperty groupPart = participants.findParticipant(temp);
            if (groupPart == null && master != null && (mparts = master.getParticipants(false)) != null) {
                groupPart = mparts.findParticipant(temp);
            }
            if (groupPart != null) {
                jsParticipant.getMemberOf(true).add((Object)groupPart.getName());
            }
        }
        BwEvent2JsCal.jsCalRole((JSList<String>)jsParticipant.getRoles(true), participant.getParticipantType());
        if (temp != null) {
            jsParticipant.setScheduleAgent(participant.getScheduleAgent());
        }
        if ((temp = participant.getScheduleStatus()) != null) {
            jsParticipant.getScheduleStatus(true).add((JSValue)new JSStringImpl(temp));
        }
        if ((temp = participant.getInvitedBy()) != null) {
            jsParticipant.setInvitedBy(temp);
        }
    }

    private static void makeAttendeeOverride(JSOverride jsval, JSCalendarObject master, Participant participant, Participant masterParticipant) {
        JSProperty jsMAttP = master.getParticipants(false).findParticipant(masterParticipant.getCalendarAddress());
        if (jsMAttP == null) {
            throw new BedeworkException("Missing master attendee " + masterParticipant.getCalendarAddress());
        }
        String partId = jsMAttP.getName();
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, BwEvent2JsCal.lower(participant.getParticipationStatus()), BwEvent2JsCal.lower(masterParticipant.getParticipationStatus()), partId, "participationStatus");
        if (participant.getExpectReply() != masterParticipant.getExpectReply()) {
            jsval.setOverrideProperty(participant.getExpectReply(), new String[]{"participants", partId, "expectReply"});
        }
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, participant.getName(), masterParticipant.getName(), partId, "name");
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, BwEvent2JsCal.jsCalCutype(participant.getKind()), BwEvent2JsCal.jsCalCutype(masterParticipant.getKind()), partId, "kind");
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, participant.getLanguage(), masterParticipant.getLanguage(), partId, "language");
        String attVal = BwEvent2JsCal.icalRole(participant.getParticipantType());
        String mattVal = BwEvent2JsCal.icalRole(masterParticipant.getParticipantType());
        if (!attVal.equalsIgnoreCase(mattVal)) {
            JSProperty roles = jsval.newOverrideProperty((TypeReference)new TypeReference<JSList<String>>(){}, "String[Boolean]", new String[]{"participants", partId, "roles"});
            jsval.setProperty(roles);
            BwEvent2JsCal.jsCalRole((JSList<String>)((JSList)roles.getValue()), attVal);
        }
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, participant.getScheduleAgent(), masterParticipant.getScheduleAgent(), partId, "scheduleAgent");
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, participant.getScheduleStatus(), masterParticipant.getScheduleStatus(), partId, "scheduleStatus");
        BwEvent2JsCal.makeAttendeeOverrideVal(jsval, participant.getInvitedBy(), masterParticipant.getInvitedBy(), partId, "invitedBy");
    }

    private static void doCategories(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        Set cats = event.getCategories();
        DifferResult catDiff = BwDiffer.differs(BwCategory.class, PropertyIndex.PropertyInfoIndex.CATEGORIES, cats, master);
        if (!catDiff.differs) {
            return;
        }
        if (master == null || catDiff.addAll) {
            JSList jscats = jsval.getKeywords(true);
            for (BwCategory cat : cats) {
                jscats.add((Object)cat.getWord().getValue());
            }
            return;
        }
        JSOverride override = (JSOverride)jsval;
        if (catDiff.removeAll) {
            override.setNull(new String[]{"keywords"});
            return;
        }
        if (!Util.isEmpty(catDiff.removed)) {
            for (BwCategory cat : (Set)catDiff.removed) {
                override.setNull(new String[]{"keywords/" + cat.getWord().getValue()});
            }
        }
        for (BwCategory cat : (Set)catDiff.added) {
            jsval.setProperty("keywords/" + cat.getWord().getValue(), true);
        }
    }

    private static void doConcepts(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        List concepts = event.getConcepts();
        DifferResult cDiff = BwDiffer.differs(BwXproperty.class, PropertyIndex.PropertyInfoIndex.CONCEPT, concepts, master);
        if (!cDiff.differs) {
            return;
        }
        if (master == null || cDiff.addAll) {
            JSList jscats = jsval.getCategories(true);
            for (BwXproperty c : concepts) {
                jscats.add((Object)c.getValue());
            }
            return;
        }
        JSOverride override = (JSOverride)jsval;
        if (cDiff.removeAll) {
            override.setNull(new String[]{"categories"});
            return;
        }
        if (!Util.isEmpty(cDiff.removed)) {
            for (BwXproperty xp : (List)cDiff.removed) {
                override.setNull(new String[]{"categories/" + xp.getValue()});
            }
        }
        for (BwXproperty c : (List)cDiff.added) {
            jsval.setProperty("categories/" + c.getValue(), true);
        }
    }

    private static void doContacts(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        Set contacts = event.getContacts();
        DifferResult cDiff = BwDiffer.differs(BwContact.class, PropertyIndex.PropertyInfoIndex.CONTACT, contacts, master);
        if (!cDiff.differs) {
            return;
        }
        JSParticipants jscontacts = jsval.getParticipants(true);
        if (master == null || cDiff.addAll) {
            for (BwContact c : contacts) {
                BwEvent2JsCal.addContact(jscontacts, c);
            }
            return;
        }
        JSOverride override = (JSOverride)jsval;
        if (cDiff.removeAll) {
            override.setNull(new String[]{"categories"});
            for (BwContact c : contacts) {
                jscontacts.remove((Object)c.getCn().getValue());
            }
            return;
        }
        if (!Util.isEmpty(cDiff.removed)) {
            for (BwContact c : cDiff.removed) {
                jscontacts.remove((Object)c.getCn().getValue());
            }
        }
        for (BwContact c : cDiff.added) {
            BwEvent2JsCal.addContact(jscontacts, c);
        }
    }

    private static void addContact(JSParticipants jscontacts, BwContact c) {
        String value;
        int pos;
        JSParticipant jsContact = (JSParticipant)jscontacts.makeEntry((Object)c.getUid()).getValue();
        JSRoles roles = jsContact.getRoles(true);
        roles.add((Object)"contact");
        if (c.getEmail() != null) {
            jsContact.setEmail(c.getEmail());
        }
        if ((pos = (value = c.getCn().getValue()).indexOf(",")) > 0) {
            jsContact.setName(value.substring(0, pos));
        } else {
            jsContact.setName(value);
        }
        jsContact.setDescription(value);
        BwEvent2JsCal.addLink(jsContact, c.getLink(), "alternate");
    }

    private static void doLocation(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        BwLocation loc = event.getLocation();
        DifferResult locDiff = BwDiffer.differs(BwLocation.class, PropertyIndex.PropertyInfoIndex.LOCATION, loc, master);
        if (!locDiff.differs) {
            return;
        }
        JSLocations locs = jsval.getLocations(true);
        JSLocation jsloc = (JSLocation)locs.makeLocation().getValue();
        jsloc.setUid(loc.getUid());
        jsloc.setName(loc.getAddressField());
        jsloc.setDescription(loc.getCombinedValues());
        JSLinks links = jsloc.getLinks(true);
        JSLink link = (JSLink)links.makeLink().getValue();
        Card card = loc.getCard();
        String cardStr = card.outputJson(false, "3");
        link.setContentType("text/vcard+json");
        link.setHref(Util.makeDataUri((String)cardStr, (String)"text/vcard+json"));
    }

    private static void doOrganizer(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        BwOrganizer org = event.getOrganizer();
        if (org == null) {
            return;
        }
        String orgUri = org.getOrganizerUri();
        DifferResult orgDiff = BwDiffer.differs(BwOrganizer.class, PropertyIndex.PropertyInfoIndex.ORGANIZER, org, master);
        if (!orgDiff.differs) {
            return;
        }
        JSParticipants parts = jsval.getParticipants(true);
        JSProperty jsOrg = parts.findParticipant(orgUri);
        if (jsOrg == null) {
            jsOrg = parts.makeParticipant();
        }
        if (master == null) {
            jsval.getReplyTo(true).makeReplyTo("imip", orgUri);
        } else {
            BwOrganizer morg = master.getEvent().getOrganizer();
            if (morg == null || !morg.getOrganizerUri().equals(orgUri)) {
                jsval.getReplyTo(true).makeReplyTo("imip", orgUri);
            }
        }
        BwEvent2JsCal.makeOrganizer(jsval, jsCalMaster, (JSParticipant)jsOrg.getValue(), org);
    }

    private static void makeOrganizer(JSCalendarObject jsval, JSCalendarObject master, JSParticipant jsOrg, BwOrganizer org) {
        JSSendTo sendTos = jsOrg.getSendTo(true);
        if (sendTos.get((Object)"imip") == null) {
            sendTos.makeSendTo("imip", org.getOrganizerUri());
        }
        jsOrg.getRoles(true).add((Object)"owner");
        String temp = org.getCn();
        if (temp != null) {
            jsOrg.setName(temp);
        }
        BwEvent2JsCal.addLink(jsOrg, org.getDir(), "alternate");
        temp = org.getLanguage();
        if (temp != null) {
            jsOrg.setLanguage(temp);
        }
        if ((temp = org.getScheduleStatus()) != null) {
            logger.warn("Do this - scheduleStatus");
        }
        if ((temp = org.getSentBy()) != null) {
            jsOrg.setInvitedBy(temp);
        }
    }

    private static void doPercentComplete(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster, int method) {
        Integer pc = event.getPercentComplete();
        if (pc == null) {
            return;
        }
        JSUnsignedIntegerImpl jspc = new JSUnsignedIntegerImpl(pc.intValue());
        if (method != 3) {
            jsval.setProperty("percentComplete", (JSValue)jspc);
            return;
        }
        JSProperty<JSParticipant> part = BwEvent2JsCal.findOnlyAttendee(jsval);
        if (part != null) {
            ((JSParticipant)part.getValue()).setProperty("percentComplete", (JSValue)jspc);
            return;
        }
        if (jsCalMaster == null) {
            return;
        }
        JSOverride override = (JSOverride)jsval;
        part = BwEvent2JsCal.findOnlyAttendee(jsCalMaster);
        if (part == null) {
            return;
        }
        override.setOverrideProperty((JSUnsignedInteger)jspc, new String[]{"participants", part.getName(), "percentComplete"});
    }

    private static JSProperty<JSParticipant> findOnlyAttendee(JSCalendarObject jsval) {
        JSParticipants parts = jsval.getParticipants(false);
        if (parts == null) {
            return null;
        }
        List attendees = parts.getAttendees();
        if (attendees.size() != 1) {
            return null;
        }
        return (JSProperty)attendees.get(0);
    }

    private static void doRelatedTo(BwEvent event, EventInfo master, JSCalendarObject jsval, JSCalendarObject jsCalMaster) {
        String[] info = null;
        BwRelatedTo relto = event.getRelatedTo();
        if (relto != null) {
            info = new String[]{relto.getRelType(), "", relto.getValue()};
        } else {
            String relx = event.getXproperty("X-BEDEWORK-RELATED-TO");
            if (relx != null) {
                info = Util.decodeArray((String)relx);
            }
        }
        if (info == null) {
            return;
        }
        JSRelations relations = jsval.getRelatedTo(true);
        block10: for (int i = 0; i < info.length; i += 3) {
            String reltype = info[i];
            String relval = info[i + 2];
            JSProperty rel = relations.makeEntry((Object)relval);
            JSRelation relVal = (JSRelation)rel.getValue();
            JSList rs = relVal.getRelations(true);
            if (reltype == null) {
                reltype = "parent";
            }
            switch (reltype.toLowerCase()) {
                case "parent": {
                    rs.add((Object)"parent");
                    continue block10;
                }
                case "child": {
                    rs.add((Object)"child");
                    continue block10;
                }
                case "sibling": {
                    rs.add((Object)"next");
                }
            }
        }
    }

    private static String scheduleAgent(int sagent) {
        if (sagent == 0) {
            return null;
        }
        return "client";
    }

    private static JSProperty<JSLink> findLink(JSCalendarObject jsval, JSCalendarObject master, String href) {
        JSProperty prop;
        JSLinks links = jsval.getLinks(false);
        if (links != null && (prop = links.findLink(href)) != null) {
            return prop;
        }
        if (master == null) {
            return null;
        }
        links = jsval.getLinks(false);
        if (links == null) {
            return null;
        }
        return links.findLink(href);
    }

    private static void addLink(JSParticipant part, String href, String rel) {
        if (href == null) {
            return;
        }
        if (BwEvent2JsCal.findLink(part.getLinks(false), href) != null) {
            return;
        }
        BwEvent2JsCal.addLink(part.getLinks(true), href, rel);
    }

    private static void addLink(JSCalendarObject cal, String href, String rel) {
        if (href == null) {
            return;
        }
        if (BwEvent2JsCal.findLink(cal.getLinks(false), href) != null) {
            return;
        }
        BwEvent2JsCal.addLink(cal.getLinks(true), href, rel);
    }

    private static JSProperty<JSLink> findLink(JSLinks links, String href) {
        if (links == null) {
            return null;
        }
        return links.findLink(href);
    }

    private static void addLink(JSLinks links, String href, String rel) {
        JSProperty linkp = links.makeLink();
        JSLink link = (JSLink)linkp.getValue();
        link.setHref(href);
        link.setRel(rel);
    }

    private static String lower(String val) {
        if (val == null) {
            return null;
        }
        return val.toLowerCase();
    }

    private static void makeAttendeeOverrideVal(JSOverride jsval, String attVal, String mattVal, String partId, String jsPropName) {
        if (attVal == null) {
            if (mattVal != null) {
                jsval.setNull(new String[]{"participants", partId, jsPropName});
            }
        } else if (!attVal.equalsIgnoreCase(mattVal)) {
            jsval.setOverrideProperty(attVal, new String[]{"participants", partId, jsPropName});
        }
    }

    private static String jsCalCutype(String icalCutype) {
        if (icalCutype == null) {
            return null;
        }
        if ("room".equalsIgnoreCase(icalCutype)) {
            return "location";
        }
        if ("unknown".equalsIgnoreCase(icalCutype)) {
            return null;
        }
        return icalCutype.toLowerCase();
    }

    private static String icalRole(String role) {
        if (role == null) {
            return "REQ-PARTICIPANT";
        }
        return role;
    }

    private static void jsCalRole(JSList<String> roles, String icalRole) {
        if (icalRole == null) {
            roles.add((Object)"attendee");
            return;
        }
        if (icalRole.equalsIgnoreCase("chair")) {
            roles.add((Object)"attendee");
            roles.add((Object)"chair");
        } else if (icalRole.equalsIgnoreCase("REQ-PARTICIPANT")) {
            roles.add((Object)"attendee");
        } else if (icalRole.equalsIgnoreCase("OPT-PARTICIPANT")) {
            roles.add((Object)"attendee");
            roles.add((Object)"optional");
        } else if (icalRole.equalsIgnoreCase("NON-PARTICIPANT")) {
            roles.add((Object)"attendee");
            roles.add((Object)"informational");
        } else {
            roles.add((Object)icalRole.toLowerCase());
        }
    }

    private static String jsonDate(String val) {
        return XcalUtil.getXmlFormatDateTime((String)val);
    }

    public static void addXproperty(JSCalendarObject jscal, JSCalendarObject master, String name, String val) {
        if (val == null) {
            return;
        }
        BwXproperty.XpropInfo xpinfo = BwXproperty.getXpropInfo((String)name);
        String jname = xpinfo == null ? name.toLowerCase() : xpinfo.jscalName;
        jscal.setProperty(jname, val);
    }

    private static String timeInZone(String dateTime, String tzid, TimeZoneRegistry tzreg) {
        try {
            Date date = dateTime.endsWith("Z") || tzid == null ? DateTimeUtil.fromISODateTimeUTC((String)dateTime) : DateTimeUtil.fromISODateTime((String)dateTime, (TimeZone)tzreg.getTimeZone(tzid));
            return DateTimeUtil.isoDateTime((Date)date);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void setLink(JSLink link, BwAttachment att) {
        link.setRel("enclosure");
        String temp = att.getFmtType();
        if (temp != null) {
            link.setContentType(temp);
        }
        if (att.getEncoding() == null) {
            link.setHref(att.getUri());
        } else {
            link.setHref(dataUriPrefix + att.getValue());
        }
    }

    static {
        JSFactory.register((JSRegistration)new BwJSRegistration());
        logger = new BwLogger().setLoggedClass(BwEvent2JsCal.class);
        dataUriPrefixLen = dataUriPrefix.length();
    }
}

