/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.jscal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.TreeSet;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwVersion;
import org.bedework.calfacade.ifs.IcalCallback;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.convert.EventTimeZonesRegistry;
import org.bedework.convert.IcalTranslator;
import org.bedework.convert.Icalendar;
import org.bedework.convert.jscal.BwEvent2JsCal;
import org.bedework.convert.jscal.JsCal2BwEvent;
import org.bedework.jsforj.impl.JSFactory;
import org.bedework.jsforj.impl.JSMapper;
import org.bedework.jsforj.model.JSCalendarObject;
import org.bedework.jsforj.model.JSEvent;
import org.bedework.jsforj.model.JSGroup;
import org.bedework.jsforj.model.JSTask;
import org.bedework.util.calendar.ScheduleMethods;

public class JSCalTranslator
extends IcalTranslator {
    private static final JSMapper mapper = new JSMapper();

    public JSCalTranslator(IcalCallback cb) {
        super(cb);
    }

    public static JSGroup newJSGroup(int methodType) {
        JSGroup group = (JSGroup)JSFactory.getFactory().newValue("Group");
        group.setProperty("prodId", BwVersion.prodId);
        if (methodType > 0 && methodType < 99) {
            group.setProperty("method", ScheduleMethods.methods[methodType]);
        }
        return group;
    }

    public JSGroup toJScal(Collection<EventInfo> vals, int methodType) {
        JSGroup group = JSCalTranslator.newJSGroup(methodType);
        if (vals == null || vals.size() == 0) {
            return group;
        }
        TreeSet<String> added = new TreeSet<String>();
        for (EventInfo ei : vals) {
            this.addToGroup(group, ei, added, methodType);
        }
        return group;
    }

    public static void writeJSCalendar(JSCalendarObject obj, Writer wtr) {
        obj.writeValue(wtr, (ObjectMapper)mapper);
    }

    @Override
    public Icalendar fromIcal(BwCalendar col, Reader rdr, String contentType, boolean mergeAttendees) {
        Icalendar ic = new Icalendar();
        JSCalTranslator.setSystemProperties();
        JSCalendarObject jscal = new JSMapper().parse(rdr);
        if (jscal == null) {
            return ic;
        }
        String prodid = jscal.getStringProperty("prodId");
        if (prodid != null) {
            ic.setProdid(prodid);
        }
        ic.setMethod(jscal.getStringProperty("method"));
        if (jscal instanceof JSGroup) {
            JSGroup group = (JSGroup)jscal;
            for (JSCalendarObject entry : group.getEntries()) {
                this.toBw(this.cb, entry, col, ic);
            }
        } else {
            this.toBw(this.cb, jscal, col, ic);
        }
        return ic;
    }

    private void toBw(IcalCallback cb, JSCalendarObject val, BwCalendar col, Icalendar ic) {
        if (!(val instanceof JSEvent) && !(val instanceof JSTask)) {
            return;
        }
        GetEntityResponse<EventInfo> eiResp = JsCal2BwEvent.toEvent(cb, val, col, ic);
        if (eiResp.isError()) {
            if (eiResp.getException() != null) {
                throw new RuntimeException(eiResp.getException());
            }
            throw new RuntimeException(eiResp.toString());
        }
        if (eiResp.isOk()) {
            ic.addComponent((EventInfo)eiResp.getEntity());
        }
    }

    private void addToGroup(JSGroup group, EventInfo val, TreeSet<String> added, int methodType) {
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        BwEvent ev = val.getEvent();
        EventTimeZonesRegistry tzreg = new EventTimeZonesRegistry(this, ev);
        JSCalendarObject jsCalMaster = null;
        GetEntityResponse<JSCalendarObject> res = BwEvent2JsCal.convert(val, null, null, methodType, tzreg, currentPrincipal);
        if (!res.isOk()) {
            throw new RuntimeException(res.toString());
        }
        jsCalMaster = (JSCalendarObject)res.getEntity();
        if (!ev.getSuppressed()) {
            group.addEntry(jsCalMaster);
        }
        if (val.getNumOverrides() > 0) {
            for (EventInfo oei : val.getOverrides()) {
                res = BwEvent2JsCal.convert(oei, val, jsCalMaster, methodType, tzreg, currentPrincipal);
                if (!res.isOk()) {
                    throw new RuntimeException(res.toString());
                }
                if (!ev.getSuppressed()) continue;
                group.addEntry((JSCalendarObject)res.getEntity());
            }
        }
    }
}

