/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.convert.xcal;

import ietf.params.xml.ns.icalendar_2.ActionPropType;
import ietf.params.xml.ns.icalendar_2.ArrayOfParameters;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.AttachPropType;
import ietf.params.xml.ns.icalendar_2.AttendeePropType;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.DescriptionPropType;
import ietf.params.xml.ns.icalendar_2.DurationPropType;
import ietf.params.xml.ns.icalendar_2.RelatedParamType;
import ietf.params.xml.ns.icalendar_2.RepeatPropType;
import ietf.params.xml.ns.icalendar_2.SummaryPropType;
import ietf.params.xml.ns.icalendar_2.TriggerPropType;
import ietf.params.xml.ns.icalendar_2.ValarmType;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.convert.xcal.ToXEvent;
import org.bedework.convert.xcal.Xutil;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.xml.tagdefs.XcalTags;

public class Xalarms
extends Xutil {
    public static ValarmType toXAlarm(BwEvent ev, BwAlarm val, BaseComponentType pattern, Class<?> masterClass) {
        ActionPropType a;
        ValarmType alarm = new ValarmType();
        int atype = val.getAlarmType();
        alarm.setProperties(new ArrayOfProperties());
        List pl = alarm.getProperties().getBasePropertyOrTzid();
        if (Xalarms.emit(pattern, masterClass, ValarmType.class, ActionPropType.class)) {
            a = new ActionPropType();
            a.setText(BwAlarm.alarmTypes[val.getAlarmType()]);
            pl.add(of.createAction(a));
        }
        if (Xalarms.emit(pattern, masterClass, ValarmType.class, TriggerPropType.class)) {
            TriggerPropType t = new TriggerPropType();
            if (val.getTriggerDateTime()) {
                t.setDateTime(XcalUtil.getXMlUTCCal((String)val.getTrigger()));
            } else {
                t.setDuration(val.getTrigger());
                if (!val.getTriggerStart()) {
                    ArrayOfParameters pars = Xalarms.getAop((BasePropertyType)t);
                    RelatedParamType r = new RelatedParamType();
                    r.setText("END");
                    JAXBElement param = of.createRelated(r);
                    pars.getBaseParameter().add(param);
                }
            }
            pl.add(of.createTrigger(t));
        }
        if (Xalarms.emit(pattern, masterClass, ValarmType.class, DurationPropType.class) && val.getDuration() != null) {
            DurationPropType dur = new DurationPropType();
            dur.setDuration(val.getDuration());
            pl.add(of.createDuration(dur));
            RepeatPropType rep = new RepeatPropType();
            rep.setInteger(BigInteger.valueOf(val.getRepeat()));
            pl.add(of.createRepeat(rep));
        }
        if (atype == 1 || atype == 2 || atype == 3) {
            String desc = val.getDescription();
            if (desc == null && ev != null) {
                desc = ev.getDescription() != null ? ev.getDescription() : ev.getSummary();
            }
            if (desc == null) {
                desc = " ";
            }
            DescriptionPropType d = new DescriptionPropType();
            d.setText(desc);
            pl.add(of.createDescription(d));
        }
        if (atype == 2) {
            SummaryPropType s = new SummaryPropType();
            s.setText(val.getSummary());
            pl.add(of.createSummary(s));
        }
        if ((atype == 0 || atype == 2 || atype == 3) && val.getAttach() != null) {
            a = new AttachPropType();
            a.setUri(val.getAttach());
            pl.add(of.createAttach((AttachPropType)a));
        }
        if (atype == 2 && val.getNumAttendees() > 0) {
            for (BwAttendee att : val.getAttendees()) {
                pl.add(of.createAttendee(ToXEvent.makeAttendee(att)));
            }
        }
        if (val.getNumXproperties() > 0) {
            // empty if block
        }
        return alarm;
    }

    public static BwAlarm toBwAlarm(ValarmType alarm, boolean validate) {
        AttachPropType a;
        SummaryPropType s;
        DescriptionPropType desc;
        DurationPropType dur;
        BwAlarm ba = new BwAlarm();
        ActionPropType action = (ActionPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.action);
        if (action == null) {
            throw new BedeworkException("Invalid alarm - no action");
        }
        String actionVal = action.getText().toUpperCase();
        int atype = -1;
        for (int i = 0; i < BwAlarm.alarmTypes.length; ++i) {
            if (!actionVal.equals(BwAlarm.alarmTypes[i])) continue;
            atype = i;
            break;
        }
        if (atype < 0) {
            throw new BedeworkException("Unhandled alarm action");
        }
        ba.setAlarmType(atype);
        TriggerPropType tr = (TriggerPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.trigger);
        if (tr == null) {
            if (validate) {
                throw new BedeworkException("Invalid alarm - no action");
            }
        } else if (tr.getDateTime() != null) {
            ba.setTrigger(XcalUtil.getIcalFormatDateTime((XMLGregorianCalendar)tr.getDateTime()));
            ba.setTriggerDateTime(true);
        } else {
            ba.setTrigger(tr.getDuration());
            RelatedParamType r = (RelatedParamType)XcalUtil.findParam((BasePropertyType)tr, (QName)XcalTags.related);
            ba.setTriggerStart(r == null || r.getText().toUpperCase().equals("START"));
        }
        if ((dur = (DurationPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.duration)) != null) {
            RepeatPropType rep = (RepeatPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.repeat);
            ba.setDuration(dur.getDuration());
            if (rep == null) {
                if (validate) {
                    throw new BedeworkException("Invalid alarm - no repeat");
                }
            } else {
                ba.setRepeat(rep.getInteger().intValue());
            }
        }
        if ((atype == 1 || atype == 2 || atype == 3) && (desc = (DescriptionPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.description)) != null) {
            ba.setDescription(desc.getText());
        }
        if (atype == 2 && (s = (SummaryPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.summary)) != null) {
            ba.setSummary(s.getText());
        }
        if ((atype == 0 || atype == 2 || atype == 3) && (a = (AttachPropType)XcalUtil.findProperty((BaseComponentType)alarm, (QName)XcalTags.attach)) != null && a.getUri() != null) {
            ba.setAttach(a.getUri());
        }
        if (atype == 2) {
            for (JAXBElement bpel : alarm.getProperties().getBasePropertyOrTzid()) {
                if (!bpel.getName().equals(XcalTags.attendee)) continue;
                AttendeePropType attp = (AttendeePropType)bpel.getValue();
                BwAttendee batt = new BwAttendee();
                batt.setAttendeeUri(attp.getCalAddress());
                ba.addAttendee(batt);
            }
        }
        return ba;
    }
}

