/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.Set;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.util.calendar.ScheduleMethods;

@Dump(elementName="event", keyFields={"colPath", "uid", "recurrenceId"}, firstFields={"ownerHref"})
public class BwEventObj
extends BwEvent
implements ScheduleMethods {
    public static BwEvent makeFreeBusyRequest(BwDateTime start, BwDateTime end, BwOrganizer organizer, String originator, Set<BwAttendee> attendees, Set<String> recipients) {
        BwEventObj fbreq = new BwEventObj();
        if (organizer == null) {
            if (originator == null) {
                return null;
            }
            organizer = new BwOrganizer();
            organizer.setOrganizerUri(originator);
        }
        if (attendees == null) {
            if (recipients == null) {
                return null;
            }
            for (String r : recipients) {
                BwAttendee att = new BwAttendee();
                att.setAttendeeUri(r);
                fbreq.addAttendee(att);
            }
        } else {
            fbreq.setAttendees(attendees);
        }
        fbreq.setDtstart(start);
        fbreq.setDtend(end);
        fbreq.setEndType('E');
        fbreq.setDuration(BwDateTime.makeDuration(fbreq.getDtstart(), fbreq.getDtend()).toString());
        fbreq.setEntityType(4);
        fbreq.setRecipients(recipients);
        fbreq.setOrganizer(organizer);
        fbreq.setOriginator(originator);
        fbreq.setScheduleMethod(2);
        fbreq.setNoStart(false);
        fbreq.setRecurring(false);
        return fbreq;
    }

    @Override
    public Object clone() {
        BwEventObj ev = new BwEventObj();
        this.copyTo(ev);
        return ev;
    }
}

