/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.util.misc.ToString;

public class BwFreeBusyComponent
extends BwDbentity<BwFreeBusyComponent> {
    public static final int typeBusy = 0;
    public static final int typeFree = 1;
    public static final int typeBusyUnavailable = 2;
    public static final int typeBusyTentative = 3;
    private int type = 0;
    public static final String[] fbtypes = new String[]{"BUSY", "FREE", "BUSY-UNAVAILABLE", "BUSY-TENTATIVE"};
    public static final boolean emitDurations = true;
    private String value;
    private Collection<Period> periods;

    public void setType(int val) {
        this.type = val;
    }

    public int getType() {
        return this.type;
    }

    public void setValue(String val) {
        this.value = val;
        this.periods = null;
    }

    public String getValue() {
        if (this.value == null) {
            if (this.periods == null || this.periods.isEmpty()) {
                return null;
            }
            PeriodList pl = new PeriodList();
            pl.addAll(this.getPeriods());
            this.value = pl.toString();
        }
        return this.value;
    }

    public Collection<Period> getPeriods() {
        if (this.periods == null) {
            this.periods = new TreeSet<Period>();
            if (this.getValue() != null) {
                try {
                    this.periods.addAll((Collection<Period>)new PeriodList(this.getValue()));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        return this.periods;
    }

    public void addPeriod(Period val) {
        this.getPeriods().add(val);
        this.value = null;
    }

    public void addPeriod(DateTime start, DateTime end) {
        Period p = new Period(start, new Dur((Date)start, (Date)end));
        this.addPeriod(p);
    }

    public boolean getEmpty() {
        return this.getPeriods().size() == 0;
    }

    public String getTypeVal() {
        return fbtypes[this.getType()];
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("type", (Object)this.getTypeVal());
        try {
            for (Period p : this.getPeriods()) {
                ts.append("(" + p.toString() + ")");
            }
        }
        catch (Throwable t) {
            ts.append("Exception(" + t.getMessage() + ")");
        }
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwFreeBusyComponent fbc = new BwFreeBusyComponent();
        fbc.setType(this.getType());
        fbc.setValue(this.getValue());
        return fbc;
    }
}

