/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.Collection;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

@Dump(elementName="property", keyFields={"name", "value"})
@NoDump(value={"byteSize"})
public class BwProperty
extends BwDbentity<BwProperty> {
    private String name;
    private String value;

    public BwProperty() {
    }

    public BwProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public String getValue() {
        return this.value;
    }

    public static BwProperty findName(String name, Collection<BwProperty> c) {
        if (c == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        for (BwProperty p : c) {
            String pname = p.getName();
            if (CalFacadeUtil.cmpObjval(name, pname) != 0) continue;
            return p;
        }
        return null;
    }

    public boolean update(BwProperty from) {
        if (CalFacadeUtil.cmpObjval(this.getName(), from.getName()) != 0) {
            return false;
        }
        if (CalFacadeUtil.cmpObjval(this.getValue(), from.getValue()) != 0) {
            this.setValue(from.getValue());
            return true;
        }
        return false;
    }

    public boolean checkNulls() {
        boolean changed = false;
        String str = Util.checkNull((String)this.getName());
        if (CalFacadeUtil.compareStrings(str, this.getName()) != 0) {
            this.setName(str);
            changed = true;
        }
        if (CalFacadeUtil.compareStrings(str = Util.checkNull((String)this.getValue()), this.getValue()) != 0) {
            this.setValue(str);
            changed = true;
        }
        return changed;
    }

    @Override
    public int compareTo(BwProperty that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int res = CalFacadeUtil.cmpObjval(this.getName(), that.getName());
        if (res != 0) {
            return res;
        }
        return CalFacadeUtil.cmpObjval(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        int hc = 7;
        if (this.getName() != null) {
            hc *= this.getName().hashCode();
        }
        if (this.getValue() != null) {
            hc *= this.getValue().hashCode();
        }
        return hc;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("name", (Object)this.getName());
        ts.append("value", (Object)this.getValue());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public Object clone() {
        return new BwProperty(this.getName(), this.getValue());
    }
}

