/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import net.fortuna.ical4j.model.property.RequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.ToString;

public class BwRequestStatus
implements Comparable<BwRequestStatus>,
Serializable {
    private String code;
    private BwString description;
    private String data;

    public BwRequestStatus() {
    }

    public BwRequestStatus(String code, String description) {
        this(code, new BwString(null, description), null);
    }

    public BwRequestStatus(String code, BwString description, String data) {
        this.code = code;
        this.description = description;
        this.data = data;
    }

    public void setCode(String val) {
        this.code = val;
    }

    public String getCode() {
        return this.code;
    }

    public void setDescription(BwString val) {
        this.description = val;
    }

    public BwString getDescription() {
        return this.description;
    }

    public void setData(String val) {
        this.data = val;
    }

    public String getData() {
        return this.data;
    }

    public String strVal() {
        StringBuilder sb = new StringBuilder();
        if (this.getCode() != null) {
            sb.append(this.getCode());
            sb.append(";");
        }
        if (this.getDescription() != null) {
            sb.append(this.getDescription().getValue());
            sb.append(";");
        }
        if (this.getData() != null) {
            sb.append(this.getData());
            sb.append(";");
        }
        return sb.toString();
    }

    public static BwRequestStatus fromRequestStatus(RequestStatus val) {
        BwString str = new BwString(null, val.getDescription());
        return new BwRequestStatus(val.getStatusCode(), str, val.getExData());
    }

    public boolean update(BwRequestStatus from) {
        boolean changed = false;
        if (CalFacadeUtil.cmpObjval(this.getCode(), from.getCode()) != 0) {
            this.setCode(from.getCode());
            changed = true;
        }
        if (this.getDescription() == null) {
            if (from.getDescription() != null) {
                this.setDescription(from.getDescription());
                changed = true;
            }
        } else if (this.getDescription().update(from.getDescription())) {
            changed = true;
        }
        if (CalFacadeUtil.cmpObjval(this.getData(), from.getData()) != 0) {
            this.setData(from.getData());
            changed = true;
        }
        return changed;
    }

    @Override
    public int compareTo(BwRequestStatus that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int res = CalFacadeUtil.cmpObjval(this.getCode(), that.getCode());
        if (res != 0) {
            return res;
        }
        res = this.getDescription().compareTo(that.getDescription());
        if (res != 0) {
            return res;
        }
        return CalFacadeUtil.cmpObjval(this.getData(), that.getData());
    }

    public int hashCode() {
        int hc = this.getCode().hashCode();
        if (this.getDescription() != null) {
            hc *= this.getDescription().hashCode();
        }
        if (this.getData() != null) {
            hc *= this.getData().hashCode();
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BwRequestStatus)) {
            return false;
        }
        return this.compareTo((BwRequestStatus)o) == 0;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("code", (Object)this.getCode());
        ts.append("description", (Object)this.getDescription());
        ts.append("data", (Object)this.getData());
        return ts.toString();
    }

    public Object clone() {
        BwRequestStatus rs = new BwRequestStatus();
        rs.setCode(this.getCode());
        BwString desc = this.getDescription();
        if (desc != null) {
            rs.setDescription((BwString)desc.clone());
        }
        rs.setData(this.getData());
        return rs;
    }
}

