/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import org.bedework.util.misc.ToString;

public class PollItmId
implements Comparable<PollItmId>,
Serializable {
    private Integer response;
    private String publicComment;
    private Integer id;
    private boolean expanded;
    private String val;

    public PollItmId(Integer id) {
        this.id = id;
        this.expanded = true;
    }

    public PollItmId(Integer response, String publicComment, Integer id) {
        this.response = response;
        if (publicComment != null) {
            this.publicComment = publicComment.replace(':', ' ');
        }
        this.id = id;
        this.expanded = true;
    }

    public PollItmId(String val) {
        this.val = val;
        this.expand();
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getResponse() {
        return this.response;
    }

    public String getPublicComment() {
        return this.publicComment;
    }

    public String getVal() {
        if (this.val != null) {
            return this.val;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getResponse() != null) {
            sb.append(this.getResponse());
        }
        sb.append(":");
        if (this.getPublicComment() != null) {
            sb.append(this.getPublicComment());
        }
        sb.append(":");
        sb.append(this.getId());
        this.val = sb.toString();
        return this.val;
    }

    private void expand() {
        if (this.expanded) {
            return;
        }
        if (this.val == null) {
            this.expanded = true;
            return;
        }
        String[] split = this.val.split(":");
        if (split.length != 3) {
            this.expanded = true;
            return;
        }
        if (!this.empty(split[0])) {
            this.response = Integer.valueOf(split[0]);
        }
        if (!this.empty(split[1])) {
            this.publicComment = split[1];
        }
        this.id = Integer.valueOf(split[2]);
        this.expanded = true;
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    @Override
    public int compareTo(PollItmId o) {
        return this.getId().compareTo(o.getId());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        if (this.getResponse() != null) {
            ts.append("response", (Object)this.getResponse());
            ts.append("publicComment", (Object)this.getPublicComment());
        }
        ts.append("id", (Object)this.getId());
        return ts.toString();
    }
}

