/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import java.io.Serializable;
import org.bedework.calfacade.util.Sysprop;
import org.bedework.util.misc.ToString;

public class CalSvcIPars
implements Serializable {
    public static final String logIdRoClient = "roclient-";
    public static final String logIdRwClient = "rwclient-";
    public static final String logIdAdminClient = "admin-client-";
    public static final String logIdTools = "tools";
    public static final String logIdIndexer = "indexer";
    public static final String logIdDump = "dump";
    public static final String logIdRestore = "restore";
    private String authUser;
    private final String user;
    private String calSuite;
    private final boolean publicAdmin;
    private final boolean publicAuth;
    private final boolean publicSubmission;
    private final boolean service;
    private final String clientId;
    private String logId;
    private final boolean allowSuperUser;
    private final boolean adminCanEditAllPublicCategories;
    private final boolean adminCanEditAllPublicLocations;
    private final boolean adminCanEditAllPublicContacts;
    private final boolean sessionless;
    private final boolean dontKill;
    private final boolean forRestore;
    private final boolean indexRebuild;
    private boolean readonly;
    private boolean webMode;

    public CalSvcIPars(String logId, String authUser, String user, String calSuite, boolean publicAdmin, boolean publicAuth, boolean allowSuperUser, boolean service, boolean publicSubmission, boolean adminCanEditAllPublicCategories, boolean adminCanEditAllPublicLocations, boolean adminCanEditAllPublicContacts, boolean sessionless, boolean dontKill, boolean readonly, String clientId, boolean forRestore, boolean indexRebuild) {
        this.logId = logId;
        this.authUser = authUser;
        this.calSuite = calSuite;
        this.publicAdmin = publicAdmin;
        this.publicAuth = publicAuth;
        this.allowSuperUser = allowSuperUser;
        this.service = service;
        this.adminCanEditAllPublicCategories = adminCanEditAllPublicCategories;
        this.adminCanEditAllPublicLocations = adminCanEditAllPublicLocations;
        this.adminCanEditAllPublicContacts = adminCanEditAllPublicContacts;
        this.sessionless = sessionless;
        this.dontKill = dontKill;
        this.user = user;
        this.publicSubmission = publicSubmission;
        this.readonly = readonly;
        this.clientId = clientId;
        this.forRestore = forRestore;
        this.indexRebuild = indexRebuild;
    }

    public static CalSvcIPars getRoClientPars(String id, String authUser, String user, String calSuite, boolean publicAuth) {
        return new CalSvcIPars(logIdRoClient + id, authUser, user, calSuite, false, publicAuth, false, false, false, false, false, false, false, false, true, null, false, false);
    }

    public static CalSvcIPars getRwClientPars(String id, String authUser, String user) {
        return new CalSvcIPars(logIdRwClient + id, authUser, user, null, false, false, false, false, false, false, false, false, false, false, false, null, false, false);
    }

    public static CalSvcIPars getAdminClientPars(String id, String authUser, String user, String calSuite, boolean adminCanEditAllPublicCategories, boolean adminCanEditAllPublicLocations, boolean adminCanEditAllPublicContacts) {
        return new CalSvcIPars(logIdAdminClient + id, authUser, user, calSuite, true, false, false, false, false, adminCanEditAllPublicCategories, adminCanEditAllPublicLocations, adminCanEditAllPublicContacts, false, false, false, null, false, false);
    }

    public static CalSvcIPars getToolPars(String user, boolean superUser) {
        return new CalSvcIPars(logIdTools, user, user, null, true, false, superUser, true, false, true, true, true, false, true, false, null, false, false);
    }

    public static CalSvcIPars getServicePars(String logId, String account, boolean publicAdmin, boolean allowSuperUser) {
        return new CalSvcIPars(logId, account, null, null, publicAdmin, false, allowSuperUser, true, false, false, false, false, false, true, false, null, false, false);
    }

    public static CalSvcIPars getIndexerPars(String account, boolean publicAdmin) {
        return new CalSvcIPars(logIdIndexer, account, null, null, publicAdmin, false, true, true, false, false, false, false, false, true, Sysprop.readOnlySystem(), null, false, true);
    }

    public static CalSvcIPars getDumpRestorePars(String id, String account, boolean superUser) {
        return new CalSvcIPars(id, account, null, null, superUser, false, superUser, true, false, true, true, true, false, true, false, null, true, true);
    }

    public static CalSvcIPars getCaldavPars(String logId, String authUser, String runAsUser, String clientId, boolean allowSuperUser, boolean service, boolean publicAdmin, String calSuite, boolean allowCreateEprops, boolean readonly) {
        return new CalSvcIPars(logId, authUser, runAsUser, calSuite, publicAdmin, false, allowSuperUser, service, false, allowCreateEprops, allowCreateEprops, allowCreateEprops, true, false, readonly, clientId, false, false);
    }

    public void setAuthUser(String val) {
        this.authUser = val;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public String getUser() {
        return this.user;
    }

    public void setCalSuite(String val) {
        this.calSuite = val;
    }

    public String getCalSuite() {
        return this.calSuite;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setLogId(String val) {
        this.logId = val;
    }

    public String getLogId() {
        return this.logId;
    }

    public boolean getPublicAdmin() {
        return this.publicAdmin;
    }

    public boolean getPublicAuth() {
        return this.publicAuth;
    }

    public boolean getPublicSubmission() {
        return this.publicSubmission;
    }

    public boolean getService() {
        return this.service;
    }

    public boolean getAllowSuperUser() {
        return this.allowSuperUser;
    }

    public boolean getAdminCanEditAllPublicCategories() {
        return this.adminCanEditAllPublicCategories;
    }

    public boolean getAdminCanEditAllPublicLocations() {
        return this.adminCanEditAllPublicLocations;
    }

    public boolean getAdminCanEditAllPublicContacts() {
        return this.adminCanEditAllPublicContacts;
    }

    public boolean getSessionsless() {
        return this.sessionless;
    }

    public boolean getDontKill() {
        return this.dontKill;
    }

    public boolean getWebMode() {
        return this.webMode;
    }

    public void setReadonly(Boolean val) {
        this.readonly = val;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public boolean getForRestore() {
        return this.forRestore;
    }

    public boolean getIndexRebuild() {
        return this.indexRebuild;
    }

    public boolean isGuest() {
        return this.authUser == null;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("authUser", (Object)this.getAuthUser());
        ts.append("user", (Object)this.getUser());
        ts.append("calSuite", (Object)this.getCalSuite());
        ts.append("publicAdmin", this.getPublicAdmin());
        ts.append("publicAuth", this.getPublicAuth());
        ts.append("service", this.getService());
        ts.append("adminCanEditAllPublicCategories()", this.getAdminCanEditAllPublicCategories());
        ts.append("adminCanEditAllPublicLocations()", this.getAdminCanEditAllPublicLocations());
        ts.append("adminCanEditAllPublicSponsors()", this.getAdminCanEditAllPublicContacts());
        ts.append("sessionless", this.getSessionsless());
        ts.append("forRestore", this.getForRestore());
        ts.append("indexRebuild", this.getIndexRebuild());
        return ts.toString();
    }

    public Object clone() {
        return new CalSvcIPars(this.getLogId(), this.getAuthUser(), this.getUser(), this.getCalSuite(), this.getPublicAdmin(), this.getPublicAuth(), this.getAllowSuperUser(), this.getService(), this.getPublicSubmission(), this.getAdminCanEditAllPublicCategories(), this.getAdminCanEditAllPublicLocations(), this.getAdminCanEditAllPublicContacts(), this.getSessionsless(), this.getDontKill(), this.getReadonly(), this.getClientId(), this.getForRestore(), this.getIndexRebuild());
    }

    public CalSvcIPars cloneRo() {
        CalSvcIPars pars = CalSvcIPars.getRoClientPars("", this.getAuthUser(), this.getUser(), this.getCalSuite(), this.getPublicAuth());
        pars.logId = this.getLogId();
        return pars;
    }
}

