/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import net.fortuna.ical4j.model.Period;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.EventPeriod;

public class Granulator {
    private Granulator() {
    }

    public static Collection<?> getPeriodsEvents(GetPeriodsPars pars) {
        ArrayList<Object> al = new ArrayList<Object>();
        if (pars.endDt != null) {
            pars.startDt = (BwDateTime)pars.endDt.clone();
        }
        pars.endDt = pars.startDt.addDuration(pars.dur);
        String start = pars.startDt.getDate();
        String end = pars.endDt.getDate();
        EntityRange er = new EntityRange();
        for (Object o : pars.periods) {
            int evendSt;
            er.setEntity(o);
            int evstSt = er.start.compareTo(end);
            if (evstSt >= 0 || (evendSt = er.end.compareTo(start)) <= 0 && (!er.start.equals(er.end) || evendSt < 0)) continue;
            al.add(er.entity);
        }
        return al;
    }

    public static class GetPeriodsPars
    implements Serializable {
        public Collection<?> periods;
        public BwDateTime startDt;
        public BwDuration dur;
        public BwDateTime endDt;
    }

    private static class EntityRange {
        Object entity;
        String start;
        String end;

        private EntityRange() {
        }

        void setEntity(Object o) {
            this.entity = o;
            if (o instanceof EventInfo) {
                EventInfo ei = (EventInfo)o;
                BwEvent ev = ei.getEvent();
                this.start = ev.getDtstart().getDate();
                this.end = ev.getDtend().getDate();
                return;
            }
            if (o instanceof EventPeriod) {
                EventPeriod ep = (EventPeriod)o;
                this.start = String.valueOf(ep.getStart());
                this.end = String.valueOf(ep.getEnd());
                return;
            }
            if (o instanceof Period) {
                Period p = (Period)o;
                this.start = String.valueOf(p.getStart());
                this.end = String.valueOf(p.getEnd());
                return;
            }
            this.start = null;
            this.end = null;
        }
    }
}

