/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fortuna.ical4j.vcard.parameter.Type;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.ical.IcalProperties;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.base.CollatableEntity;
import org.bedework.calfacade.base.SizedEntity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.FieldSplitter;
import org.bedework.calfacade.util.QuotaUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;
import org.bedework.util.vcard.Card;
import org.bedework.util.xml.FromXmlCallback;

@Dump(elementName="location", keyFields={"uid"})
public class BwLocation
extends BwEventProperty<BwLocation>
implements CollatableEntity,
Comparator<BwLocation>,
SizedEntity {
    public static final String fieldDelimiter = "\t";
    private BwString address;
    private Splitter addressSplit;
    private static final int addrIndex = 0;
    private static final int roomIndex = 1;
    private static final int subf1Index = 2;
    private static final int subf2Index = 3;
    private static final int accessibleIndex = 4;
    private static final int geouriIndex = 5;
    private static final int loctypeIndex = 6;
    private static final int countryIndex = 7;
    private BwString subaddress;
    private Splitter subaddressSplit;
    private FieldSplitter keysSplit;
    private static final int streetIndex = 0;
    private static final int cityIndex = 1;
    private static final int stateIndex = 2;
    private static final int zipIndex = 3;
    private static final int alternateAddressIndex = 4;
    private static final int codeIndex = 5;
    private static final int keysIndex = 6;
    private static final int doNotUseIndex = 7;
    private String link;
    Function<KeyFld, String> keyFldToString = val -> {
        if (val == null) {
            return null;
        }
        return val.getKeyName() + ":" + val.getKeyVal();
    };
    Function<String, KeyFld> stringToKeyFld = val -> {
        if (val == null) {
            return null;
        }
        String[] vals = val.split(":");
        if (vals.length != 2) {
            throw new RuntimeException("Bad keys value: " + val);
        }
        return new KeyFld(vals[0], vals[1]);
    };
    private static FromXmlCallback fromXmlCb;

    public void setAddress(BwString val) {
        this.address = val;
    }

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ADDRESS), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOC_ALL, jname="loc_all", termsField="loc_all_terms", analyzed=true)})
    @JsonIgnore
    public BwString getAddress() {
        return this.address;
    }

    public void setAddressField(String val) {
        this.assignAddressField(0, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ADDRESS_FLD)
    public String getAddressField() {
        return this.fetchAddressSplit().getFld(0);
    }

    public void setRoomField(String val) {
        this.assignAddressField(1, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ROOM_FLD)
    public String getRoomField() {
        return this.fetchAddressSplit().getFld(1);
    }

    public void setSubField1(String val) {
        this.assignAddressField(2, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SUB1_FLD)
    public String getSubField1() {
        return this.fetchAddressSplit().getFld(2);
    }

    public void setSubField2(String val) {
        this.assignAddressField(3, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SUB2_FLD)
    public String getSubField2() {
        return this.fetchAddressSplit().getFld(3);
    }

    public void setAccessible(boolean val) {
        String flag = val ? "T" : null;
        this.assignAddressField(4, flag);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ACCESSIBLE_FLD)
    public boolean getAccessible() {
        String fld = this.fetchAddressSplit().getFld(4);
        return "T".equals(fld);
    }

    public void setGeouri(String val) {
        this.assignAddressField(5, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.GEOURI_FLD)
    public String getGeouri() {
        return this.fetchAddressSplit().getFld(5);
    }

    public void setLoctype(String val) {
        this.assignAddressField(6, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOCTYPE_FLD)
    public String getLoctype() {
        return this.fetchAddressSplit().getFld(6);
    }

    public void setCountry(String val) {
        this.assignAddressField(7, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.COUNTRY_FLD)
    public String getCountry() {
        return this.fetchAddressSplit().getFld(7);
    }

    public void setStatus(String val) {
        if (this.getAddress() == null) {
            this.setAddress(new BwString(val, null));
        } else {
            this.getAddress().setLang(val);
        }
    }

    @Override
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.STATUS)
    public String getStatus() {
        BwString s = this.getAddress();
        if (s == null) {
            return null;
        }
        return s.getLang();
    }

    public void setKeys(List<KeyFld> vals) {
        List<String> strVals = vals.stream().map(this.keyFldToString).collect(Collectors.toList());
        this.fetchKeysSplit().setFlds(strVals);
        this.assignSubaddressField(6, this.fetchKeysSplit().getCombined());
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOC_KEYS_FLD, nested=true, jname="locKeys")
    public List<KeyFld> getKeys() {
        List<String> vals = this.fetchKeysSplit().getFlds();
        if (Util.isEmpty(vals)) {
            return null;
        }
        return vals.stream().map(this.stringToKeyFld).collect(Collectors.toList());
    }

    public void addKey(String name, String val) {
        assert (name != null);
        assert (val != null);
        List<KeyFld> keyFlds = this.getKeys();
        if (keyFlds == null) {
            keyFlds = new ArrayList<KeyFld>();
        }
        keyFlds.add(new KeyFld(name, val));
        this.setKeys(keyFlds);
    }

    public void updKey(String name, String val) {
        assert (name != null);
        assert (val != null);
        List<KeyFld> keyFlds = this.getKeys();
        if (keyFlds == null) {
            keyFlds = new ArrayList<KeyFld>();
        }
        KeyFld kf = null;
        for (KeyFld lkf : keyFlds) {
            if (!lkf.getKeyName().equals(name)) continue;
            kf = lkf;
            break;
        }
        if (kf == null) {
            keyFlds.add(new KeyFld(name, val));
        } else {
            kf.setKeyVal(val);
        }
        this.setKeys(keyFlds);
    }

    public void delKey(String name) {
        assert (name != null);
        List<KeyFld> keyFlds = this.getKeys();
        if (keyFlds == null) {
            return;
        }
        KeyFld kf = null;
        for (KeyFld lkf : keyFlds) {
            if (!lkf.getKeyName().equals(name)) continue;
            kf = lkf;
            break;
        }
        if (kf == null) {
            return;
        }
        keyFlds.remove(kf);
        this.setKeys(keyFlds);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.SUBADDRESS)
    public void setSubaddress(BwString val) {
        this.subaddress = val;
    }

    @JsonIgnore
    public BwString getSubaddress() {
        return this.subaddress;
    }

    @JsonIgnore
    @NoDump
    public String getSubaddressField() {
        if (this.getSubaddress() == null) {
            return null;
        }
        return this.getSubaddress().getValue();
    }

    public void setStreet(String val) {
        this.assignSubaddressField(0, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.STREET_FLD)
    public String getStreet() {
        return this.fetchSubaddressSplit().getFld(0);
    }

    public void setCity(String val) {
        this.assignSubaddressField(1, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CITY_FLD)
    public String getCity() {
        return this.fetchSubaddressSplit().getFld(1);
    }

    public void setState(String val) {
        this.assignSubaddressField(2, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.STATE_FLD)
    public String getState() {
        return this.fetchSubaddressSplit().getFld(2);
    }

    public void setZip(String val) {
        this.assignSubaddressField(3, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ZIP_FLD)
    public String getZip() {
        return this.fetchSubaddressSplit().getFld(3);
    }

    public void setAlternateAddress(String val) {
        this.assignSubaddressField(4, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.ALTADDRESS_FLD)
    public String getAlternateAddress() {
        return this.fetchSubaddressSplit().getFld(4);
    }

    public void setCode(String val) {
        this.assignSubaddressField(5, val);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CODEIDX_FLD)
    public String getCode() {
        return this.fetchSubaddressSplit().getFld(5);
    }

    public void setDoNotUse(boolean val) {
        this.assignSubaddressField(7, String.valueOf(val));
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOC_DONOTUSE_FLD)
    public boolean getDoNotUse() {
        return Boolean.parseBoolean(this.fetchSubaddressSplit().getFld(7));
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public static BwLocation makeLocation() {
        return (BwLocation)new BwLocation().initUid();
    }

    public void deleteAddress() {
        this.addDeletedEntity(this.getAddress());
        this.setAddress(null);
    }

    public void deleteSubaddress() {
        this.addDeletedEntity(this.getSubaddress());
        this.setSubaddress(null);
    }

    @Override
    void fixNames() {
        this.setColPath("locations", null);
        this.setHref(Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), this.getUid()}));
    }

    @Override
    @NoDump
    @JsonIgnore
    public BwString getFinderKeyValue() {
        return this.getAddress();
    }

    @Override
    @NoDump
    @JsonIgnore
    public String getCollateValue() {
        if (this.getAddress().getValue() == null) {
            return "";
        }
        return this.getAddress().getValue();
    }

    @Override
    public void afterDeletion() {
        this.addDeletedEntity(this.getAddress());
        this.addDeletedEntity(this.getSubaddress());
    }

    @Override
    @NoDump
    @JsonIgnore
    public int getSize() {
        return super.length() + QuotaUtil.size(this.getAddress()) + QuotaUtil.size(this.getSubaddress()) + QuotaUtil.size(this.getLink());
    }

    public boolean updateFrom(BwLocation ent) {
        boolean changed = false;
        if (!CalFacadeUtil.eqObjval(this.getAddress(), ent.getAddress())) {
            this.setAddress(ent.getAddress());
            changed = true;
        }
        if (!CalFacadeUtil.eqObjval(this.getSubaddress(), ent.getSubaddress())) {
            this.setSubaddress(ent.getSubaddress());
            changed = true;
        }
        if (!CalFacadeUtil.eqObjval(this.getLink(), ent.getLink())) {
            this.setLink(ent.getLink());
            changed = true;
        }
        return changed;
    }

    @NoDump
    public static FromXmlCallback getRestoreCallback() {
        if (fromXmlCb == null) {
            fromXmlCb = new FromXmlCallback();
            fromXmlCb.addSkips(new String[]{"byteSize", "id", "seq"});
            fromXmlCb.addMapField("public", "publick");
        }
        return fromXmlCb;
    }

    @Override
    public int compare(BwLocation thisone, BwLocation thatone) {
        if (thisone.equals(thatone)) {
            return 0;
        }
        return CalFacadeUtil.cmpObjval(thisone.getAddress().getValue(), thatone.getAddress().getValue());
    }

    @Override
    public int compareTo(BwLocation that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        return CalFacadeUtil.cmpObjval(this.getUid(), that.getUid());
    }

    @Override
    public int hashCode() {
        return this.getUid().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("uid", (Object)this.getUid());
        ts.append("address", (Object)this.getAddress());
        ts.append("addressField", (Object)this.getAddressField());
        ts.append("roomField", (Object)this.getRoomField());
        ts.append("accessible", this.getAccessible());
        ts.append("subField1", (Object)this.getSubField1());
        ts.append("subField2", (Object)this.getSubField2());
        ts.append("geouri", (Object)this.getGeouri());
        ts.append("subaddress", (Object)this.getSubaddress());
        ts.append("street", (Object)this.getStreet());
        ts.append("city", (Object)this.getCity());
        ts.append("state", (Object)this.getState());
        ts.append("zip", (Object)this.getZip());
        ts.append("link", (Object)this.getLink());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwLocation loc = new BwLocation();
        super.copyTo(loc);
        if (this.getAddress() != null) {
            loc.setAddress((BwString)this.getAddress().clone());
        }
        if (this.getSubaddress() != null) {
            loc.setSubaddress((BwString)this.getSubaddress().clone());
        }
        loc.setLink(this.getLink());
        return loc;
    }

    @NoDump
    @JsonIgnore
    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOC_COMBINED_VALUES)
    public String getCombinedValues() {
        if (this.value(this.getAddress()) == null && this.value(this.getSubaddress()) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAddressField());
        this.addCombined(sb, this.getRoomField());
        this.addCombined(sb, this.getCity());
        this.addCombined(sb, this.getState());
        this.addCombined(sb, this.getZip());
        return sb.toString();
    }

    @NoDump
    @JsonIgnore
    public Card getCard() {
        Card card = new Card();
        card.setName(this.getUid() + ".vcf");
        card.setUid(this.getUid());
        StringBuilder sb = new StringBuilder(this.getAddressField());
        this.addCombined(sb, this.getRoomField());
        card.setAddress(null, sb.toString(), this.getStreet(), this.getCity(), this.getState(), this.getZip(), null, new Type[0]);
        if (this.getLink() != null) {
            card.setUrl(this.getLink());
        }
        if (this.getGeouri() != null) {
            try {
                card.setGeoUri(this.getGeouri());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        card.setAccessible(this.getAccessible());
        return card;
    }

    private void addCombined(StringBuilder sb, String field) {
        if (field == null) {
            return;
        }
        sb.append(", ");
        sb.append(field);
    }

    private String value(BwString val) {
        if (val == null) {
            return null;
        }
        return val.getValue();
    }

    private Splitter fetchAddressSplit() {
        if (this.addressSplit == null) {
            this.addressSplit = new Splitter(this.getAddress());
        }
        return this.addressSplit;
    }

    private void assignAddressField(int index, String val) {
        this.fetchAddressSplit().setFld(index, val);
        this.setAddress(this.fetchAddressSplit().getCombined(this.getAddress()));
    }

    private Splitter fetchSubaddressSplit() {
        if (this.subaddressSplit == null) {
            this.subaddressSplit = new Splitter(this.getSubaddress());
        }
        return this.subaddressSplit;
    }

    private void assignSubaddressField(int index, String val) {
        this.fetchSubaddressSplit().setFld(index, val);
        this.setSubaddress(this.fetchSubaddressSplit().getCombined(this.getSubaddress()));
    }

    private FieldSplitter fetchKeysSplit() {
        if (this.keysSplit == null) {
            this.keysSplit = new FieldSplitter("\b");
            this.keysSplit.setVal(this.fetchSubaddressSplit().getFld(6));
        }
        return this.keysSplit;
    }

    private static class Splitter
    extends FieldSplitter {
        Splitter(BwString fld) {
            super(BwLocation.fieldDelimiter);
            if (fld != null && fld.getValue() != null) {
                this.setVal(fld.getValue());
            }
        }

        public BwString getCombined(BwString val) {
            if (val != null) {
                val.setValue(this.getCombined());
                return val;
            }
            return new BwString(null, this.getCombined());
        }
    }

    public static class KeyFld {
        private final String keyName;
        private String keyVal;

        public KeyFld(String keyName, String keyVal) {
            this.keyName = keyName;
            this.keyVal = keyVal;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyVal(String val) {
            this.keyVal = val;
        }

        public String getKeyVal() {
            return this.keyVal;
        }

        public int hashCode() {
            return this.getKeyName().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyFld)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            return this.getKeyName().equals(((KeyFld)o).getKeyName());
        }
    }
}

