/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.ToString;

public class SubContext
implements Comparable<SubContext> {
    private BwProperty prop;
    private String contextName;
    private String calSuite;
    private boolean defaultContext;

    public SubContext(BwProperty prop) {
        this.prop = prop;
    }

    public SubContext(String contextName, String calSuite, boolean defaultContext) {
        this.contextName = contextName;
        this.calSuite = calSuite;
        this.defaultContext = defaultContext;
    }

    public SubContext(String encoded) {
        this.setPvals(encoded);
    }

    public BwProperty getProp() {
        if (this.prop != null) {
            return this.prop;
        }
        String val = this.contextName + "," + this.calSuite;
        if (this.defaultContext) {
            val = val + ",true";
        }
        this.prop = new BwProperty("bedework:contexts", val);
        return this.prop;
    }

    public String getContextName() {
        this.setPvals();
        return this.contextName;
    }

    public String getCalSuite() {
        this.setPvals();
        return this.calSuite;
    }

    public boolean getDefaultContext() {
        this.setPvals();
        return this.defaultContext;
    }

    static String extractContextName(String encoded) {
        return encoded.split(",")[0];
    }

    private void setPvals() {
        if (this.contextName != null) {
            return;
        }
        if (this.prop == null) {
            return;
        }
        this.setPvals(this.prop.getValue());
    }

    private void setPvals(String val) {
        String[] pvals = val.split(",");
        this.contextName = pvals[0];
        this.calSuite = pvals[1];
        this.defaultContext = pvals.length == 3;
    }

    @Override
    public int compareTo(SubContext that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        return CalFacadeUtil.cmpObjval(this.getContextName(), that.getContextName());
    }

    public int hashCode() {
        return 7 * this.getContextName().hashCode();
    }

    protected ToString toStringSegment(ToString ts) {
        return ts.append("contextName", (Object)this.getContextName()).append("calSuite", (Object)this.getCalSuite());
    }

    public String toString() {
        return this.toStringSegment(new ToString((Object)this)).toString();
    }
}

