/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.bedework.caldav.util.filter.AndFilter;
import org.bedework.caldav.util.filter.BooleanFilter;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.caldav.util.filter.ObjectFilter;
import org.bedework.caldav.util.filter.OrFilter;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.EventListEntry;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.CalFacadeSubscriptionLoopException;
import org.bedework.calfacade.filter.BwCollectionFilter;
import org.bedework.calfacade.filter.BwHrefFilter;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class FilterBuilder
implements Logged {
    private HashMap<String, BwCalendar> colCache = new HashMap();
    private SimpleFilterParser parser;
    private BwLogger logger = new BwLogger();

    public FilterBuilder(SimpleFilterParser parser) {
        this.parser = parser;
    }

    public FilterBase buildFilter(String path, boolean applyFilter, boolean explicitSelection) {
        CalFilter calFilter;
        if (path == null) {
            return BooleanFilter.falseFilter;
        }
        BwCalendar col = this.colCache.get(path);
        if (col == null) {
            try {
                col = this.parser.getCollection(path);
            }
            catch (CalFacadeException cfe) {
                this.error(cfe);
                return BooleanFilter.falseFilter;
            }
            this.colCache.put(path, col);
        }
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.add(path);
        try {
            calFilter = this.makeColFilter(col, applyFilter, explicitSelection, pathElements);
        }
        catch (CalFacadeException cfe) {
            this.error(cfe);
            return BooleanFilter.falseFilter;
        }
        if (calFilter == null) {
            return BooleanFilter.falseFilter;
        }
        FilterBase f = this.makeBwFilter(calFilter);
        if (this.debug()) {
            this.debug(" ---------  FilterBuilder result ---------------");
            this.dump(f, "");
            this.debug(" ---------  end of FilterBuilder result ---------------");
        }
        return f;
    }

    private FilterBase makeBwFilter(CalFilter val) {
        boolean conjunction = val instanceof AndCalFilter;
        if (val instanceof CalFilterTerms) {
            CalFilterTerms cft = (CalFilterTerms)val;
            if (cft.terms.size() == 0) {
                return BooleanFilter.falseFilter;
            }
            if (cft.terms.size() == 1) {
                return this.makeBwFilter(cft.terms.iterator().next());
            }
            FilterBase res = null;
            for (CalFilter cf : cft.terms) {
                FilterBase f = this.makeBwFilter(cf);
                if (f == null) continue;
                if (conjunction) {
                    res = FilterBase.addAndChild(res, (FilterBase)f);
                    continue;
                }
                res = FilterBase.addOrChild(res, (FilterBase)f);
            }
            return res;
        }
        if (val instanceof HrefFilter) {
            BwHrefFilter hf = new BwHrefFilter(null, PropertyIndex.PropertyInfoIndex.HREF);
            hf.setEntity(((HrefFilter)val).href);
            return hf;
        }
        EntityCalFilter ecf = (EntityCalFilter)val;
        if (ecf.cal == null) {
            return ecf.filter;
        }
        BwCollectionFilter f = new BwCollectionFilter(null, ecf.cal);
        return FilterBase.addAndChild((FilterBase)f, (FilterBase)ecf.filter);
    }

    private CalFilter makeColFilter(BwCalendar cal, boolean applyFilter, boolean explicitSelection, ArrayList<String> pathElements) throws CalFacadeException {
        FilterBase fltr = null;
        if (applyFilter && cal.getFilterExpr() != null) {
            fltr = this.parseExpr(cal);
        }
        if (cal.getCalType() == 11) {
            OrCalFilter ocf = new OrCalFilter();
            for (EventListEntry ele : cal.getEventList()) {
                HrefFilter hf = new HrefFilter();
                hf.href = ele.getHref();
                ocf.terms.add(hf);
            }
            return ocf;
        }
        if (cal.getCollectionInfo().onlyCalEntities) {
            if (!explicitSelection && cal.getCalType() != 1 && cal.getCalType() != 8) {
                return null;
            }
            EntityCalFilter ecalFilter = new EntityCalFilter();
            ecalFilter.cal = cal;
            ecalFilter.filter = fltr;
            return ecalFilter;
        }
        if (cal.getInternalAlias()) {
            BwCalendar target = this.parser.resolveAlias(cal, false);
            if (target == null) {
                return null;
            }
            String path = target.getPath();
            if (pathElements.contains(path)) {
                throw new CalFacadeSubscriptionLoopException();
            }
            pathElements.add(path);
            return this.anded(fltr, this.makeColFilter(target, true, false, pathElements));
        }
        if (cal.getCalType() == 0) {
            return this.anded(fltr, this.makeFolderFilter(cal, pathElements));
        }
        return null;
    }

    private CalFilter anded(FilterBase fltr, CalFilter calFilter) throws CalFacadeException {
        if (calFilter == null) {
            return null;
        }
        if (fltr != null) {
            calFilter.filter = FilterBase.addAndChild((FilterBase)fltr, (FilterBase)calFilter.filter);
        }
        return calFilter;
    }

    private CalFilter makeFolderFilter(BwCalendar val, ArrayList<String> pathElements) throws CalFacadeException {
        Collection<BwCalendar> cols = this.parser.getChildren(val);
        OrCalFilter res = new OrCalFilter();
        for (BwCalendar col : cols) {
            String path;
            if (this.colCache.get(col.getPath()) == null) {
                this.colCache.put(col.getPath(), col);
            }
            if (!col.getDisplay()) continue;
            ArrayList<Object> pe = pathElements == null ? new ArrayList() : new ArrayList<String>(pathElements);
            if (pe.contains(path = col.getPath())) {
                throw new CalFacadeSubscriptionLoopException();
            }
            pe.add(path);
            CalFilter cf = this.makeColFilter(col, true, false, pe);
            if (cf == null) continue;
            this.mergeFilter(res.terms, cf, false);
        }
        if (res.terms.size() == 0) {
            return null;
        }
        if (res.terms.size() == 1) {
            return (CalFilter)res.terms.iterator().next();
        }
        return res;
    }

    private void mergeFilter(Collection<CalFilter> terms, CalFilter cf, boolean conjunction) throws CalFacadeException {
        if (!(cf instanceof EntityCalFilter) || terms.size() == 0) {
            terms.add(cf);
            return;
        }
        if (conjunction) {
            terms.add(cf);
            return;
        }
        EntityCalFilter ecf = (EntityCalFilter)cf;
        for (CalFilter calf : terms) {
            if (!(calf instanceof EntityCalFilter)) continue;
            EntityCalFilter ecalf = (EntityCalFilter)calf;
            if (!ecf.cal.equals(ecalf.cal)) continue;
            if (ecalf.filter == null || ecf.filter == null) {
                ecalf.filter = null;
                return;
            }
            if (!(ecalf.filter instanceof ObjectFilter) || !(ecf.filter instanceof ObjectFilter)) {
                ecalf.filter = FilterBase.addOrChild((FilterBase)ecalf.filter, (FilterBase)ecf.filter);
                return;
            }
            ObjectFilter ocalf = (ObjectFilter)ecalf.filter;
            ObjectFilter ocf = (ObjectFilter)ecf.filter;
            if (!ocalf.getPropertyIndex().equals((Object)ocf.getPropertyIndex()) || !ocalf.getExact() || !ocf.getExact() || BwIcalPropertyInfo.getPinfo(ocalf.getPropertyIndex()).getMultiValued()) {
                ecalf.filter = FilterBase.addOrChild((FilterBase)ecalf.filter, (FilterBase)ecf.filter);
                return;
            }
            Object o1 = ocalf.getEntity();
            Object o2 = ocf.getEntity();
            ArrayList<Object> c1 = null;
            Collection c2 = null;
            if (o1 instanceof Collection) {
                c1 = (ArrayList<Object>)o1;
                o1 = c1.size() > 0 ? c1.iterator().next() : null;
            }
            if (o2 instanceof Collection) {
                c2 = (Collection)o2;
                o2 = c2.size() > 0 ? c2.iterator().next() : null;
            }
            if (o1 == null || o2 == null || !o1.getClass().equals(o2.getClass())) {
                ecalf.filter = FilterBase.addOrChild((FilterBase)ecalf.filter, (FilterBase)ecf.filter);
                return;
            }
            if (c1 == null) {
                c1 = new ArrayList<Object>();
                c1.add(o1);
                ocalf.setEntity(c1);
            }
            if (c2 != null) {
                c1.addAll(c2);
            } else {
                c1.add(o2);
            }
            return;
        }
        terms.add(cf);
    }

    private void dump(FilterBase f, String curLine) {
        if (f instanceof OrFilter) {
            this.debug(curLine + "  OR ");
            Iterator<FilterBase> it = f.getChildren().iterator();
            this.dumpChildren(it, curLine);
            return;
        }
        if (f instanceof AndFilter) {
            this.debug(curLine + "  AND ");
            Iterator<FilterBase> it = f.getChildren().iterator();
            this.dumpChildren(it, curLine);
            return;
        }
        if (f instanceof ObjectFilter) {
            ObjectFilter of = (ObjectFilter)f;
            if (of.getEntity() instanceof BwCalendar) {
                StringBuilder sb = new StringBuilder(curLine);
                sb.append(curLine);
                sb.append("  cal=");
                sb.append(((BwCalendar)of.getEntity()).getPath());
                this.debug(sb.toString());
            } else {
                this.debug(curLine + f.toString());
            }
        } else {
            this.debug(curLine + f.toString());
        }
    }

    private FilterBase parseExpr(BwCalendar col) throws CalFacadeException {
        SimpleFilterParser sfp = this.parser.getParser();
        SimpleFilterParser.ParseResult pr = sfp.parse(col.getFilterExpr(), false, col.getPath());
        if (!pr.ok) {
            throw pr.cfe;
        }
        return pr.filter;
    }

    private void dumpChildren(Iterator<FilterBase> it, String curLine) {
        if (!it.hasNext()) {
            return;
        }
        FilterBase f = it.next();
        if (it.hasNext()) {
            this.dumpChildren(it, curLine + "   |   ");
        }
        this.dump(f, curLine);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private static class CalFilter {
        FilterBase filter;

        private CalFilter() {
        }
    }

    private static class AndCalFilter
    extends CalFilterTerms {
        private AndCalFilter() {
        }
    }

    private static class CalFilterTerms
    extends CalFilter {
        Collection<CalFilter> terms = new ArrayList<CalFilter>();

        private CalFilterTerms() {
        }
    }

    private static class HrefFilter
    extends CalFilter {
        String href;

        private HrefFilter() {
        }
    }

    private static class EntityCalFilter
    extends CalFilter {
        BwCalendar cal;

        private EntityCalFilter() {
        }
    }

    private static class OrCalFilter
    extends CalFilterTerms {
        private OrCalFilter() {
        }
    }
}

