/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.filter;

import ietf.params.xml.ns.caldav.TextMatchType;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.fortuna.ical4j.model.DateTime;
import org.bedework.caldav.util.TimeRange;
import org.bedework.caldav.util.filter.AndFilter;
import org.bedework.caldav.util.filter.EntityTypeFilter;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.caldav.util.filter.ObjectFilter;
import org.bedework.caldav.util.filter.OrFilter;
import org.bedework.caldav.util.filter.PresenceFilter;
import org.bedework.caldav.util.filter.parse.Filters;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.filter.BwCategoryFilter;
import org.bedework.calfacade.filter.BwViewFilter;
import org.bedework.calfacade.filter.FilterBuilder;
import org.bedework.calfacade.filter.SfpTokenizer;
import org.bedework.calfacade.filter.SortTerm;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.calfacade.svc.BwView;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.response.GetEntityResponse;

public abstract class SimpleFilterParser
implements Logged {
    private SfpTokenizer tokenizer;
    private String currentExpr;
    private String source;
    private SimpleFilterParser subParser;
    private boolean explicitSelection;
    private static final Token openParen = new OpenParenthesis();
    private static final int isDefined = 0;
    private static final int notDefined = 1;
    private static final int equal = 2;
    private static final int notEqual = 3;
    private static final int like = 4;
    private static final int notLike = 5;
    private static final int greaterThan = 6;
    private static final int lessThan = 7;
    private static final int greaterThanOrEqual = 8;
    private static final int lessThanOrEqual = 9;
    private static final int inTimeRange = 10;
    private static final int andOp = 11;
    private static final int orOp = 12;
    private static final int startsWithOp = 13;
    private static final int indexedOp = 14;
    private static final LogicalOperator andOperator = new LogicalOperator(11);
    private static final LogicalOperator orOperator = new LogicalOperator(12);
    private final Stack<Token> stack = new Stack();
    private final Stack<FilterBase> filterStack = new Stack();
    private final ParseResult parseResult = new ParseResult();
    private BwLogger logger = new BwLogger();

    public abstract BwCalendar getCollection(String var1) throws CalFacadeException;

    public abstract BwCalendar resolveAlias(BwCalendar var1, boolean var2) throws CalFacadeException;

    public abstract Collection<BwCalendar> getChildren(BwCalendar var1) throws CalFacadeException;

    public abstract BwCategory getCategoryByName(String var1) throws CalFacadeException;

    public abstract GetEntityResponse<BwCategory> getCategoryByUid(String var1);

    public abstract BwView getView(String var1) throws CalFacadeException;

    public abstract Collection<BwCalendar> decomposeVirtualPath(String var1) throws CalFacadeException;

    public abstract SimpleFilterParser getParser();

    public ParseResult parse(String expr, boolean explicitSelection, String source) {
        this.explicitSelection = explicitSelection;
        this.source = source;
        this.parseResult.ok = true;
        try {
            if (this.debug()) {
                this.debug("About to parse filter expression: " + expr + " from " + source);
            }
            this.currentExpr = expr;
            this.tokenizer = new SfpTokenizer(new StringReader(expr));
            this.doExpr();
            if (this.topLOp()) {
                this.pop();
            }
            if (!this.stackEmpty()) {
                throw this.parseResult.fail("Filter syntax: source: " + source);
            }
            if (this.filterStack.size() != 1) {
                throw this.parseResult.fail("Filter syntax:  source: " + source);
            }
            FilterBase f = this.popFilters();
            if (this.debug()) {
                this.debug(f.toString());
            }
            this.parseResult.SetFilter(f);
        }
        catch (ParseFailed parseFailed) {
            // empty catch block
        }
        return this.parseResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParseResult parseSort(String sexpr) {
        this.parseResult.ok = true;
        this.parseResult.sortTerms = new ArrayList<SortTerm>();
        if (sexpr == null) {
            return this.parseResult;
        }
        try {
            this.tokenizer = new SfpTokenizer(new StringReader(sexpr));
            while (true) {
                int tkn;
                if ((tkn = this.nextToken("parseSort()")) == -1) {
                    return this.parseResult;
                }
                List<PropertyInfo> pis = this.getProperty(tkn);
                tkn = this.nextToken("parseSort() - :");
                boolean ascending = false;
                if (tkn == 58) {
                    tkn = this.nextToken("parseSort() - asc/desc");
                    if (tkn != -3) {
                        throw this.parseResult.fail("Expected Asc Desc: " + tkn + " source: " + this.source);
                    }
                    if ("asc".equalsIgnoreCase(this.tokenizer.sval)) {
                        ascending = true;
                    } else {
                        if (!"desc".equalsIgnoreCase(this.tokenizer.sval)) throw this.parseResult.fail("Expected Asc Desc: " + tkn + " source: " + this.source);
                        ascending = false;
                    }
                } else if (tkn == -1) {
                    this.tokenizer.pushBack();
                } else if (tkn != 44) {
                    throw this.parseResult.fail("Bad sort: " + tkn + " from " + sexpr + " source: " + this.source);
                }
                ArrayList<PropertyIndex.PropertyInfoIndex> pixs = new ArrayList<PropertyIndex.PropertyInfoIndex>();
                pis.forEach(val -> pixs.add(val.pii));
                this.parseResult.sortTerms.add(new SortTerm(pixs, ascending));
            }
        }
        catch (ParseFailed ignored) {
            return this.parseResult;
        }
    }

    private boolean doFactor() throws ParseFailed {
        int tkn;
        if (this.debug()) {
            this.debug("doFactor: " + this.tokenizer.toString());
        }
        if ((tkn = this.nextToken("doFactor(1)")) == -1) {
            return false;
        }
        if (tkn == 40) {
            this.push(openParen);
            this.doExpr();
            if (this.nextToken("doFactor(2)") != 41) {
                throw this.parseResult.fail("Expected close paren:  source: " + this.source);
            }
            this.popOpenParen();
        } else {
            this.tokenizer.pushBack();
            if (!this.doPropertyComparison()) {
                return false;
            }
        }
        if (!this.topLOp()) {
            return true;
        }
        FilterBase filter = this.popFilters();
        FilterBase topFilter = this.popFilters();
        if (this.anding()) {
            this.filterStack.push(FilterBase.addAndChild((FilterBase)topFilter, (FilterBase)filter));
        } else {
            this.filterStack.push(FilterBase.addOrChild((FilterBase)topFilter, (FilterBase)filter));
        }
        this.pop();
        return true;
    }

    private boolean doExpr() throws ParseFailed {
        if (this.debug()) {
            this.debug("doExpr: " + this.tokenizer.toString());
        }
        return this.doTerm();
    }

    private boolean doTerm() throws ParseFailed {
        int tkn;
        if (!this.doFactor()) {
            return false;
        }
        if (this.debug()) {
            this.debug("doTerm: " + this.tokenizer.toString());
        }
        if ((tkn = this.nextToken("doTerm()")) == -1) {
            return false;
        }
        if ((tkn = this.checkLop(tkn)) != 38 && tkn != 124) {
            this.tokenizer.pushBack();
            if (this.topLOp()) {
                FilterBase filter = this.popFilters();
                FilterBase topFilter = this.popFilters();
                if (this.anding()) {
                    this.filterStack.push(FilterBase.addAndChild((FilterBase)topFilter, (FilterBase)filter));
                } else {
                    this.filterStack.push(FilterBase.addOrChild((FilterBase)topFilter, (FilterBase)filter));
                }
                this.pop();
            }
            return true;
        }
        this.doLop(tkn);
        this.doTerm();
        return true;
    }

    private boolean doLop(int tkn) throws ParseFailed {
        LogicalOperator oper = null;
        if (this.topLOp()) {
            oper = this.popLOp();
        }
        if (oper != null) {
            if (tkn == 38 ? oper.op != 11 : oper.op != 12) {
                throw this.parseResult.fail("Mixed Logical Operators:  source: " + this.source);
            }
            this.push(oper);
        } else if (tkn == 38) {
            this.push(andOperator);
        } else {
            this.push(orOperator);
        }
        return true;
    }

    private int checkLop(int tkn) {
        if (tkn == 38) {
            return tkn;
        }
        if (tkn == 124) {
            return tkn;
        }
        if (tkn != -3) {
            return tkn;
        }
        String pname = this.tokenizer.sval;
        if (pname.equalsIgnoreCase("and")) {
            return 38;
        }
        if (pname.equalsIgnoreCase("or")) {
            return 124;
        }
        return tkn;
    }

    private List<PropertyInfo> getProperty(int curtkn) throws ParseFailed {
        int tkn = curtkn;
        ArrayList<PropertyInfo> pis = new ArrayList<PropertyInfo>();
        while (true) {
            if (tkn != -3) {
                throw this.parseResult.fail("Expected Property Name: " + tkn + " source: " + this.source);
            }
            String pname = this.tokenizer.sval;
            String pnameUc = pname.toUpperCase();
            if (pis.size() == 0 && pnameUc.equals("CATUID")) {
                pis.add(new PropertyInfo(PropertyIndex.PropertyInfoIndex.CATEGORIES, null, null));
                pis.add(new PropertyInfo(PropertyIndex.PropertyInfoIndex.UID, null, null));
                return pis;
            }
            PropertyIndex.PropertyInfoIndex pi = PropertyIndex.PropertyInfoIndex.fromName((String)pname);
            if (pi == null) {
                throw this.parseResult.fail("unknown Property: " + pname + ": expr was " + this.currentExpr + " source: " + this.source);
            }
            Integer intIndex = null;
            String strIndex = null;
            tkn = this.nextToken("getProperty(index)");
            if (tkn == 91) {
                if (pis.size() > 0) {
                    throw this.parseResult.fail("Unimplemented - indexing of nested fields: found" + tkn + " source: " + this.source);
                }
                tkn = this.nextToken("getProperty(index-1)");
                if (tkn == -2) {
                    intIndex = (int)this.tokenizer.nval;
                } else {
                    if (tkn != 34 && tkn != 39) {
                        throw this.parseResult.fail("Expected number or quoted string: found" + tkn + " source: " + this.source);
                    }
                    strIndex = this.tokenizer.sval;
                }
                tkn = this.nextToken("end-getProperty(index)");
                if (tkn != 93) {
                    throw this.parseResult.fail("Expected ']': found" + tkn + " source: " + this.source);
                }
                tkn = this.nextToken("getProperty");
            }
            pis.add(new PropertyInfo(pi, intIndex, strIndex));
            if (tkn != 46) {
                this.tokenizer.pushBack();
                return pis;
            }
            tkn = this.nextToken("getProperty: pname");
        }
    }

    private boolean doPropertyComparison() throws ParseFailed {
        List<PropertyInfo> pis = this.getProperty(this.nextToken("getProperty()"));
        Operator oper = this.nextOperator();
        FilterBase pfilter = this.makePropFilter(pis, oper.op);
        if (pfilter == null) {
            this.error(new CalFacadeException("org.bedework.exception.filter.badproperty", this.listProps(pis) + " source: " + this.source));
            throw this.parseResult.fail("Bad property: " + this.listProps(pis) + " source: " + this.source);
        }
        this.filterStack.push(pfilter);
        return true;
    }

    private ArrayList<String> doWordList() throws ParseFailed {
        int tkn = this.nextToken("doWordList(1)");
        if (tkn == -1) {
            throw this.parseResult.fail("Expected word list: found EOF source: " + this.source);
        }
        boolean paren = false;
        ArrayList<String> res = new ArrayList<String>();
        if (tkn == 40) {
            this.push(openParen);
            paren = true;
        } else {
            this.tokenizer.pushBack();
        }
        while (true) {
            if ((tkn = this.nextToken("doWordList(2)")) != 34 && tkn != 39) {
                throw this.parseResult.fail("Expected quoted string: found" + tkn + " source: " + this.source);
            }
            res.add(this.tokenizer.sval);
            tkn = this.nextToken("doWordList(3)");
            if (tkn == 44) {
                if (paren) continue;
                throw this.parseResult.fail("Bad list: " + tkn + " source: " + this.source);
            }
            if (paren) {
                if (tkn == 41) {
                    this.popOpenParen();
                    return res;
                }
            } else {
                this.tokenizer.pushBack();
                return res;
            }
            this.tokenizer.pushBack();
        }
    }

    private void popOpenParen() throws ParseFailed {
        Token tkn = this.pop();
        if (tkn != openParen) {
            throw this.parseResult.fail("filterSyntax: Expected openParen on stack. source: " + this.source);
        }
    }

    private FilterBase makePropFilter(List<PropertyInfo> pis, int oper) throws ParseFailed {
        boolean exact;
        PropertyInfo pi = pis.get(0);
        FilterBase filter = null;
        ArrayList<PropertyIndex.PropertyInfoIndex> pixs = new ArrayList<PropertyIndex.PropertyInfoIndex>();
        pis.forEach(val -> pixs.add(val.pii));
        boolean bl = exact = oper != 4 && oper != 5;
        if (pi.pii == PropertyIndex.PropertyInfoIndex.ENTITY_TYPE) {
            this.checkSub(pis, 1);
            return this.entityFilter(this.getMatch(oper).getValue());
        }
        if (oper == 1) {
            this.checkSub(pis, 2);
            return new PresenceFilter(null, pixs, false, pi.intKey, pi.strKey);
        }
        if (oper == 0) {
            this.checkSub(pis, 2);
            return new PresenceFilter(null, pixs, true, pi.intKey, pi.strKey);
        }
        if (oper == 10) {
            this.checkSub(pis, 2);
            return ObjectFilter.makeFilter(null, pixs, (TimeRange)this.getTimeRange(), (Integer)pi.intKey, (String)pi.strKey);
        }
        if (pi.pii == PropertyIndex.PropertyInfoIndex.VIEW) {
            this.checkSub(pis, 1);
            ArrayList<String> views = this.doWordList();
            for (String view : views) {
                FilterBase vpf = this.viewFilter(view);
                filter = this.and(null, filter, vpf);
            }
            return filter;
        }
        if (pi.pii == PropertyIndex.PropertyInfoIndex.VPATH) {
            this.checkSub(pis, 1);
            ArrayList<String> vpaths = this.doWordList();
            for (String vpath : vpaths) {
                FilterBase vpf = this.resolveVpath(vpath);
                filter = this.and(null, filter, vpf);
            }
            return filter;
        }
        if (pi.pii == PropertyIndex.PropertyInfoIndex.CATEGORIES && pis.size() == 2) {
            PropertyInfo subPi = pis.get(1);
            if (subPi.pii == PropertyIndex.PropertyInfoIndex.UID) {
                ArrayList<String> uids = this.doWordList();
                for (String uid : uids) {
                    GetEntityResponse<BwCategory> cat = this.callGetCategory(uid);
                    if (cat.isNotFound()) {
                        throw this.parseResult.fail("Category uid references missing category: " + uid + " Filter will always fail to match");
                    }
                    if (!cat.isOk()) {
                        throw this.parseResult.fail(cat.toString());
                    }
                    ObjectFilter f = new ObjectFilter(null, pixs);
                    f.setEntity((Object)uid);
                    f.setExact(exact);
                    f.setNot(oper == 3);
                    filter = this.and(null, filter, (FilterBase)f);
                }
                return filter;
            }
            if (subPi.pii == PropertyIndex.PropertyInfoIndex.HREF) {
                ArrayList<String> paths = this.doWordList();
                for (String path : paths) {
                    ObjectFilter f = new ObjectFilter(null, pixs);
                    f.setEntity((Object)path);
                    f.setCaseless(false);
                    f.setExact(exact);
                    f.setNot(oper == 3);
                    filter = this.and(null, filter, (FilterBase)f);
                }
                return filter;
            }
        }
        if (pi.pii == PropertyIndex.PropertyInfoIndex.COLLECTION || pi.pii == PropertyIndex.PropertyInfoIndex.COLPATH) {
            this.checkSub(pis, 1);
            ArrayList<String> paths = this.doWordList();
            for (String path : paths) {
                FilterBase pf = this.resolveColPath(path, true, true);
                if (pf == null) continue;
                filter = this.and(null, filter, pf);
            }
            return filter;
        }
        MatchType match = this.getMatch(oper);
        if (pi.pii == PropertyIndex.PropertyInfoIndex.CATEGORIES) {
            this.checkSub(pis, 1);
            String val2 = match.getValue();
            if (val2.startsWith("/")) {
                pixs.add(PropertyIndex.PropertyInfoIndex.HREF);
                ObjectFilter f = new ObjectFilter(null, pixs);
                f.setEntity((Object)val2);
                f.setCaseless(false);
                f.setExact(exact);
                f.setNot(match.getNegateCondition().equals("yes"));
                return f;
            }
            BwCategory cat = this.callGetCategoryByName(val2);
            if (cat == null) {
                throw this.parseResult.fail("Bad property: category name: " + match.getValue() + " source: " + this.source);
            }
            pixs.add(PropertyIndex.PropertyInfoIndex.UID);
            BwCategoryFilter f = new BwCategoryFilter(null, pixs);
            f.setEntity(cat);
            f.setExact(exact);
            f.setNot(match.getNegateCondition().equals("yes"));
            return f;
        }
        this.checkSub(pis, 2);
        ObjectFilter f = new ObjectFilter(null, pixs, pi.intKey, pi.strKey);
        f.setEntity((Object)match.getValue());
        f.setCaseless(Filters.caseless((TextMatchType)match));
        f.setExact(exact);
        f.setNot(match.getNegateCondition().equals("yes"));
        f.setPrefixMatch(match.getPrefixMatch());
        return f;
    }

    private void checkSub(List<PropertyInfo> pis, int depth) throws ParseFailed {
        if (depth < pis.size()) {
            throw this.parseResult.fail("Bad Property: " + this.listProps(pis) + " (exceeds allowable depth) source: " + this.source);
        }
    }

    private String listProps(List<PropertyInfo> pis) {
        String delim = "";
        StringBuilder sb = new StringBuilder();
        for (PropertyInfo pi : pis) {
            sb.append(delim);
            BwIcalPropertyInfo.BwIcalPropertyInfoEntry ipie = BwIcalPropertyInfo.getPinfo(pi.pii);
            if (ipie == null) {
                sb.append("bad-index(").append(pi).append("(");
            } else {
                sb.append(ipie.getJname());
            }
            delim = ".";
        }
        return sb.toString();
    }

    private MatchType getMatch(int oper) throws ParseFailed {
        this.assertString();
        MatchType tm = new MatchType();
        tm.setValue(this.tokenizer.sval);
        if (oper == 13) {
            tm.setPrefixMatch(true);
            tm.setCollation("i;octet");
            return tm;
        }
        if (oper == 3 || oper == 5) {
            tm.setNegateCondition("yes");
        } else {
            tm.setNegateCondition("no");
        }
        if (oper == 5 || oper == 4) {
            tm.setCollation("i;ascii-casemap");
        } else {
            tm.setCollation("i;octet");
        }
        return tm;
    }

    private FilterBase entityFilter(String val) throws ParseFailed {
        try {
            return EntityTypeFilter.makeEntityTypeFilter(null, (String)val, (boolean)false);
        }
        catch (Throwable t) {
            throw this.parseResult.setCfe(new CalFacadeException(t));
        }
    }

    private FilterBase viewFilter(String val) throws ParseFailed {
        BwView view = this.callGetView(val);
        if (view == null) {
            throw this.parseResult.fail("Unknown view: " + val + " source: " + this.source);
        }
        FilterBase filter = view.getFilter();
        if (filter != null) {
            return filter;
        }
        for (String vpath : view.getCollectionPaths()) {
            FilterBase vpf = this.resolveVpath(vpath);
            filter = this.or(filter, vpf);
        }
        BwViewFilter vf = new BwViewFilter(null);
        vf.setEntity(view);
        vf.setFilter(filter);
        view.setFilter(filter);
        return vf;
    }

    private FilterBase or(FilterBase of, FilterBase f) {
        if (of == null) {
            return f;
        }
        if (of instanceof OrFilter) {
            of.addChild(f);
            return of;
        }
        OrFilter nof = new OrFilter();
        nof.addChild(of);
        nof.addChild(f);
        return nof;
    }

    private FilterBase and(String name, FilterBase af, FilterBase f) {
        FilterBase res;
        if (af == null) {
            res = f;
        } else {
            if (af instanceof AndFilter) {
                res = af;
            } else {
                res = new AndFilter();
                res.addChild(af);
            }
            res.addChild(f);
        }
        if (name != null) {
            res.setName(name);
        }
        return res;
    }

    private FilterBase resolveVpath(String vpath) throws ParseFailed {
        Collection<BwCalendar> cols = this.callDecomposeVirtualPath(vpath);
        if (cols == null) {
            throw this.parseResult.fail("Bad virtual path: " + vpath);
        }
        FilterBase vfilter = null;
        BwCalendar vpathTarget = null;
        for (BwCalendar col : cols) {
            if (this.debug()) {
                this.debug("      vpath collection:" + col.getPath());
            }
            if (col.getFilterExpr() != null) {
                if (this.subParser == null) {
                    this.subParser = this.callGetParser();
                }
                ParseResult pr = this.subParser.parse(col.getFilterExpr(), false, col.getPath());
                if (!pr.ok) {
                    throw this.parseResult.fromPr(pr);
                }
                if (pr.filter != null) {
                    vfilter = this.and(null, vfilter, pr.filter);
                }
            }
            if (!col.getCollectionInfo().onlyCalEntities && col.getCalType() != 0) continue;
            vpathTarget = col;
        }
        if (vpathTarget == null) {
            throw this.parseResult.fail("Bad vpath - no calendar collection vpath: " + vpath + " source: " + this.source);
        }
        String name = vpathTarget.getAliasOrigin() != null ? vpathTarget.getAliasOrigin().getPath() : vpathTarget.getPath();
        return this.and(name, vfilter, this.resolveColPath(vpathTarget.getPath(), false, false));
    }

    private FilterBase resolveColPath(String path, boolean applyFilter, boolean explicitSelection) throws ParseFailed {
        try {
            return new FilterBuilder(this).buildFilter(path, applyFilter, explicitSelection);
        }
        catch (Throwable t) {
            throw this.parseResult.setCfe(new CalFacadeException(t));
        }
    }

    private TimeRange getTimeRange() throws ParseFailed {
        this.assertString();
        String startStr = this.tokenizer.sval;
        this.assertToken("to");
        this.assertString();
        return this.makeTimeRange(startStr, this.tokenizer.sval);
    }

    private TimeRange makeTimeRange(String startStr, String endStr) throws ParseFailed {
        try {
            DateTime start = null;
            DateTime end = null;
            if (startStr != null) {
                start = new DateTime(startStr);
            }
            if (endStr != null) {
                end = new DateTime(endStr);
            }
            return new TimeRange(start, end);
        }
        catch (Throwable t) {
            throw this.parseResult.setCfe(new CalFacadeException(t));
        }
    }

    private Operator nextOperator() throws ParseFailed {
        int tkn = this.nextToken("nextOperator(1)");
        if (tkn == 91) {
            return new Operator(14);
        }
        if (tkn == 61) {
            return new Operator(2);
        }
        if (tkn == 126) {
            return new Operator(4);
        }
        if (tkn == 33) {
            if (this.testToken(126)) {
                return new Operator(5);
            }
            this.assertToken(61);
            return new Operator(3);
        }
        if (tkn == 62) {
            tkn = this.nextToken("nextOperator(2)");
            if (tkn == 61) {
                return new Operator(8);
            }
            this.tokenizer.pushBack();
            return new Operator(6);
        }
        if (tkn == 60) {
            tkn = this.nextToken("nextOperator(3)");
            if (tkn == 61) {
                return new Operator(9);
            }
            this.tokenizer.pushBack();
            return new Operator(7);
        }
        if (tkn != -3) {
            throw this.parseResult.fail("Bad operator: " + this.tokenizer.sval + " source: " + this.source);
        }
        if (this.tokenizer.sval.equals("in")) {
            return new Operator(10);
        }
        if (this.tokenizer.sval.equals("startsWith")) {
            return new Operator(13);
        }
        if (this.tokenizer.sval.equals("isdefined")) {
            return new Operator(0);
        }
        if (this.tokenizer.sval.equals("notdefined")) {
            return new Operator(1);
        }
        throw this.parseResult.fail("Bad operator: " + this.tokenizer.sval + " source: " + this.source);
    }

    private boolean topLOp() {
        if (this.stackEmpty()) {
            return false;
        }
        return this.stack.peek() instanceof LogicalOperator;
    }

    private boolean anding() {
        if (this.stackEmpty() || !this.topLOp()) {
            return true;
        }
        return ((LogicalOperator)this.stack.peek()).op == 11;
    }

    private LogicalOperator popLOp() {
        return (LogicalOperator)this.stack.pop();
    }

    private void assertNotEmpty() throws ParseFailed {
        if (this.stack.empty()) {
            throw this.parseResult.fail("Filter Syntax:  source: " + this.source);
        }
    }

    private boolean stackEmpty() {
        return this.stack.empty();
    }

    private void push(Token val) {
        this.stack.push(val);
    }

    private Token pop() throws ParseFailed {
        this.assertNotEmpty();
        return this.stack.pop();
    }

    private void assertFiltersNotEmpty() throws ParseFailed {
        if (this.filterStack.empty()) {
            throw this.parseResult.fail("FilterSyntax:  source: " + this.source);
        }
    }

    private FilterBase popFilters() throws ParseFailed {
        this.assertFiltersNotEmpty();
        return this.filterStack.pop();
    }

    private void showStack(String tr) {
        this.debug("nextToken(" + tr + "): Parse stack======");
        for (int i = 0; i < this.stack.size(); ++i) {
            this.debug(((Token)this.stack.elementAt(i)).toString());
        }
    }

    private int nextToken(String tr) throws ParseFailed {
        try {
            int tkn = this.tokenizer.next();
            if (!this.debug()) {
                return tkn;
            }
            this.showStack(tr);
            if (tkn == -3) {
                this.debug("nextToken(" + tr + ") = word: " + this.tokenizer.sval);
            } else if (tkn == 39) {
                this.debug("nextToken(" + tr + ") = '" + this.tokenizer.sval + "'");
            } else if (tkn > 0) {
                this.debug("nextToken(" + tr + ") = " + (char)tkn);
            } else {
                this.debug("nextToken(" + tr + ") = " + tkn);
            }
            return tkn;
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private void assertString() throws ParseFailed {
        try {
            this.tokenizer.assertString();
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private void assertToken(String val) throws ParseFailed {
        try {
            this.tokenizer.assertToken(val);
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private void assertToken(int val) throws ParseFailed {
        try {
            this.tokenizer.assertToken(val);
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private boolean testToken(String val) throws ParseFailed {
        try {
            return this.tokenizer.testToken(val);
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private boolean testToken(int val) throws ParseFailed {
        try {
            return this.tokenizer.testToken(val);
        }
        catch (CalFacadeException cfe) {
            this.parseResult.setCfe(cfe);
            return false;
        }
    }

    private BwCategory callGetCategoryByName(String name) throws ParseFailed {
        try {
            return this.getCategoryByName(name);
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private GetEntityResponse<BwCategory> callGetCategory(String uid) {
        return this.getCategoryByUid(uid);
    }

    private BwView callGetView(String path) throws ParseFailed {
        try {
            return this.getView(path);
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private Collection<BwCalendar> callDecomposeVirtualPath(String vpath) throws ParseFailed {
        try {
            return this.decomposeVirtualPath(vpath);
        }
        catch (CalFacadeException cfe) {
            throw this.parseResult.setCfe(cfe);
        }
    }

    private SimpleFilterParser callGetParser() {
        return this.getParser();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class ParseResult {
        public boolean ok = true;
        public String message;
        public FilterBase filter;
        public CalFacadeException cfe;
        public List<SortTerm> sortTerms;

        public void SetFilter(FilterBase filter) {
            this.filter = filter;
        }

        public ParseFailed fail(String message) throws ParseFailed {
            this.ok = false;
            this.message = message;
            throw new ParseFailed();
        }

        public ParseFailed setCfe(CalFacadeException cfe) throws ParseFailed {
            this.ok = false;
            this.message = cfe.getMessage();
            this.cfe = cfe;
            throw new ParseFailed();
        }

        public ParseFailed fromPr(ParseResult pr) throws ParseFailed {
            this.ok = false;
            this.message = pr.message;
            this.cfe = pr.cfe;
            throw new ParseFailed();
        }

        public String toString() {
            ToString ts = new ToString((Object)this);
            ts.append("ok", this.ok);
            if (this.ok) {
                ts.append("filter", (Object)this.filter);
            } else {
                ts.append("errcode", (Object)this.cfe.getMessage());
            }
            return ts.toString();
        }
    }

    private static class Token {
        private Token() {
        }
    }

    private static class ParseFailed
    extends Exception {
        private ParseFailed() {
        }
    }

    private static class LogicalOperator
    extends Operator {
        LogicalOperator(int op) {
            super(op);
        }
    }

    private static class PropertyInfo {
        final PropertyIndex.PropertyInfoIndex pii;
        final Integer intKey;
        final String strKey;

        private PropertyInfo(PropertyIndex.PropertyInfoIndex pii, Integer intKey, String strKey) {
            this.pii = pii;
            this.intKey = intKey;
            this.strKey = strKey;
        }
    }

    private static class Operator
    extends Token {
        int op;

        Operator(int op) {
            this.op = op;
        }

        public String toString() {
            return "Operator{op=" + this.op + "}";
        }
    }

    private static class MatchType
    extends TextMatchType {
        protected boolean prefix;

        private MatchType() {
        }

        public boolean getPrefixMatch() {
            return this.prefix;
        }

        public void setPrefixMatch(boolean val) {
            this.prefix = val;
        }
    }

    private static class OpenParenthesis
    extends Token {
        private OpenParenthesis() {
        }

        public String toString() {
            return "OpenParenthesis{}";
        }
    }
}

