/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import java.io.Serializable;
import org.bedework.access.Access;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.PrivilegeSet;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.util.misc.Util;

public abstract class PrincipalInfo
implements Access.AccessCb,
Serializable {
    protected boolean superUser;
    protected boolean subscriptionsOnly;
    protected BwPrincipal principal;
    protected String calendarHomePath;
    protected BwPrincipal authPrincipal;
    protected PrivilegeSet maxAllowedPrivs;

    public PrincipalInfo(BwPrincipal principal, BwPrincipal authPrincipal, PrivilegeSet maxAllowedPrivs, boolean subscriptionsOnly) {
        this.principal = principal;
        this.authPrincipal = authPrincipal;
        this.maxAllowedPrivs = maxAllowedPrivs;
        this.subscriptionsOnly = subscriptionsOnly;
    }

    public PrivilegeSet getMaximumAllowedPrivs() {
        return this.maxAllowedPrivs;
    }

    public abstract AccessPrincipal getPrincipal(String var1) throws CalFacadeException;

    public String getCalendarHomePath() {
        if (this.calendarHomePath == null) {
            this.calendarHomePath = this.getCalendarHomePath(this.getPrincipal());
        }
        return this.calendarHomePath;
    }

    public String getCalendarHomePath(AccessPrincipal pr) {
        if (pr.getKind() == 1) {
            return Util.buildPath((boolean)false, (String[])new String[]{BasicSystemProperties.userCalendarRootPath, "/", pr.getAccount()});
        }
        return Util.buildPath((boolean)false, (String[])new String[]{BasicSystemProperties.userCalendarRootPath, "/", pr.getPrincipalRef()});
    }

    public boolean getSuperUser() {
        return this.superUser;
    }

    public boolean getSubscriptionsOnly() {
        return this.subscriptionsOnly;
    }

    public BwPrincipal getPrincipal() {
        return this.principal;
    }

    public BwPrincipal getAuthPrincipal() {
        return this.authPrincipal;
    }
}

