/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

@Dump(elementName="autoSchedule", keyFields={"timestamp", "sequence"})
public class ScheduleMessage
extends BwDbentity<ScheduleMessage> {
    private String timestamp;
    private int sequence;
    private String lastProcessed;
    private boolean inBox;
    private String principalHref;
    private String eventName;
    private String rid;

    public ScheduleMessage() {
        this.updateTimestamp();
    }

    public ScheduleMessage(boolean inBox, String principalHref, String eventName, String rid) {
        this.inBox = inBox;
        this.principalHref = principalHref;
        this.eventName = eventName;
        this.rid = rid;
        this.updateTimestamp();
        this.setLastProcessed(this.getTimestamp());
    }

    public void setTimestamp(String val) {
        this.timestamp = val;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setLastProcessed(String val) {
        this.lastProcessed = val;
    }

    public String getLastProcessed() {
        return this.lastProcessed;
    }

    public void setInBox(boolean val) {
        this.inBox = val;
    }

    public boolean getInBox() {
        return this.inBox;
    }

    public void setPrincipalHref(String val) {
        this.principalHref = val;
    }

    public String getPrincipalHref() {
        return this.principalHref;
    }

    public void setEventName(String val) {
        this.eventName = val;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setRid(String val) {
        this.rid = val;
    }

    public String getRid() {
        return this.rid;
    }

    public void updateTimestamp() {
        this.setTimestamp(Util.icalUTCTimestamp());
        this.setSequence(this.getSequence() + 1);
    }

    @Override
    public int compareTo(ScheduleMessage that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int res = this.getTimestamp().compareTo(that.getTimestamp());
        if (res != 0) {
            return res;
        }
        return Integer.compare(this.getSequence(), that.getSequence());
    }

    @Override
    public int hashCode() {
        return this.getTimestamp().hashCode() + this.getSequence();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.newLine();
        ts.append("timestamp", (Object)this.getTimestamp());
        ts.append("sequence", this.getSequence());
        ts.append("lastProcessed", (Object)this.getLastProcessed());
        ts.newLine();
        ts.append("inBox", this.getInBox());
        ts.append("principalHref", (Object)this.getPrincipalHref());
        ts.append("eventName", (Object)this.getEventName());
        ts.append("rid", (Object)this.getRid());
        return ts.toString();
    }
}

