/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.bedework.access.Access;

public class BwStats
implements Serializable {
    protected CacheStats collectionCacheStats = new CacheStats("Collections");
    protected int tzFetches;
    protected int systemTzFetches;
    protected int tzStores;
    protected double eventFetchTime;
    protected long eventFetches;
    protected CacheStats dateCacheStats = new CacheStats("UTC Dates");
    protected Collection<Access.AccessStatsEntry> accessStats;
    private static final String padder = "                                                                                ";
    private static final int padderLen = "                                                                                ".length();
    private static final int maxvalpad = 10;

    public CacheStats getCollectionCacheStats() {
        return this.collectionCacheStats;
    }

    public int getTzFetches() {
        return this.tzFetches;
    }

    public void incTzFetches() {
        ++this.tzFetches;
    }

    public int getSystemTzFetches() {
        return this.systemTzFetches;
    }

    public void incSystemTzFetches() {
        ++this.systemTzFetches;
    }

    public int getTzStores() {
        return this.tzStores;
    }

    public void incTzStores() {
        ++this.tzStores;
    }

    public double getEventFetchTime() {
        return this.eventFetchTime;
    }

    public void incEventFetchTime(double val) {
        this.eventFetchTime += val;
    }

    public long getEventFetches() {
        return this.eventFetches;
    }

    public void incEventFetches(long val) {
        this.eventFetches += val;
    }

    public CacheStats getDateCacheStats() {
        return this.dateCacheStats;
    }

    public void setAccessStats(Collection<Access.AccessStatsEntry> val) {
        this.accessStats = val;
    }

    public Collection<Access.AccessStatsEntry> getAccessStats() {
        return this.accessStats;
    }

    public Collection<StatsEntry> getStats() {
        ArrayList<StatsEntry> al = new ArrayList<StatsEntry>();
        al.add(new StatsEntry("Bedework statistics."));
        this.cacheStatsToString(al, this.collectionCacheStats);
        al.add(new StatsEntry("tzFetches", this.getTzFetches()));
        al.add(new StatsEntry("systemTzFetches", this.getSystemTzFetches()));
        al.add(new StatsEntry("tzStores", this.getTzStores()));
        al.add(new StatsEntry("event fetch time", this.getEventFetchTime()));
        al.add(new StatsEntry("event fetches", this.getEventFetches()));
        this.cacheStatsToString(al, this.dateCacheStats);
        if (this.getAccessStats() != null) {
            al.add(new StatsEntry("Access statistics."));
            for (Access.AccessStatsEntry ase : this.getAccessStats()) {
                al.add(new StatsEntry(ase.name, ase.count));
            }
        }
        return al;
    }

    public void cacheStatsToString(ArrayList<StatsEntry> al, CacheStats cs) {
        String name = cs.getName() + " ";
        al.add(new StatsEntry(name + "cached", cs.getCached()));
        al.add(new StatsEntry(name + " hits", cs.getHits()));
        al.add(new StatsEntry(name + " misses", cs.getMisses()));
        al.add(new StatsEntry(name + " flushes", cs.getFlushes()));
        al.add(new StatsEntry(name + " refetches", cs.getRefetches()));
    }

    public static String toString(Collection<StatsEntry> c) {
        StringBuilder sb = new StringBuilder();
        for (StatsEntry se : c) {
            int k = se.getStatKind();
            if (k == 0) {
                BwStats.header(sb, se.getStatLabel());
                continue;
            }
            BwStats.format(sb, se.getStatLabel(), se.getStatVal());
        }
        return sb.toString();
    }

    public String toString() {
        return BwStats.toString(this.getStats());
    }

    private static void pad(StringBuilder sb, String val, int padlen) {
        int len = padlen - val.length();
        if (len > 0) {
            sb.append(padder, 0, len);
        }
        sb.append(val);
    }

    private static void header(StringBuilder sb, String h) {
        sb.append("\n");
        BwStats.pad(sb, h, padderLen);
        sb.append("\n");
    }

    private static void format(StringBuilder sb, String name, String val) {
        BwStats.pad(sb, name, padderLen);
        sb.append(": ");
        BwStats.pad(sb, val, 10);
        sb.append("\n");
    }

    public static class CacheStats {
        protected String name;
        protected long cached;
        protected long hits;
        protected long misses;
        protected long flushes;
        protected long refetches;

        CacheStats(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setCached(long val) {
            this.cached = val;
        }

        public long getCached() {
            return this.cached;
        }

        public void incCached() {
            ++this.cached;
        }

        public void setHits(long val) {
            this.hits = val;
        }

        public long getHits() {
            return this.hits;
        }

        public void incHits() {
            ++this.hits;
        }

        public void setMisses(long val) {
            this.misses = val;
        }

        public long getMisses() {
            return this.misses;
        }

        public void incMisses() {
            ++this.misses;
        }

        public void setFlushes(long val) {
            this.flushes = val;
        }

        public long getFlushes() {
            return this.flushes;
        }

        public void incFlushes() {
            ++this.flushes;
        }

        public void setRefetches(long val) {
            this.refetches = val;
        }

        public long getRefetches() {
            return this.refetches;
        }

        public void incRefetches() {
            ++this.refetches;
        }
    }

    public static class StatsEntry {
        public static final int statKindHeader = 0;
        public static final int statKindStat = 1;
        private final int statKind;
        private final String statLabel;
        public static final int statTypeString = 0;
        public static final int statTypeInt = 1;
        public static final int statTypeLong = 2;
        public static final int statTypeDouble = 3;
        private int statType;
        private String statVal;

        public StatsEntry(String label, int val) {
            this.statKind = 1;
            this.statLabel = label;
            this.statType = 1;
            this.statVal = String.valueOf(val);
        }

        public StatsEntry(String label, long val) {
            this.statKind = 1;
            this.statLabel = label;
            this.statType = 2;
            this.statVal = String.valueOf(val);
        }

        public StatsEntry(String label, double val) {
            this.statKind = 1;
            this.statLabel = label;
            this.statType = 3;
            this.statVal = String.valueOf(val);
        }

        public StatsEntry(String label, String val) {
            this.statKind = 1;
            this.statLabel = label;
            this.statType = 0;
            this.statVal = val;
        }

        public StatsEntry(String header) {
            this.statKind = 0;
            this.statLabel = header;
        }

        public int getStatKind() {
            return this.statKind;
        }

        public String getStatLabel() {
            return this.statLabel;
        }

        public int getStatType() {
            return this.statType;
        }

        public String getStatVal() {
            return this.statVal;
        }
    }
}

