/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.Vote;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.PollItemId;
import net.fortuna.ical4j.model.property.Response;
import org.bedework.calfacade.BwParticipant;
import org.bedework.calfacade.base.Differable;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class BwVote
implements Comparable<BwVote>,
Differable<BwVote> {
    private final BwParticipant parent;
    private String stringRepresentation;
    private Vote vote;

    public BwVote(BwParticipant parent, Vote vote) {
        this.parent = parent;
        this.vote = vote;
    }

    public void setPollItemId(int val) {
        PropertyList props = this.getVote().getProperties();
        PollItemId p = (PollItemId)props.getProperty("POLL-ITEM-ID");
        String sval = String.valueOf(val);
        ChangeTable ctab = this.parent.getParent().getParent().getChangeset();
        if (ctab != null) {
            ctab.getEntry(PropertyIndex.PropertyInfoIndex.VOTE).addChangedValue(this);
        }
        if (p == null) {
            props.add((Property)new PollItemId(val));
        } else if (!sval.equals(p.getValue())) {
            p.setValue(sval);
        }
        this.parent.changed();
    }

    public int getPollItemId() {
        PollItemId p = (PollItemId)this.getVote().getProperties().getProperty("POLL-ITEM-ID");
        if (p == null) {
            return -1;
        }
        return p.getPollitemid();
    }

    public void setResponse(int val) {
        PropertyList props = this.getVote().getProperties();
        Response p = (Response)props.getProperty("RESPONSE");
        ChangeTable ctab = this.parent.getParent().getParent().getChangeset();
        if (ctab != null) {
            ctab.getEntry(PropertyIndex.PropertyInfoIndex.VOTE).addChangedValue(this);
        }
        if (p == null) {
            props.add((Property)new Response(val));
        } else if (val != p.getResponse()) {
            p.setValue(String.valueOf(val));
        }
        this.parent.changed();
    }

    public int getResponse() {
        Response p = (Response)this.getVote().getProperties().getProperty("RESPONSE");
        if (p == null) {
            return -1;
        }
        return p.getResponse();
    }

    public void setComment(String val) {
        PropertyList props = this.getVote().getProperties();
        Comment p = (Comment)props.getProperty("COMMENT");
        ChangeTable ctab = this.parent.getParent().getParent().getChangeset();
        if (ctab != null) {
            ctab.getEntry(PropertyIndex.PropertyInfoIndex.COMMENT).addChangedValue(this);
        }
        if (p == null) {
            props.add((Property)new Comment(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
        }
        this.parent.changed();
    }

    public String getComment() {
        Comment p = (Comment)this.getVote().getProperties().getProperty("COMMENT");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public Vote getVote() {
        if (this.vote == null) {
            this.vote = new Vote();
        }
        return this.vote;
    }

    public int hashCode() {
        return 19 + 17 * (this.getPollItemId() + 3) * (this.getResponse() + 3);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BwVote)) {
            return false;
        }
        BwVote vot = (BwVote)obj;
        return this.compareTo(vot) == 0;
    }

    @Override
    public int compareTo(BwVote that) {
        if (this == that) {
            return 0;
        }
        int res = Util.cmpIntval((int)this.getPollItemId(), (int)that.getPollItemId());
        if (res != 0) {
            return res;
        }
        return Util.cmpIntval((int)this.getResponse(), (int)that.getResponse());
    }

    @Override
    public boolean differsFrom(BwVote that) {
        return Util.cmpIntval((int)this.getPollItemId(), (int)that.getPollItemId()) != 0 || Util.cmpIntval((int)this.getResponse(), (int)that.getResponse()) != 0;
    }

    public String asString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.vote.toString();
        }
        return this.stringRepresentation;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        return ts.newLine().append(this.asString()).toString();
    }
}

