/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.base.BwCloneable;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class BwXproperty
extends BwDbentity<BwXproperty>
implements BwCloneable {
    public static final String bedeworkOrganizerSchedulingObject = "X-BEDEWORK-ORGSCHEDOBJ";
    public static final String bedeworkAttendeeSchedulingObject = "X-BEDEWORK-ATTSCHEDOBJ";
    public static final String bedeworkSubmitComment = "X-BEDEWORK-SUBMIT-COMMENT";
    public static final String bedeworkSubmitStatus = "X-BEDEWORK-SUBMIT-STATUS";
    public static final String bedeworkSubmitAlias = "X-BEDEWORK-SUBMIT-ALIAS";
    public static final String bedeworkSubmitterEmail = "X-BEDEWORK-SUBMITTER-EMAIL";
    public static final String bedeworkSubmitterClaimant = "X-BEDEWORK-SUBMISSION-CLAIMANT";
    public static final String bedeworkAlias = "X-BEDEWORK-ALIAS";
    public static final String bedeworkDisplayName = "X-BEDEWORK-PARAM-DISPLAYNAME";
    public static final String bedeworkParamPath = "X-BEDEWORK-PARAM-PATH";
    public static final String bedeworkParamAliasPath = "X-BEDEWORK-PARAM-ALIASPATH";
    public static final String bedeworkSchedulingEntityPath = "X-BEDEWORK-SCHED-PATH";
    public static final String bedeworkSchedulingNew = "X-BEDEWORK-SCHED-NEW";
    public static final String bedeworkSchedulingReschedule = "X-BEDEWORK-SCHED-RESCHED";
    public static final String bedeworkSchedulingReplyUpdate = "X-BEDEWORK-SCHED-REPLY-UPDATE";
    public static final String bedeworkDavProp = "X-BEDEWORK-DAV-PROP";
    public static final String bedeworkIcal = "X-BEDEWORK-ICAL";
    public static final String bedeworkIcalProp = "X-BEDEWORK-ICAL-PROP";
    public static final String bedeworkIcalPropPname = "PNAME";
    public static final String xparUid = "X-BEDEWORK-UID";
    public static final String bedeworkCost = "X-BEDEWORK-COST";
    public static final String bedeworkDeleted = "X-BEDEWORK-DELETED";
    public static final String bedeworkRelatedTo = "X-BEDEWORK-RELATED-TO";
    public static final String bedeworkParticipant = "X-BEDEWORK-PARTICIPANT";
    public static final String bedeworkExsynchEndtzid = "X-BEDEWORK-EXSYNCH-ENDTZID";
    public static final String bedeworkExsynchLastmod = "X-BEDEWORK-EXSYNCH-LASTMOD";
    public static final String bedeworkExsynchOrganizer = "X-BEDEWORK-EXSYNCH-ORGANIZER";
    public static final String bedeworkExsynchStarttzid = "X-BEDEWORK-EXSYNCH-STARTTZID";
    public static final String bedeworkSuggestedTo = "X-BEDEWORK-SUGGESTED-TO";
    public static final String bedeworkEventRegMaxTickets = "X-BEDEWORK-MAX-TICKETS";
    public static final String bedeworkEventRegMaxTicketsPerUser = "X-BEDEWORK-MAX-TICKETS-PER-USER";
    public static final String bedeworkEventRegStart = "X-BEDEWORK-REGISTRATION-START";
    public static final String bedeworkEventRegEnd = "X-BEDEWORK-REGISTRATION-END";
    public static final String bedeworkEventRegForm = "X-BEDEWORK-REGISTRATION-FORM";
    public static final String bedeworkEventRegWaitListLimit = "X-BEDEWORK-WAIT-LIST-LIMIT";
    public static final String bedeworkEventRegInternal = "X-BEDEWORK-REGISTRATION-INTERNAL";
    public static final String bedeworkEventRegExternal = "X-BEDEWORK-REGISTRATION-EXTERNAL";
    public static final String bedeworkPublishUrl = "X-BEDEWORK-PUBLISH-URL";
    public static final String peruserPropTransp = "X-PERUSER-PROP-TRANSP";
    public static final String peruserOwnerParam = "X-PERUSER-OWNER";
    public static final String peruserInstance = "X-PERUSER-INSTANCE";
    public static final String estimatedDuration = "X-BW-ESTIMATED-DURATION";
    public static final String pollItemId = "X-BW-POLL-ITEMID";
    public static final String pollWinner = "X-BW-POLL-WINNER";
    public static final String pollAccceptResponse = "X-BW-POLL-ACCEPT_RESPONSE";
    public static final String pollMode = "X-BW-POLL-MODE";
    public static final String pollCompletion = "X-BW-POLL-COMPLETION";
    public static final String pollProperties = "X-BW-POLL-PROPERTIES";
    public static final String pollItem = "X-BW-POLL-ITEM";
    public static final String pollCandidate = "X-BW-POLL-CANDIDATE";
    public static final String xBedeworkCategories = "X-BEDEWORK-CATEGORIES";
    public static final String xBedeworkLocation = "X-BEDEWORK-LOCATION";
    public static final String xBedeworkLocationKeyName = "x-bedework-loc-key";
    public static final String xBedeworkContact = "X-BEDEWORK-CONTACT";
    public static final String xBedeworkVLocation = "X-BEDEWORK-VLOCATION";
    public static final String xBedeworkLocationAddr = "X-BEDEWORK-LOCATION-ADDR";
    public static final String xBedeworkLocationRoom = "X-BEDEWORK-LOCATION-ROOM";
    public static final String xBedeworkLocationAccessible = "X-BEDEWORK-LOCATION-ACCESSIBLE";
    public static final String xBedeworkLocationSfield1 = "X-BEDEWORK-LOCATION-SFIELD1";
    public static final String xBedeworkLocationSfield2 = "X-BEDEWORK-LOCATION-SFIELD2";
    public static final String xBedeworkLocationGeo = "X-BEDEWORK-LOCATION-GEO";
    public static final String xBedeworkLocationStreet = "X-BEDEWORK-LOCATION-STREET";
    public static final String xBedeworkLocationCity = "X-BEDEWORK-LOCATION-CITY";
    public static final String xBedeworkLocationState = "X-BEDEWORK-LOCATION-STATE";
    public static final String xBedeworkLocationZip = "X-BEDEWORK-LOCATION-ZIP";
    public static final String xBedeworkLocationLink = "X-BEDEWORK-LOCATION-LINK";
    public static final String bedeworkTag = "X-BEDEWORK-TAG";
    public static final String bedeworkCalsuite = "X-BEDEWORK-CALSUITE";
    public static final String bedeworkSchedAssist = "X-BEDEWORK-SCHED-ASSIST";
    public static final String bedeworkImage = "X-BEDEWORK-IMAGE";
    public static final String bedeworkThumbImage = "X-BEDEWORK-THUMB-IMAGE";
    public static final String bedeworkXTimezone = "X-BEDEWORK-TZ";
    @Deprecated
    public static final String bedeworkTimezonePrefix = "X-BEDEWORK-TZ-";
    public static final String bedeworkChanges = "X-BEDEWORK-CHANGES";
    public static final String appleNeedsReply = "X-APPLE-NEEDS-REPLY";
    public static final String appleDefaultAlarm = "X-APPLE-DEFAULT-ALARM";
    private static final Set<String> xskipJsp = new TreeSet<String>();
    private static final Set<String> xskip;
    private static final Map<String, XpropInfo> xinfo;
    private static final Map<String, String> jsToBw;
    private String name;
    private String pars;
    private String value;
    private List<Xpar> parameters;

    private static void addXpinfo(String xName, String jscalName, boolean simpleVal) {
        String lcn = xName.toLowerCase();
        xinfo.put(lcn, new XpropInfo(lcn, jscalName, simpleVal));
        jsToBw.put(jscalName, xName);
    }

    public static XpropInfo getXpropInfo(String name) {
        return xinfo.get(name.toLowerCase());
    }

    public static String getBwFromJsCal(String jscalName) {
        return jsToBw.get(jscalName);
    }

    public BwXproperty() {
    }

    public BwXproperty(String name, String pars, String value) {
        this.name = name;
        if (pars != null && pars.length() > 0) {
            this.pars = pars;
        }
        this.value = value;
    }

    public static BwXproperty makeIcalProperty(String name, String pars, String value) {
        StringBuilder sb = new StringBuilder(bedeworkIcalPropPname);
        sb.append("=");
        sb.append(name);
        if (pars != null && pars.length() > 0) {
            sb.append(";");
            sb.append(pars);
        }
        return new BwXproperty(bedeworkIcalProp, sb.toString(), value);
    }

    public static BwXproperty makeBwAlias(String displayName, String aliasUri, String aliasPath, String topicalAreaPath) {
        StringBuilder sb = new StringBuilder(bedeworkDisplayName).append("=").append(displayName).append(";").append(bedeworkParamPath).append("=").append(aliasUri).append(";").append(bedeworkParamAliasPath).append("=").append(aliasPath);
        return new BwXproperty(bedeworkAlias, sb.toString(), topicalAreaPath);
    }

    public static BwXproperty makeDavProperty(String name, String value) {
        return new BwXproperty(bedeworkDavProp, "PNAMEPNAME=" + name, value);
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.NAME, jname="name")
    public void setName(String val) {
        if (val == null) {
            throw new RuntimeException("Name cannot be null");
        }
        this.name = val;
        this.parameters = null;
    }

    public String getName() {
        return this.name;
    }

    public void setPars(String val) {
        this.pars = val != null && val.length() > 0 ? val : null;
        this.parameters = null;
    }

    public String getPars() {
        return this.pars;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.VALUE, jname="value")
    public void setValue(String val) {
        this.value = val;
        this.parameters = null;
    }

    public String getValue() {
        return this.value;
    }

    @NoDump
    public List<Xpar> getParameters() {
        if (this.getPars() == null) {
            return null;
        }
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = BwXproperty.parseParameters(this.getPars());
        return this.parameters;
    }

    @NoDump
    public String getParam(String name) {
        List<Xpar> params = this.getParameters();
        if (params == null) {
            return null;
        }
        for (Xpar param : params) {
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    public static List<Xpar> parseParameters(String val) {
        int WORD_CHAR_START = 32;
        int WORD_CHAR_END = 255;
        boolean WHITESPACE_CHAR_START = false;
        int WHITESPACE_CHAR_END = 20;
        if (val == null || ((String)val).length() == 0) {
            return null;
        }
        if (!((String)val).startsWith(";")) {
            val = ";" + (String)val;
        }
        StreamTokenizer tokeniser = new StreamTokenizer(new StringReader((String)val));
        ArrayList<Xpar> pars = new ArrayList<Xpar>();
        try {
            tokeniser.resetSyntax();
            tokeniser.wordChars(32, 255);
            tokeniser.whitespaceChars(0, 20);
            tokeniser.ordinaryChar(58);
            tokeniser.ordinaryChar(59);
            tokeniser.ordinaryChar(61);
            tokeniser.ordinaryChar(9);
            tokeniser.eolIsSignificant(true);
            tokeniser.whitespaceChars(0, 0);
            tokeniser.quoteChar(34);
            while (tokeniser.nextToken() == 59) {
                BwXproperty.parseParameter(tokeniser, pars);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return pars;
    }

    public static String escapeName(String val) {
        if (!val.contains(" ")) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (pos < val.length()) {
            int nextPos = val.indexOf(" ", pos);
            if (nextPos < 0) {
                sb.append(val.substring(pos));
                break;
            }
            sb.append(val, pos, nextPos);
            sb.append("_");
            pos = nextPos + 1;
        }
        return sb.toString();
    }

    public static String escapeSemi(String val) {
        if (!val.contains(";")) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (pos < val.length()) {
            int nextPos = val.indexOf(";", pos);
            if (nextPos < 0) {
                sb.append(val.substring(pos));
                break;
            }
            sb.append(val, pos, nextPos);
            sb.append("\\;");
            pos = nextPos + 1;
        }
        return sb.toString();
    }

    public static String unescapeSemi(String val) {
        if (!val.contains("\\;")) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (pos < val.length()) {
            int nextPos = val.indexOf("\\;", pos);
            if (nextPos < 0) {
                sb.append(val.substring(pos));
                break;
            }
            sb.append(val, pos, nextPos);
            sb.append(";");
            pos = nextPos + 2;
        }
        return sb.toString();
    }

    public static int nextSemi(String val, int start) {
        while (start < val.length()) {
            int escPos = val.indexOf("\\;", start);
            int sPos = val.indexOf(";", start);
            if (sPos < 0) {
                return -1;
            }
            if (escPos < 0) {
                return sPos;
            }
            if (escPos == sPos - 1) {
                start = sPos + 1;
                continue;
            }
            return sPos;
        }
        return -1;
    }

    @Override
    public int compareTo(BwXproperty that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int res = CalFacadeUtil.cmpObjval(this.getName(), that.getName());
        if (res != 0) {
            return res;
        }
        res = CalFacadeUtil.cmpObjval(this.getPars(), that.getPars());
        if (res != 0) {
            return res;
        }
        return CalFacadeUtil.cmpObjval(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        int hc = this.getName().hashCode();
        if (this.getPars() != null) {
            hc *= this.getPars().hashCode();
        }
        if (this.getValue() != null) {
            hc *= this.getValue().hashCode();
        }
        return hc;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("name", (Object)this.getName()).append("pars", (Object)this.getPars()).append("value", (Object)this.getValue());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public Object clone() {
        return new BwXproperty(this.getName(), this.getPars(), this.getValue());
    }

    @NoDump
    public boolean getSkip() {
        return xskip.contains(this.getName());
    }

    @NoDump
    public boolean getSkipJsp() {
        return xskipJsp.contains(this.getName());
    }

    private static void parseParameter(StreamTokenizer tokeniser, List<Xpar> pars) throws CalFacadeException {
        try {
            if (tokeniser.nextToken() != -3) {
                throw new CalFacadeException("org.bedework.exception.badrequest");
            }
            String paramName = tokeniser.sval;
            if (tokeniser.nextToken() != 61) {
                throw new CalFacadeException("org.bedework.exception.badrequest");
            }
            StringBuilder paramValue = new StringBuilder();
            if (tokeniser.nextToken() == 34) {
                paramValue.append(tokeniser.sval);
            } else if (tokeniser.sval != null) {
                paramValue.append(tokeniser.sval);
                int nextToken = tokeniser.nextToken();
                while (nextToken > 0 && nextToken != 59 && nextToken != 58 && nextToken != 44) {
                    if (tokeniser.ttype == -3) {
                        paramValue.append(tokeniser.sval);
                    } else {
                        paramValue.append((char)tokeniser.ttype);
                    }
                    nextToken = tokeniser.nextToken();
                }
                tokeniser.pushBack();
            } else {
                tokeniser.pushBack();
            }
            pars.add(new Xpar(paramName, paramValue.toString()));
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static void main(String[] args) {
        BwXproperty.testEsc("abcdefg", "Some value");
        BwXproperty.testEsc("abcd;efg", "Some value");
        BwXproperty.testEsc("abcdefg;", "Some value");
        BwXproperty.testEsc(";abcdefg", "Some value");
        BwXproperty.testEsc(";abc;de;fg", "Some value");
        BwXproperty.testEsc(";abc;de;fg;", "Some value");
        BwXproperty.testEsc("abcdefg", "Some \\;value");
    }

    private static void testEsc(String val1, String val2) {
        String svVal1 = val1;
        System.out.println("val1 = " + val1);
        System.out.println("val2 = " + val2);
        val1 = BwXproperty.escapeSemi(val1);
        System.out.println("esc val1 = " + val1);
        String val = val1 + ";" + val2;
        int pos = BwXproperty.nextSemi(val, 0);
        System.out.println("Semi at " + pos + " in " + val);
        val1 = pos < 0 ? BwXproperty.unescapeSemi(val) : BwXproperty.unescapeSemi(val.substring(0, pos));
        System.out.println("unesc val1 = " + val1);
        if (!svVal1.equals(val1)) {
            System.out.println("***** Val1 != original");
        }
        System.out.println();
    }

    static {
        xskipJsp.add(bedeworkSuggestedTo);
        xskipJsp.add(bedeworkXTimezone);
        xskipJsp.add(bedeworkChanges);
        xskipJsp.add(bedeworkAttendeeSchedulingObject);
        xskipJsp.add(bedeworkOrganizerSchedulingObject);
        xskipJsp.add(bedeworkIcal);
        xskipJsp.add(bedeworkIcalProp);
        xskipJsp.add(bedeworkDavProp);
        xskipJsp.add(bedeworkParticipant);
        xskipJsp.add(xBedeworkVLocation);
        xskipJsp.add(pollItemId);
        xskipJsp.add(pollAccceptResponse);
        xskipJsp.add(pollMode);
        xskipJsp.add(pollWinner);
        xskipJsp.add(pollProperties);
        xskipJsp.add(pollItem);
        xskipJsp.add(pollCandidate);
        xskipJsp.add(peruserPropTransp);
        xskipJsp.add(peruserInstance);
        xskip = new TreeSet<String>();
        xskip.addAll(xskipJsp);
        xskip.add(bedeworkSchedulingNew);
        xskip.add(bedeworkSchedulingEntityPath);
        xskip.add(bedeworkSchedulingReplyUpdate);
        xskip.add(bedeworkRelatedTo);
        xskip.add(bedeworkParticipant);
        xinfo = new HashMap<String, XpropInfo>();
        jsToBw = new HashMap<String, String>();
        BwXproperty.addXpinfo(bedeworkSubmitComment, "bedework.org/submit-comment", true);
        BwXproperty.addXpinfo(bedeworkSubmitStatus, "bedework.org/submit-status", true);
        BwXproperty.addXpinfo(bedeworkSubmitAlias, "bedework.org/submit-alias", true);
        BwXproperty.addXpinfo(bedeworkSubmitterEmail, "bedework.org/submitter-email", true);
        BwXproperty.addXpinfo(bedeworkSubmitterClaimant, "bedework.org/submission-claimant", true);
        BwXproperty.addXpinfo(bedeworkAlias, "bedework.org/alias", true);
        BwXproperty.addXpinfo(bedeworkDisplayName, "bedework.org/param-displayname", true);
        BwXproperty.addXpinfo(bedeworkSchedulingEntityPath, "bedework.org/sched-path", true);
        BwXproperty.addXpinfo(bedeworkSchedulingNew, "bedework.org/sched-new", true);
        BwXproperty.addXpinfo(bedeworkSchedulingReschedule, "bedework.org/sched-resched", true);
        BwXproperty.addXpinfo(bedeworkSchedulingReplyUpdate, "bedework.org/sched-reply-update", true);
        BwXproperty.addXpinfo(bedeworkDavProp, "bedework.org/dav-prop", true);
        BwXproperty.addXpinfo(bedeworkIcal, "bedework.org/ical", true);
        BwXproperty.addXpinfo(bedeworkIcalProp, "bedework.org/ical-prop", true);
        BwXproperty.addXpinfo(xparUid, "bedework.org/uid", true);
        BwXproperty.addXpinfo(bedeworkCost, "bedework.org/cost", true);
        BwXproperty.addXpinfo(bedeworkDeleted, "bedework.org/deleted", true);
        BwXproperty.addXpinfo(bedeworkRelatedTo, "bedework.org/related-to", true);
        BwXproperty.addXpinfo(bedeworkSuggestedTo, "bedework.org/suggested-to", true);
        BwXproperty.addXpinfo(bedeworkEventRegMaxTickets, "bedework.org/max-tickets", true);
        BwXproperty.addXpinfo(bedeworkEventRegMaxTicketsPerUser, "bedework.org/max-tickets-per-user", true);
        BwXproperty.addXpinfo(bedeworkEventRegStart, "bedework.org/registration-start", true);
        BwXproperty.addXpinfo(bedeworkEventRegEnd, "bedework.org/registration-end", true);
        BwXproperty.addXpinfo(bedeworkEventRegForm, "bedework.org/registration-form", true);
        BwXproperty.addXpinfo(bedeworkEventRegWaitListLimit, "bedework.org/wait-list-limit", true);
        BwXproperty.addXpinfo(bedeworkEventRegInternal, "bedework.org/registration-internal", true);
        BwXproperty.addXpinfo(bedeworkEventRegExternal, "bedework.org/registration-external", true);
        BwXproperty.addXpinfo(bedeworkPublishUrl, "bedework.org/publish-url", true);
        BwXproperty.addXpinfo(xBedeworkCategories, "bedework.org/categories", true);
        BwXproperty.addXpinfo(xBedeworkLocation, "bedework.org/location", true);
        BwXproperty.addXpinfo(xBedeworkContact, "bedework.org/contact", true);
        BwXproperty.addXpinfo(xBedeworkLocationAddr, "bedework.org/location-addr", true);
        BwXproperty.addXpinfo(xBedeworkLocationRoom, "bedework.org/location-room", true);
        BwXproperty.addXpinfo(xBedeworkLocationAccessible, "bedework.org/location-accessible", true);
        BwXproperty.addXpinfo(xBedeworkLocationSfield1, "bedework.org/location-sfield1", true);
        BwXproperty.addXpinfo(xBedeworkLocationSfield2, "bedework.org/location-sfield2", true);
        BwXproperty.addXpinfo(xBedeworkLocationGeo, "bedework.org/location-geo", true);
        BwXproperty.addXpinfo(xBedeworkLocationStreet, "bedework.org/location-street", true);
        BwXproperty.addXpinfo(xBedeworkLocationCity, "bedework.org/location-city", true);
        BwXproperty.addXpinfo(xBedeworkLocationState, "bedework.org/location-state", true);
        BwXproperty.addXpinfo(xBedeworkLocationZip, "bedework.org/location-zip", true);
        BwXproperty.addXpinfo(xBedeworkLocationLink, "bedework.org/location-link", true);
        BwXproperty.addXpinfo(bedeworkTag, "bedework.org/tag", true);
        BwXproperty.addXpinfo(bedeworkCalsuite, "bedework.org/calsuite", true);
        BwXproperty.addXpinfo(bedeworkSchedAssist, "bedework.org/sched-assist", true);
        BwXproperty.addXpinfo(bedeworkImage, "bedework.org/image", true);
        BwXproperty.addXpinfo(bedeworkThumbImage, "bedework.org/thumb-image", true);
    }

    public static class XpropInfo {
        public final String xName;
        public final String jscalName;
        public final boolean simpleType;

        XpropInfo(String xName, String jscalName, boolean simpleType) {
            this.xName = xName;
            this.jscalName = jscalName;
            this.simpleType = simpleType;
        }
    }

    public static class Xpar
    implements Comparable<Xpar>,
    Serializable {
        private final String name;
        private final String value;

        public Xpar(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Xpar o) {
            if (o == null) {
                return 1;
            }
            int cmp = Util.cmpObjval((Comparable)((Object)this.getName()), (Comparable)((Object)o.getName()));
            if (cmp != 0) {
                return cmp;
            }
            return Util.cmpObjval((Comparable)((Object)this.getValue()), (Comparable)((Object)o.getValue()));
        }
    }
}

