/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.TextList;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwParticipant;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.base.Differable;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class Participant
implements Comparable<Participant>,
Differable<Participant> {
    private final SchedulingInfo parent;
    private BwAttendee attendee;
    private BwParticipant bwParticipant;
    private static final Map<String, List<String>> jscalRoles = new HashMap<String, List<String>>();
    private static final Map<String, String> jscalRolesAsString = new HashMap<String, String>();
    private static final List<String> defaultRoles = List.of("attendee");

    Participant(SchedulingInfo parent, BwAttendee attendee, BwParticipant bwParticipant) {
        this.parent = parent;
        this.attendee = attendee;
        this.bwParticipant = bwParticipant;
    }

    public BwAttendee getAttendee() {
        return this.attendee;
    }

    public BwParticipant getBwParticipant() {
        return this.bwParticipant;
    }

    public void setCalendarAddress(String val) {
        if (this.attendee != null) {
            this.attendee.setAttendeeUri(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setCalendarAddress(val);
        }
    }

    public String getCalendarAddress() {
        if (this.attendee != null) {
            return this.attendee.getAttendeeUri();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getCalendarAddress();
        }
        return null;
    }

    public void setName(String val) {
        if (this.attendee != null) {
            this.attendee.setCn(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setName(val);
        }
    }

    public String getName() {
        String val = null;
        if (this.attendee != null) {
            val = this.attendee.getCn();
        }
        if (this.bwParticipant != null && val == null) {
            return this.bwParticipant.getName();
        }
        return val;
    }

    public void setLanguage(String val) {
        if (this.attendee != null) {
            this.attendee.setLanguage(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setLanguage(val);
        }
    }

    public String getLanguage() {
        String val = null;
        if (this.attendee != null) {
            val = this.attendee.getLanguage();
        }
        if (this.bwParticipant != null && val == null) {
            return this.bwParticipant.getLanguage();
        }
        return val;
    }

    public void setKind(String val) {
        if (this.attendee != null) {
            this.attendee.setCuType(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setKind(val);
        }
    }

    public String getKind() {
        if (this.attendee != null) {
            return this.attendee.getCuType();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getKind();
        }
        return null;
    }

    public void setParticipationStatus(String val) {
        if (this.attendee != null) {
            this.attendee.setPartstat(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setParticipationStatus(val);
        }
    }

    public String getParticipationStatus() {
        String s;
        if (this.attendee != null && (s = this.attendee.getPartstat()) != null) {
            return s;
        }
        if (this.bwParticipant != null && (s = this.bwParticipant.getParticipationStatus()) != null) {
            return s;
        }
        return "needs-action";
    }

    public void setParticipantType(String val) {
        if (this.attendee != null) {
            this.attendee.setRole(Participant.iCalRole(val));
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setParticipantType(val);
        }
    }

    public String getParticipantType() {
        if (this.attendee != null) {
            return Participant.jsCalRolesAsString(this.attendee.getRole());
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getParticipantType();
        }
        return null;
    }

    public boolean includesParticipantType(String val) {
        if (this.bwParticipant != null) {
            return this.bwParticipant.includesParticipantType(val);
        }
        if (this.attendee != null) {
            return Participant.jsCalRoles(this.attendee.getRole()).contains(val.toLowerCase());
        }
        return false;
    }

    public boolean isRecipient() {
        if (this.attendee != null) {
            return true;
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.includesParticipantType("ATTENDEE") || this.bwParticipant.includesParticipantType("CHAIR") || this.bwParticipant.includesParticipantType("VOTER");
        }
        return false;
    }

    public static List<String> jsCalRoles(String icalRole) {
        if (icalRole == null) {
            return defaultRoles;
        }
        List<String> res = jscalRoles.get(icalRole.toUpperCase());
        if (res == null) {
            return defaultRoles;
        }
        return res;
    }

    public static String jsCalRolesAsString(String icalRole) {
        if (icalRole == null) {
            return "attendee";
        }
        String res = jscalRolesAsString.get(icalRole.toUpperCase());
        if (res == null) {
            return "attendee";
        }
        return res;
    }

    public static String iCalRole(String jsCalRoles) {
        TextList roles = new TextList(jsCalRoles);
        if (roles.containsIgnoreCase("chair")) {
            return "CHAIR";
        }
        if (!roles.containsIgnoreCase("attendee")) {
            return jsCalRoles;
        }
        if (roles.size() == 1) {
            return "REQ-PARTICIPANT";
        }
        if (roles.containsIgnoreCase("optional")) {
            return "OPT-PARTICIPANT";
        }
        if (roles.containsIgnoreCase("informational")) {
            return "NON-PARTICIPANT";
        }
        return jsCalRoles;
    }

    public void setDelegatedFrom(String val) {
        if (this.attendee != null) {
            this.attendee.setDelegatedFrom(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setDelegatedFrom(val);
        }
    }

    public String getDelegatedFrom() {
        if (this.attendee != null) {
            return this.attendee.getDelegatedFrom();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getDelegatedFrom();
        }
        return null;
    }

    public void setDelegatedTo(String val) {
        if (this.attendee != null) {
            this.attendee.setDelegatedTo(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setDelegatedTo(val);
        }
    }

    public String getDelegatedTo() {
        if (this.attendee != null) {
            return this.attendee.getDelegatedTo();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getDelegatedTo();
        }
        return null;
    }

    public void setMemberOf(String val) {
        if (this.attendee != null) {
            this.attendee.setMember(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setMemberOf(val);
        }
    }

    public String getMemberOf() {
        if (this.attendee != null) {
            return this.attendee.getMember();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getMemberOf();
        }
        return null;
    }

    public void setExpectReply(boolean val) {
        if (this.attendee != null) {
            this.attendee.setRsvp(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setExpectReply(val);
        }
    }

    public boolean getExpectReply() {
        if (this.attendee != null) {
            return this.attendee.getRsvp();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getExpectReply();
        }
        return false;
    }

    public void setEmail(String val) {
        if (this.attendee != null) {
            this.attendee.setEmail(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setEmail(val);
        }
    }

    public String getEmail() {
        if (this.attendee != null) {
            return this.attendee.getEmail();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getEmail();
        }
        return null;
    }

    public void setInvitedBy(String val) {
        if (this.attendee != null) {
            this.attendee.setSentBy(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setInvitedBy(val);
        }
    }

    public String getInvitedBy() {
        if (this.attendee != null) {
            return this.attendee.getSentBy();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getInvitedBy();
        }
        return null;
    }

    public void setSequence(int val) {
        if (this.attendee != null) {
            this.attendee.setSequence(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setSequence(val);
        }
    }

    public int getSequence() {
        if (this.attendee != null) {
            return this.attendee.getSequence();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getSequence();
        }
        return 0;
    }

    public void setSchedulingDtStamp(String val) {
        if (this.attendee != null) {
            this.attendee.setDtstamp(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setSchedulingDtStamp(val);
        }
    }

    public String getSchedulingDtStamp() {
        if (this.attendee != null) {
            return this.attendee.getDtstamp();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getSchedulingDtStamp();
        }
        return null;
    }

    public void setScheduleAgent(String val) {
        if (this.attendee != null) {
            for (int i = 0; i <= IcalDefs.scheduleAgents.length; ++i) {
                if (!IcalDefs.scheduleAgents[i].equalsIgnoreCase(val)) continue;
                this.attendee.setScheduleAgent(i);
                break;
            }
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setScheduleAgent(val);
        }
    }

    public String getScheduleAgent() {
        String agent;
        int i;
        if (this.attendee != null && (i = this.attendee.getScheduleAgent()) >= 0 && i < IcalDefs.scheduleAgents.length) {
            return IcalDefs.scheduleAgents[i];
        }
        if (this.bwParticipant != null && (agent = this.bwParticipant.getScheduleAgent()) != null) {
            return this.bwParticipant.getScheduleAgent();
        }
        return "SERVER";
    }

    public void setScheduleStatus(String val) {
        if (this.attendee != null) {
            this.attendee.setScheduleStatus(val);
        }
        if (this.bwParticipant != null) {
            this.bwParticipant.setScheduleStatus(val);
        }
    }

    public String getScheduleStatus() {
        if (this.attendee != null) {
            return this.attendee.getScheduleStatus();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.getScheduleStatus();
        }
        return null;
    }

    public void copyTo(Participant that) {
        if (this.attendee != null) {
            if (that.attendee != null) {
                this.attendee.copyTo(that.attendee);
            } else {
                that.attendee = (BwAttendee)this.attendee.clone();
            }
        }
        if (this.bwParticipant != null) {
            if (that.bwParticipant != null) {
                this.bwParticipant.copyTo(that.bwParticipant);
            } else {
                that.bwParticipant = (BwParticipant)this.bwParticipant.clone();
            }
        }
    }

    public boolean changedBy(Participant val) {
        return this.changedBy(val, true);
    }

    public boolean changedBy(Participant val, boolean checkPartStat) {
        if (this.attendee != null) {
            if (val.attendee == null) {
                return true;
            }
            return this.attendee.changedBy(val.attendee, checkPartStat);
        }
        if (this.bwParticipant != null) {
            if (val.bwParticipant == null) {
                return true;
            }
            return this.bwParticipant.changedBy(val.bwParticipant, checkPartStat);
        }
        return val.attendee != null || val.bwParticipant != null;
    }

    public int hashCode() {
        if (this.attendee != null) {
            return this.attendee.hashCode();
        }
        if (this.bwParticipant != null) {
            return this.bwParticipant.hashCode();
        }
        return -1;
    }

    public boolean equals(Participant val) {
        if (val == null) {
            return false;
        }
        return this.getCalendarAddress().equals(val.getCalendarAddress());
    }

    @Override
    public int compareTo(Participant that) {
        if (this == that) {
            return 0;
        }
        int res = Util.cmpObjval((Comparable)this.attendee, (Comparable)that.attendee);
        if (res != 0) {
            return res;
        }
        return Util.cmpObjval((Comparable)this.bwParticipant, (Comparable)that.bwParticipant);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        if (this.attendee != null) {
            ts.append("attendee", (Object)this.attendee);
        }
        if (this.bwParticipant != null) {
            ts.append("participant", (Object)this.bwParticipant);
        }
        return ts.toString();
    }

    @Override
    public boolean differsFrom(Participant val) {
        return Util.compareStrings((String)val.getParticipationStatus(), (String)this.getParticipationStatus()) != 0 || Util.compareStrings((String)val.getCalendarAddress(), (String)this.getCalendarAddress()) != 0 || Util.compareStrings((String)val.getKind(), (String)this.getKind()) != 0 || Util.compareStrings((String)val.getName(), (String)this.getName()) != 0 || Util.compareStrings((String)val.getParticipantType(), (String)this.getParticipantType()) != 0 || Util.compareStrings((String)val.getDelegatedFrom(), (String)this.getDelegatedFrom()) != 0 || Util.compareStrings((String)val.getDelegatedTo(), (String)this.getDelegatedTo()) != 0 || Util.compareStrings((String)val.getLanguage(), (String)this.getLanguage()) != 0 || Util.compareStrings((String)val.getMemberOf(), (String)this.getMemberOf()) != 0 || Util.cmpBoolval((boolean)val.getExpectReply(), (boolean)this.getExpectReply()) != 0 || Util.compareStrings((String)val.getEmail(), (String)this.getEmail()) != 0 || Util.compareStrings((String)val.getInvitedBy(), (String)this.getInvitedBy()) != 0 || Util.compareStrings((String)val.getScheduleAgent(), (String)this.getScheduleAgent()) != 0;
    }

    static {
        jscalRoles.put("CHAIR", List.of("chair"));
        jscalRoles.put("REQ-PARTICIPANT", defaultRoles);
        jscalRoles.put("OPT-PARTICIPANT", List.of("attendee", "optional"));
        jscalRoles.put("NON-PARTICIPANT", List.of("attendee", "informational"));
        jscalRolesAsString.put("CHAIR", "chair");
        jscalRolesAsString.put("REQ-PARTICIPANT", "attendee");
        jscalRolesAsString.put("OPT-PARTICIPANT", "attendee, optional");
        jscalRolesAsString.put("NON-PARTICIPANT", "attendee, informational");
    }
}

