/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.component.VEvent;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwParticipant;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.SchedulingOwner;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.util.calendar.IcalendarUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.misc.response.Response;

public class SchedulingInfo {
    private final BwEvent parent;
    private SchedulingOwner schedulingOwner;
    private Set<BwParticipant> bwParticipants;
    private Map<String, BwParticipant> bwParticipantMap;
    private Set<Participant> participants;
    private Map<String, Participant> participantMap;
    private boolean changed;

    public SchedulingInfo(BwEvent parent) {
        this.parent = parent;
    }

    public BwEvent getParent() {
        return this.parent;
    }

    public SchedulingOwner getSchedulingOwner() {
        if (this.schedulingOwner == null) {
            Map<String, Participant> owners = this.getParticipantsWithRoles("OWNER");
            BwParticipant powner = owners.size() == 1 ? owners.values().iterator().next().getBwParticipant() : null;
            this.schedulingOwner = new SchedulingOwner(this, this.parent.getOrganizer(), powner);
        }
        return this.schedulingOwner;
    }

    public SchedulingOwner newSchedulingOwner(String calendarAddress) {
        BwParticipant powner;
        if (this.parent.getEntityType() == 7) {
            Participant part = this.findParticipant(calendarAddress);
            if (part == null) {
                powner = new BwParticipant(this);
                this.getBwParticipantsSet().add(powner);
            } else {
                powner = part.getBwParticipant();
            }
        } else {
            powner = null;
        }
        BwOrganizer organizer = powner == null ? new BwOrganizer() : null;
        this.schedulingOwner = new SchedulingOwner(this, organizer, powner);
        this.schedulingOwner.setCalendarAddress(calendarAddress);
        this.markChanged();
        return this.schedulingOwner;
    }

    public SchedulingOwner newSchedulingOwner(BwOrganizer organizer, BwParticipant powner) {
        this.schedulingOwner = new SchedulingOwner(this, organizer, powner);
        return this.schedulingOwner;
    }

    public SchedulingOwner copySchedulingOwner(SchedulingOwner from) {
        if (from.getOrganizer() != null) {
            BwOrganizer org = (BwOrganizer)from.getOrganizer().clone();
            this.parent.setOrganizer(org);
            this.schedulingOwner = this.newSchedulingOwner(org, null);
            this.markChanged();
            return this.schedulingOwner;
        }
        if (from.getParticipant() == null) {
            return null;
        }
        Participant p = this.findParticipant(from.getCalendarAddress());
        if (p == null) {
            BwParticipant powner = (BwParticipant)from.getParticipant().clone();
            powner.addParticipantType("OWNER");
            this.getBwParticipantsSet().add(powner);
            this.schedulingOwner = this.newSchedulingOwner(null, powner);
            return this.schedulingOwner;
        }
        BwParticipant powner = p.getBwParticipant();
        from.getParticipant().copyTo(powner);
        powner.addParticipantType("OWNER");
        this.schedulingOwner = this.newSchedulingOwner(null, powner);
        return this.schedulingOwner;
    }

    public Set<Participant> getParticipants() {
        return Collections.unmodifiableSet(this.getParticipantsSet());
    }

    public int getNumParticipants() {
        return this.getParticipantsSet().size();
    }

    public Set<String> getParticipantAddrs() {
        this.getParticipantsSet();
        return this.participantMap.keySet();
    }

    public void clearParticipants() {
        if (this.parent.getAttendees() != null) {
            this.parent.getAttendees().clear();
        }
        SchedulingOwner owner = this.getSchedulingOwner();
        BwParticipant ownerParticipant = owner.getParticipant();
        this.bwParticipants.clear();
        if (ownerParticipant != null) {
            ownerParticipant.setParticipantType("OWNER");
            this.bwParticipants.add(ownerParticipant);
        }
        this.markChanged();
    }

    public void setOnlyParticipant(Participant participant) {
        this.clearParticipants();
        this.makeParticipant(participant.getAttendee(), participant.getBwParticipant());
    }

    public GetEntityResponse<Participant> getOnlyParticipant() {
        GetEntityResponse resp = new GetEntityResponse();
        Map<String, Participant> recipients = this.getRecipientParticipants();
        if (recipients.size() != 1) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)new CalFacadeException("org.bedework.error.scheduling.expectoneattendee"));
        }
        resp.setEntity((Object)recipients.values().iterator().next());
        return resp;
    }

    public Participant findParticipant(String calAddr) {
        this.getParticipantsSet();
        return this.participantMap.get(calAddr);
    }

    public Participant makeParticipant() {
        BwParticipant p = this.newBwParticipant();
        BwAttendee att = new BwAttendee();
        this.parent.addAttendee(att);
        Participant a = new Participant(this, att, p);
        this.getParticipantsSet().add(a);
        this.markChanged();
        return a;
    }

    public void removeRecipientParticipant(Participant val) {
        BwParticipant part;
        ChangeTable ctab = this.parent.getChangeset();
        BwAttendee att = val.getAttendee();
        if (att != null) {
            if (ctab == null) {
                this.parent.removeAttendee(att);
            } else {
                ctab.changed(PropertyIndex.PropertyInfoIndex.ATTENDEE, att, null);
            }
        }
        if ((part = val.getBwParticipant()) != null) {
            part.removeParticipantType("ATTENDEE");
            part.removeParticipantType("CHAIR");
            part.removeParticipantType("VOTER");
            if (part.getParticipantType() == null) {
                this.removeBwParticipant(part);
            }
        }
        this.markChanged();
    }

    public Participant addParticipant(Participant val) {
        BwAttendee evAtt = this.parent.findAttendee(val.getCalendarAddress());
        BwAttendee att = val.getAttendee();
        ChangeTable ctab = this.parent.getChangeset();
        if (att != null) {
            if (ctab == null) {
                this.parent.addAttendee(val.getAttendee());
            } else {
                ChangeTableEntry cte = ctab.getEntry(PropertyIndex.PropertyInfoIndex.ATTENDEE);
                if (evAtt != null) {
                    cte.addChangedValue(att);
                } else {
                    cte.addAddedValue(att);
                }
            }
        }
        BwParticipant evPart = this.getBwParticipantMap().get(val.getCalendarAddress());
        BwParticipant part = val.getBwParticipant();
        if (part != null) {
            if (evPart != null) {
                part.copyToMerge(evPart);
            } else {
                evPart = new BwParticipant(this);
                part.copyTo(evPart);
                this.getBwParticipantsSet().add(evPart);
            }
        }
        this.markChanged();
        return val;
    }

    public Participant copyParticipant(Participant val) {
        BwParticipant part;
        Participant ourParticipant = this.findParticipant(val.getCalendarAddress());
        if (ourParticipant != null) {
            val.copyTo(ourParticipant);
            ChangeTable ctab = this.parent.getChangeset();
            if (ctab != null) {
                ChangeTableEntry cte = ctab.getEntry(PropertyIndex.PropertyInfoIndex.ATTENDEE);
                cte.addChangedValue(ourParticipant.getAttendee());
            }
            return ourParticipant;
        }
        BwAttendee att = val.getAttendee() != null ? (BwAttendee)val.getAttendee().clone() : null;
        if (val.getBwParticipant() != null) {
            part = (BwParticipant)val.getBwParticipant().clone();
            this.getBwParticipantsSet().add(part);
        } else {
            part = null;
        }
        return this.addParticipant(new Participant(this, att, part));
    }

    public Participant makeParticipant(BwAttendee att, BwParticipant part) {
        Participant a = new Participant(this, att, part);
        return this.addParticipant(a);
    }

    public Participant makeParticipantLike(Participant val) {
        BwParticipant mPart;
        BwAttendee mAtt;
        if (val.getAttendee() != null) {
            mAtt = new BwAttendee();
            mPart = null;
        } else {
            mPart = this.newBwParticipant();
            mAtt = null;
        }
        return this.makeParticipant(mAtt, mPart);
    }

    public Participant newParticipant(net.fortuna.ical4j.model.component.Participant part) {
        BwParticipant bwpart = new BwParticipant(this, part);
        String calAddr = bwpart.getCalendarAddress();
        if (calAddr != null && this.getBwParticipantMap().get(calAddr) != null) {
            throw new CalFacadeException("Duplicate participant " + calAddr);
        }
        this.getBwParticipantsSet().add(bwpart);
        Participant participant = new Participant(this, null, bwpart);
        this.markChanged();
        return participant;
    }

    public Participant addUpdateParticipant(net.fortuna.ical4j.model.component.Participant part) {
        BwParticipant setBwpart;
        BwParticipant bwpart = new BwParticipant(this, part);
        String calAddr = bwpart.getCalendarAddress();
        boolean addIt = true;
        if (calAddr != null && (setBwpart = this.getBwParticipantMap().get(calAddr)) != null) {
            bwpart.copyToMerge(setBwpart);
            addIt = false;
        }
        if (addIt) {
            this.getBwParticipantsSet().add(bwpart);
        }
        Participant participant = new Participant(this, null, bwpart);
        this.markChanged();
        return participant;
    }

    public Map<String, Participant> getParticipantsWithRoles(String ... roles) {
        HashMap<String, Participant> vals = new HashMap<String, Participant>();
        block0: for (Participant p : this.getParticipants()) {
            for (String r : roles) {
                if (!p.includesParticipantType(r)) continue;
                vals.put(p.getCalendarAddress(), p);
                continue block0;
            }
        }
        return Collections.unmodifiableMap(vals);
    }

    public Map<String, Participant> getRecipientParticipants() {
        return this.getParticipantsWithRoles("ATTENDEE", "CHAIR", "VOTER");
    }

    public void markChanged() {
        this.changed = true;
        this.participants = null;
        this.participantMap = null;
        this.bwParticipantMap = null;
        this.schedulingOwner = null;
    }

    public void onSave() {
        if (!this.changed) {
            return;
        }
        List<BwXproperty> props = this.parent.getXproperties("X-BEDEWORK-PARTICIPANT");
        if (!Util.isEmpty(props)) {
            for (BwXproperty bwXproperty : props) {
                this.parent.removeXproperty(bwXproperty);
            }
        }
        for (BwParticipant bwParticipant : this.getBwParticipantsSet()) {
            BwXproperty xp = new BwXproperty("X-BEDEWORK-PARTICIPANT", null, bwParticipant.asString());
            this.parent.addXproperty(xp);
        }
        this.changed = false;
    }

    public SchedulingInfo copyFor(BwEvent ev) {
        SchedulingInfo res = new SchedulingInfo(ev);
        BwOrganizer org = this.parent.getOrganizer();
        if (org != null) {
            org = (BwOrganizer)org.clone();
        }
        ev.setOrganizer(org);
        ev.setAttendees(this.parent.cloneAttendees());
        for (BwParticipant p : this.getBwParticipantsSet()) {
            res.getBwParticipantsSet().add((BwParticipant)p.clone());
        }
        res.markChanged();
        return res;
    }

    private Set<Participant> getParticipantsSet() {
        Participant participant;
        String addr;
        if (this.participants != null) {
            return this.participants;
        }
        this.participants = new HashSet<Participant>();
        this.participantMap = new HashMap<String, Participant>();
        Set<BwAttendee> evatts = this.parent.getAttendees();
        HashMap<String, BwAttendee> attMap = new HashMap<String, BwAttendee>();
        if (evatts != null) {
            for (BwAttendee att : evatts) {
                addr = att.getAttendeeUri();
                attMap.put(addr, att);
                BwParticipant part = this.findBwParticipant(addr);
                participant = new Participant(this, att, part);
                this.participants.add(participant);
                this.participantMap.put(addr, participant);
            }
        }
        for (BwParticipant part : this.getBwParticipantsSet()) {
            addr = part.getCalendarAddress();
            if (addr == null) continue;
            BwAttendee att = (BwAttendee)attMap.get(addr);
            if (att == null) {
                participant = new Participant(this, null, part);
                this.participants.add(participant);
                this.participantMap.put(addr, participant);
                continue;
            }
            attMap.remove(addr);
        }
        for (BwAttendee att : attMap.values()) {
            Participant participant2 = new Participant(this, att, null);
            this.participants.add(participant2);
            this.participantMap.put(att.getAttendeeUri(), participant2);
        }
        return this.participants;
    }

    private Map<String, BwParticipant> getBwParticipantMap() {
        if (this.bwParticipantMap == null) {
            this.bwParticipantMap = new HashMap<String, BwParticipant>();
            for (BwParticipant part : this.getBwParticipantsSet()) {
                this.bwParticipantMap.put(part.getCalendarAddress(), part);
            }
        }
        return this.bwParticipantMap;
    }

    private Set<BwParticipant> getBwParticipantsSet() {
        if (this.bwParticipants == null) {
            this.bwParticipants = new HashSet<BwParticipant>();
            List<BwXproperty> xprops = this.parent.getXproperties("X-BEDEWORK-PARTICIPANT");
            if (Util.isEmpty(xprops)) {
                return this.bwParticipants;
            }
            StringBuilder sb = new StringBuilder("BEGIN:VCALENDAR\nPRODID://Bedework.org//BedeWork V3.9//EN\nVERSION:2.0\nBEGIN:VEVENT\nUID:0123\n");
            boolean found = false;
            for (BwXproperty xp : xprops) {
                found = true;
                sb.append(xp.getValue());
            }
            if (!found) {
                return this.bwParticipants;
            }
            sb.append("END:VEVENT\nEND:VCALENDAR\n");
            Calendar ical = IcalendarUtil.fromBuilder((String)sb.toString());
            VEvent ev = (VEvent)ical.getComponent("VEVENT");
            for (Component comp : ev.getComponents().getComponents("PARTICIPANT")) {
                this.bwParticipants.add(new BwParticipant(this, (net.fortuna.ical4j.model.component.Participant)comp));
            }
        }
        return this.bwParticipants;
    }

    private BwParticipant findBwParticipant(String calAddr) {
        for (BwParticipant p : this.getBwParticipantsSet()) {
            if (!calAddr.equals(p.getCalendarAddress())) continue;
            return p;
        }
        return null;
    }

    private void removeBwParticipant(BwParticipant part) {
        this.getBwParticipantsSet().remove(part);
        this.markChanged();
    }

    private BwParticipant newBwParticipant() {
        BwParticipant p = new BwParticipant(this);
        this.getBwParticipantsSet().add(p);
        this.markChanged();
        return p;
    }
}

