/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.filter;

import org.bedework.caldav.util.filter.EntityTypeFilter;
import org.bedework.caldav.util.filter.ObjectFilter;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.SchedulingOwner;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.webdav.servlet.shared.WebdavException;

public class BwObjectFilter
extends ObjectFilter<ObjectFilter<?>> {
    public BwObjectFilter(String name, ObjectFilter<?> of) {
        super(name, PropertyIndex.PropertyInfoIndex.CATEGORIES);
        this.setEntity(of);
        this.setPropertyIndex(of.getPropertyIndex());
        this.setParentPropertyIndex(of.getParentPropertyIndex());
        this.setExact(of.getExact());
        this.setNot(of.getNot());
        this.setCaseless(of.getCaseless());
    }

    public PropertyIndex.PropertyInfoIndex getPropertyIndex() {
        return ((ObjectFilter)this.getEntity()).getPropertyIndex();
    }

    public PropertyIndex.PropertyInfoIndex getParentPropertyIndex() {
        return ((ObjectFilter)this.getEntity()).getParentPropertyIndex();
    }

    public boolean match(Object o, String userHref) {
        ObjectFilter of = (ObjectFilter)this.getEntity();
        Object ent = of.getEntity();
        boolean not = of.getNot();
        String val = null;
        Integer ival = null;
        if (ent instanceof BwCalendar) {
            val = ((BwCalendar)ent).getPath();
        } else if (ent instanceof String) {
            val = (String)ent;
        } else if (ent instanceof Integer) {
            ival = (Integer)ent;
        } else {
            throw new WebdavException("Unmatchable filter");
        }
        BwEvent ev = null;
        if (o instanceof BwEvent) {
            ev = (BwEvent)o;
        }
        if (ev == null) {
            return false;
        }
        if (of instanceof EntityTypeFilter) {
            if (not) {
                return ev.getEntityType() != ival.intValue();
            }
            return ev.getEntityType() == ival.intValue();
        }
        PropertyIndex.PropertyInfoIndex pii = of.getPropertyIndex();
        BwIcalPropertyInfo.BwIcalPropertyInfoEntry pi = BwIcalPropertyInfo.getPinfo(pii);
        if (pi.getParam()) {
            pii = of.getParentPropertyIndex();
        }
        switch (pii) {
            case CLASS: {
                if (ev.getClassification() == null) {
                    return false;
                }
                return this.stringMatch(ev.getClassification(), val);
            }
            case CREATED: {
                return this.stringMatch(ev.getCreated(), val);
            }
            case DESCRIPTION: {
                for (BwLongString ls : ev.getDescriptions()) {
                    if (!this.stringMatch(ls.getValue(), val)) continue;
                    return true;
                }
                return false;
            }
            case DTSTAMP: {
                return this.stringMatch(ev.getDtstamp(), val);
            }
            case DTEND: 
            case DUE: {
                return this.matchDateTime(pi, ev.getDtend(), val);
            }
            case DTSTART: {
                return this.matchDateTime(pi, ev.getDtstart(), val);
            }
            case DURATION: {
                return this.stringMatch(ev.getDuration(), val);
            }
            case GEO: {
                if (ev.getGeo() == null) {
                    return false;
                }
                return this.stringMatch(ev.getGeo().toString(), val);
            }
            case LAST_MODIFIED: {
                return this.stringMatch(ev.getLastmod(), val);
            }
            case LOCATION: {
                if (ev.getLocation() == null) {
                    return false;
                }
                return this.stringMatch(ev.getLocation().getAddress().getValue(), val);
            }
            case ORGANIZER: {
                SchedulingOwner so = ev.getSchedulingInfo().getSchedulingOwner();
                if (so.noOwner()) {
                    return false;
                }
                return this.stringMatch(so.getCalendarAddress(), val);
            }
            case PRIORITY: {
                if (ev.getPriority() == null) {
                    return false;
                }
                return this.stringMatch(String.valueOf(ev.getPriority()), val);
            }
            case RECURRENCE_ID: {
                if (ev.getRecurrenceId() == null) {
                    return false;
                }
                return this.stringMatch(ev.getRecurrenceId(), val);
            }
            case SEQUENCE: {
                return this.stringMatch(String.valueOf(ev.getSequence()), val);
            }
            case STATUS: {
                if (ev.getStatus() == null) {
                    return false;
                }
                return this.stringMatch(ev.getStatus(), val);
            }
            case SUMMARY: {
                for (BwString s : ev.getSummaries()) {
                    if (!this.stringMatch(s.getValue(), val)) continue;
                    return true;
                }
                return false;
            }
            case UID: {
                return this.stringMatch(ev.getUid(), val);
            }
            case URL: {
                if (ev.getLink() == null) {
                    return false;
                }
                return this.stringMatch(ev.getLink(), val);
            }
            case TRANSP: {
                try {
                    if (ev.getPeruserTransparency(userHref) == null) {
                        return false;
                    }
                    return this.stringMatch(ev.getPeruserTransparency(userHref), val);
                }
                catch (Throwable t) {
                    throw new WebdavException(t);
                }
            }
            case COMPLETED: {
                if (ev.getCompleted() == null) {
                    return false;
                }
                return this.stringMatch(ev.getCompleted(), val);
            }
            case PERCENT_COMPLETE: {
                if (ev.getPercentComplete() == null) {
                    return false;
                }
                return this.stringMatch(String.valueOf(ev.getPercentComplete()), val);
            }
            case ATTACH: {
                break;
            }
            case ATTENDEE: {
                break;
            }
            case CATEGORIES: {
                for (BwCategory cat : ev.getCategories()) {
                    if (!this.stringMatch(cat.getWordVal(), val)) continue;
                    return true;
                }
                return false;
            }
            case COMMENT: {
                for (BwString s : ev.getComments()) {
                    if (!this.stringMatch(s.getValue(), val)) continue;
                    return true;
                }
                return false;
            }
            case CONTACT: {
                for (BwContact c : ev.getContacts()) {
                    if (!this.stringMatch(c.getCn().getValue(), val)) continue;
                    return true;
                }
                return false;
            }
            case EXDATE: {
                for (BwDateTime dt : ev.getExdates()) {
                    if (!this.stringMatch(dt.getDtval(), val)) continue;
                    return true;
                }
                return false;
            }
            case EXRULE: {
                for (String s : ev.getExrules()) {
                    if (!this.stringMatch(s, val)) continue;
                    return true;
                }
                return false;
            }
            case REQUEST_STATUS: {
                for (BwRequestStatus rs : ev.getRequestStatuses()) {
                    if (!this.stringMatch(rs.getCode(), val)) continue;
                    return true;
                }
                return false;
            }
            case RELATED_TO: {
                if (ev.getRelatedTo() == null) {
                    return false;
                }
                return this.stringMatch(ev.getRelatedTo().getValue(), val);
            }
            case RESOURCES: {
                for (BwString s : ev.getResources()) {
                    if (!this.stringMatch(s.getValue(), val)) continue;
                    return true;
                }
                return false;
            }
            case RDATE: {
                for (BwDateTime dt : ev.getRdates()) {
                    if (!this.stringMatch(dt.getDtval(), val)) continue;
                    return true;
                }
                return false;
            }
            case RRULE: {
                for (String s : ev.getRrules()) {
                    if (!this.stringMatch(s, val)) continue;
                    return true;
                }
                return false;
            }
            case FREEBUSY: {
                break;
            }
            case TZID: {
                break;
            }
            case TZNAME: {
                break;
            }
            case TZOFFSETFROM: {
                break;
            }
            case TZOFFSETTO: {
                break;
            }
            case TZURL: {
                break;
            }
            case ACTION: {
                break;
            }
            case REPEAT: {
                break;
            }
            case TRIGGER: {
                break;
            }
            case COLLECTION: {
                return this.stringMatch(ev.getColPath(), val);
            }
            case CREATOR: {
                return this.stringMatch(ev.getCreatorHref(), val);
            }
            case OWNER: {
                return this.stringMatch(ev.getOwnerHref(), val);
            }
        }
        return false;
    }

    private boolean matchDateTime(BwIcalPropertyInfo.BwIcalPropertyInfoEntry pi, BwDateTime dt, String val) {
        if (!pi.getParam()) {
            return false;
        }
        if (dt == null) {
            return false;
        }
        if (this.getPropertyIndex() != PropertyIndex.PropertyInfoIndex.TZIDPAR) {
            return false;
        }
        return this.stringMatch(dt.getTzid(), val);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.getPropertyIndex());
        if (this.getExact()) {
            if (this.getNot()) {
                sb.append(" != ");
            } else {
                sb.append(" = ");
            }
        } else {
            if (this.getNot()) {
                sb.append(" not ");
            }
            sb.append(" like ");
        }
        sb.append(((ObjectFilter)this.getEntity()).getEntity());
        sb.append(")");
        return sb.toString();
    }

    private boolean stringMatch(String fldVal, String val) {
        boolean matches = this.getExact() ? (this.getCaseless() ? val.equalsIgnoreCase(fldVal) : val.equals(fldVal)) : (this.getCaseless() ? fldVal.toLowerCase().contains(val.toLowerCase()) : val.contains(fldVal));
        if (this.getNot()) {
            return !matches;
        }
        return matches;
    }
}

