/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.requests;

import java.util.Collection;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.requests.RequestBase;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.response.Response;

public class GetInstancesRequest
extends RequestBase {
    private String rrule;
    private BwDateTime startDt;
    private BwDateTime endDt;
    private Collection<String> exdates;
    private Collection<String> rdates;
    private String begin;
    private String end;

    public GetInstancesRequest() {
        this.setAction("get-instances");
    }

    public GetInstancesRequest(String rrule, BwDateTime startDt, BwDateTime endDt) {
        this();
        this.rrule = rrule;
        this.startDt = startDt;
        this.endDt = endDt;
    }

    public String getRrule() {
        return this.rrule;
    }

    public BwDateTime getStartDt() {
        return this.startDt;
    }

    public BwDateTime getEndDt() {
        return this.endDt;
    }

    public void setExdates(Collection<String> val) {
        this.exdates = val;
    }

    public Collection<String> getExdates() {
        return this.exdates;
    }

    public void setRdates(Collection<String> val) {
        this.rdates = val;
    }

    public Collection<String> getRdates() {
        return this.rdates;
    }

    public void setBegin(String val) {
        this.begin = val;
    }

    public String getBegin() {
        return this.begin;
    }

    public void setEnd(String val) {
        this.end = val;
    }

    public String getEnd() {
        return this.end;
    }

    @Override
    public boolean validate(Response resp) {
        if (this.getStartDt() == null) {
            Response.invalid((Response)resp, (String)"Missing start date/time");
            return false;
        }
        if (this.getRrule() != null) {
            return true;
        }
        if (this.getRdates() == null) {
            Response.invalid((Response)resp, (String)"Missing rdates when no rrule");
            return false;
        }
        return true;
    }

    @Override
    public void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("rrule", (Object)this.getRrule());
        ts.append("startDt", (Object)this.getStartDt());
        ts.append("endDt", (Object)this.getEndDt());
        ts.append("exdates", this.getExdates());
        ts.append("rdates", this.getRdates());
        ts.append("begin", (Object)this.getBegin());
        ts.append("end", (Object)this.getEnd());
    }
}

