/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.base.Differable;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class ChangeTableEntry {
    private ChangeTable chg;
    private PropertyIndex.PropertyInfoIndex index;
    private Object oldVal;
    private Object newVal;
    private Collection newValues;
    private Collection addedValues;
    private Collection removedValues;
    private Collection changedValues;
    private boolean present;
    private boolean changed;
    private boolean deleted;
    private boolean added;
    private boolean listField;

    public ChangeTableEntry(ChangeTable chg, PropertyIndex.PropertyInfoIndex index) {
        this.chg = chg;
        this.index = index;
    }

    public void addValue(Object val) {
        if (!this.index.getMultiValued()) {
            throw new CalFacadeException("org.bedework.icalendar.notmultivalued");
        }
        if (this.newValues == null) {
            this.newValues = this.index == PropertyIndex.PropertyInfoIndex.XPROP ? new ArrayList() : new TreeSet();
        }
        this.present = true;
        this.changed = true;
        this.newValues.add(val);
    }

    public void addValues(Collection val) {
        if (!this.index.getMultiValued()) {
            throw new CalFacadeException("org.bedework.icalendar.notmultivalued");
        }
        if (this.newValues == null) {
            this.newValues = this.listField ? new ArrayList() : new TreeSet();
        }
        this.present = true;
        this.changed = true;
        this.newValues.addAll(val);
    }

    public PropertyIndex.PropertyInfoIndex getIndex() {
        return this.index;
    }

    public Object getOldVal() {
        return this.oldVal;
    }

    public Object getNewVal() {
        return this.newVal;
    }

    public boolean getEventProperty() {
        return this.index.getEventProperty();
    }

    public boolean getTodoProperty() {
        return this.index.getTodoProperty();
    }

    public boolean getFreebusyProperty() {
        return this.index.getFreeBusyProperty();
    }

    public boolean getVcalendarProperty() {
        return this.index.getVcalendarProperty();
    }

    public boolean getJournalProperty() {
        return this.index.getJournalProperty();
    }

    public boolean getFreeBusyProperty() {
        return this.index.getFreeBusyProperty();
    }

    public boolean getTimezoneProperty() {
        return this.index.getTimezoneProperty();
    }

    public boolean getAlarmProperty() {
        return this.index.getAlarmProperty();
    }

    public boolean getVavailabilityProperty() {
        return this.index.getVavailabilityProperty();
    }

    public boolean getAvailableProperty() {
        return this.index.getAvailableProperty();
    }

    public boolean getVpollProperty() {
        return this.index.getVpollProperty();
    }

    public boolean setChanged(Object oldVal, Object newVal) {
        boolean ch = this.isChanged(oldVal, newVal);
        this.present = true;
        if (!ch) {
            return false;
        }
        this.oldVal = oldVal;
        this.newVal = newVal;
        this.deleted = newVal == null;
        this.added = oldVal == null;
        this.changed = true;
        return true;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setAdded(Object newVal) {
        this.newVal = newVal;
        this.oldVal = null;
        this.changed = true;
        this.added = true;
    }

    public void setPresent(boolean val) {
        this.present = val;
    }

    public boolean getPresent() {
        return this.present;
    }

    public boolean getAdded() {
        return this.added;
    }

    public void setDeleted(Object oldVal) {
        this.oldVal = oldVal;
        this.newVal = null;
        this.changed = true;
        this.deleted = true;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public Collection getNewValues() {
        return this.newValues;
    }

    public void setAddedValues(Collection val) {
        this.addedValues = val;
    }

    public Collection getAddedValues() {
        return this.addedValues;
    }

    public void addAddedValue(Object o) {
        if (this.addedValues == null) {
            this.addedValues = new ArrayList();
        }
        this.addedValues.add(o);
        this.changed = true;
        this.chg.noteCollectionSetChanged();
    }

    public void setRemovedValues(Collection val) {
        this.removedValues = val;
    }

    public Collection getRemovedValues() {
        return this.removedValues;
    }

    public void addRemovedValue(Object o) {
        if (this.removedValues == null) {
            this.removedValues = new ArrayList();
        }
        this.removedValues.add(o);
        this.changed = true;
        this.chg.noteCollectionSetChanged();
    }

    public void setChangedValues(Collection val) {
        this.changedValues = val;
    }

    public Collection getChangedValues() {
        return this.changedValues;
    }

    public void addChangedValue(Object o) {
        if (this.changedValues == null) {
            this.changedValues = new ArrayList();
        }
        this.changedValues.add(o);
        this.changed = true;
    }

    public boolean diff(Collection<?> originalVals) {
        boolean alarms = this.index == PropertyIndex.PropertyInfoIndex.VALARM;
        Collection newVals = this.getNewValues();
        boolean collectionSetChanged = false;
        if (!Util.isEmpty(originalVals)) {
            if (!alarms && newVals == null) {
                this.setRemovedValues(this.getCollection(originalVals));
                this.getRemovedValues().addAll(originalVals);
                this.changed = true;
                collectionSetChanged = true;
            } else {
                for (Object o : originalVals) {
                    BwAlarm al;
                    if (alarms && !(al = (BwAlarm)o).getOwnerHref().equals(this.chg.getUserHref()) || newVals != null && newVals.contains(o)) continue;
                    if (this.getRemovedValues() == null) {
                        this.setRemovedValues(this.getCollection(originalVals));
                    }
                    this.getRemovedValues().add(o);
                    this.changed = true;
                    collectionSetChanged = true;
                }
            }
        }
        if (newVals == null) {
            return collectionSetChanged;
        }
        if (Util.isEmpty(originalVals)) {
            this.setAddedValues(this.getCollection(newVals));
            this.getAddedValues().addAll(newVals);
            this.added = true;
            this.changed = true;
            return true;
        }
        ArrayList differList = null;
        for (Object o : newVals) {
            Differable orig;
            if (o instanceof Differable && differList == null) {
                differList = new ArrayList(originalVals);
            }
            if (!originalVals.contains(o)) {
                if (this.getAddedValues() == null) {
                    this.setAddedValues(this.getCollection(newVals));
                }
                this.getAddedValues().add(o);
                this.changed = true;
                collectionSetChanged = true;
                continue;
            }
            if (differList == null || !(orig = (Differable)differList.get(differList.indexOf(o))).differsFrom(o)) continue;
            if (this.getChangedValues() == null) {
                this.setChangedValues(this.getCollection(newVals));
            }
            this.getChangedValues().add(o);
            this.changed = true;
        }
        return collectionSetChanged;
    }

    private <T extends Collection<?>> T getCollection(T orig) {
        if (orig instanceof List) {
            return (T)new ArrayList();
        }
        return (T)new TreeSet();
    }

    private boolean isChanged(Object from, Object to) {
        if (to instanceof Collection && from instanceof Collection) {
            return this.isChanged((Collection)from, (Collection)to);
        }
        if (from == null) {
            return to != null;
        }
        if (to == null) {
            return true;
        }
        if (to instanceof Differable && from instanceof Differable) {
            return ((Differable)from).differsFrom(to);
        }
        return !from.equals(to);
    }

    private boolean isChanged(Collection from, Collection to) {
        if (Util.isEmpty((Collection)from)) {
            return !Util.isEmpty((Collection)to);
        }
        if (Util.isEmpty((Collection)to)) {
            return true;
        }
        if (from.size() != to.size()) {
            return true;
        }
        ArrayList differList = null;
        for (Object o : from) {
            Differable orig;
            if (o instanceof Differable && differList == null) {
                differList = new ArrayList(to);
            }
            if (!to.contains(o)) {
                return true;
            }
            if (!(o instanceof Differable)) continue;
            if (differList == null) {
                differList = new ArrayList(to);
            }
            if (!(orig = (Differable)differList.get(differList.indexOf(o))).differsFrom(o)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("index", (Object)this.index.toString());
        ts.append("added", this.added);
        ts.append("deleted", this.deleted);
        ts.append("changed", this.changed);
        if (!this.added) {
            ts.append("oldVal", (Object)String.valueOf(this.oldVal));
        }
        if (!this.deleted) {
            ts.append("newVal", (Object)String.valueOf(this.newVal));
        }
        ts.append("newValues", this.newValues);
        ts.append("removedValues", this.removedValues);
        ts.append("changedValues", this.changedValues);
        return ts.toString();
    }
}

