/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.wrappers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bedework.access.CurrentAccess;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwCollectionLastmod;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.CollectionInfo;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.util.AccessUtilI;
import org.bedework.calfacade.wrappers.EntityWrapper;
import org.bedework.util.misc.ToString;

public class CalendarWrapper
extends BwCalendar
implements EntityWrapper<BwCalendar> {
    private final AccessUtilI accessUtil;
    private BwCalendar entity;
    private BwCalendar aliasTarget;
    private BwCalendar aliasOrigin;
    private CurrentAccess currentAccess;
    private Map<Integer, CurrentAccess> caMap = new HashMap<Integer, CurrentAccess>(20);
    private int lastDesiredAccess;
    private String virtualPath;
    private boolean open;
    private boolean disabled;
    private Collection<BwCalendar> children;

    public CalendarWrapper(BwCalendar entity, AccessUtilI accessUtil) {
        this.entity = entity;
        this.accessUtil = accessUtil;
    }

    @Override
    public void putEntity(BwCalendar val) {
        this.entity = val;
    }

    @Override
    public BwCalendar fetchEntity() {
        return this.entity;
    }

    @Override
    public void setId(int val) {
        this.entity.setId(val);
    }

    @Override
    public int getId() {
        return this.entity.getId();
    }

    @Override
    public void setSeq(int val) {
        this.entity.setSeq(val);
    }

    @Override
    public int getSeq() {
        return this.entity.getSeq();
    }

    @Override
    public void setOwnerHref(String val) {
        this.entity.setOwnerHref(val);
    }

    @Override
    public String getOwnerHref() {
        return this.entity.getOwnerHref();
    }

    @Override
    public void setPublick(Boolean val) {
        this.entity.setPublick(val);
    }

    @Override
    public Boolean getPublick() {
        return this.entity.getPublick();
    }

    @Override
    public void setCreatorHref(String val) {
        this.entity.setCreatorHref(val);
    }

    @Override
    public String getCreatorHref() {
        return this.entity.getCreatorHref();
    }

    @Override
    public void setAccess(String val) {
        this.entity.setAccess(val);
    }

    @Override
    public String getAccess() {
        return this.entity.getAccess();
    }

    @Override
    public void setColPath(String val) {
        this.entity.setColPath(val);
    }

    @Override
    public String getColPath() {
        return this.entity.getColPath();
    }

    @Override
    public void setName(String val) {
        throw new RuntimeException("org.bedework.noaccess");
    }

    @Override
    public String getName() {
        return this.entity.getName();
    }

    @Override
    public void setPath(String val) {
        this.entity.setPath(val);
    }

    @Override
    public String getPath() {
        if (this.entity != null) {
            return this.entity.getPath();
        }
        return null;
    }

    @Override
    public void setSummary(String val) {
        this.entity.setSummary(val);
    }

    @Override
    public String getSummary() {
        return this.entity.getSummary();
    }

    @Override
    public void setDescription(String val) {
        this.entity.setDescription(val);
    }

    @Override
    public String getDescription() {
        return this.entity.getDescription();
    }

    @Override
    public void setMailListId(String val) {
        this.entity.setMailListId(val);
    }

    @Override
    public String getMailListId() {
        return this.entity.getMailListId();
    }

    @Override
    public void setCalType(int val) {
        throw new RuntimeException("org.bedework.noaccess");
    }

    @Override
    public int getCalType() {
        return this.entity.getCalType();
    }

    @Override
    public void setLastmod(BwCollectionLastmod val) {
        if (this.entity != null) {
            this.entity.setLastmod(val);
        }
    }

    @Override
    public BwCollectionLastmod getLastmod() {
        return this.entity.getLastmod();
    }

    @Override
    public void setAliasUri(String val) {
        if (val != null) {
            boolean internal = val.startsWith("bwcal://");
            if (internal) {
                this.entity.setCalType(7);
            } else {
                this.entity.setCalType(8);
            }
        }
        this.entity.setAliasUri(val);
    }

    @Override
    public String getAliasUri() {
        return this.entity.getAliasUri();
    }

    @Override
    public void setPwNeedsEncrypt(boolean val) {
        this.entity.setPwNeedsEncrypt(val);
    }

    @Override
    public boolean getPwNeedsEncrypt() {
        return this.entity.getPwNeedsEncrypt();
    }

    @Override
    public void setFilterExpr(String val) {
        this.entity.setFilterExpr(val);
    }

    @Override
    public String getFilterExpr() {
        return this.entity.getFilterExpr();
    }

    @Override
    public void setRefreshRate(int val) {
        this.entity.setRefreshRate(val);
    }

    @Override
    public int getRefreshRate() {
        return this.entity.getRefreshRate();
    }

    @Override
    public void setLastRefresh(String val) {
        this.entity.setLastRefresh(val);
    }

    @Override
    public String getLastRefresh() {
        return this.entity.getLastRefresh();
    }

    @Override
    public void setLastEtag(String val) {
        this.entity.setLastEtag(val);
    }

    @Override
    public String getLastEtag() {
        return this.entity.getLastEtag();
    }

    @Override
    public void setRemoteId(String val) {
        this.entity.setRemoteId(val);
    }

    @Override
    public String getRemoteId() {
        return this.entity.getRemoteId();
    }

    @Override
    public void setRemotePw(String val) {
        this.entity.setRemotePw(val);
    }

    @Override
    public String getRemotePw() {
        return this.entity.getRemotePw();
    }

    @Override
    public void setDisplay(boolean val) {
        this.entity.setDisplay(val);
    }

    @Override
    public boolean getDisplay() {
        return this.entity.getDisplay();
    }

    @Override
    public void setAffectsFreeBusy(boolean val) {
        this.entity.setAffectsFreeBusy(val);
    }

    @Override
    public boolean getAffectsFreeBusy() {
        return this.entity.getAffectsFreeBusy();
    }

    @Override
    public void setUnremoveable(boolean val) {
        this.entity.setUnremoveable(val);
    }

    @Override
    public boolean getUnremoveable() {
        return this.entity.getUnremoveable();
    }

    @Override
    public void setCategories(Set<BwCategory> val) {
        this.entity.setCategories(val);
    }

    @Override
    public Set<BwCategory> getCategories() {
        return this.entity.getCategories();
    }

    @Override
    public void setCategoryHrefs(Set<String> val) {
        this.entity.setCategoryHrefs(val);
    }

    @Override
    public Set<String> getCategoryHrefs() {
        return this.entity.getCategoryHrefs();
    }

    @Override
    public void setProperties(Set<BwProperty> val) {
        this.entity.setProperties(val);
    }

    @Override
    public Set<BwProperty> getProperties() {
        return this.entity.getProperties();
    }

    @Override
    public boolean getCalendarCollection() {
        return this.entity.getCalendarCollection();
    }

    public void clearCurrentAccess() {
        this.caMap.clear();
        this.currentAccess = null;
    }

    @Override
    @JsonIgnore
    public CurrentAccess getCurrentAccess() {
        if (this.currentAccess != null) {
            return this.currentAccess;
        }
        return this.getCurrentAccess(25);
    }

    public CurrentAccess getCurrentAccess(int desiredAccess) {
        if (desiredAccess == this.lastDesiredAccess && this.currentAccess != null) {
            return this.currentAccess;
        }
        this.currentAccess = this.caMap.get(desiredAccess);
        this.lastDesiredAccess = desiredAccess;
        return this.currentAccess;
    }

    @Override
    public void setCurrentAccess(CurrentAccess val) {
        this.entity.setCurrentAccess(val);
    }

    public void setCurrentAccess(CurrentAccess ca, int desiredAccess) {
        this.currentAccess = ca;
        this.lastDesiredAccess = desiredAccess;
        this.caMap.put(desiredAccess, ca);
    }

    public Set<Integer> evaluatedAccesses() {
        return this.caMap.keySet();
    }

    @JsonIgnore
    public int getLastDesiredAccess() {
        return this.lastDesiredAccess;
    }

    @Override
    public void setVirtualPath(String val) {
        this.virtualPath = val;
    }

    @Override
    @NoDump
    public String getVirtualPath() {
        return this.virtualPath;
    }

    @Override
    public void setOpen(boolean val) {
        this.open = val;
    }

    @Override
    public boolean getOpen() {
        return this.open;
    }

    @Override
    public void setDisabled(boolean val) {
        this.disabled = val;
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    @JsonIgnore
    public BwCalendar getAliasedEntity() {
        BwCalendar ent = this.entity.getAliasedEntity();
        if (ent == this.entity) {
            return this;
        }
        return ent;
    }

    @Override
    public boolean getAlias() {
        return this.entity.getAlias();
    }

    @Override
    public boolean getInternalAlias() {
        return this.entity.getCalType() == 7;
    }

    @Override
    public boolean getExternalSub() {
        return this.entity.getCalType() == 8;
    }

    @Override
    public String getInternalAliasPath() {
        return this.entity.getInternalAliasPath();
    }

    @Override
    public void setChildren(Collection<BwCalendar> val) {
        this.children = val;
    }

    @Override
    public Collection<BwCalendar> getChildren() {
        return this.children;
    }

    @Override
    public CollectionInfo getCollectionInfo() {
        return this.getCollectionInfo(this.entity.getCalType());
    }

    @Override
    public String getEncodedPath() {
        return this.entity.getEncodedPath();
    }

    @Override
    public void updateLastmod(Timestamp val) {
        this.entity.updateLastmod(val);
    }

    @Override
    public void setHref(String val) {
        this.entity.setHref(val);
    }

    @Override
    public String getHref() {
        return this.entity.getHref();
    }

    @Override
    public void setAliasTarget(BwCalendar val) {
        this.entity.setAliasTarget(val);
        this.aliasTarget = null;
    }

    @Override
    public BwCalendar getAliasTarget() {
        if (this.aliasTarget == null) {
            this.aliasTarget = this.entity.getAliasTarget();
            if (this.aliasTarget == null) {
                return null;
            }
            if (!(this.aliasTarget instanceof CalendarWrapper)) {
                this.aliasTarget = new CalendarWrapper(this.aliasTarget, this.accessUtil);
            }
        }
        return this.aliasTarget;
    }

    @Override
    public void setAliasOrigin(BwCalendar val) {
        this.entity.setAliasOrigin(val);
        this.aliasOrigin = null;
    }

    @Override
    public BwCalendar getAliasOrigin() {
        if (this.aliasOrigin == null) {
            this.aliasOrigin = this.entity.getAliasOrigin();
            if (this.aliasOrigin == null) {
                return null;
            }
            if (!(this.aliasOrigin instanceof CalendarWrapper)) {
                this.aliasOrigin = new CalendarWrapper(this.aliasOrigin, this.accessUtil);
            }
        }
        return this.aliasOrigin;
    }

    @Override
    public void tombstone() {
        this.entity.tombstone();
    }

    @Override
    public boolean getTombstoned() {
        return this.entity.getTombstoned();
    }

    @Override
    public void dump(File f) {
        this.entity.dump(f);
    }

    @Override
    public int compareTo(BwCalendar o) {
        return this.entity.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.entity.hashCode();
    }

    @Override
    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append((Object)this.entity);
        ts.append("currentAccess", (Object)this.getCurrentAccess());
        ts.append("virtualPath", (Object)this.getVirtualPath());
        return ts.toString();
    }

    @Override
    public Object clone() {
        CalendarWrapper cw = new CalendarWrapper((BwCalendar)this.entity.clone(), this.accessUtil);
        cw.currentAccess = this.currentAccess;
        cw.caMap = this.caMap;
        cw.lastDesiredAccess = this.lastDesiredAccess;
        cw.open = this.open;
        return cw;
    }

    @Override
    public BwCalendar cloneWrapper() {
        CalendarWrapper cw = new CalendarWrapper(this.entity, this.accessUtil);
        cw.currentAccess = this.currentAccess;
        cw.caMap = this.caMap;
        cw.lastDesiredAccess = this.lastDesiredAccess;
        cw.open = this.open;
        if (this.children != null) {
            cw.children = new ArrayList<BwCalendar>(this.children);
        }
        return cw;
    }

    @Override
    public BwCalendar shallowClone() {
        CalendarWrapper cw = new CalendarWrapper(this.entity.shallowClone(), this.accessUtil);
        cw.currentAccess = this.currentAccess;
        cw.caMap = this.caMap;
        cw.lastDesiredAccess = this.lastDesiredAccess;
        cw.open = this.open;
        return cw;
    }
}

