/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.calfacade.BwCalendar;
import org.bedework.util.misc.Util;

public class AliasesInfo
implements Serializable {
    private final String entityName;
    private final BwCalendar collection;
    private final String principalHref;
    private boolean externalCua;
    private boolean visible;
    private boolean shared;
    private boolean notificationsEnabled;
    private final Map<String, AliasesInfo> shareeInfoMap = new HashMap<String, AliasesInfo>();

    public AliasesInfo(String principalHref, BwCalendar collection, String entityName) {
        this.principalHref = principalHref;
        this.collection = collection;
        this.entityName = entityName;
    }

    public String getPrincipalHref() {
        return this.principalHref;
    }

    public BwCalendar getCollection() {
        return this.collection;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setExternalCua(boolean val) {
        this.externalCua = val;
    }

    public boolean getExternalCua() {
        return this.externalCua;
    }

    public void setVisible(boolean val) {
        this.visible = val;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean getShared() {
        return this.shared;
    }

    public void setNotificationsEnabled(boolean val) {
        this.notificationsEnabled = val;
    }

    public boolean getNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public void addSharee(AliasesInfo ai) {
        this.shareeInfoMap.put(ai.getCollection().getPath(), ai);
        this.shared = true;
    }

    public List<AliasesInfo> getAliases() {
        return new ArrayList<AliasesInfo>(this.shareeInfoMap.values());
    }

    public boolean referencesCollection(String val) {
        return this.collection.getPath().equals(val) || this.shareeInfoMap.get(val) != null;
    }

    public String makeKey() {
        if (this.getEntityName() == null) {
            return this.getCollection().getPath();
        }
        return Util.buildPath((boolean)false, (String[])new String[]{this.getCollection().getPath(), "/", this.getEntityName()});
    }

    public static String makeKey(String collectionHref, String entityName) {
        if (entityName == null) {
            return collectionHref;
        }
        return Util.buildPath((boolean)false, (String[])new String[]{collectionHref, "/", entityName});
    }

    public AliasesInfo copyForEntity(String entityName, boolean visible) {
        AliasesInfo ai = new AliasesInfo(this.getPrincipalHref(), this.getCollection(), entityName);
        ai.setVisible(visible);
        for (AliasesInfo a : this.getAliases()) {
            ai.addSharee(a.copyForEntity(entityName, visible));
        }
        return ai;
    }
}

