/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import java.util.Comparator;
import org.bedework.base.ToString;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.calfacade.base.CollatableEntity;
import org.bedework.calfacade.base.SizedEntity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.QuotaUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.FromXmlCallback;

@Dump(elementName="category", keyFields={"uid"})
@JsonIgnoreProperties(value={"size", "word", "wordVal", "collateValue", "finderKeyValue", "description"})
public class BwCategory
extends BwEventProperty<BwCategory>
implements CollatableEntity,
Comparator<BwCategory>,
SizedEntity {
    private BwString word;
    private BwString description;
    private String name;
    private static FromXmlCallback fromXmlCb;

    public void setWord(BwString val) {
        this.word = val;
    }

    @Dump(compound=true)
    public BwString getWord() {
        return this.word;
    }

    public void deleteWord() {
        this.addDeletedEntity(this.getWord());
        this.setWord(null);
    }

    public void setDescription(BwString val) {
        this.description = val;
    }

    @Dump(compound=true)
    public BwString getDescription() {
        return this.description;
    }

    public static BwCategory makeCategory() {
        return (BwCategory)new BwCategory().initUid();
    }

    public void deleteDescription() {
        this.addDeletedEntity(this.getDescription());
        this.setDescription(null);
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    @Override
    void fixNames() {
        String name;
        String extra = this.getWordVal();
        if (extra == null) {
            return;
        }
        int pos = extra.lastIndexOf("/");
        if (pos < 0) {
            name = extra;
            extra = "";
        } else {
            name = extra.substring(pos + 1);
            extra = extra.substring(0, pos);
        }
        this.setName(name);
        this.setColPath("categories", extra);
        this.setHref(Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), this.getName()}));
    }

    @Override
    @NoDump
    public BwString getFinderKeyValue() {
        return this.getWord();
    }

    @Override
    @NoDump
    public String getCollateValue() {
        return this.getWord().getValue();
    }

    public void afterDeletion() {
        this.addDeletedEntity(this.getWord());
        this.addDeletedEntity(this.getDescription());
    }

    @Override
    @NoDump
    public int getSize() {
        return super.length() + QuotaUtil.size(this.getWord()) + QuotaUtil.size(this.getDescription());
    }

    public void setWordVal(String val) {
        BwString s = this.getWord();
        if (val == null) {
            if (s != null) {
                this.addDeletedEntity(s);
                this.setWord(null);
            }
            return;
        }
        if (s == null) {
            s = new BwString();
            this.setWord(s);
        }
        s.setValue(val);
    }

    @NoDump
    public String getWordVal() {
        BwString s = this.getWord();
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    public void setDescriptionVal(String val) {
        BwString s = this.getDescription();
        if (val == null) {
            if (s != null) {
                this.addDeletedEntity(s);
                this.setDescription(null);
            }
            return;
        }
        if (s == null) {
            s = new BwString();
            this.setDescription(s);
        }
        s.setValue(val);
    }

    @NoDump
    public String getDescriptionVal() {
        BwString s = this.getDescription();
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    public void setStatus(String val) {
        if (this.getDescription() == null) {
            this.setDescription(new BwString(val, null));
        } else {
            this.getDescription().setLang(val);
        }
    }

    @Override
    public String getStatus() {
        BwString s = this.getDescription();
        if (s == null) {
            return null;
        }
        return s.getLang();
    }

    @Override
    public int length() {
        return super.length() + this.getWord().length() + this.getDescription().length();
    }

    public boolean updateFrom(BwCategory cat) {
        boolean changed = false;
        if (!this.getWord().equals(cat.getWord())) {
            this.setWord(cat.getWord());
            changed = true;
        }
        if (Util.cmpObjval((Comparable)this.getDescription(), (Comparable)cat.getDescription()) != 0) {
            this.setDescription(cat.getDescription());
            changed = true;
        }
        return changed;
    }

    public void toJson(JsonGenerator jgen) {
        try {
            jgen.writeStartObject();
            this.outJsonField("name", this.getName(), jgen);
            this.outJsonField("href", this.getHref(), jgen);
            this.outJsonField("colPath", this.getColPath(), jgen);
            this.outJsonField("uid", this.getUid(), jgen);
            this.outJsonBwString("word", this.getWord(), jgen);
            this.outJsonBwString("description", this.getDescription(), jgen);
            jgen.writeEndObject();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void outJsonField(String name, String value, JsonGenerator jgen) {
        try {
            if (value == null) {
                return;
            }
            jgen.writeObjectField(name, (Object)value);
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    private void outJsonBwString(String name, BwStringBase<?> value, JsonGenerator jgen) {
        try {
            if (value == null) {
                return;
            }
            jgen.writeFieldName(name);
            jgen.writeStartObject();
            this.outJsonField("lang", value.getLang(), jgen);
            this.outJsonField("value", value.getValue(), jgen);
            jgen.writeEndObject();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NoDump
    public static FromXmlCallback getRestoreCallback() {
        if (fromXmlCb == null) {
            fromXmlCb = new FromXmlCallback();
            fromXmlCb.addSkips(new String[]{"byteSize", "id", "seq"});
            fromXmlCb.addMapField("public", "publick");
        }
        return fromXmlCb;
    }

    @Override
    public int compare(BwCategory o1, BwCategory o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compareTo(BwCategory that) {
        if (that == null) {
            return -1;
        }
        return CalFacadeUtil.cmpObjval(this.getUid(), that.getUid());
    }

    @Override
    public int hashCode() {
        return this.getUid().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("word", (Object)this.getWord());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwCategory cat = new BwCategory();
        super.copyTo(cat);
        cat.setWord((BwString)this.getWord().clone());
        if (this.getDescription() != null) {
            cat.setDescription((BwString)this.getDescription().clone());
        }
        cat.setName(this.getName());
        return cat;
    }
}

