/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Comparator;
import org.bedework.base.ToString;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.ical.IcalProperties;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.base.CollatableEntity;
import org.bedework.calfacade.base.SizedEntity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.QuotaUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.FromXmlCallback;

@Dump(elementName="contact", keyFields={"uid"})
@JsonIgnoreProperties(value={"size"})
public class BwContact
extends BwEventProperty<BwContact>
implements CollatableEntity,
Comparator<BwContact>,
SizedEntity {
    private BwString cn;
    private String phone;
    private String email;
    private String link;
    private static FromXmlCallback fromXmlCb;

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CN, analyzed=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.CONTACT_ALL, jname="contact_all", termsField="contact_all_terms", analyzed=true)})
    public void setCn(BwString val) {
        this.cn = val;
    }

    public BwString getCn() {
        return this.cn;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.PHONE)
    public void setPhone(String val) {
        this.phone = val;
    }

    public String getPhone() {
        return this.phone;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.EMAIL)
    public void setEmail(String val) {
        this.email = val;
    }

    public String getEmail() {
        return this.email;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public static BwContact makeContact() {
        return (BwContact)new BwContact().initUid();
    }

    public void deleteName() {
        this.addDeletedEntity(this.getCn());
        this.setCn(null);
    }

    @Override
    void fixNames() {
        this.setColPath("contacts", null);
        this.setHref(Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), this.getUid()}));
    }

    public void setStatus(String val) {
        if (this.getCn() == null) {
            this.setCn(new BwString(val, null));
        } else {
            this.getCn().setLang(val);
        }
    }

    @Override
    @NoDump
    public String getStatus() {
        BwString s = this.getCn();
        if (s == null) {
            return null;
        }
        return s.getLang();
    }

    @Override
    @NoDump
    public BwString getFinderKeyValue() {
        return this.getCn();
    }

    @Override
    @NoDump
    public String getCollateValue() {
        if (this.getCn() == null || this.getCn().getValue() == null) {
            return "<nocn>";
        }
        return this.getCn().getValue();
    }

    public void afterDeletion() {
        this.addDeletedEntity(this.getCn());
    }

    @Override
    @NoDump
    public int getSize() {
        return super.length() + QuotaUtil.size(this.getCn()) + QuotaUtil.size(this.getPhone()) + QuotaUtil.size(this.getEmail()) + QuotaUtil.size(this.getLink());
    }

    public boolean updateFrom(BwContact ent) {
        boolean changed = false;
        if (!CalFacadeUtil.eqObjval(this.getCn(), ent.getCn())) {
            this.setCn(ent.getCn());
            changed = true;
        }
        if (!CalFacadeUtil.eqObjval(this.getPhone(), ent.getPhone())) {
            this.setPhone(ent.getPhone());
            changed = true;
        }
        if (!CalFacadeUtil.eqObjval(this.getEmail(), ent.getEmail())) {
            this.setEmail(ent.getEmail());
            changed = true;
        }
        if (!CalFacadeUtil.eqObjval(this.getLink(), ent.getLink())) {
            this.setLink(ent.getLink());
            changed = true;
        }
        return changed;
    }

    @NoDump
    public static FromXmlCallback getRestoreCallback() {
        if (fromXmlCb == null) {
            fromXmlCb = new FromXmlCallback();
            fromXmlCb.addSkips(new String[]{"byteSize", "id", "seq"});
            fromXmlCb.addMapField("public", "publick");
        }
        return fromXmlCb;
    }

    @Override
    public int compare(BwContact thisone, BwContact thatone) {
        if (thisone.equals(thatone)) {
            return 0;
        }
        return CalFacadeUtil.cmpObjval(thisone.getCn().getValue(), thatone.getCn().getValue());
    }

    @Override
    public int compareTo(BwContact that) {
        if (this == that) {
            return 0;
        }
        return CalFacadeUtil.cmpObjval(this.getUid(), that.getUid());
    }

    @Override
    public int hashCode() {
        return this.getUid().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("uid", (Object)this.getUid());
        ts.append("cn", (Object)this.getCn());
        ts.append("phone", (Object)this.getPhone());
        ts.append("email", (Object)this.getEmail());
        ts.append("link", (Object)this.getLink());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwContact sp = new BwContact();
        super.copyTo(sp);
        sp.setCn((BwString)this.getCn().clone());
        sp.setPhone(this.getPhone());
        sp.setEmail(this.getEmail());
        sp.setLink(this.getLink());
        return sp;
    }
}

