/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import ietf.params.xml.ns.icalendar_2.DateDatetimePropertyType;
import java.io.Serializable;
import java.text.ParseException;
import java.time.temporal.TemporalAmount;
import java.util.Calendar;
import java.util.Comparator;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import org.bedework.base.ToString;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.ical.IcalProperties;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.calfacade.base.BwCloneable;
import org.bedework.calfacade.base.DumpEntity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.FieldSplitter;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;

@Dump(elementName="date-time", keyFields={"dateType", "tzid", "dtval", "date"})
public class BwDateTime
extends DumpEntity<BwDateTime>
implements BwCloneable,
Comparable<BwDateTime>,
Comparator<BwDateTime>,
Serializable {
    private boolean dateType;
    private String tzid;
    public static final String fieldDelimiter = "\t";
    private FieldSplitter tzidSplit;
    private static final int tzidIndex = 0;
    private static final int fractionalIndex = 1;
    private String dtval;
    private String range;
    public static String oneDayForward = "P1D";
    public static String oneDayBack = "-P1D";
    private String date;
    private Boolean floatFlag;
    private static final Calendar dateIncrementor = Calendar.getInstance(java.util.TimeZone.getTimeZone("GMT"));
    public static final int dtOk = 0;
    public static final int dtBadTz = 1;
    public static final int dtBadDtval = 2;

    public static BwDateTime makeBwDateTime(boolean dateType, String date, String tzid) {
        try {
            if (dateType && !DateTimeUtil.isISODate((String)date)) {
                throw new RuntimeException("org.bedework.datetime.expect.dateonly");
            }
            BwDateTime bwd = new BwDateTime();
            bwd.setDateType(dateType);
            bwd.setDtval(date);
            bwd.setTzid(tzid);
            if (tzid == null && DateTimeUtil.isISODateTime((String)date)) {
                bwd.setFloatFlag(true);
                bwd.setDate(date + "Z");
            }
            if (!bwd.getFloating()) {
                bwd.setDate(Timezones.getUtc((String)date, (String)tzid));
            }
            return bwd;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static BwDateTime makeBwDateTime(boolean dateType, String date, String utcDate, String tzid, boolean floating) {
        try {
            if (dateType && !DateTimeUtil.isISODate((String)date)) {
                throw new RuntimeException("org.bedework.datetime.expect.dateonly");
            }
            BwDateTime bwd = new BwDateTime();
            bwd.setDateType(dateType);
            bwd.setDtval(date);
            bwd.setDate(utcDate);
            bwd.setTzid(tzid);
            bwd.setFloatFlag(floating);
            return bwd;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static BwDateTime makeBwDateTime(DateProperty val) {
        Parameter par = BwDateTime.getIcalParameter((Property)val, "VALUE");
        BwDateTime bwdt = BwDateTime.makeBwDateTime(par != null && par.equals((Object)Value.DATE), val.getValue(), BwDateTime.getTzid(val));
        par = BwDateTime.getIcalParameter((Property)val, "RANGE");
        if (par != null) {
            bwdt.range = par.getValue();
        }
        return bwdt;
    }

    public static BwDateTime makeBwDateTime(DateDatetimePropertyType val) {
        XcalUtil.DtTzid dtTzid = XcalUtil.getDtTzid((DateDatetimePropertyType)val);
        return BwDateTime.makeBwDateTime(dtTzid.dateOnly, dtTzid.dt, dtTzid.tzid);
    }

    public static BwDateTime makeBwDateTime(DateDatetimePropertyType val, String tzid) {
        XcalUtil.DtTzid dtTzid = XcalUtil.getDtTzid((DateDatetimePropertyType)val);
        return BwDateTime.makeBwDateTime(dtTzid.dateOnly, dtTzid.dt, tzid);
    }

    public static BwDateTime makeBwDateTime(Date val) {
        String tzid = null;
        boolean dateType = true;
        if (val instanceof DateTime) {
            dateType = false;
            TimeZone tz = ((DateTime)val).getTimeZone();
            if (tz != null) {
                tzid = tz.getID();
            }
        }
        return BwDateTime.makeBwDateTime(dateType, val.toString(), tzid);
    }

    public static BwDateTime makeDateTime(DateProperty dtStart, boolean dateOnly, String dur) {
        DtEnd dtEnd;
        java.util.Date endDt = new Dur(dur).getTime((java.util.Date)dtStart.getDate());
        Parameter tzid = BwDateTime.getIcalParameter((Property)dtStart, "TZID");
        if (dateOnly) {
            ParameterList parl = new ParameterList();
            parl.add((Parameter)Value.DATE);
            dtEnd = new DtEnd(parl, new Date(endDt));
        } else {
            DateTime d = new DateTime(endDt);
            if (tzid != null) {
                DateTime sd = (DateTime)dtStart.getDate();
                d.setTimeZone(sd.getTimeZone());
            }
            dtEnd = new DtEnd((Date)d);
            if (tzid != null) {
                BwDateTime.addIcalParameter((Property)dtEnd, tzid);
            } else if (dtStart.isUtc()) {
                dtEnd.setUtc(true);
            }
        }
        return BwDateTime.makeBwDateTime((DateProperty)dtEnd);
    }

    public static BwDateTime fromUTC(boolean dateType, String date) {
        if (!dateType && !date.endsWith("Z")) {
            throw new RuntimeException("org.bedework.error.bad.date");
        }
        BwDateTime bwd = new BwDateTime();
        bwd.setDateType(dateType);
        bwd.setDtval(date);
        bwd.setTzid(null);
        if (dateType) {
            bwd.setDate(date + "T000000Z");
        } else {
            bwd.setDate(date);
        }
        return bwd;
    }

    public static BwDateTime fromUTC(boolean dateType, String date, String tzid) {
        if (!dateType && !date.endsWith("Z")) {
            throw new BedeworkException("org.bedework.error.bad.date");
        }
        try {
            BwDateTime bwd = new BwDateTime();
            bwd.setDateType(dateType);
            if (dateType | tzid == null) {
                bwd.setDtval(date);
                bwd.setTzid(null);
            } else {
                java.util.Date dt = DateTimeUtil.fromISODateTimeUTC((String)date);
                bwd.setDtval(DateTimeUtil.isoDateTime((java.util.Date)dt, (java.util.TimeZone)Timezones.getTz((String)tzid)));
                bwd.setTzid(tzid);
            }
            if (dateType) {
                bwd.setDate(date + "T000000Z");
            } else {
                bwd.setDate(date);
            }
            return bwd;
        }
        catch (Throwable t) {
            throw new BedeworkException("org.bedework.error.bad.date");
        }
    }

    public boolean getDateType() {
        return this.dateType;
    }

    @IcalProperties(value={@IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TZIDPAR, dbFieldName="tzid", param=true), @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TZID)})
    public String getTzid() {
        return this.fetchTzidSplit().getFld(0);
    }

    public void setFractional(String val) {
        this.assignTzidField(1, val);
    }

    public String getFractional() {
        return this.fetchTzidSplit().getFld(1);
    }

    @NoDump
    private String getTimezoneId() {
        return this.tzid;
    }

    public String getDtval() {
        return this.dtval;
    }

    public String getRange() {
        return this.range;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.UTC, jname="utc")
    private void setDate(String val) {
        this.date = val;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.LOCAL, jname="local")
    public String getDate() {
        return this.date;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.FLOATING, jname="floating")
    private void setFloatFlag(Boolean val) {
        this.floatFlag = val;
    }

    public Boolean getFloatFlag() {
        return this.floatFlag;
    }

    public boolean getFloating() {
        if (this.getFloatFlag() == null) {
            return false;
        }
        return this.floatFlag;
    }

    public boolean isUTC() {
        if (this.getDateType()) {
            return false;
        }
        try {
            return DateTimeUtil.isISODateTimeUTC((String)this.getDtval());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public DtEnd makeDtEnd() {
        return this.makeDtEnd(Timezones.getTzRegistry());
    }

    public DtEnd makeDtEnd(TimeZoneRegistry tzreg) {
        DtEnd dt = new DtEnd();
        this.initDateProp((DateProperty)dt, tzreg);
        return dt;
    }

    public Due makeDue(TimeZoneRegistry tzreg) {
        Due dt = new Due();
        this.initDateProp((DateProperty)dt, tzreg);
        return dt;
    }

    public BwDateTime copy() {
        return BwDateTime.makeBwDateTime((DateProperty)this.makeDtEnd());
    }

    public DtStart makeDtStart() {
        return this.makeDtStart(Timezones.getTzRegistry());
    }

    public DtStart makeDtStart(TimeZoneRegistry tzreg) {
        String tzid = this.getTzid();
        DtStart dt = new DtStart();
        ParameterList pl = dt.getParameters();
        if (this.getDateType()) {
            pl.add((Parameter)Value.DATE);
        } else if (tzid != null) {
            dt.setTimeZone(tzreg.getTimeZone(tzid));
        }
        try {
            dt.setValue(this.getDtval());
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        return dt;
    }

    public Date makeDate() {
        try {
            if (this.getDateType()) {
                return new Date(this.getDtval());
            }
            if (this.tzid != null) {
                return new DateTime(this.getDtval(), Timezones.getTz((String)this.tzid));
            }
            return new DateTime(this.getDtval());
        }
        catch (Throwable t) {
            this.checkRuntimeException(t);
            throw new RuntimeException(t);
        }
    }

    public static Dur makeDuration(BwDateTime start, BwDateTime end) {
        return new Dur((java.util.Date)start.makeDate(), (java.util.Date)end.makeDate());
    }

    public BwDateTime addDuration(BwDuration val) {
        return this.addDuration(val.makeDuration().getDuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BwDateTime getNextDay() {
        if (!this.getDateType()) {
            throw new RuntimeException("org.bedework.datetime.expect.dateonly");
        }
        try {
            Date dt = new Date(this.getDtval());
            Calendar calendar = dateIncrementor;
            synchronized (calendar) {
                dateIncrementor.setTime((java.util.Date)dt);
                dateIncrementor.add(5, 1);
                dt = new Date(dateIncrementor.getTime());
            }
            return BwDateTime.makeBwDateTime(dt);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public BwDateTime getPreviousDay() {
        if (!this.getDateType()) {
            throw new RuntimeException("Must be a date only value");
        }
        return BwDateTime.makeDateTime((DateProperty)this.makeDtStart(Timezones.getTzRegistry()), true, oneDayBack);
    }

    public BwDateTime addDur(String d) {
        return BwDateTime.makeDateTime((DateProperty)this.makeDtStart(Timezones.getTzRegistry()), this.getDateType(), d);
    }

    private void setDateType(boolean val) {
        this.dateType = val;
    }

    private void setTzid(String val) {
        this.tzid = val;
    }

    private void setTimezoneId(String val) {
        this.tzid = val;
    }

    private void setDtval(String val) {
        this.dtval = val;
        if (val == null) {
            this.setDate(null);
        }
    }

    private static void addIcalParameter(Property prop, Parameter val) {
        ParameterList parl = prop.getParameters();
        parl.add(val);
    }

    private static Parameter getIcalParameter(Property prop, String name) {
        ParameterList parl = prop.getParameters();
        if (parl == null) {
            return null;
        }
        return parl.getParameter(name);
    }

    private static String getTzid(DateProperty val) {
        Parameter tzidPar = BwDateTime.getIcalParameter((Property)val, "TZID");
        String tzid = null;
        if (tzidPar != null) {
            tzid = tzidPar.getValue();
        }
        return tzid;
    }

    private void initDateProp(DateProperty dt, TimeZoneRegistry tzreg) {
        String tzid = this.getTzid();
        ParameterList pl = dt.getParameters();
        if (this.getDateType()) {
            pl.add((Parameter)Value.DATE);
        }
        if (tzid != null) {
            dt.setTimeZone(tzreg.getTimeZone(tzid));
        }
        try {
            dt.setValue(this.getDtval());
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    private BwDateTime addDuration(TemporalAmount val) {
        DtEnd dtEnd;
        java.util.Date endDt = new TemporalAmountAdapter(val).getTime((java.util.Date)this.makeDate());
        DtStart dtStart = this.makeDtStart(Timezones.getTzRegistry());
        if (this.getDateType()) {
            dtEnd = new DtEnd(new Date(endDt));
            BwDateTime.addIcalParameter((Property)dtEnd, (Parameter)Value.DATE);
        } else {
            DateTime d = new DateTime(endDt);
            Parameter tzid = BwDateTime.getIcalParameter((Property)dtStart, "TZID");
            if (tzid != null) {
                DateTime sd = (DateTime)dtStart.getDate();
                d.setTimeZone(sd.getTimeZone());
            }
            dtEnd = new DtEnd((Date)d);
            if (tzid != null) {
                BwDateTime.addIcalParameter((Property)dtEnd, tzid);
            } else if (dtStart.isUtc()) {
                dtEnd.setUtc(true);
            }
        }
        return BwDateTime.makeBwDateTime((DateProperty)dtEnd);
    }

    @Override
    public int compare(BwDateTime dt1, BwDateTime dt2) {
        if (dt1 == dt2) {
            return 0;
        }
        return dt1.getDate().compareTo(dt2.getDate());
    }

    @Override
    public int compareTo(BwDateTime o2) {
        return this.compare(this, o2);
    }

    public boolean before(BwDateTime val) {
        return this.compare(this, val) < 0;
    }

    public boolean after(BwDateTime val) {
        return this.compare(this, val) > 0;
    }

    public int hashCode() {
        int hc = 1;
        if (this.getDateType()) {
            hc = 3;
        }
        if (this.getTzid() != null) {
            hc *= this.getTzid().hashCode();
        }
        if (this.getDtval() != null) {
            hc *= this.getDtval().hashCode();
        }
        return hc;
    }

    public int validate() {
        if (this.getDtval().length() == 8 && !this.getDateType()) {
            return 2;
        }
        if (this.getDateType()) {
            if (this.getDtval().length() > 8) {
                return 2;
            }
            if (this.getTzid() != null) {
                return 1;
            }
            return 0;
        }
        if (this.getDtval().length() == 16) {
            if (!this.getDtval().endsWith("Z")) {
                return 2;
            }
            if (this.getTzid() != null) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BwDateTime)) {
            return false;
        }
        BwDateTime that = (BwDateTime)obj;
        if (this.getDateType() != that.getDateType()) {
            return false;
        }
        if (!CalFacadeUtil.eqObjval(this.getTzid(), that.getTzid())) {
            return false;
        }
        return CalFacadeUtil.eqObjval(this.getDtval(), that.getDtval());
    }

    @Override
    public Object clone() {
        BwDateTime ndt = new BwDateTime();
        ndt.setDateType(this.getDateType());
        ndt.setTzid(this.getTzid());
        ndt.setDtval(this.getDtval());
        ndt.setDate(this.getDate());
        ndt.setFloatFlag(this.getFloatFlag());
        return ndt;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        if (this.getDateType()) {
            ts.append("DATE");
        } else {
            ts.append("DATETIME");
        }
        if (this.getTzid() != null) {
            ts.append("tzid", (Object)this.getTzid());
        }
        ts.append("dtval", (Object)this.getDtval());
        if (this.getFloating()) {
            ts.append("floating");
        } else if (this.isUTC()) {
            ts.append("UTC");
        } else {
            ts.append("UTC", (Object)this.getDate());
        }
        return ts.toString();
    }

    private FieldSplitter fetchTzidSplit() {
        if (this.tzidSplit == null) {
            this.tzidSplit = new FieldSplitter(fieldDelimiter);
            this.tzidSplit.setVal(this.getTimezoneId());
        }
        return this.tzidSplit;
    }

    private void assignTzidField(int index, String val) {
        this.fetchTzidSplit().setFld(index, val);
        this.setTimezoneId(this.fetchTzidSplit().getCombined());
    }

    private void checkRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }
}

