/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import org.bedework.base.ToString;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.ical.IcalProperty;
import org.bedework.util.calendar.PropertyIndex;

@Dump(elementName="event", keyFields={"colPath", "uid", "recurrenceId"}, firstFields={"ownerHref"})
public class BwEventAnnotation
extends BwEvent {
    private BwEvent target;
    private BwEvent master;
    private Boolean override;
    private String emptyFlags;
    private static final int flagsLen = BwEvent.ProxiedFieldIndex.values().length;
    private static final char[] initCflags = new char[flagsLen];

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.TARGET, annotationRequired=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setTarget(BwEvent val) {
        this.target = val;
    }

    public BwEvent getTarget() {
        return this.target;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.MASTER, annotationRequired=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setMaster(BwEvent val) {
        this.master = val;
    }

    public BwEvent getMaster() {
        return this.master;
    }

    @IcalProperty(pindex=PropertyIndex.PropertyInfoIndex.OVERRIDE, annotationRequired=true, eventProperty=true, todoProperty=true, journalProperty=true, freeBusyProperty=true)
    public void setOverride(Boolean val) {
        this.override = val;
    }

    public Boolean getOverride() {
        return this.override;
    }

    public boolean testOverride() {
        return this.getOverride() != null && this.getOverride() != false;
    }

    public void setEmptyFlags(String val) {
        this.emptyFlags = val;
    }

    public String getEmptyFlags() {
        return this.emptyFlags;
    }

    public void setEmptyFlag(BwEvent.ProxiedFieldIndex fieldIndex, boolean val) {
        char[] fs = null;
        if (this.getEmptyFlags() != null) {
            fs = this.getEmptyFlags().toCharArray();
        }
        if (fs == null) {
            fs = (char[])initCflags.clone();
        } else if (fs.length < flagsLen) {
            char[] newFs = (char[])initCflags.clone();
            System.arraycopy(fs, 0, newFs, 0, fs.length);
            fs = newFs;
        }
        int fsi = fieldIndex.ordinal();
        char newF = val ? (char)'T' : 'F';
        if (fs[fsi] != newF) {
            fs[fsi] = newF;
        }
        this.setEmptyFlags(new String(fs));
    }

    public Boolean getEmptyFlag(BwEvent.ProxiedFieldIndex fieldIndex) {
        char[] fs = null;
        if (this.getEmptyFlags() != null) {
            fs = this.getEmptyFlags().toCharArray();
        }
        if (fs == null) {
            return false;
        }
        int fsi = fieldIndex.ordinal();
        if (fs.length <= fsi) {
            return false;
        }
        return fs[fsi] == 'T';
    }

    @Override
    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("target", this.getTarget().getId());
        ts.append("master", this.getMaster().getId());
        ts.append("override", (Object)this.getOverride());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwEventAnnotation ev = new BwEventAnnotation();
        this.copyTo(ev);
        ev.setTarget(this.getTarget());
        ev.setMaster(this.getMaster());
        ev.setOverride(this.getOverride());
        return ev;
    }

    static {
        for (int i = 0; i < flagsLen; ++i) {
            BwEventAnnotation.initCflags[i] = 70;
        }
    }
}

