/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.base.ToString;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwShareableContainedDbentity;
import org.bedework.calfacade.base.DescriptionEntity;
import org.bedework.calfacade.base.DisplayNameEntity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.Util;

@Dump(elementName="filter", keyFields={"owner", "name"})
public class BwFilterDef
extends BwShareableContainedDbentity<BwFilterDef>
implements DescriptionEntity<BwLongString>,
DisplayNameEntity,
Comparator<BwFilterDef> {
    private String name;
    public static final int maxNameLength = 100;
    private Collection<BwString> displayNames;
    private String definition;
    private Set<BwLongString> descriptions;
    private FilterBase filters;

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void setFilters(FilterBase val) {
        this.filters = val;
    }

    @NoDump
    public FilterBase getFilters() {
        return this.filters;
    }

    public void setDefinition(String val) {
        this.definition = val;
    }

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public void setDisplayNames(Collection<BwString> val) {
        this.displayNames = val;
    }

    @Override
    @Dump(collectionElementName="displayName")
    public Collection<BwString> getDisplayNames() {
        return this.displayNames;
    }

    @Override
    @NoDump
    public int getNumDisplayNames() {
        Collection<BwString> rs = this.getDisplayNames();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    public void addDisplayName(String lang, String val) {
        this.addDisplayName(new BwString(lang, val));
    }

    @Override
    public void addDisplayName(BwString val) {
        Collection<BwString> rs = this.getDisplayNames();
        if (rs == null) {
            rs = new TreeSet<BwString>();
            this.setDisplayNames(rs);
        }
        if (!rs.contains(val)) {
            rs.add(val);
        }
    }

    @Override
    public boolean removeDisplayName(BwString val) {
        Collection<BwString> rs = this.getDisplayNames();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    public void updateDisplayNames(String lang, String val) {
        BwString s = this.findDisplayName(lang);
        if (val == null) {
            if (s != null) {
                this.removeDisplayName(s);
            }
        } else if (s == null) {
            this.addDisplayName(lang, val);
        } else if (CalFacadeUtil.cmpObjval(val, s.getValue()) != 0) {
            this.removeDisplayName(s);
            this.addDisplayName(lang, val);
        }
    }

    @Override
    public BwString findDisplayName(String lang) {
        return BwString.findLang(lang, this.getDisplayNames());
    }

    @Override
    public void setDisplayName(String val) {
        this.updateDisplayNames(null, val);
    }

    @Override
    @NoDump
    public String getDisplayName() {
        BwString s = this.findDisplayName(null);
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    @Override
    public void setDescriptions(Set<BwLongString> val) {
        this.descriptions = val;
    }

    @Override
    @Dump(collectionElementName="description")
    public Set<BwLongString> getDescriptions() {
        return this.descriptions;
    }

    @Override
    @NoDump
    public int getNumDescriptions() {
        Set<BwLongString> rs = this.getDescriptions();
        if (rs == null) {
            return 0;
        }
        return rs.size();
    }

    @Override
    public void addDescription(String lang, String val) {
        this.addDescription(new BwLongString(lang, val));
    }

    @Override
    public void addDescription(BwLongString val) {
        Set<BwLongString> rs = this.getDescriptions();
        if (rs == null) {
            rs = new TreeSet<BwLongString>();
            this.setDescriptions(rs);
        }
        rs.add(val);
    }

    @Override
    public boolean removeDescription(BwLongString val) {
        Set<BwLongString> rs = this.getDescriptions();
        if (rs == null) {
            return false;
        }
        return rs.remove(val);
    }

    @Override
    public void updateDescriptions(String lang, String val) {
        BwLongString s = this.findDescription(lang);
        if (val == null) {
            if (s != null) {
                this.removeDescription(s);
            }
        } else if (s == null) {
            this.addDescription(lang, val);
        } else if (CalFacadeUtil.cmpObjval(val, s.getValue()) != 0) {
            this.removeDescription(s);
            this.addDescription(lang, val);
        }
    }

    @Override
    public BwLongString findDescription(String lang) {
        return BwLongString.findLang(lang, this.getDescriptions());
    }

    @Override
    public void setDescription(String val) {
        this.updateDescriptions(null, val);
    }

    @Override
    @NoDump
    public String getDescription() {
        BwLongString s = this.findDescription(null);
        if (s == null) {
            return null;
        }
        return s.getValue();
    }

    void fixNames() {
        this.setColPath("filters", null);
        this.setHref(Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), this.getName()}));
    }

    @Override
    public String getColPath() {
        if (super.getColPath() == null) {
            this.fixNames();
        }
        return super.getColPath();
    }

    @Override
    public String getHref() {
        if (super.getHref() == null) {
            this.fixNames();
        }
        return super.getHref();
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.newLine();
        ts.append("name", (Object)this.getName());
        ts.append("description", (Object)this.getDescription());
    }

    @Override
    public int compare(BwFilterDef f1, BwFilterDef f2) {
        return f1.compareTo(f2);
    }

    @Override
    public int compareTo(BwFilterDef that) {
        int cmp = CalFacadeUtil.cmpObjval(this.getOwnerHref(), that.getOwnerHref());
        if (cmp != 0) {
            return cmp;
        }
        return CalFacadeUtil.cmpObjval(this.getName(), that.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }
}

