/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.component.Vote;
import net.fortuna.ical4j.model.property.CalendarAddress;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.EmailAddress;
import net.fortuna.ical4j.model.property.ExpectReply;
import net.fortuna.ical4j.model.property.Kind;
import net.fortuna.ical4j.model.property.Lang;
import net.fortuna.ical4j.model.property.MemberOf;
import net.fortuna.ical4j.model.property.Name;
import net.fortuna.ical4j.model.property.ParticipantType;
import net.fortuna.ical4j.model.property.ParticipationDelegatedFrom;
import net.fortuna.ical4j.model.property.ParticipationDelegatedTo;
import net.fortuna.ical4j.model.property.ParticipationStatus;
import net.fortuna.ical4j.model.property.SchedulingAgent;
import net.fortuna.ical4j.model.property.SchedulingDtStamp;
import net.fortuna.ical4j.model.property.SchedulingSequence;
import net.fortuna.ical4j.model.property.SchedulingStatus;
import net.fortuna.ical4j.model.property.Uid;
import org.bedework.base.ToString;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwVote;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.base.BwCloneable;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.base.Differable;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.util.misc.Util;

public class BwParticipant
extends BwDbentity<BwParticipant>
implements BwCloneable,
Differable<BwParticipant> {
    private final SchedulingInfo parent;
    private String stringRepresentation;
    private final Participant participant;

    public BwParticipant(SchedulingInfo parent) {
        this.parent = parent;
        this.participant = new Participant();
        this.participant.getProperties().add((Property)new Uid(org.bedework.util.misc.Uid.getUid()));
    }

    BwParticipant(SchedulingInfo parent, Participant participant) {
        this.parent = parent;
        this.participant = participant;
    }

    public SchedulingInfo getParent() {
        return this.parent;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public String getUid() {
        Uid p = this.participant.getUid();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setCalendarAddress(String val) {
        PropertyList props = this.participant.getProperties();
        CalendarAddress p = this.participant.getCalendarAddress();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        try {
            if (p == null) {
                this.participant.getProperties().add((Property)new CalendarAddress(val));
            } else if (!val.equals(p.getValue())) {
                p.setValue(val);
                this.changed();
            }
        }
        catch (URISyntaxException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public String getCalendarAddress() {
        CalendarAddress p = this.participant.getCalendarAddress();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setName(String val) {
        PropertyList props = this.participant.getProperties();
        Name p = this.participant.getNameProperty();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            this.participant.getProperties().add((Property)new Name(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getName() {
        Name p = this.participant.getNameProperty();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setDescription(String val) {
        PropertyList props = this.participant.getProperties();
        Description p = this.participant.getDescription();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new Description(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getDescription() {
        Description p = this.participant.getDescription();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setKind(String val) {
        PropertyList props = this.participant.getProperties();
        Kind p = this.participant.getKind();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new Kind(val));
            this.changed();
        } else if (!val.equals(p.getValue())) {
            props.remove((Property)p);
            props.add((Property)new Kind(val));
            this.changed();
        }
    }

    public String getKind() {
        Kind p = this.participant.getKind();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setParticipantType(String val) {
        PropertyList props = this.participant.getProperties();
        ParticipantType p = this.participant.getParticipantType();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new ParticipantType(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getParticipantType() {
        ParticipantType p = this.participant.getParticipantType();
        if (p == null || p.getValue() == null) {
            return null;
        }
        return p.getValue();
    }

    public Set<String> getParticipantTypes() {
        ParticipantType p = this.participant.getParticipantType();
        if (p == null) {
            return Collections.EMPTY_SET;
        }
        return p.getTypes().asSet();
    }

    public void removeParticipantType(String val) {
        ParticipantType p = this.participant.getParticipantType();
        if (p != null) {
            p.getTypes().remove(val);
        }
    }

    public void addParticipantType(String ... val) {
        ParticipantType p = this.participant.getParticipantType();
        for (String s : val) {
            if (p == null) {
                this.participant.getProperties().add((Property)new ParticipantType(s));
                continue;
            }
            p.getTypes().add(s);
        }
    }

    public void addParticipantType(Set<String> val) {
        ParticipantType p = this.participant.getParticipantType();
        for (String s : val) {
            if (p == null) {
                this.participant.getProperties().add((Property)new ParticipantType(s));
                continue;
            }
            p.getTypes().add(s);
        }
    }

    public boolean includesParticipantType(String val) {
        ParticipantType p = this.participant.getParticipantType();
        if (p == null) {
            return false;
        }
        return p.getTypes().containsIgnoreCase(val);
    }

    public void setParticipationStatus(String val) {
        PropertyList props = this.participant.getProperties();
        ParticipationStatus p = this.participant.getParticipationStatus();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
                return;
            }
        } else if (p == null) {
            props.add((Property)new ParticipationStatus(val));
        } else if (!val.equals(p.getValue())) {
            props.remove((Property)p);
            props.add((Property)new ParticipationStatus(val));
            this.changed();
        }
    }

    public String getParticipationStatus() {
        ParticipationStatus p = this.participant.getParticipationStatus();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setDelegatedFrom(String val) {
        PropertyList props = this.participant.getProperties();
        ParticipationDelegatedFrom p = (ParticipationDelegatedFrom)props.getProperty("PARTICIPATION-DELEGATED-FROM");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        try {
            if (p == null) {
                this.participant.getProperties().add((Property)new ParticipationDelegatedFrom(val));
            } else if (!val.equals(p.getValue())) {
                p.setValue(val);
                this.changed();
            }
        }
        catch (URISyntaxException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public String getDelegatedFrom() {
        ParticipationDelegatedFrom p = (ParticipationDelegatedFrom)this.participant.getProperties().getProperty("PARTICIPATION-DELEGATED-FROM");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setDelegatedTo(String val) {
        PropertyList props = this.participant.getProperties();
        ParticipationDelegatedTo p = (ParticipationDelegatedTo)props.getProperty("PARTICIPATION-DELEGATED-TO");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        try {
            if (p == null) {
                props.add((Property)new ParticipationDelegatedTo(val));
            } else if (!val.equals(p.getValue())) {
                p.setValue(val);
                this.changed();
            }
        }
        catch (URISyntaxException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public String getDelegatedTo() {
        ParticipationDelegatedTo p = (ParticipationDelegatedTo)this.participant.getProperties().getProperty("PARTICIPATION-DELEGATED-TO");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setLanguage(String val) {
        PropertyList props = this.participant.getProperties();
        Lang p = (Lang)props.getProperty("LANG");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new Lang(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getLanguage() {
        Lang p = (Lang)this.participant.getProperties().getProperty("LANG");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setMemberOf(String val) {
        PropertyList props = this.participant.getProperties();
        MemberOf p = (MemberOf)props.getProperty("MEMBER-OF");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        try {
            if (p == null) {
                props.add((Property)new MemberOf(val));
            } else if (!val.equals(p.getValue())) {
                p.setValue(val);
                this.changed();
            }
        }
        catch (URISyntaxException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public String getMemberOf() {
        MemberOf p = (MemberOf)this.participant.getProperties().getProperty("MEMBER-OF");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setExpectReply(boolean val) {
        PropertyList props = this.participant.getProperties();
        ExpectReply p = (ExpectReply)props.getProperty("EXPECT-REPLY");
        String sval = String.valueOf(val);
        if (p == null) {
            if (val) {
                props.add((Property)new ExpectReply(sval));
            }
        } else if (!sval.equals(p.getValue())) {
            if (!val) {
                props.remove((Property)p);
            } else {
                p.setValue(sval);
            }
            this.changed();
        }
    }

    public boolean getExpectReply() {
        ExpectReply p = (ExpectReply)this.participant.getProperties().getProperty("EXPECT-REPLY");
        if (p == null) {
            return false;
        }
        return Boolean.parseBoolean(p.getValue());
    }

    public void setEmail(String val) {
        PropertyList props = this.participant.getProperties();
        EmailAddress p = this.participant.getEmail();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        try {
            if (p == null) {
                props.add((Property)new EmailAddress(val));
            } else if (!val.equals(p.getValue())) {
                p.setValue(val);
                this.changed();
            }
        }
        catch (ParseException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public String getEmail() {
        EmailAddress p = this.participant.getEmail();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setInvitedBy(String val) {
        PropertyList props = this.participant.getProperties();
        SchedulingSequence p = (SchedulingSequence)props.getProperty("INVITED-BY");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new Lang(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getInvitedBy() {
        Lang p = (Lang)this.participant.getProperties().getProperty("INVITED-BY");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setSequence(int val) {
        PropertyList props = this.participant.getProperties();
        SchedulingSequence p = (SchedulingSequence)props.getProperty("SCHEDULING-SEQUENCE");
        String sval = String.valueOf(val);
        if (p == null) {
            if (val != 0) {
                props.add((Property)new SchedulingSequence(val));
            }
        } else if (!sval.equals(p.getValue())) {
            if (val == 0) {
                props.remove((Property)p);
            } else {
                p.setValue(sval);
            }
            this.changed();
        }
    }

    public int getSequence() {
        SchedulingSequence p = (SchedulingSequence)this.participant.getProperties().getProperty("SCHEDULING-SEQUENCE");
        if (p == null) {
            return 0;
        }
        return p.getSequenceNo();
    }

    public void setSchedulingDtStamp(String val) {
        PropertyList props = this.participant.getProperties();
        SchedulingDtStamp p = this.participant.getSchedulingDtStamp();
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        try {
            if (p == null) {
                props.add((Property)new SchedulingDtStamp(val));
            } else if (!val.equals(p.getValue())) {
                p.setValue(val);
                this.changed();
            }
        }
        catch (ParseException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public String getSchedulingDtStamp() {
        SchedulingDtStamp p = this.participant.getSchedulingDtStamp();
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setScheduleAgent(String val) {
        PropertyList props = this.participant.getProperties();
        SchedulingAgent p = (SchedulingAgent)props.getProperty("SCHEDULING-AGENT");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new SchedulingAgent(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getScheduleAgent() {
        SchedulingAgent p = (SchedulingAgent)this.participant.getProperties().getProperty("SCHEDULING-AGENT");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public void setScheduleStatus(String val) {
        PropertyList props = this.participant.getProperties();
        SchedulingStatus p = (SchedulingStatus)props.getProperty("SCHEDULING-STATUS");
        if (val == null) {
            if (p != null) {
                props.remove((Property)p);
                this.changed();
            }
            return;
        }
        if (p == null) {
            props.add((Property)new SchedulingStatus(val));
        } else if (!val.equals(p.getValue())) {
            p.setValue(val);
            this.changed();
        }
    }

    public String getScheduleStatus() {
        SchedulingStatus p = (SchedulingStatus)this.participant.getProperties().getProperty("SCHEDULING-STATUS");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public List<BwVote> getVotes() {
        ComponentList comps = this.participant.getComponents();
        ComponentList c = comps.getComponents("VOTE");
        ArrayList<BwVote> votes = new ArrayList<BwVote>();
        for (Component cv : c) {
            votes.add(new BwVote(this, (Vote)cv));
        }
        return votes;
    }

    public void setVotes(List<BwVote> val) {
        ComponentList comps = this.participant.getComponents();
        ComponentList c = comps.getComponents("VOTE");
        comps.removeAll((Collection)c);
        for (BwVote v : val) {
            comps.add((Object)v.getVote());
        }
        this.changed();
    }

    public void addVote(BwVote val) {
        ComponentList comps = this.participant.getComponents();
        ComponentList c = comps.getComponents("VOTE");
        int id = val.getPollItemId();
        ChangeTable ctab = this.parent.getParent().getChangeset();
        BwVote vote = null;
        for (Component cv : c) {
            BwVote bwv = new BwVote(this, (Vote)cv);
            if (id != bwv.getPollItemId()) continue;
            vote = bwv;
            break;
        }
        if (vote == null) {
            comps.add((Object)val.getVote());
            this.changed();
            return;
        }
        vote.setResponse(val.getResponse());
        this.changed();
    }

    public void copyTo(BwParticipant val) {
        val.setCalendarAddress(this.getCalendarAddress());
        val.setKind(this.getKind());
        val.setName(this.getName());
        val.setParticipantType(this.getParticipantType());
        val.setParticipationStatus(this.getParticipationStatus());
        val.setDelegatedFrom(this.getDelegatedFrom());
        val.setDelegatedTo(this.getDelegatedTo());
        val.setLanguage(this.getLanguage());
        val.setMemberOf(this.getMemberOf());
        val.setExpectReply(this.getExpectReply());
        val.setEmail(this.getEmail());
        val.setInvitedBy(this.getInvitedBy());
        val.setSequence(this.getSequence());
        val.setSchedulingDtStamp(this.getSchedulingDtStamp());
        val.setScheduleAgent(this.getScheduleAgent());
        val.setScheduleStatus(this.getScheduleStatus());
        val.setVotes(this.getVotes());
    }

    public void copyToMerge(BwParticipant val) {
        val.setCalendarAddress(this.getCalendarAddress());
        val.setKind(this.getKind());
        val.setName(this.getName());
        Set<String> types = val.getParticipantTypes();
        if (!types.isEmpty()) {
            this.addParticipantType(types);
        }
        val.setParticipationStatus(this.getParticipationStatus());
        val.setDelegatedFrom(this.getDelegatedFrom());
        val.setDelegatedTo(this.getDelegatedTo());
        val.setLanguage(this.getLanguage());
        val.setMemberOf(this.getMemberOf());
        val.setExpectReply(this.getExpectReply());
        val.setEmail(this.getEmail());
        val.setInvitedBy(this.getInvitedBy());
        val.setSequence(this.getSequence());
        val.setSchedulingDtStamp(this.getSchedulingDtStamp());
        val.setScheduleAgent(this.getScheduleAgent());
        val.setScheduleStatus(this.getScheduleStatus());
        val.setVotes(this.getVotes());
    }

    public boolean changedBy(BwParticipant val) {
        return this.changedBy(val, true);
    }

    public boolean changedBy(BwParticipant val, boolean checkPartStat) {
        return checkPartStat && Util.compareStrings((String)val.getParticipationStatus(), (String)this.getParticipationStatus()) != 0 || Util.compareStrings((String)val.getCalendarAddress(), (String)this.getCalendarAddress()) != 0 || Util.compareStrings((String)val.getKind(), (String)this.getKind()) != 0 || Util.compareStrings((String)val.getName(), (String)this.getName()) != 0 || Util.compareStrings((String)val.getParticipantType(), (String)this.getParticipantType()) != 0 || Util.compareStrings((String)val.getDelegatedFrom(), (String)this.getDelegatedFrom()) != 0 || Util.compareStrings((String)val.getDelegatedTo(), (String)this.getDelegatedTo()) != 0 || Util.compareStrings((String)val.getLanguage(), (String)this.getLanguage()) != 0 || Util.compareStrings((String)val.getMemberOf(), (String)this.getMemberOf()) != 0 || Util.compareStrings((String)val.getEmail(), (String)this.getEmail()) != 0 || Util.compareStrings((String)val.getInvitedBy(), (String)this.getInvitedBy()) != 0 || Util.cmpObjval(val.getVotes(), this.getVotes()) != 0;
    }

    @Override
    public boolean differsFrom(BwParticipant val) {
        return Util.compareStrings((String)val.getParticipationStatus(), (String)this.getParticipationStatus()) != 0 || Util.compareStrings((String)val.getCalendarAddress(), (String)this.getCalendarAddress()) != 0 || Util.compareStrings((String)val.getKind(), (String)this.getKind()) != 0 || Util.compareStrings((String)val.getName(), (String)this.getName()) != 0 || Util.compareStrings((String)val.getParticipantType(), (String)this.getParticipantType()) != 0 || Util.compareStrings((String)val.getDelegatedFrom(), (String)this.getDelegatedFrom()) != 0 || Util.compareStrings((String)val.getDelegatedTo(), (String)this.getDelegatedTo()) != 0 || Util.compareStrings((String)val.getLanguage(), (String)this.getLanguage()) != 0 || Util.compareStrings((String)val.getMemberOf(), (String)this.getMemberOf()) != 0 || Util.cmpBoolval((boolean)val.getExpectReply(), (boolean)this.getExpectReply()) != 0 || Util.compareStrings((String)val.getEmail(), (String)this.getEmail()) != 0 || Util.compareStrings((String)val.getInvitedBy(), (String)this.getInvitedBy()) != 0 || Util.compareStrings((String)val.getScheduleAgent(), (String)this.getScheduleAgent()) != 0 || Util.cmpObjval(val.getVotes(), this.getVotes()) != 0;
    }

    @Override
    public int hashCode() {
        String uid = this.getUid();
        if (uid != null) {
            return uid.hashCode();
        }
        return this.getCalendarAddress().hashCode();
    }

    public boolean equals(BwParticipant val) {
        if (val == null) {
            return false;
        }
        return this.getCalendarAddress().equals(val.getCalendarAddress());
    }

    @Override
    public int compareTo(BwParticipant that) {
        if (this == that) {
            return 0;
        }
        String uid = this.getUid();
        if (uid != null) {
            return uid.compareTo(that.getUid());
        }
        return this.getCalendarAddress().compareTo(that.getCalendarAddress());
    }

    public String asString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.participant.toString();
        }
        return this.stringRepresentation;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.newLine().append(this.asString()).toString();
    }

    @Override
    public Object clone() {
        BwParticipant nobj = new BwParticipant(this.parent);
        this.copyTo(nobj);
        return nobj;
    }

    void changed() {
        this.parent.markChanged();
        this.stringRepresentation = null;
    }
}

