/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.bedework.access.AccessException;
import org.bedework.access.AccessPrincipal;
import org.bedework.base.ToString;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocpr;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.BwUser;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.FromXmlCallback;

@Dump(firstFields={"account", "principalRef"})
@JsonIgnoreProperties(value={"aclAccount"})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class BwPrincipal<T extends BwPrincipal<?>>
extends BwDbentity<BwPrincipal<?>>
implements AccessPrincipal,
Comparator<BwPrincipal<?>> {
    public static final String principalRoot = "/principals/";
    public static final String groupPrincipalRoot = "/principals/groups/";
    public static final String hostPrincipalRoot = "/principals/hosts/";
    public static final String resourcePrincipalRoot = "/principals/resources/";
    public static final String ticketPrincipalRoot = "/principals/tickets/";
    public static final String userPrincipalRoot = "/principals/users/";
    public static final String venuePrincipalRoot = "/principals/locations/";
    public static final String bwadmingroupPrincipalRoot = "/principals/groups/bwadmin/";
    public static final String publicUser = "public-user";
    public static final String publicUserHref = Util.buildPath((boolean)false, (String[])new String[]{"/principals/users/", "public-user"});
    public static final String calsuitePrincipalRoot = "/principals/calsuites/";
    private static final HashMap<String, Integer> toWho = new HashMap();
    private static final HashMap<Integer, String> fromWho = new HashMap();
    private String account;
    private String principalRef;
    protected Timestamp created;
    private String description;
    protected Timestamp logon;
    protected Timestamp lastAccess;
    protected Timestamp lastModify;
    private long quota;
    protected String categoryAccess;
    protected String contactAccess;
    protected String locationAccess;
    protected boolean unauthenticated;
    protected BwPrincipalInfo principalInfo;
    protected Collection<BwGroup<?>> groups;
    protected Collection<String> groupNames;
    private static FromXmlCallback fromXmlCb;

    public static BwPrincipal<?> makePrincipal(int whoType) {
        if (whoType == 1) {
            return BwPrincipal.makeUserPrincipal();
        }
        if (whoType == 2) {
            return BwPrincipal.makeGroupPrincipal();
        }
        if (whoType == 6) {
            return BwPrincipal.makeLocationPrincipal();
        }
        return null;
    }

    public static BwPrincipal<?> makeUserPrincipal() {
        return new BwUser();
    }

    public static BwPrincipal<?> makeGroupPrincipal() {
        return new BwGroup();
    }

    public static BwPrincipal<?> makeLocationPrincipal() {
        return new BwLocpr();
    }

    public static boolean isPrincipal(String href) {
        if (href == null) {
            return false;
        }
        int pos1 = href.indexOf("/", 1);
        if (pos1 < 0) {
            return false;
        }
        if (!href.substring(0, pos1 + 1).equals(principalRoot)) {
            return false;
        }
        int pos2 = href.indexOf("/", pos1 + 1);
        if (pos2 < 0) {
            return false;
        }
        for (String root : toWho.keySet()) {
            if (!href.startsWith(root)) continue;
            return !href.equals(root);
        }
        return false;
    }

    public static BwPrincipal<?> makePrincipal(String href) {
        try {
            if (href.startsWith(calsuitePrincipalRoot)) {
                return new BwCalSuite();
            }
            String uri = URLDecoder.decode(new URI(URLEncoder.encode(href, StandardCharsets.UTF_8)).getPath(), StandardCharsets.UTF_8);
            if (!BwPrincipal.isPrincipal(uri)) {
                return null;
            }
            int start = -1;
            int end = uri.length();
            if (uri.endsWith("/")) {
                --end;
            }
            for (String prefix : toWho.keySet()) {
                if (!uri.startsWith(prefix)) continue;
                if (uri.equals(prefix)) {
                    return null;
                }
                int whoType = toWho.get(prefix);
                String who = whoType == 1 || whoType == 2 ? uri.substring(prefix.length(), end) : uri;
                BwAdminGroup p = whoType == 2 && uri.startsWith(bwadmingroupPrincipalRoot) ? new BwAdminGroup() : BwPrincipal.makePrincipal(whoType);
                if (p == null) continue;
                p.setAccount(who);
                p.setPrincipalRef(uri);
                return p;
            }
            throw new BedeworkException("org.bedework.exception.principalnotfound");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String makePrincipalHref(String id, int whoType) throws AccessException {
        if (BwPrincipal.isPrincipal(id)) {
            return id;
        }
        String root = fromWho.get(whoType);
        if (root == null) {
            throw new AccessException("org.bedework.exception.unknownprincipaltype");
        }
        return Util.buildPath((boolean)true, (String[])new String[]{root, "/", id});
    }

    @NoDump
    public abstract int getKind();

    public void setKind(int ignoredVal) {
    }

    public void setUnauthenticated(boolean val) {
        this.unauthenticated = val;
    }

    @NoDump
    public boolean getUnauthenticated() {
        if (this.getAccount() == null) {
            return true;
        }
        return this.unauthenticated;
    }

    public void setAccount(String val) {
        this.account = val;
    }

    public String getAccount() {
        return this.account;
    }

    @NoDump
    public String getAclAccount() {
        return this.account;
    }

    public void setPrincipalRef(String val) {
        this.principalRef = val;
    }

    public void setDescription(String val) {
        this.description = val;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrincipalRef() {
        return this.principalRef;
    }

    public void setCreated(Timestamp val) {
        this.created = val;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public void setLogon(Timestamp val) {
        this.logon = val;
    }

    public Timestamp getLogon() {
        return this.logon;
    }

    public void setLastAccess(Timestamp val) {
        this.lastAccess = val;
    }

    public Timestamp getLastAccess() {
        return this.lastAccess;
    }

    public void setLastModify(Timestamp val) {
        this.lastModify = val;
    }

    public Timestamp getLastModify() {
        return this.lastModify;
    }

    public void setQuota(long val) {
        this.quota = val;
    }

    public long getQuota() {
        return this.quota;
    }

    public void setCategoryAccess(String val) {
        this.categoryAccess = val;
    }

    public String getCategoryAccess() {
        return this.categoryAccess;
    }

    public void setLocationAccess(String val) {
        this.locationAccess = val;
    }

    public String getLocationAccess() {
        return this.locationAccess;
    }

    public void setContactAccess(String val) {
        this.contactAccess = val;
    }

    public String getContactAccess() {
        return this.contactAccess;
    }

    @NoDump
    @JsonIgnore
    public String getAccountNoSlash() {
        String res = this.getAccount();
        if (res.startsWith("/")) {
            res = res.substring(1);
        }
        if (res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    @NoDump
    @JsonIgnore
    public String[] getAccountSplit() {
        String res = this.getAccount();
        if (!res.contains("/")) {
            return new String[]{res};
        }
        return res.split("/");
    }

    public void setGroups(Collection<BwGroup<?>> val) {
        this.groupNames = null;
        this.groups = val;
    }

    @NoDump
    @JsonIgnore
    public Collection<BwGroup<?>> getGroups() {
        if (this.groups == null) {
            this.groups = new TreeSet();
        }
        return this.groups;
    }

    public void setPrincipalInfo(BwPrincipalInfo val) {
        this.principalInfo = val;
    }

    @JsonIgnore
    public BwPrincipalInfo getPrincipalInfo() {
        return this.principalInfo;
    }

    @Override
    public void setHref(String val) {
        this.setPrincipalRef(val);
    }

    @Override
    public String getHref() {
        return this.getPrincipalRef();
    }

    public void addGroup(BwGroup<?> val) {
        this.getGroups().add(val);
    }

    public void setGroupNames(Collection<String> val) {
        this.groupNames = val;
    }

    @NoDump
    @JsonIgnore
    public Collection<String> getGroupNames() {
        if (this.groupNames == null) {
            this.groupNames = new TreeSet<String>();
            for (BwGroup<?> group : this.getGroups()) {
                this.groupNames.add(group.getPrincipalRef());
            }
        }
        return this.groupNames;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("account", (Object)this.getAccount()).append("pref", (Object)this.getPrincipalRef()).append("created", (Object)this.getCreated()).newLine().append("logon", (Object)this.getLogon()).append("lastAccess", (Object)this.getLastAccess()).append("lastModify", (Object)this.getLastModify()).append("kind", this.getKind());
        ts.append("quota", Long.valueOf(this.getQuota()));
    }

    public static void toStringSegment(ToString ts, String name, BwPrincipal<?> val) {
        if (val == null) {
            ts.append(name, (Object)"**NULL**");
        } else {
            ts.append(name, (Object)("(" + val.getId() + ", " + val.getPrincipalRef() + ")"));
        }
    }

    private static void initWhoMaps(String prefix, int whoType) {
        toWho.put(prefix, whoType);
        fromWho.put(whoType, prefix);
    }

    public void copyTo(BwPrincipal<?> val) {
        val.setAccount(this.getAccount());
        val.setPrincipalRef(this.getPrincipalRef());
        val.setId(this.getId());
        val.setSeq(this.getSeq());
        val.setCreated(this.getCreated());
        val.setLogon(this.getLogon());
        val.setLastAccess(this.getLastAccess());
        val.setLastModify(this.getLastModify());
        val.setCategoryAccess(this.getCategoryAccess());
        val.setLocationAccess(this.getLocationAccess());
        val.setContactAccess(this.getContactAccess());
        val.setGroups(this.getGroups());
    }

    @NoDump
    public static FromXmlCallback getRestoreCallback() {
        if (fromXmlCb == null) {
            fromXmlCb = new FromXmlCallback(){
                protected Timestamp lastAccess;
                protected Timestamp lastModify;

                public Object simpleValue(Class cl, String val) {
                    if (cl.getCanonicalName().equals(Timestamp.class.getCanonicalName())) {
                        return Timestamp.valueOf(val);
                    }
                    return null;
                }
            };
            fromXmlCb.addSkips(new String[]{"id", "seq"});
        }
        return fromXmlCb;
    }

    @Override
    public int compareTo(BwPrincipal that) {
        if (that == this) {
            return 0;
        }
        return this.compare(this, that);
    }

    @Override
    public int compare(BwPrincipal p1, BwPrincipal p2) {
        if (p1.getKind() < p2.getKind()) {
            return -1;
        }
        if (p1.getKind() > p2.getKind()) {
            return 1;
        }
        return CalFacadeUtil.compareStrings(p1.getAccount(), p2.getAccount());
    }

    @Override
    public int hashCode() {
        int hc = 7 * (this.getKind() + 1);
        if (this.account != null) {
            hc = this.account.hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BwPrincipal)) {
            return false;
        }
        return this.compareTo((BwPrincipal)o) == 0;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public abstract Object clone();

    static {
        BwPrincipal.initWhoMaps(userPrincipalRoot, 1);
        BwPrincipal.initWhoMaps(groupPrincipalRoot, 2);
        BwPrincipal.initWhoMaps(ticketPrincipalRoot, 4);
        BwPrincipal.initWhoMaps(resourcePrincipalRoot, 5);
        BwPrincipal.initWhoMaps(venuePrincipalRoot, 6);
        BwPrincipal.initWhoMaps(hostPrincipalRoot, 3);
        BwPrincipal.initWhoMaps(bwadmingroupPrincipalRoot, 2);
    }
}

