/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.property.Capacity;
import net.fortuna.ical4j.vcard.property.Categories;
import net.fortuna.ical4j.vcard.property.Kind;
import net.fortuna.ical4j.vcard.property.MaxInstances;
import net.fortuna.ical4j.vcard.property.NoCost;
import org.bedework.base.ToString;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.vcard.JsonCardBuilder;

public class BwPrincipalInfo
implements Logged,
Comparable<BwPrincipalInfo>,
Serializable {
    protected String principalHref;
    private VCard card;
    private String cardStr;
    private String lastname;
    private String firstname;
    private String phone;
    private String email;
    private String dept;
    private String caladruri;
    private String kind;
    private boolean hasFullAccess;
    private List<BwPrincipalInfo> members;
    private List<PrincipalProperty<?>> properties;
    public static final int ptypeString = 0;
    public static final int ptypeInt = 1;
    public static final int ptypeBoolean = 2;
    public static final int ptypeImage = 3;
    public static final boolean isMulti = true;
    private static final Map<String, PrincipalPropertyInfo> pinfoMap = new HashMap<String, PrincipalPropertyInfo>();
    private final BwLogger logger = new BwLogger();

    public void setPrincipalHref(String val) {
        this.principalHref = val;
    }

    public String getPrincipalHref() {
        return this.principalHref;
    }

    public VCard getCard() {
        return this.card;
    }

    public String getCardStr() {
        return this.cardStr;
    }

    public void setLastname(String val) {
        this.lastname = val;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setFirstname(String val) {
        this.firstname = val;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setPhone(String val) {
        this.phone = val;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setEmail(String val) {
        this.email = val;
    }

    public String getEmail() {
        return this.email;
    }

    public void setDept(String val) {
        this.dept = val;
    }

    public String getDept() {
        return this.dept;
    }

    public void setKind(String val) {
        this.kind = val;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean getHasFullAccess() {
        return this.hasFullAccess;
    }

    public void setCaladruri(String val) {
        this.caladruri = val;
    }

    public String getCaladruri() {
        return this.caladruri;
    }

    public void setProperties(List<PrincipalProperty<?>> val) {
        this.properties = val;
    }

    public List<PrincipalProperty<?>> getProperties() {
        return this.properties;
    }

    public void setMembers(List<BwPrincipalInfo> val) {
        this.members = val;
    }

    public List<BwPrincipalInfo> getMembers() {
        return this.members;
    }

    public void addProperty(PrincipalProperty<?> val) {
        List<PrincipalProperty<?>> c = this.getProperties();
        if (c == null) {
            c = new ArrayList();
            this.setProperties(c);
        }
        if (!c.contains(val)) {
            c.add(val);
        }
    }

    public PrincipalProperty<?> findProperty(String name) {
        List<PrincipalProperty<?>> l = this.getProperties();
        if (l == null) {
            return null;
        }
        for (PrincipalProperty<?> p : l) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    public List<PrincipalProperty<?>> getProperties(String name) {
        ArrayList res = new ArrayList();
        List<PrincipalProperty<?>> l = this.getProperties();
        if (l == null) {
            return res;
        }
        for (PrincipalProperty<?> p : l) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            res.add(p);
        }
        return res;
    }

    public void addProperty(PrincipalPropertyInfo pi, Property p) {
        switch (p.getId()) {
            case KIND: {
                this.setKind(p.getValue());
                this.addProperty(new PrincipalProperty<String>("kind", p.getValue()));
                break;
            }
            case FN: {
                this.addProperty(new PrincipalProperty<String>("fn", p.getValue()));
                break;
            }
            case N: {
                if (p.getValue() == null) break;
                String[] split = p.getValue().split(";");
                if (split.length > 0) {
                    this.setLastname(split[0]);
                }
                if (split.length > 1) {
                    this.setFirstname(split[1]);
                }
                this.addProperty(new PrincipalProperty<String>("n", p.getValue()));
                break;
            }
            case CALADRURI: {
                this.setCaladruri(p.getValue());
                this.addProperty(new PrincipalProperty<String>("caladruri", p.getValue()));
                break;
            }
            case EMAIL: {
                this.setEmail(p.getValue());
                this.addProperty(new PrincipalProperty<String>("email", p.getValue()));
                break;
            }
            case ORG: {
                this.addProperty(new PrincipalProperty<String>("ou", p.getValue()));
                break;
            }
            case CATEGORIES: {
                Iterator it = ((Categories)p).getCategories().iterator();
                while (it.hasNext()) {
                    this.addProperty(new PrincipalProperty<String>("category", (String)it.next()));
                }
                break;
            }
            case PHOTO: {
                break;
            }
            case CAPACITY: {
                this.addProperty(new IntPrincipalProperty("capacity", ((Capacity)p).getInteger()));
                break;
            }
            case AUTOSCHEDULE: {
                this.addProperty(new PrincipalProperty<String>("auto-schedule", p.getValue()));
                break;
            }
            case SCHEDADMININFO: {
                this.addProperty(new PrincipalProperty<String>("admin-url", p.getValue()));
                break;
            }
            case MAXINSTANCES: {
                this.addProperty(new IntPrincipalProperty("max-instances", ((MaxInstances)p).getInteger()));
                break;
            }
            case BOOKINGWINDOWSTART: {
                this.addProperty(new PrincipalProperty<String>("schedule-window-start", p.getValue()));
                break;
            }
            case BOOKINGWINDOWEND: {
                this.addProperty(new PrincipalProperty<String>("schedule-window-end", p.getValue()));
                break;
            }
            case NOCOST: {
                this.addProperty(new BooleanPrincipalProperty("nocost", ((NoCost)p).getBoolean()));
            }
        }
    }

    public static Collection<PrincipalPropertyInfo> getPrincipalPropertyInfoSet() {
        return pinfoMap.values();
    }

    public void setPropertiesFromVCard(String cardStr, String addrDataCtype) {
        if (cardStr == null) {
            return;
        }
        this.cardStr = cardStr;
        this.addProperty(new PrincipalProperty<String>("vcard", cardStr));
        try {
            this.card = "application/vcard+json".equals(addrDataCtype) ? new JsonCardBuilder(null).build((Reader)new StringReader(cardStr)) : new VCardBuilder((Reader)new StringReader(cardStr)).build();
            Property piprop = this.card.getExtendedProperty("X-BW-PRINCIPALHREF");
            if (piprop != null) {
                this.setPrincipalHref(piprop.getValue());
            }
            if ((piprop = this.card.getExtendedProperty("X-ICAL4J-TOV3-KIND")) != null) {
                this.setKind(piprop.getValue());
            }
            if (this.getKind() == null && (piprop = this.card.getProperty(Property.Id.MEMBER)) != null) {
                this.setKind(Kind.GROUP.getValue());
            }
            for (PrincipalPropertyInfo ppi : BwPrincipalInfo.getPrincipalPropertyInfoSet()) {
                Property.Id pname = ppi.getVcardPname();
                if (pname == null) continue;
                if (!ppi.getMulti()) {
                    Property prop = this.card.getProperty(pname);
                    if (prop == null) continue;
                    this.addProperty(ppi, prop);
                    continue;
                }
                List ps = this.card.getProperties(pname);
                if (Util.isEmpty((Collection)ps)) continue;
                for (Property prop : ps) {
                    this.addProperty(ppi, prop);
                }
            }
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.debug("CardStr was " + cardStr);
            }
            throw new RuntimeException(t);
        }
    }

    @Override
    public int compareTo(BwPrincipalInfo that) {
        if (this == that) {
            return 0;
        }
        return this.getPrincipalHref().compareTo(that.getPrincipalHref());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BwPrincipalInfo)) {
            return false;
        }
        return this.compareTo((BwPrincipalInfo)obj) == 0;
    }

    public int hashCode() {
        return 7 * this.getPrincipalHref().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("user", (Object)this.getPrincipalHref());
        ts.append("lastName", (Object)this.getLastname());
        ts.append("kind", (Object)this.getKind());
        ts.append("caladruri", (Object)this.getCaladruri());
        ts.append("properties", this.getProperties(), true);
        return ts.toString();
    }

    private static void addPinfo(Property.Id vcardPname, String name) {
        BwPrincipalInfo.addPinfo(vcardPname, name, 0, false);
    }

    private static void addPinfo(Property.Id vcardPname, String name, boolean multi) {
        BwPrincipalInfo.addPinfo(vcardPname, name, 0, multi);
    }

    private static void addPinfo(Property.Id vcardPname, String name, int ptype) {
        BwPrincipalInfo.addPinfo(vcardPname, name, ptype, false);
    }

    private static void addPinfo(Property.Id vcardPname, String name, int ptype, boolean multi) {
        String lcname = name.toLowerCase();
        pinfoMap.put(lcname, new PrincipalPropertyInfo(vcardPname, lcname, ptype, multi));
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    static {
        BwPrincipalInfo.addPinfo(Property.Id.KIND, "kind");
        BwPrincipalInfo.addPinfo(null, "principal-class", 1);
        BwPrincipalInfo.addPinfo(Property.Id.FN, "fn");
        BwPrincipalInfo.addPinfo(Property.Id.N, "n");
        BwPrincipalInfo.addPinfo(null, "vcard");
        BwPrincipalInfo.addPinfo(Property.Id.ORG, "ou");
        BwPrincipalInfo.addPinfo(Property.Id.EMAIL, "email");
        BwPrincipalInfo.addPinfo(Property.Id.CALADRURI, "caladruri");
        BwPrincipalInfo.addPinfo(Property.Id.CATEGORIES, "category", true);
        BwPrincipalInfo.addPinfo(Property.Id.PHOTO, "image", 3, true);
        BwPrincipalInfo.addPinfo(Property.Id.CAPACITY, "capacity", 1);
        BwPrincipalInfo.addPinfo(Property.Id.AUTOSCHEDULE, "auto-schedule");
        BwPrincipalInfo.addPinfo(Property.Id.SCHEDADMININFO, "admin-url");
        BwPrincipalInfo.addPinfo(Property.Id.MAXINSTANCES, "max-instances", 1);
        BwPrincipalInfo.addPinfo(Property.Id.BOOKINGWINDOWSTART, "schedule-window-start");
        BwPrincipalInfo.addPinfo(Property.Id.BOOKINGWINDOWEND, "schedule-window-end");
        BwPrincipalInfo.addPinfo(Property.Id.NOCOST, "nocost", 2);
    }

    public static class PrincipalProperty<T>
    implements Comparable<PrincipalProperty<T>> {
        private final String name;
        private final T val;

        public PrincipalProperty(String name, T val) {
            this.name = name;
            this.val = val;
        }

        public String getName() {
            return this.name;
        }

        public T getVal() {
            return this.val;
        }

        @Override
        public int compareTo(PrincipalProperty that) {
            if (this == that) {
                return 0;
            }
            int ret = CalFacadeUtil.compareStrings(this.name, that.name);
            if (ret != 0) {
                return ret;
            }
            if (this.val instanceof Comparable) {
                return ((Comparable)this.val).compareTo(that.val);
            }
            return -1;
        }

        public String toString() {
            ToString ts = new ToString((Object)this);
            ts.append("name", (Object)this.getName());
            ts.append("val", this.getVal());
            return ts.toString();
        }
    }

    public static class IntPrincipalProperty
    extends PrincipalProperty<Integer> {
        public IntPrincipalProperty(String name, Integer val) {
            super(name, val);
        }
    }

    public static class BooleanPrincipalProperty
    extends PrincipalProperty<Boolean> {
        public BooleanPrincipalProperty(String name, Boolean val) {
            super(name, val);
        }
    }

    public static class PrincipalPropertyInfo {
        private final Property.Id vcardPname;
        public String name;
        public int ptype;
        public boolean multi;

        PrincipalPropertyInfo(Property.Id vcardPname, String name, int ptype, boolean multi) {
            this.vcardPname = vcardPname;
            this.name = name;
            this.ptype = ptype;
            this.multi = multi;
        }

        public Property.Id getVcardPname() {
            return this.vcardPname;
        }

        public String getName() {
            return this.name;
        }

        public int getPtype() {
            return this.ptype;
        }

        public boolean getMulti() {
            return this.multi;
        }
    }

    public static class ImagePrincipalProperty
    extends PrincipalProperty<ImagePropertyVal> {
        public ImagePrincipalProperty(String name, ImagePropertyVal val) {
            super(name, val);
        }
    }

    public static class ImagePropertyVal {
        public String url;
        public byte[] bytes;
        String encoding;
        String imageType;

        ImagePropertyVal(String url, byte[] bytes, String encoding, String imageType) {
            this.url = url;
            this.bytes = bytes;
            this.encoding = encoding;
            this.imageType = imageType;
        }
    }
}

