/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.bedework.base.ToString;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.Util;

@Dump(elementName="resourceContent", keyFields={"colPath", "name", "encodedContent"})
public class BwResourceContent
extends BwDbentity<BwResourceContent> {
    private String colPath;
    private String name;
    private byte[] byteValue;
    private int hash;
    private boolean hashZero;

    public void setColPath(String val) {
        this.colPath = val;
    }

    public String getColPath() {
        return this.colPath;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void setByteValue(byte[] val) {
        this.byteValue = val;
        this.hashZero = false;
        this.hash = 0;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    @Override
    public void setHref(String val) {
    }

    @Override
    public String getHref() {
        return Util.buildPath((boolean)false, (String[])new String[]{this.getColPath(), "/", this.getName()});
    }

    public InputStream getBinaryStream() {
        if (this.byteValue != null) {
            return new ByteArrayInputStream(this.byteValue);
        }
        return null;
    }

    public String getEncodedContent() {
        try {
            int len;
            InputStream str = this.getBinaryStream();
            if (str == null) {
                return null;
            }
            int chunkSize = 1024;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutputStream b64out = new Base64OutputStream((OutputStream)baos);
            while ((len = str.read(buffer)) != -1) {
                b64out.write(buffer, 0, len);
            }
            b64out.close();
            return baos.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NoDump
    public String getStringContent() {
        try {
            int len;
            InputStream str = this.getBinaryStream();
            if (str == null) {
                return null;
            }
            int chunkSize = 1024;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = str.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toString();
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    public void copyTo(BwResourceContent val) {
        val.setColPath(this.getColPath());
        val.setName(this.getName());
        val.setByteValue(this.getByteValue());
    }

    @Override
    public int hashCode() {
        String strVal = this.getStringContent();
        if (strVal == null) {
            return 0;
        }
        int h = this.hash;
        if (h == 0 && !this.hashZero) {
            h = strVal.hashCode();
            if (h == 0) {
                this.hashZero = true;
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    public int compareTo(BwResourceContent that) {
        if (this == that) {
            return 0;
        }
        return CalFacadeUtil.cmpObjval(this.getColPath(), that.getColPath());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("path", (Object)this.getColPath());
        ts.append("name", (Object)this.getName());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwResourceContent nobj = new BwResourceContent();
        this.copyTo(nobj);
        return nobj;
    }
}

