/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.bedework.base.ToString;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.SubContext;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.base.PropertiesEntity;
import org.bedework.util.xml.tagdefs.NamespaceAbbrevs;

@Dump(elementName="system")
@NoDump(value={"byteSize"})
public class BwSystem
extends BwDbentity<BwSystem>
implements PropertiesEntity,
Comparator<BwSystem> {
    private String name;
    static final String bedeworkContextsPname = "bedework:contexts";
    private Set<BwProperty> properties;

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setProperties(Set<BwProperty> val) {
        this.properties = val;
    }

    @Override
    @Dump(collectionElementName="property", compound=true)
    public Set<BwProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Set<BwProperty> getProperties(String name) {
        TreeSet<BwProperty> ps = new TreeSet<BwProperty>();
        if (this.getNumProperties() == 0) {
            return null;
        }
        for (BwProperty p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            ps.add(p);
        }
        return ps;
    }

    @Override
    public void removeProperties(String name) {
        Set<BwProperty> ps = this.getProperties(name);
        if (ps == null) {
            return;
        }
        for (BwProperty p : ps) {
            this.removeProperty(p);
        }
    }

    @Override
    @NoDump
    public int getNumProperties() {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    public BwProperty findProperty(String name) {
        Set<BwProperty> props = this.getProperties();
        if (props == null) {
            return null;
        }
        for (BwProperty prop : props) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public void addProperty(BwProperty val) {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            c = new TreeSet<BwProperty>();
            this.setProperties(c);
        }
        c.add(val);
    }

    @Override
    public boolean removeProperty(BwProperty val) {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            return false;
        }
        return c.remove(val);
    }

    @Override
    public Set<BwProperty> copyProperties() {
        if (this.getNumProperties() == 0) {
            return null;
        }
        return new TreeSet<BwProperty>(this.getProperties());
    }

    @Override
    public Set<BwProperty> cloneProperties() {
        if (this.getNumProperties() == 0) {
            return null;
        }
        TreeSet<BwProperty> ts = new TreeSet<BwProperty>();
        for (BwProperty p : this.getProperties()) {
            ts.add((BwProperty)p.clone());
        }
        return ts;
    }

    public void setProperty(String name, String val) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            prop = new BwProperty(name, val);
            this.addProperty(prop);
        } else {
            prop.setValue(val);
        }
    }

    public String getProperty(String name) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    @NoDump
    public Set<SubContext> getContexts() {
        TreeSet<SubContext> cs = new TreeSet<SubContext>();
        Set<BwProperty> cps = this.getProperties(bedeworkContextsPname);
        if (cps == null) {
            return cs;
        }
        for (BwProperty cp : cps) {
            cs.add(new SubContext(cp));
        }
        return cs;
    }

    public void addContext(SubContext sc) {
        this.addProperty(sc.getProp());
    }

    public void removeContext(SubContext sc) {
        this.removeProperty(sc.getProp());
    }

    public SubContext findContext(String name) {
        Set<BwProperty> cps = this.getProperties(bedeworkContextsPname);
        if (cps == null) {
            return null;
        }
        for (BwProperty cp : cps) {
            if (!name.equals(SubContext.extractContextName(cp.getValue()))) continue;
            return new SubContext(cp);
        }
        return null;
    }

    public void setQproperty(QName name, String val) {
        this.setProperty(NamespaceAbbrevs.prefixed((QName)name), val);
    }

    public String getQproperty(QName name) {
        return this.getProperty(NamespaceAbbrevs.prefixed((QName)name));
    }

    @Override
    public void setHref(String val) {
    }

    @Override
    public String getHref() {
        return null;
    }

    @Override
    public int compare(BwSystem o1, BwSystem o2) {
        if (o1 == o2) {
            return 0;
        }
        return o1.getName().compareTo(o2.getName());
    }

    @Override
    public int compareTo(BwSystem o2) {
        return this.compare(this, o2);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.newLine();
        ts.append("name", (Object)this.getName());
        ts.append("properties", this.getProperties());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwSystem clone = new BwSystem();
        clone.setName(this.getName());
        for (BwProperty p : this.getProperties()) {
            clone.addProperty(p);
        }
        return clone;
    }
}

