/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade;

import org.bedework.base.ToString;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwParticipant;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.util.misc.Util;

public class SchedulingOwner
implements Comparable<SchedulingOwner> {
    private final SchedulingInfo parent;
    private final BwOrganizer organizer;
    private final BwParticipant participant;

    SchedulingOwner(SchedulingInfo parent, BwOrganizer organizer, BwParticipant participant) {
        this.parent = parent;
        this.organizer = organizer;
        this.participant = participant;
        if (participant != null) {
            participant.addParticipantType("OWNER");
        }
    }

    public boolean noOwner() {
        return this.organizer == null && this.participant == null;
    }

    public BwOrganizer getOrganizer() {
        return this.organizer;
    }

    public BwOrganizer makeOrganizer() {
        if (this.organizer != null) {
            return this.organizer;
        }
        BwOrganizer org = new BwOrganizer();
        org.setCn(this.getName());
        org.setOrganizerUri(this.getCalendarAddress());
        org.setLanguage(this.getLanguage());
        return org;
    }

    public BwParticipant getParticipant() {
        return this.participant;
    }

    public void setCalendarAddress(String val) {
        if (this.organizer != null) {
            this.organizer.setOrganizerUri(val);
        }
        if (this.participant != null) {
            this.participant.setCalendarAddress(val);
        }
    }

    public String getCalendarAddress() {
        if (this.organizer != null) {
            return this.organizer.getOrganizerUri();
        }
        if (this.participant != null) {
            return this.participant.getCalendarAddress();
        }
        return null;
    }

    public void setName(String val) {
        if (this.organizer != null) {
            this.organizer.setCn(val);
        }
        if (this.participant != null) {
            this.participant.setName(val);
        }
    }

    public String getName() {
        String val = null;
        if (this.organizer != null) {
            val = this.organizer.getCn();
        }
        if (this.participant != null && val == null) {
            return this.participant.getName();
        }
        return val;
    }

    public void setLanguage(String val) {
        if (this.organizer != null) {
            this.organizer.setLanguage(val);
        }
        if (this.participant != null) {
            this.participant.setLanguage(val);
        }
    }

    public String getLanguage() {
        String val = null;
        if (this.organizer != null) {
            val = this.organizer.getLanguage();
        }
        if (this.participant != null && val == null) {
            return this.participant.getLanguage();
        }
        return val;
    }

    public void setInvitedBy(String val) {
        if (this.organizer != null) {
            this.organizer.setSentBy(val);
        }
        if (this.participant != null) {
            this.participant.setInvitedBy(val);
        }
    }

    public String getInvitedBy() {
        if (this.organizer != null) {
            return this.organizer.getSentBy();
        }
        if (this.participant != null) {
            return this.participant.getInvitedBy();
        }
        return null;
    }

    public void setSchedulingDtStamp(String val) {
        if (this.organizer != null) {
            this.organizer.setDtstamp(val);
        }
        if (this.participant != null) {
            this.participant.setSchedulingDtStamp(val);
        }
    }

    public String getSchedulingDtStamp() {
        if (this.organizer != null) {
            return this.organizer.getDtstamp();
        }
        if (this.participant != null) {
            return this.participant.getSchedulingDtStamp();
        }
        return null;
    }

    public void setScheduleStatus(String val) {
        if (this.organizer != null) {
            this.organizer.setScheduleStatus(val);
        }
        if (this.participant != null) {
            this.participant.setScheduleStatus(val);
        }
    }

    public String getScheduleStatus() {
        if (this.organizer != null) {
            return this.organizer.getScheduleStatus();
        }
        if (this.participant != null) {
            return this.participant.getScheduleStatus();
        }
        return null;
    }

    public int hashCode() {
        if (this.organizer != null) {
            return this.organizer.hashCode();
        }
        if (this.participant != null) {
            return this.participant.hashCode();
        }
        return -1;
    }

    @Override
    public int compareTo(SchedulingOwner that) {
        if (this == that) {
            return 0;
        }
        int res = Util.cmpObjval((Comparable)this.organizer, (Comparable)that.organizer);
        if (res != 0) {
            return res;
        }
        return Util.cmpObjval((Comparable)this.participant, (Comparable)that.participant);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        if (this.organizer != null) {
            ts.append("organizer", (Object)this.organizer);
        }
        if (this.participant != null) {
            ts.append("participant", (Object)this.participant);
        }
        return this.toString();
    }
}

