/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Timestamp;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.LastModified;
import org.bedework.base.ToString;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.NoWrap;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.util.timezones.DateTimeUtil;

public class BwLastMod<T extends BwDbentity, T1>
extends BwUnversionedDbentity<T1> {
    private int id = -1;
    private T dbEntity;
    private String timestamp;
    private int sequence;

    public BwLastMod(T dbEntity) {
        this.dbEntity = dbEntity;
    }

    public BwLastMod(T dbEntity, Date dt) {
        this(dbEntity);
        this.setTimestamp(DateTimeUtil.isoDateTimeUTC((Date)dt));
    }

    @Override
    public void setId(int val) {
        this.id = val;
    }

    @Override
    @NoDump
    public int getId() {
        return this.id;
    }

    public void setDbEntity(T val) {
        this.dbEntity = val;
    }

    @NoDump
    @JsonIgnore
    public T getDbEntity() {
        return this.dbEntity;
    }

    public void setTimestamp(String val) {
        this.timestamp = val;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    public boolean unsaved() {
        return this.getId() == -1;
    }

    @Override
    public void setHref(String val) {
    }

    @Override
    public String getHref() {
        return ((BwUnversionedDbentity)this.dbEntity).getHref();
    }

    public void updateLastmod(Timestamp val) {
        DateTime dt = new DateTime((Date)val);
        this.setTimestamp(new LastModified(dt).getValue());
        this.setSequence(val.getNanos());
    }

    @NoDump
    @JsonIgnore
    public String getTagValue() {
        return BwLastMod.getTagValue(this.getTimestamp(), this.getSequence());
    }

    @NoDump
    public static String getTagValue(String timestamp, int sequence) {
        return timestamp + "-" + BwEvent.hex4(sequence);
    }

    @Override
    protected void toStringSegment(ToString ts) {
        ts.append("id", this.getId());
        ts.append("timestamp", (Object)this.getTimestamp());
        ts.append("sequence", this.getSequence());
    }

    @Override
    @NoWrap
    public int hashCode() {
        return this.getTagValue().hashCode();
    }
}

