/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.base;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.vcard.VCard;
import org.bedework.base.exc.persist.BedeworkDatabaseException;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.annotations.NoWrap;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.xml.XmlEmit;

public class DumpEntity<T>
implements Logged {
    private final BwLogger logger = new BwLogger();

    @NoWrap
    public boolean hasDumpValue() {
        return true;
    }

    @NoWrap
    public void dump(File f) {
        Dump dCl = this.getClass().getAnnotation(Dump.class);
        if (dCl.format() == Dump.DumpFormat.xml) {
            Writer wtr = null;
            try {
                XmlEmit xml = new XmlEmit();
                wtr = new FileWriter(f);
                xml.startEmit(wtr);
                this.dump(xml, DumpType.def, false);
                xml.flush();
                return;
            }
            catch (IOException e) {
                throw new BedeworkDatabaseException((Throwable)e);
            }
            finally {
                if (wtr != null) {
                    try {
                        wtr.close();
                    }
                    catch (Throwable t) {
                        throw new BedeworkDatabaseException(t);
                    }
                }
            }
        }
        if (dCl.format() == Dump.DumpFormat.vCard) {
            Writer wtr = null;
            try {
                VCard vc = new VCard();
                this.dump(vc, DumpType.def);
                String vcStr = vc.toString();
                wtr = new FileWriter(f);
                wtr.append(vcStr);
                return;
            }
            catch (Throwable t) {
                throw new BedeworkDatabaseException(t);
            }
            finally {
                if (wtr != null) {
                    try {
                        wtr.close();
                    }
                    catch (Throwable t) {
                        throw new BedeworkDatabaseException(t);
                    }
                }
            }
        }
        throw new BedeworkDatabaseException("Unsupported dump format " + dCl.format());
    }

    @NoWrap
    public void dump(XmlEmit xml) {
        this.dump(xml, DumpType.def, false);
    }

    @NoWrap
    private void dump(XmlEmit xml, DumpType dtype, boolean fromCollection) {
        if (!this.hasDumpValue()) {
            return;
        }
        NoDump ndCl = this.getClass().getAnnotation(NoDump.class);
        Dump dCl = this.getClass().getAnnotation(Dump.class);
        boolean dumpKeyFields = dtype == DumpType.reference;
        ArrayList noDumpMethods = null;
        ArrayList<String> firstMethods = null;
        if (ndCl != null) {
            if (ndCl.value().length == 0) {
                return;
            }
            noDumpMethods = new ArrayList();
            Collections.addAll(noDumpMethods, ndCl.value());
        }
        if (!dumpKeyFields && dCl != null && dCl.firstFields().length != 0) {
            firstMethods = new ArrayList<String>();
            for (String f : dCl.firstFields()) {
                firstMethods.add(this.methodName(f));
            }
        }
        QName qn = null;
        if (fromCollection || dtype != DumpType.compound) {
            qn = this.startElement(xml, this.getClass(), dCl);
        }
        Collection<ComparableMethod> ms = this.findGetters(dCl, dtype);
        if (firstMethods != null) {
            block5: for (String methodName : firstMethods) {
                for (ComparableMethod cm : ms) {
                    Method m = cm.m;
                    if (!methodName.equals(m.getName())) continue;
                    Dump d = m.getAnnotation(Dump.class);
                    try {
                        this.dumpValue(xml, m, d, m.invoke((Object)this, (Object[])null), fromCollection);
                        continue block5;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new BedeworkDatabaseException((Throwable)e);
                    }
                }
                this.error("Listed first field has no corresponding getter: " + methodName);
            }
        }
        for (ComparableMethod cm : ms) {
            Method m = cm.m;
            if (noDumpMethods != null && noDumpMethods.contains(this.fieldName(m.getName())) || firstMethods != null && firstMethods.contains(m.getName())) continue;
            Dump d = m.getAnnotation(Dump.class);
            try {
                this.dumpValue(xml, m, d, m.invoke((Object)this, (Object[])null), fromCollection);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BedeworkDatabaseException((Throwable)e);
            }
        }
        if (qn != null) {
            this.closeElement(xml, qn);
        }
    }

    private boolean dumpValue(XmlEmit xml, Method m, Dump d, Object methVal, boolean fromCollection) {
        if (methVal instanceof DumpEntity) {
            DumpEntity de = (DumpEntity)methVal;
            if (!de.hasDumpValue()) {
                return false;
            }
            boolean compound = d != null && d.compound();
            QName mqn = this.startElement(xml, m, d, fromCollection);
            DumpType dt = compound ? DumpType.compound : DumpType.reference;
            de.dump(xml, dt, false);
            if (mqn != null) {
                this.closeElement(xml, mqn);
            }
            return true;
        }
        if (methVal instanceof Collection) {
            Collection c = (Collection)methVal;
            if (c.isEmpty()) {
                return false;
            }
            QName mqn = null;
            for (Object o : c) {
                DumpEntity de;
                if (o instanceof DumpEntity && !(de = (DumpEntity)o).hasDumpValue()) continue;
                if (mqn == null) {
                    mqn = this.startElement(xml, m, d, fromCollection);
                }
                this.dumpValue(xml, m, d, o, true);
            }
            if (mqn != null) {
                this.closeElement(xml, mqn);
            }
            return true;
        }
        this.property(xml, m, d, methVal, fromCollection);
        return true;
    }

    private QName startElement(XmlEmit xml, Class<?> c, Dump d) {
        QName qn = d == null ? new QName(c.getName()) : new QName(d.elementName());
        xml.openTag(qn);
        return qn;
    }

    private QName startElement(XmlEmit xml, Method m, Dump d, boolean fromCollection) {
        QName qn = this.getTag(m, d, fromCollection);
        if (qn != null) {
            xml.openTag(qn);
        }
        return qn;
    }

    private QName getTag(Method m, Dump d, boolean fromCollection) {
        String tagName = null;
        if (d != null) {
            if (!fromCollection) {
                if (!d.elementName().isEmpty()) {
                    tagName = d.elementName();
                }
            } else if (!d.collectionElementName().isEmpty()) {
                tagName = d.collectionElementName();
            }
        }
        if (tagName == null && !fromCollection) {
            tagName = this.fieldName(m.getName());
        }
        if (tagName == null) {
            return null;
        }
        return new QName(tagName);
    }

    private void property(XmlEmit xml, Method m, Dump d, Object p, boolean fromCollection) {
        String sval;
        if (p == null) {
            return;
        }
        QName qn = this.getTag(m, d, fromCollection);
        if (qn == null) {
            qn = new QName(p.getClass().getName());
        }
        if ((sval = p instanceof char[] ? new String((char[])p) : String.valueOf(p)).indexOf(38) < 0 && sval.indexOf(60) < 0) {
            xml.property(qn, sval);
        } else {
            xml.cdataProperty(qn, sval);
        }
    }

    private void closeElement(XmlEmit xml, QName qn) {
        xml.closeTag(qn);
    }

    @NoWrap
    private void dump(VCard vc, DumpType dtype) {
        boolean dumpKeyFields;
        if (!this.hasDumpValue()) {
            return;
        }
        NoDump ndCl = this.getClass().getAnnotation(NoDump.class);
        Dump dCl = this.getClass().getAnnotation(Dump.class);
        boolean bl = dumpKeyFields = dtype == DumpType.reference;
        if (ndCl != null) {
            if (ndCl.value().length == 0) {
                return;
            }
            ArrayList noDumpMethods = new ArrayList();
            Collections.addAll(noDumpMethods, ndCl.value());
        }
        if (!dumpKeyFields && dCl != null && dCl.firstFields().length != 0) {
            ArrayList<String> firstMethods = new ArrayList<String>();
            for (String f : dCl.firstFields()) {
                firstMethods.add(this.methodName(f));
            }
        }
    }

    private Collection<ComparableMethod> findGetters(Dump d, DumpType dt) {
        Method[] meths = this.getClass().getMethods();
        TreeSet<ComparableMethod> getters = new TreeSet<ComparableMethod>();
        ArrayList<String> keyMethods = null;
        if (dt == DumpType.reference) {
            if (d == null || d.keyFields().length == 0) {
                this.error("No key fields defined for class " + this.getClass().getCanonicalName());
                throw new BedeworkDatabaseException("org.bedework.exception.nokeyfields");
            }
            keyMethods = new ArrayList<String>();
            for (String f : d.keyFields()) {
                keyMethods.add(this.methodName(f));
            }
        }
        for (Method m : meths) {
            Class<?>[] parClasses;
            String mname = m.getName();
            if (mname.length() < 4 || !mname.startsWith("get") || mname.equals("getClass") || (parClasses = m.getParameterTypes()).length != 0 || m.getAnnotation(NoDump.class) != null || keyMethods != null && !keyMethods.contains(mname)) continue;
            getters.add(new ComparableMethod(m));
        }
        return getters;
    }

    private String methodName(String val) {
        String m = "get" + val.substring(0, 1).toUpperCase();
        if (val.length() > 1) {
            m = m + val.substring(1);
        }
        return m;
    }

    private String fieldName(String val) {
        if (val.length() < 4) {
            return null;
        }
        return val.substring(3, 4).toLowerCase() + val.substring(4);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static enum DumpType {
        def,
        compound,
        reference;

    }

    private static class ComparableMethod
    implements Comparable<ComparableMethod> {
        Method m;

        ComparableMethod(Method m) {
            this.m = m;
        }

        @Override
        public int compareTo(ComparableMethod that) {
            return this.m.getName().compareTo(that.m.getName());
        }
    }
}

