/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.base.ChangeFlag;

public abstract class OverrideCollection<T, C extends Collection<T>>
implements Collection<T> {
    BwEvent.ProxiedFieldIndex fieldIndex;
    BwEventAnnotation ann;
    ChangeFlag cf;

    public OverrideCollection(BwEvent.ProxiedFieldIndex fieldIndex, BwEventAnnotation ann, ChangeFlag cf) {
        this.fieldIndex = fieldIndex;
        this.ann = ann;
        this.cf = cf;
    }

    public abstract void setOverrideCollection(C var1);

    public abstract C getOverrideCollection();

    public abstract C getEmptyOverrideCollection();

    public abstract void copyIntoOverrideCollection();

    public void setOverrideIsEmpty(boolean val) {
        this.ann.setEmptyFlag(this.fieldIndex, val);
        this.cf.setChangeFlag(true);
    }

    public boolean getOverrideIsEmpty() {
        return this.ann.getEmptyFlag(this.fieldIndex);
    }

    public abstract C getMasterCollection();

    @Override
    public int size() {
        C c = this.getCollection();
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    @Override
    public boolean isEmpty() {
        C c = this.getCollection();
        if (c == null) {
            return true;
        }
        return c.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        C c = this.getCollection();
        if (c == null) {
            return false;
        }
        return c.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        C c = this.getCollection();
        if (c == null) {
            return new EmptyIterator();
        }
        return c.iterator();
    }

    @Override
    public Object[] toArray() {
        C c = this.getCollection();
        if (c == null) {
            return new Object[0];
        }
        return c.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        C c = this.getCollection();
        if (c == null) {
            return new TreeSet().toArray(a);
        }
        return c.toArray(a);
    }

    @Override
    public boolean add(T o) {
        C c = this.getModCollection();
        this.setOverrideEmptyFlag(false);
        this.cf.setChangeFlag(true);
        return c.add(o);
    }

    @Override
    public boolean remove(Object o) {
        C c = this.getModCollection();
        boolean changed = c.remove(o);
        if (c.isEmpty()) {
            this.setOverrideEmptyFlag(true);
        }
        this.cf.setChangeFlag(true);
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        C cc = this.getCollection();
        if (cc == null) {
            return false;
        }
        return cc.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        C cc = this.getModCollection();
        this.setOverrideEmptyFlag(false);
        this.cf.setChangeFlag(true);
        return cc.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        C cc = this.getModCollection();
        boolean changed = cc.removeAll(c);
        this.setOverrideEmptyFlag(true);
        this.cf.setChangeFlag(true);
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        C cc = this.getModCollection();
        boolean changed = cc.retainAll(c);
        if (cc.isEmpty()) {
            this.setOverrideEmptyFlag(true);
        }
        this.cf.setChangeFlag(true);
        return changed;
    }

    @Override
    public void clear() {
        this.getModCollection().clear();
        this.setOverrideEmptyFlag(true);
        this.cf.setChangeFlag(true);
    }

    @Override
    public boolean equals(Object o) {
        return this.getCollection().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getCollection().hashCode();
    }

    protected void setOverrideEmptyFlag(boolean val) {
        if (val == this.getOverrideIsEmpty()) {
            return;
        }
        this.setOverrideIsEmpty(val);
    }

    protected C getCollection() {
        C c = this.getOverrideCollection();
        if (c != null && !c.isEmpty()) {
            return c;
        }
        if (this.getOverrideIsEmpty()) {
            return c;
        }
        return this.getMasterCollection();
    }

    protected C getModCollection() {
        C over = this.getOverrideCollection();
        if (over != null && !over.isEmpty()) {
            return over;
        }
        if (over == null) {
            over = this.getEmptyOverrideCollection();
            this.setOverrideCollection(over);
        }
        if (this.getOverrideIsEmpty()) {
            return over;
        }
        this.copyIntoOverrideCollection();
        return over;
    }

    private class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

